/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.tcp;

import com.dataiku.dss.shadelibazure.io.netty.handler.ssl.IdentityCipherSuiteFilter;
import com.dataiku.dss.shadelibazure.io.netty.handler.ssl.OpenSsl;
import com.dataiku.dss.shadelibazure.io.netty.handler.ssl.SslContextBuilder;
import com.dataiku.dss.shadelibazure.io.netty.handler.ssl.SslProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.tcp.AbstractProtocolSslContextSpec;
import java.io.File;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.function.Consumer;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;

public final class TcpSslContextSpec
extends AbstractProtocolSslContextSpec<TcpSslContextSpec> {
    static final Consumer<SslContextBuilder> DEFAULT_CONFIGURATOR = sslCtxBuilder -> sslCtxBuilder.sslProvider(OpenSsl.isAvailable() ? SslProvider.OPENSSL : SslProvider.JDK).ciphers(null, IdentityCipherSuiteFilter.INSTANCE).applicationProtocolConfig(null);

    public static TcpSslContextSpec forClient() {
        return new TcpSslContextSpec(SslContextBuilder.forClient());
    }

    public static TcpSslContextSpec forServer(File keyCertChainFile, File keyFile) {
        return new TcpSslContextSpec(SslContextBuilder.forServer(keyCertChainFile, keyFile));
    }

    public static TcpSslContextSpec forServer(File keyCertChainFile, File keyFile, String keyPassword) {
        return new TcpSslContextSpec(SslContextBuilder.forServer(keyCertChainFile, keyFile, keyPassword));
    }

    public static TcpSslContextSpec forServer(InputStream keyCertChainInputStream, InputStream keyInputStream) {
        return new TcpSslContextSpec(SslContextBuilder.forServer(keyCertChainInputStream, keyInputStream));
    }

    public static TcpSslContextSpec forServer(InputStream keyCertChainInputStream, InputStream keyInputStream, String keyPassword) {
        return new TcpSslContextSpec(SslContextBuilder.forServer(keyCertChainInputStream, keyInputStream, keyPassword));
    }

    public static TcpSslContextSpec forServer(KeyManager keyManager) {
        return new TcpSslContextSpec(SslContextBuilder.forServer(keyManager));
    }

    public static TcpSslContextSpec forServer(KeyManagerFactory keyManagerFactory) {
        return new TcpSslContextSpec(SslContextBuilder.forServer(keyManagerFactory));
    }

    public static TcpSslContextSpec forServer(PrivateKey key, Iterable<? extends X509Certificate> keyCertChain) {
        return new TcpSslContextSpec(SslContextBuilder.forServer(key, keyCertChain));
    }

    public static TcpSslContextSpec forServer(PrivateKey key, String keyPassword, Iterable<? extends X509Certificate> keyCertChain) {
        return new TcpSslContextSpec(SslContextBuilder.forServer(key, keyPassword, keyCertChain));
    }

    public static TcpSslContextSpec forServer(PrivateKey key, String keyPassword, X509Certificate ... keyCertChain) {
        return new TcpSslContextSpec(SslContextBuilder.forServer(key, keyPassword, keyCertChain));
    }

    public static TcpSslContextSpec forServer(PrivateKey key, X509Certificate ... keyCertChain) {
        return new TcpSslContextSpec(SslContextBuilder.forServer(key, keyCertChain));
    }

    TcpSslContextSpec(SslContextBuilder sslContextBuilder) {
        super(sslContextBuilder);
    }

    @Override
    public TcpSslContextSpec get() {
        return this;
    }

    @Override
    protected Consumer<SslContextBuilder> defaultConfiguration() {
        return DEFAULT_CONFIGURATOR;
    }
}

