/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.transport;

import com.dataiku.dss.shadelibazure.io.netty.channel.Channel;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelConfig;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelHandler;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelHandlerContext;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelInboundHandlerAdapter;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelInitializer;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelOption;
import com.dataiku.dss.shadelibazure.io.netty.channel.EventLoopGroup;
import com.dataiku.dss.shadelibazure.io.netty.channel.ServerChannel;
import com.dataiku.dss.shadelibazure.io.netty.channel.socket.DatagramChannel;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.DecoderException;
import com.dataiku.dss.shadelibazure.io.netty.util.AttributeKey;
import com.dataiku.dss.shadelibazure.org.reactivestreams.Subscription;
import com.dataiku.dss.shadelibazure.reactor.core.CoreSubscriber;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.MonoSink;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Operators;
import com.dataiku.dss.shadelibazure.reactor.netty.ChannelBindException;
import com.dataiku.dss.shadelibazure.reactor.netty.Connection;
import com.dataiku.dss.shadelibazure.reactor.netty.ConnectionObserver;
import com.dataiku.dss.shadelibazure.reactor.netty.DisposableServer;
import com.dataiku.dss.shadelibazure.reactor.netty.FutureMono;
import com.dataiku.dss.shadelibazure.reactor.netty.ReactorNetty;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.AbortedException;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ChannelOperations;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.util.MapUtils;
import com.dataiku.dss.shadelibazure.reactor.netty.resources.ConnectionProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.resources.LoopResources;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.AddressUtils;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.DomainSocketAddressUtils;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.ServerTransportConfig;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.Transport;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.TransportConfig;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.TransportConnector;
import com.dataiku.dss.shadelibazure.reactor.util.Logger;
import com.dataiku.dss.shadelibazure.reactor.util.Loggers;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import com.dataiku.dss.shadelibazure.reactor.util.context.Context;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public abstract class ServerTransport<T extends ServerTransport<T, CONF>, CONF extends ServerTransportConfig<CONF>>
extends Transport<T, CONF> {
    static final Logger log = Loggers.getLogger(ServerTransport.class);

    public Mono<? extends DisposableServer> bind() {
        ServerTransportConfig config = (ServerTransportConfig)this.configuration();
        Objects.requireNonNull(config.bindAddress(), "bindAddress");
        Mono mono = Mono.create(sink2 -> {
            DisposableBind disposableServer;
            InetSocketAddress localInet;
            SocketAddress local = Objects.requireNonNull(config.bindAddress().get(), "Bind Address supplier returned null");
            if (local instanceof InetSocketAddress && (localInet = (InetSocketAddress)local).isUnresolved()) {
                local = AddressUtils.createResolved(localInet.getHostName(), localInet.getPort());
            }
            boolean isDomainSocket = false;
            if (DomainSocketAddressUtils.isDomainSocketAddress(local)) {
                isDomainSocket = true;
                disposableServer = new UdsDisposableBind((MonoSink<DisposableServer>)sink2, config, local);
            } else {
                disposableServer = new InetDisposableBind((MonoSink<DisposableServer>)sink2, config, local);
            }
            ChildObserver childObs = new ChildObserver(config.defaultChildObserver().then(config.childObserver()));
            AcceptorInitializer channelInitializer = config.channelInitializer(childObs, null, true);
            if (!config.channelType(isDomainSocket).equals(DatagramChannel.class)) {
                Acceptor acceptor = new Acceptor(config.childEventLoopGroup(), channelInitializer, config.childOptions, config.childAttrs, isDomainSocket);
                channelInitializer = new AcceptorInitializer(acceptor);
            }
            TransportConnector.bind(config, channelInitializer, local, isDomainSocket).subscribe(disposableServer);
        });
        if (config.doOnBind() != null) {
            mono = mono.doOnSubscribe(s2 -> config.doOnBind().accept(config));
        }
        return mono;
    }

    public final DisposableServer bindNow() {
        return this.bindNow(Duration.ofSeconds(45L));
    }

    public final DisposableServer bindNow(Duration timeout2) {
        Objects.requireNonNull(timeout2, "timeout");
        try {
            return Objects.requireNonNull(this.bind().block(timeout2), "aborted");
        }
        catch (IllegalStateException e) {
            if (e.getMessage().contains("blocking read")) {
                throw new IllegalStateException(this.getClass().getSimpleName() + " couldn't be started within " + timeout2.toMillis() + "ms");
            }
            throw e;
        }
    }

    public final void bindUntilJavaShutdown(Duration timeout2, @Nullable Consumer<DisposableServer> onStart) {
        Objects.requireNonNull(timeout2, "timeout");
        DisposableServer facade = Objects.requireNonNull(this.bindNow(), "facade");
        if (onStart != null) {
            onStart.accept(facade);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> facade.disposeNow(timeout2)));
        facade.onDispose().block();
    }

    public <A> T childAttr(AttributeKey<A> key, @Nullable A value) {
        Objects.requireNonNull(key, "key");
        ServerTransport dup = (ServerTransport)this.duplicate();
        ((ServerTransportConfig)dup.configuration()).childAttrs = TransportConfig.updateMap(((ServerTransportConfig)this.configuration()).childAttrs, key, value);
        return (T)dup;
    }

    public T childObserve(ConnectionObserver observer) {
        Objects.requireNonNull(observer, "observer");
        ServerTransport dup = (ServerTransport)this.duplicate();
        ConnectionObserver current = ((ServerTransportConfig)this.configuration()).childObserver;
        ((ServerTransportConfig)dup.configuration()).childObserver = current == null ? observer : current.then(observer);
        return (T)dup;
    }

    public <A> T childOption(ChannelOption<A> key, @Nullable A value) {
        Objects.requireNonNull(key, "key");
        if (ChannelOption.AUTO_READ == key) {
            if (value instanceof Boolean && Boolean.TRUE.equals(value)) {
                log.error("ChannelOption.AUTO_READ is configured to be [false], it cannot be set to [true]");
            }
            ServerTransport dup = this;
            return (T)dup;
        }
        ServerTransport dup = (ServerTransport)this.duplicate();
        ((ServerTransportConfig)dup.configuration()).childOptions = TransportConfig.updateMap(((ServerTransportConfig)this.configuration()).childOptions, key, value);
        return (T)dup;
    }

    public T doOnBind(Consumer<? super CONF> doOnBind) {
        Objects.requireNonNull(doOnBind, "doOnBind");
        ServerTransport dup = (ServerTransport)this.duplicate();
        Consumer current = ((ServerTransportConfig)this.configuration()).doOnBind;
        ((ServerTransportConfig)dup.configuration()).doOnBind = current == null ? doOnBind : current.andThen(doOnBind);
        return (T)dup;
    }

    public T doOnBound(Consumer<? super DisposableServer> doOnBound) {
        Objects.requireNonNull(doOnBound, "doOnBound");
        ServerTransport dup = (ServerTransport)this.duplicate();
        Consumer<? super DisposableServer> current = ((ServerTransportConfig)this.configuration()).doOnBound;
        ((ServerTransportConfig)dup.configuration()).doOnBound = current == null ? doOnBound : current.andThen(doOnBound);
        return (T)dup;
    }

    public T doOnConnection(Consumer<? super Connection> doOnConnection) {
        Objects.requireNonNull(doOnConnection, "doOnConnected");
        ServerTransport dup = (ServerTransport)this.duplicate();
        Consumer<? super Connection> current = ((ServerTransportConfig)this.configuration()).doOnConnection;
        ((ServerTransportConfig)dup.configuration()).doOnConnection = current == null ? doOnConnection : current.andThen(doOnConnection);
        return (T)dup;
    }

    public T doOnUnbound(Consumer<? super DisposableServer> doOnUnbound) {
        Objects.requireNonNull(doOnUnbound, "doOnUnbound");
        ServerTransport dup = (ServerTransport)this.duplicate();
        Consumer<? super DisposableServer> current = ((ServerTransportConfig)this.configuration()).doOnUnbound;
        ((ServerTransportConfig)dup.configuration()).doOnUnbound = current == null ? doOnUnbound : current.andThen(doOnUnbound);
        return (T)dup;
    }

    public T host(String host) {
        Objects.requireNonNull(host, "host");
        return (T)((ServerTransport)this.bindAddress(() -> AddressUtils.updateHost(((ServerTransportConfig)this.configuration()).bindAddress(), host)));
    }

    public T port(int port) {
        return (T)((ServerTransport)this.bindAddress(() -> AddressUtils.updatePort(((ServerTransportConfig)this.configuration()).bindAddress(), port)));
    }

    public Mono<Void> warmup() {
        return Mono.fromRunnable(() -> {
            ((ServerTransportConfig)this.configuration()).childEventLoopGroup();
            ((ServerTransportConfig)this.configuration()).eventLoopGroup();
        });
    }

    static final class UdsDisposableBind
    extends DisposableBind {
        UdsDisposableBind(MonoSink<DisposableServer> sink2, TransportConfig config, SocketAddress bindAddress) {
            super(sink2, config, bindAddress);
        }

        @Override
        public String path() {
            return DomainSocketAddressUtils.path(this.channel().localAddress());
        }
    }

    static final class InetDisposableBind
    extends DisposableBind {
        InetDisposableBind(MonoSink<DisposableServer> sink2, TransportConfig config, SocketAddress bindAddress) {
            super(sink2, config, bindAddress);
        }

        @Override
        public InetSocketAddress address() {
            return (InetSocketAddress)this.channel().localAddress();
        }

        @Override
        public String host() {
            return this.address().getHostString();
        }

        @Override
        public int port() {
            return this.address().getPort();
        }
    }

    static class DisposableBind
    implements CoreSubscriber<Channel>,
    DisposableServer,
    Connection {
        final MonoSink<DisposableServer> sink;
        final Context currentContext;
        final TransportConfig config;
        final SocketAddress bindAddress;
        Channel channel;
        Subscription subscription;

        DisposableBind(MonoSink<DisposableServer> sink2, TransportConfig config, SocketAddress bindAddress) {
            this.sink = sink2;
            this.currentContext = Context.of(sink2.contextView());
            this.config = config;
            this.bindAddress = bindAddress;
        }

        @Override
        public Channel channel() {
            return this.channel;
        }

        @Override
        public Context currentContext() {
            return this.currentContext;
        }

        @Override
        public final void dispose() {
            if (this.channel != null) {
                if (this.channel.isActive()) {
                    SocketAddress localAddress = this.channel.localAddress();
                    this.channel.close();
                    LoopResources loopResources = this.config.loopResources();
                    if (loopResources instanceof ConnectionProvider) {
                        ((ConnectionProvider)((Object)loopResources)).disposeWhen(this.bindAddress);
                        if (localAddress != null) {
                            ((ConnectionProvider)((Object)loopResources)).disposeWhen(localAddress);
                        }
                    }
                }
            } else {
                this.subscription.cancel();
            }
        }

        @Override
        public void disposeNow(Duration timeout2) {
            if (this.isDisposed()) {
                if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format(this.channel(), "Server has been disposed"));
                }
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "Server is about to be disposed with timeout: {}"), timeout2);
            }
            this.dispose();
            Mono<Object> terminateSignals = Mono.empty();
            if (this.config.channelGroup != null && this.config.channelGroup.size() > 0) {
                HashMap channelsToMono = new HashMap(MapUtils.calculateInitialCapacity(this.config.channelGroup.size()));
                for (Channel channel : this.config.channelGroup) {
                    ChannelOperations<?, ?> ops;
                    Channel parent = channel.parent();
                    boolean isParentServerChannel = parent instanceof ServerChannel;
                    List monos = MapUtils.computeIfAbsent(channelsToMono, isParentServerChannel ? channel : parent, key -> new ArrayList());
                    if (monos.isEmpty() && !isParentServerChannel) {
                        monos.add(FutureMono.from(parent.close()));
                    }
                    if ((ops = ChannelOperations.get(channel)) == null) continue;
                    monos.add(ops.onTerminate().doFinally(sig -> ops.dispose()));
                }
                for (Map.Entry entry : channelsToMono.entrySet()) {
                    Channel channel = (Channel)entry.getKey();
                    List monos = (List)entry.getValue();
                    if (monos.isEmpty()) {
                        channel.close();
                        continue;
                    }
                    terminateSignals = Mono.when(monos).and(terminateSignals);
                }
            }
            try {
                this.onDispose().then(terminateSignals).block(timeout2);
            }
            catch (IllegalStateException e) {
                if (e.getMessage().contains("blocking read")) {
                    throw new IllegalStateException("Socket couldn't be stopped within " + timeout2.toMillis() + "ms");
                }
                throw e;
            }
        }

        @Override
        public void onComplete() {
        }

        @Override
        public void onError(Throwable t) {
            this.sink.error(ChannelBindException.fail(this.bindAddress, t));
        }

        @Override
        public void onNext(Channel channel) {
            this.channel = channel;
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(channel, "Bound new server"));
            }
            this.sink.success(this);
            this.config.defaultConnectionObserver().then(this.config.connectionObserver()).onStateChange(this, ConnectionObserver.State.CONNECTED);
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (Operators.validate(this.subscription, s2)) {
                this.subscription = s2;
                this.sink.onCancel(this);
                s2.request(Long.MAX_VALUE);
            }
        }
    }

    static final class ChildObserver
    implements ConnectionObserver {
        final ConnectionObserver childObs;

        ChildObserver(ConnectionObserver childObs) {
            this.childObs = childObs;
        }

        @Override
        public void onUncaughtException(Connection connection, Throwable error) {
            ChannelOperations<?, ?> ops = ChannelOperations.get(connection.channel());
            if (ops == null && (error instanceof IOException || AbortedException.isConnectionReset(error) || error instanceof DecoderException)) {
                if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format(connection.channel(), "onUncaughtException(" + connection + ")"), error);
                }
            } else {
                log.error(ReactorNetty.format(connection.channel(), "onUncaughtException(" + connection + ")"), error);
            }
            connection.dispose();
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if (newState == ConnectionObserver.State.DISCONNECTING && connection.channel().isActive() && !connection.isPersistent()) {
                connection.dispose();
            }
            this.childObs.onStateChange(connection, newState);
        }
    }

    static final class AcceptorInitializer
    extends ChannelInitializer<Channel> {
        final Acceptor acceptor;

        AcceptorInitializer(Acceptor acceptor) {
            this.acceptor = acceptor;
        }

        @Override
        public void initChannel(Channel ch) {
            ch.eventLoop().execute(() -> ch.pipeline().addLast(this.acceptor));
        }
    }

    static class Acceptor
    extends ChannelInboundHandlerAdapter {
        final EventLoopGroup childGroup;
        final ChannelHandler childHandler;
        final Map<ChannelOption<?>, ?> childOptions;
        final Map<AttributeKey<?>, ?> childAttrs;
        final boolean isDomainSocket;
        Runnable enableAutoReadTask;

        Acceptor(EventLoopGroup childGroup, ChannelHandler childHandler, Map<ChannelOption<?>, ?> childOptions, Map<AttributeKey<?>, ?> childAttrs, boolean isDomainSocket) {
            this.childGroup = childGroup;
            this.childHandler = childHandler;
            this.childOptions = childOptions;
            this.childAttrs = childAttrs;
            this.isDomainSocket = isDomainSocket;
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            Channel child = (Channel)msg;
            child.pipeline().addLast(this.childHandler);
            TransportConnector.setChannelOptions(child, this.childOptions, this.isDomainSocket);
            TransportConnector.setAttributes(child, this.childAttrs);
            try {
                this.childGroup.register(child).addListener(future -> {
                    if (!future.isSuccess()) {
                        Acceptor.forceClose(child, future.cause());
                    }
                });
            }
            catch (Throwable t) {
                Acceptor.forceClose(child, t);
            }
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            ChannelConfig config = ctx.channel().config();
            if (config.isAutoRead()) {
                config.setAutoRead(false);
                ctx.channel().eventLoop().schedule(this.enableAutoReadTask, 1L, TimeUnit.SECONDS).addListener(future -> {
                    if (!future.isSuccess() && log.isDebugEnabled()) {
                        log.debug(ReactorNetty.format(ctx.channel(), "Cannot enable auto-read"), future.cause());
                    }
                });
            }
        }

        void enableAutoReadTask(Channel channel) {
            this.enableAutoReadTask = () -> channel.config().setAutoRead(true);
        }

        static void forceClose(Channel child, Throwable t) {
            child.unsafe().closeForcibly();
            if (log.isWarnEnabled()) {
                log.warn(ReactorNetty.format(child, "Failed to register an accepted channel: {}"), child, t);
            }
        }
    }
}

