/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agents.diagram;

import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dataflow.graph.utils.GraphSerializerCommon;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dss.shadelib.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import com.dataiku.j2ts.annotations.UIModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringEscapeUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.fishtank.css.selectors.NodeSelectorException;
import se.fishtank.css.selectors.dom.DOMNodeSelector;

public class BlockGraphSerializer
extends GraphSerializerCommon {
    private final StringBuilder headSB = new StringBuilder();
    private final SavedModel.ToolsUsingAgentSettings agentSettings;
    private final Map<String, SavedModel.BlocksGraphBlock> blocksMap = new HashMap<String, SavedModel.BlocksGraphBlock>();
    public Map<String, SavedModel.BlocksGraphBlock> usedBlocks = new HashMap<String, SavedModel.BlocksGraphBlock>();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.graph");

    public BlockGraphSerializer(SavedModel.ToolsUsingAgentSettings settings) throws IOException {
        SpringUtils.getInstance().autowire((Object)this);
        this.agentSettings = settings;
        for (SavedModel.BlocksGraphBlock block : this.agentSettings.blocks) {
            this.blocksMap.put(block.id, block);
        }
    }

    @Override
    protected String getCacheKeyPrefix() {
        return "???";
    }

    private SavedModel.BlocksGraphBlock getBlockMand(String blockId) {
        SavedModel.BlocksGraphBlock block = this.blocksMap.get(blockId);
        if (block == null) {
            throw new IllegalArgumentException("Block with id " + blockId + " not found -- cannot render diagram");
        }
        return block;
    }

    protected SerializedGraph createSerializedGraph() {
        return new SerializedGraph();
    }

    private String linkProperties(List<String> l1, String ... l2) {
        ArrayList<String> allProperties = new ArrayList<String>();
        allProperties.addAll(l1);
        allProperties.addAll(Arrays.asList(l2));
        Object propertiesStr = "";
        if (!allProperties.isEmpty()) {
            propertiesStr = " [" + String.join((CharSequence)", ", allProperties) + "]";
        }
        return propertiesStr;
    }

    private String nodeIdForBlockInput(BlockNode node) {
        if (node.block instanceof SavedModel.ForEachBlock || node.block instanceof SavedModel.ParallelBlock || node.block instanceof SavedModel.ReflectionBlock) {
            return node.id + "_in";
        }
        return "block_" + node.id;
    }

    private String nodeIdForBlockOutput(BlockNode node) {
        if (node.block instanceof SavedModel.ForEachBlock || node.block instanceof SavedModel.ParallelBlock || node.block instanceof SavedModel.ReflectionBlock) {
            return node.id + "_out";
        }
        return "block_" + node.id;
    }

    private List<String> propertiesForLinkingFromBlock(BlockNode node) {
        if (node.block instanceof SavedModel.ForEachBlock || node.block instanceof SavedModel.ParallelBlock || node.block instanceof SavedModel.ReflectionBlock) {
            return Lists.newArrayList((Object[])new String[]{"ltail=cluster_" + node.id});
        }
        return new ArrayList<String>();
    }

    private List<String> propertiesForLinkingToBlock(BlockNode node) {
        if (node.block instanceof SavedModel.ForEachBlock || node.block instanceof SavedModel.ParallelBlock || node.block instanceof SavedModel.ReflectionBlock) {
            return Lists.newArrayList((Object[])new String[]{"lhead=cluster_" + node.id});
        }
        return new ArrayList<String>();
    }

    private String linkBlocks(BlockNode from, BlockNode to, String ... additionalProperties) {
        return String.format("%s -> %s %s\n", this.nodeIdForBlockOutput(from), this.nodeIdForBlockInput(to), this.getLinkPropertiesString(from, to, additionalProperties));
    }

    private String linkBlockToConditionNode(BlockNode from, String id) {
        String fromId = this.nodeIdForBlockOutput(from);
        String conditionId = this.getConditionNodeId(from, id);
        return String.format("%s:e -> %s [dir=none]\n", fromId, conditionId);
    }

    private String linkBlockFromConditionNode(BlockNode from, BlockNode to, String id) {
        String toId = this.nodeIdForBlockInput(to);
        String conditionId = this.getConditionNodeId(from, id);
        return String.format("%s -> %s\n", conditionId, toId);
    }

    private String linkBlocksWithConditionNode(BlockNode from, BlockNode to, String id) {
        return this.linkBlockToConditionNode(from, id) + this.linkBlockFromConditionNode(from, to, id);
    }

    private String getConditionNodeId(BlockNode from, String id) {
        return "condition_" + id + "_" + this.nodeIdForBlockOutput(from);
    }

    private String getLinkPropertiesString(BlockNode from, BlockNode to, String ... additionalProperties) {
        ArrayList<String> allProperties = new ArrayList<String>();
        allProperties.addAll(this.propertiesForLinkingFromBlock(from));
        allProperties.addAll(this.propertiesForLinkingToBlock(to));
        allProperties.addAll(Arrays.asList(additionalProperties));
        Object propertiesStr = "";
        if (!allProperties.isEmpty()) {
            propertiesStr = " [" + String.join((CharSequence)", ", allProperties) + "]";
        }
        return propertiesStr;
    }

    private boolean isBlockValid(String blockId) {
        return StringUtils.isNotBlank((CharSequence)blockId) && this.blocksMap.get(blockId) != null;
    }

    private String standardReactCluster(SavedModel.BlocksGraphBlock block, int index) {
        if (block instanceof SavedModel.StandardReactBlock) {
            SavedModel.StandardReactBlock srtool = (SavedModel.StandardReactBlock)block;
            String clusterName = "cluster_block_" + block.id;
            String escapedId = BlockGraphSerializer.graphVizEscape(block.id);
            Object s = "";
            s = (String)s + String.format("subgraph cluster_%s {\n    label=<\n        <TABLE BORDER=\"0\" CELLBORDER=\"1\" CELLSPACING=\"0\" CELLPADDING=\"6\" FIXEDSIZE=\"TRUE\" WIDTH=\"240\">\n          <TR>\n            <TD HEIGHT=\"32\"><B>%s</B></TD>\n          </TR>\n          <TR>\n            <TD HEIGHT=\"20\">Here be dragons</TD>\n          </TR>\n        </TABLE>\n    >;\n    id=%s;\n    margin=0;\n    %s_in  [shape=point, style=invis; label=\"\";  width=0; height=0; fixedsize=true,];\n    %s_out [shape=point, style=invis; label=\"\"];\n", escapedId, StringEscapeUtils.escapeHtml((String)block.id), index, escapedId, escapedId);
            Object previousToolId = escapedId + "_in";
            for (SavedModel.BlockGraphReactTool bgrt : srtool.tools) {
                s = (String)s + String.format("tool_%s_%s [label=%s];\n%s -> tool_%s_%s [style=invis]\n", block.id, bgrt.toolRef, bgrt.toolRef, previousToolId, block.id, bgrt.toolRef);
                previousToolId = String.format("tool_%s_%s", block.id, bgrt.toolRef);
            }
            s = (String)s + String.format("    %s -> %s_out [style=invis];\n", previousToolId, escapedId);
            s = (String)s + "}\n";
            return s;
        }
        throw new IllegalArgumentException("not a react block  " + JSON.log((Object)block));
    }

    private String getReactBlockExitConditionDescription(SavedModel.ReactBlockExitCondition condition) {
        Object description = "";
        if (condition instanceof SavedModel.StateHasKeysExitCondition) {
            SavedModel.StateHasKeysExitCondition sc = (SavedModel.StateHasKeysExitCondition)condition;
            description = String.join((CharSequence)", ", sc.stateKeys);
        } else if (condition instanceof SavedModel.ScratchpadHasKeysExitCondition) {
            SavedModel.ScratchpadHasKeysExitCondition sp = (SavedModel.ScratchpadHasKeysExitCondition)condition;
            description = String.join((CharSequence)", ", sp.scratchpadKeys);
        } else if (condition instanceof SavedModel.ToolsCalledExitCondition) {
            SavedModel.ToolsCalledExitCondition tc = (SavedModel.ToolsCalledExitCondition)condition;
            description = tc.toolRefs.size() + " tool" + (tc.toolRefs.size() != 1 ? "s" : "");
        } else if (condition instanceof SavedModel.ExpressionExitCondition) {
            SavedModel.ExpressionExitCondition ec = (SavedModel.ExpressionExitCondition)condition;
            description = ec.expression.expression;
        }
        return description;
    }

    private String getRoutingBlockConditionClauseDescription(SavedModel.RoutingBlock rb, SavedModel.RoutingConditionClause condition) {
        Object description = "";
        if (condition instanceof SavedModel.StateHasKeysRoutingConditionClause) {
            SavedModel.StateHasKeysRoutingConditionClause sc = (SavedModel.StateHasKeysRoutingConditionClause)condition;
            description = String.join((CharSequence)", ", sc.stateKeys);
        } else if (condition instanceof SavedModel.ScratchpadHasKeysRoutingConditionClause) {
            SavedModel.ScratchpadHasKeysRoutingConditionClause sp = (SavedModel.ScratchpadHasKeysRoutingConditionClause)condition;
            description = String.join((CharSequence)", ", sp.scratchpadKeys);
        } else if (condition instanceof SavedModel.ExpressionRoutingConditionClause) {
            SavedModel.ExpressionRoutingConditionClause ec = (SavedModel.ExpressionRoutingConditionClause)condition;
            description = ec.expression.expression;
        } else if (condition instanceof SavedModel.ToolsCalledInHistoryRoutingConditionClause) {
            SavedModel.ToolsCalledInHistoryRoutingConditionClause tc = (SavedModel.ToolsCalledInHistoryRoutingConditionClause)condition;
            description = tc.toolRefs.size() + " tool" + (tc.toolRefs.size() != 1 ? "s" : "");
        } else if (condition instanceof SavedModel.AndRoutingConditionClause) {
            SavedModel.AndRoutingConditionClause ac = (SavedModel.AndRoutingConditionClause)condition;
            description = ac.clauses.size() + " sub-clause" + (ac.clauses.size() != 1 ? "s" : "");
        } else if (condition instanceof SavedModel.OrRoutingConditionClause) {
            SavedModel.OrRoutingConditionClause oc = (SavedModel.OrRoutingConditionClause)condition;
            description = oc.clauses.size() + " sub-clause" + (oc.clauses.size() != 1 ? "s" : "");
        } else if (condition instanceof SavedModel.LLMBasedDecisionRoutingConditionClause) {
            SavedModel.LLMBasedDecisionRoutingConditionClause llmc = (SavedModel.LLMBasedDecisionRoutingConditionClause)condition;
            description = rb.llmId;
        }
        return description;
    }

    private String createConditionNode(BlockNode currentNode, String id, String description, String type) {
        String nodeId = this.getConditionNodeId(currentNode, id);
        BlockNodeRemapping conditionNode = new BlockNodeRemapping();
        String descriptionLabel = "";
        conditionNode.nodeId = nodeId;
        conditionNode.blockId = nodeId;
        conditionNode.type = type;
        conditionNode.nodeType = NodeType.CONDITION;
        this.labelsRemapping.add(conditionNode);
        if (!StringUtils.isBlank((CharSequence)description)) {
            descriptionLabel = String.format("<TR>\n    <TD WIDTH=\"120\" HEIGHT=\"22\" FIXEDSIZE=\"true\">\n        %s\n    </TD>\n</TR>\n", StringEscapeUtils.escapeHtml((String)description));
        }
        return String.format("%s [\n    label=<\n        <TABLE BORDER=\"0\" CELLBORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"6\">\n             <TR>\n                <TD WIDTH=\"120\" HEIGHT=\"26\" FIXEDSIZE=\"true\">\n                    %s\n                </TD>\n             </TR>\n             %s\n        </TABLE>\n     >;\n     id=%s;\n     margin=0;\n     width=0;\n     height=0;\n]\n", nodeId, type, descriptionLabel, id);
    }

    private String createTextNode(String label, String previousEscapedNodeId, String inputBlockId, String linkProps) {
        String id;
        BlockNodeRemapping textNode = new BlockNodeRemapping();
        textNode.nodeId = id = String.valueOf(this.labelsRemapping.size());
        textNode.nodeType = NodeType.TEXT;
        this.labelsRemapping.add(textNode);
        return String.format("%s [\n    label=<\n        <TABLE BORDER=\"0\" CELLBORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"6\">\n             <TR>\n                <TD>%s</TD>\n             </TR>\n        </TABLE>\n    >;\n    id=%s;\n    width=0.65; height=0.35; fixedsize=true;\n];\n\n%s -> %s:w %s\n", previousEscapedNodeId, label, id, previousEscapedNodeId, inputBlockId, linkProps);
    }

    private void collectChainTails(Set<BlockNode> chainTails, Set<String> visitedBlockIds, String currentBlockId, List<String> blockPath, String identifier) {
        block24: {
            BlockNode currentNode;
            SavedModel.BlocksGraphBlock bgb;
            block26: {
                block25: {
                    block23: {
                        if (StringUtils.isBlank((CharSequence)currentBlockId)) {
                            return;
                        }
                        bgb = this.getBlockMand(currentBlockId);
                        currentNode = new BlockNode(bgb, blockPath, identifier);
                        if (visitedBlockIds.contains(currentNode.id)) {
                            return;
                        }
                        visitedBlockIds.add(currentNode.id);
                        if (!(bgb instanceof SavedModel.StandardReactBlock)) break block23;
                        SavedModel.StandardReactBlock srb = (SavedModel.StandardReactBlock)bgb;
                        if (srb.exitConditions.isEmpty() && StringUtils.isBlank((CharSequence)srb.defaultNextBlock)) {
                            chainTails.add(currentNode);
                            return;
                        }
                        for (SavedModel.ReactBlockExitCondition rbec : srb.exitConditions) {
                            this.collectChainTails(chainTails, visitedBlockIds, rbec.nextBlock, blockPath, identifier);
                        }
                        if (this.isBlockValid(srb.defaultNextBlock)) {
                            this.collectChainTails(chainTails, visitedBlockIds, srb.defaultNextBlock, blockPath, identifier);
                        }
                        break block24;
                    }
                    if (!(bgb instanceof SavedModel.BasicLinearBlock)) break block25;
                    SavedModel.BasicLinearBlock blb = (SavedModel.BasicLinearBlock)((Object)bgb);
                    String nextBlockId = blb.getSingleNextBlock();
                    if (StringUtils.isBlank((CharSequence)nextBlockId)) {
                        chainTails.add(currentNode);
                        return;
                    }
                    this.collectChainTails(chainTails, visitedBlockIds, blb.getSingleNextBlock(), blockPath, identifier);
                    break block24;
                }
                if (!(bgb instanceof SavedModel.RoutingBlock)) break block26;
                SavedModel.RoutingBlock rb = (SavedModel.RoutingBlock)bgb;
                switch (rb.routingMode) {
                    case CLAUSES: {
                        if (rb.clausesBasedDecisions.isEmpty()) {
                            chainTails.add(currentNode);
                            return;
                        }
                        for (SavedModel.RoutingClauseBasedDecision decision : rb.clausesBasedDecisions) {
                            visitedBlockIds.add(currentNode.id);
                            this.collectChainTails(chainTails, visitedBlockIds, decision.nextBlock, blockPath, identifier);
                        }
                        break block24;
                    }
                    case LLM_DISPATCH: {
                        if (rb.resultDispatch.isEmpty()) {
                            chainTails.add(currentNode);
                            return;
                        }
                        for (SimpleKeyValue skv : rb.resultDispatch) {
                            visitedBlockIds.add(currentNode.id);
                            this.collectChainTails(chainTails, visitedBlockIds, skv.value, blockPath, identifier);
                        }
                        break block24;
                    }
                    case EXPRESSION_DISPATCH: {
                        throw new NotImplementedException();
                    }
                }
                break block24;
            }
            if (bgb instanceof SavedModel.ForEachBlock) {
                SavedModel.ForEachBlock feb = (SavedModel.ForEachBlock)bgb;
                if (feb.nextBlock == null) {
                    chainTails.add(currentNode);
                    return;
                }
                this.collectChainTails(chainTails, visitedBlockIds, feb.nextBlock, blockPath, identifier);
            } else if (bgb instanceof SavedModel.ParallelBlock) {
                SavedModel.ParallelBlock pb = (SavedModel.ParallelBlock)bgb;
                if (pb.nextBlock == null) {
                    chainTails.add(currentNode);
                    return;
                }
                this.collectChainTails(chainTails, visitedBlockIds, pb.nextBlock, blockPath, identifier);
            } else if (bgb instanceof SavedModel.ReflectionBlock) {
                SavedModel.ReflectionBlock rb = (SavedModel.ReflectionBlock)bgb;
                if (rb.nextBlock == null) {
                    chainTails.add(currentNode);
                    return;
                }
                this.collectChainTails(chainTails, visitedBlockIds, rb.nextBlock, blockPath, identifier);
            }
        }
    }

    private void handleChainRec(StringBuilder chainData, Set<String> visitedBlockIds, String currentBlockId, List<String> blockPath, String identifier) {
        if (!this.isBlockValid(currentBlockId)) {
            return;
        }
        int METADATA_LIMIT = 5;
        String escapedId = BlockGraphSerializer.graphVizEscape(currentBlockId);
        SavedModel.BlocksGraphBlock bgb = this.getBlockMand(currentBlockId);
        BlockNode currentNode = new BlockNode(bgb, blockPath, identifier);
        if (visitedBlockIds.contains(currentNode.id)) {
            return;
        }
        int idx = this.labelsRemapping.size();
        BlockNodeRemapping bnr = new BlockNodeRemapping();
        bnr.nodeId = currentNode.id;
        bnr.blockId = bgb.id;
        bnr.type = bgb.getType();
        bnr.nodeType = NodeType.BLOCK;
        this.labelsRemapping.add(bnr);
        this.usedBlocks.put(bgb.id, bgb);
        if (bgb instanceof SavedModel.StandardReactBlock) {
            SavedModel.StandardReactBlock srb = (SavedModel.StandardReactBlock)bgb;
            String tools = srb.tools.stream().limit(METADATA_LIMIT).map(tool -> "<TR>\n    <TD FIXEDSIZE=\"true\" WIDTH=\"200\" HEIGHT=\"32\"></TD>\n</TR>").collect(Collectors.joining("\n"));
            String srbLabel = "block_%s [\n    label=<\n        <TABLE BORDER=\"0\" CELLBORDER=\"1\" CELLSPACING=\"0\" CELLPADDING=\"6\">\n        <TR>\n            <TD FIXEDSIZE=\"true\" WIDTH=\"200\" HEIGHT=\"40\">%s</TD>\n        </TR>\n        <TR>\n            <TD FIXEDSIZE=\"true\" WIDTH=\"200\" HEIGHT=\"32\"></TD>\n        </TR>\n        %s\n        </TABLE>\n    >;\n    id=%s;\n    margin=0;\n]".formatted(currentNode.id, StringEscapeUtils.escapeHtml((String)bgb.id), tools, idx);
            chainData.append(srbLabel);
            for (SavedModel.ReactBlockExitCondition rbec : srb.exitConditions) {
                if (rbec instanceof SavedModel.ExpressionExitCondition) {
                    SavedModel.ExpressionExitCondition eec = (SavedModel.ExpressionExitCondition)rbec;
                } else if (rbec.nextBlock == null) {
                    logger.warn((Object)("Ignoring invalid exit condition with no next block in block " + JSON.log((Object)bgb)));
                    continue;
                }
                String type = rbec.getType();
                String description = this.getReactBlockExitConditionDescription(rbec);
                String id = String.valueOf(this.labelsRemapping.size());
                String exitConditionNode = this.createConditionNode(currentNode, id, description, type);
                chainData.append(exitConditionNode);
                visitedBlockIds.add(currentNode.id);
                if (rbec instanceof SavedModel.ExpressionExitCondition) {
                    SavedModel.ExpressionExitCondition eec = (SavedModel.ExpressionExitCondition)rbec;
                    chainData.append(this.linkBlockToConditionNode(currentNode, id));
                    for (String blockId : eec.validNextBlocks) {
                        BlockNode nextNode = new BlockNode(this.getBlockMand(blockId), blockPath, identifier);
                        chainData.append(this.linkBlockFromConditionNode(currentNode, nextNode, id));
                        visitedBlockIds.add(currentNode.id);
                        this.handleChainRec(chainData, visitedBlockIds, blockId, blockPath, identifier);
                    }
                    continue;
                }
                BlockNode nextNode = new BlockNode(this.getBlockMand(rbec.nextBlock), blockPath, identifier);
                chainData.append(this.linkBlocksWithConditionNode(currentNode, nextNode, id));
                this.handleChainRec(chainData, visitedBlockIds, rbec.nextBlock, blockPath, identifier);
            }
            if (!StringUtils.isBlank((CharSequence)srb.defaultNextBlock)) {
                BlockNode nextNode = new BlockNode(this.getBlockMand(srb.defaultNextBlock), blockPath, identifier);
                String id = String.valueOf(this.labelsRemapping.size());
                String defaultConditionNode = this.createConditionNode(currentNode, id, null, null);
                chainData.append(defaultConditionNode);
                chainData.append(this.linkBlocksWithConditionNode(currentNode, nextNode, id));
                visitedBlockIds.add(currentNode.id);
                this.handleChainRec(chainData, visitedBlockIds, srb.defaultNextBlock, blockPath, identifier);
            }
        } else if (bgb instanceof SavedModel.BasicLinearBlock) {
            SavedModel.BasicLinearBlock blb = (SavedModel.BasicLinearBlock)((Object)bgb);
            String description = this.getDescriptionDefinition(bgb);
            chainData.append(String.format("block_%s [\n    label=<\n        <TABLE BORDER=\"0\" CELLBORDER=\"1\" CELLSPACING=\"0\" CELLPADDING=\"6\">\n          <TR>\n            <TD FIXEDSIZE=\"true\" WIDTH=\"200\" HEIGHT=\"40\">%s</TD>\n          </TR>\n          %s\n        </TABLE>\n    >;\n    margin=0;\n    id=%s;\n];", currentNode.id, StringEscapeUtils.escapeHtml((String)bgb.id), description, idx));
            String nextBlockId = blb.getSingleNextBlock();
            if (!StringUtils.isBlank((CharSequence)nextBlockId)) {
                BlockNode nextNode = new BlockNode(this.getBlockMand(nextBlockId), blockPath, identifier);
                chainData.append(this.linkBlocks(currentNode, nextNode, new String[0]));
            }
            visitedBlockIds.add(currentNode.id);
            this.handleChainRec(chainData, visitedBlockIds, nextBlockId, blockPath, identifier);
        } else if (bgb instanceof SavedModel.PythonCodeBlock) {
            SavedModel.PythonCodeBlock pcb = (SavedModel.PythonCodeBlock)bgb;
            chainData.append(String.format("block_%s [\n    label=<\n        <TABLE BORDER=\"0\" CELLBORDER=\"1\" CELLSPACING=\"0\" CELLPADDING=\"6\">\n          <TR>\n            <TD FIXEDSIZE=\"true\" WIDTH=\"200\" HEIGHT=\"40\">%s</TD>\n          </TR>\n        </TABLE>\n    >;\n    margin=0;\n    id=%s;\n];", currentNode.id, StringEscapeUtils.escapeHtml((String)bgb.id), idx));
            if (!StringUtils.isBlank((CharSequence)pcb.defaultNextBlock)) {
                BlockNode nextNode = new BlockNode(this.getBlockMand(pcb.defaultNextBlock), blockPath, identifier);
                chainData.append(this.linkBlocks(currentNode, nextNode, new String[0]));
                visitedBlockIds.add(currentNode.id);
                this.handleChainRec(chainData, visitedBlockIds, pcb.defaultNextBlock, blockPath, identifier);
            }
            for (String blockId : pcb.validNextBlocksFromCode) {
                BlockNode nextNode = new BlockNode(this.getBlockMand(blockId), blockPath, identifier);
                chainData.append(this.linkBlocks(currentNode, nextNode, new String[0]));
                visitedBlockIds.add(currentNode.id);
                this.handleChainRec(chainData, visitedBlockIds, blockId, blockPath, identifier);
            }
        } else if (bgb instanceof SavedModel.CustomBlock) {
            SavedModel.CustomBlock cb = (SavedModel.CustomBlock)bgb;
            chainData.append(String.format("block_%s [\n    label=<\n        <TABLE BORDER=\"0\" CELLBORDER=\"1\" CELLSPACING=\"0\" CELLPADDING=\"6\">\n          <TR>\n            <TD FIXEDSIZE=\"true\" WIDTH=\"200\" HEIGHT=\"40\">%s</TD>\n          </TR>\n        </TABLE>\n    >;\n    margin=0;\n    id=%s;\n];", currentNode.id, StringEscapeUtils.escapeHtml((String)bgb.id), idx));
            if (!StringUtils.isBlank((CharSequence)cb.defaultNextBlock)) {
                BlockNode nextNode = new BlockNode(this.getBlockMand(cb.defaultNextBlock), blockPath, identifier);
                chainData.append(this.linkBlocks(currentNode, nextNode, new String[0]));
                visitedBlockIds.add(currentNode.id);
                this.handleChainRec(chainData, visitedBlockIds, cb.defaultNextBlock, blockPath, identifier);
            }
            for (String blockId : cb.validNextBlocks) {
                BlockNode nextNode = new BlockNode(this.getBlockMand(blockId), blockPath, identifier);
                chainData.append(this.linkBlocks(currentNode, nextNode, new String[0]));
                visitedBlockIds.add(currentNode.id);
                this.handleChainRec(chainData, visitedBlockIds, blockId, blockPath, identifier);
            }
        } else if (bgb instanceof SavedModel.RoutingBlock) {
            SavedModel.RoutingBlock rb = (SavedModel.RoutingBlock)bgb;
            chainData.append(String.format("block_%s [\n    label=<\n        <TABLE BORDER=\"0\" CELLBORDER=\"1\" CELLSPACING=\"0\" CELLPADDING=\"6\">\n            <TR>\n                <TD FIXEDSIZE=\"true\" WIDTH=\"200\" HEIGHT=\"40\">%s</TD>\n            </TR>\n        </TABLE>\n    >;\n    margin=0;\n    id=%s;\n];", currentNode.id, StringEscapeUtils.escapeHtml((String)bgb.id), idx));
            switch (rb.routingMode) {
                case CLAUSES: {
                    for (SavedModel.RoutingClauseBasedDecision decision : rb.clausesBasedDecisions) {
                        if (decision.nextBlock == null) {
                            logger.warn((Object)("Ignoring invalid clause-based decision with no next block in block " + JSON.log((Object)bgb)));
                            continue;
                        }
                        BlockNode nextNode = new BlockNode(this.getBlockMand(decision.nextBlock), blockPath, identifier);
                        String type = decision.clause.getType();
                        String description = this.getRoutingBlockConditionClauseDescription(rb, decision.clause);
                        String id = String.valueOf(this.labelsRemapping.size());
                        String exitConditionNode = this.createConditionNode(currentNode, id, description, type);
                        chainData.append(exitConditionNode);
                        chainData.append(this.linkBlocksWithConditionNode(currentNode, nextNode, id));
                        visitedBlockIds.add(currentNode.id);
                        this.handleChainRec(chainData, visitedBlockIds, decision.nextBlock, blockPath, identifier);
                    }
                    break;
                }
                case LLM_DISPATCH: {
                    for (SimpleKeyValue skv : rb.resultDispatch) {
                        BlockNode nextNode = new BlockNode(this.getBlockMand(skv.value), blockPath, identifier);
                        String type = "LLM_DISPATCH";
                        String description = skv.key;
                        String id = String.valueOf(this.labelsRemapping.size());
                        String exitConditionNode = this.createConditionNode(currentNode, id, description, type);
                        chainData.append(exitConditionNode);
                        chainData.append(this.linkBlocksWithConditionNode(currentNode, nextNode, id));
                        visitedBlockIds.add(currentNode.id);
                        this.handleChainRec(chainData, visitedBlockIds, skv.value, blockPath, identifier);
                    }
                    break;
                }
                case EXPRESSION_DISPATCH: {
                    String type = "EXPRESSION_DISPATCH";
                    String description = rb.expression;
                    String id = String.valueOf(this.labelsRemapping.size());
                    String exitConditionNode = this.createConditionNode(currentNode, id, description, type);
                    chainData.append(exitConditionNode);
                    chainData.append(this.linkBlockToConditionNode(currentNode, id));
                    for (String blockId : rb.validNextBlocksFromExpression) {
                        BlockNode nextNode = new BlockNode(this.getBlockMand(blockId), blockPath, identifier);
                        chainData.append(this.linkBlockFromConditionNode(currentNode, nextNode, id));
                        visitedBlockIds.add(currentNode.id);
                        this.handleChainRec(chainData, visitedBlockIds, blockId, blockPath, identifier);
                    }
                    break;
                }
            }
            if (this.isBlockValid(rb.defaultNextBlockIfNoClauseMatch)) {
                BlockNode nextNode = new BlockNode(this.blocksMap.get(rb.defaultNextBlockIfNoClauseMatch), blockPath, identifier);
                chainData.append(this.linkBlocks(currentNode, nextNode, new String[0]));
                visitedBlockIds.add(currentNode.id);
                this.handleChainRec(chainData, visitedBlockIds, rb.defaultNextBlockIfNoClauseMatch, blockPath, identifier);
            }
        } else if (bgb instanceof SavedModel.ForEachBlock) {
            SavedModel.ForEachBlock feb = (SavedModel.ForEachBlock)bgb;
            String expressionLabel = "";
            if (StringUtils.isNotBlank((CharSequence)feb.sourceExpression)) {
                expressionLabel = String.format("    <TR>\n        <TD HEIGHT=\"32\">%s</TD>\n    </TR>\n", feb.sourceExpression);
            }
            chainData.append(String.format("subgraph cluster_%s {\n    label=<\n        <TABLE BORDER=\"0\" CELLBORDER=\"1\" CELLSPACING=\"0\" CELLPADDING=\"6\">\n          <TR>\n            <TD WIDTH=\"120\" HEIGHT=\"40\">%s</TD>\n          </TR>\n          %s\n        </TABLE>\n    >;\n    id=%s;\n    %s_in  [shape=point, style=invis; label=\"\";  width=0; height=0; fixedsize=true];\n    %s_out [shape=point, style=invis; label=\"\"];\n", currentNode.id, StringEscapeUtils.escapeHtml((String)bgb.id), expressionLabel, idx, currentNode.id, currentNode.id));
            if (this.isBlockValid(feb.blockIdToRepeat) && !blockPath.contains(escapedId)) {
                StringBuilder repeatedChainData = new StringBuilder();
                Set<String> repeatedVisitedBlockIds = visitedBlockIds;
                this.handleChainRec(repeatedChainData, repeatedVisitedBlockIds, feb.blockIdToRepeat, currentNode.blockPath, identifier);
                if (!StringUtils.isBlank((CharSequence)repeatedChainData)) {
                    chainData.append("\n// Content of the repeat block " + feb.blockIdToRepeat + "\n");
                    chainData.append(repeatedChainData.toString());
                    chainData.append("\n// END OF Content of the repeat block" + feb.blockIdToRepeat + "\n");
                    BlockNode nextNode = new BlockNode(this.getBlockMand(feb.blockIdToRepeat), currentNode.blockPath, identifier);
                    String linkProps = this.linkProperties(this.propertiesForLinkingToBlock(nextNode), "style=invis");
                    chainData.append(String.format("%s -> %s %s;\n", this.nodeIdForBlockInput(currentNode), this.nodeIdForBlockInput(nextNode), linkProps));
                    HashSet<BlockNode> chainTails = new HashSet<BlockNode>();
                    HashSet<String> visitedForTails = new HashSet<String>();
                    this.collectChainTails(chainTails, visitedForTails, feb.blockIdToRepeat, currentNode.blockPath, identifier);
                    for (BlockNode tailNode : chainTails) {
                        String linkProps2 = this.linkProperties(this.propertiesForLinkingFromBlock(tailNode), "style=invis");
                        chainData.append(String.format("%s -> %s %s;\n", this.nodeIdForBlockOutput(tailNode), this.nodeIdForBlockOutput(currentNode), linkProps2));
                    }
                }
            }
            chainData.append("}\n\n");
            if (!StringUtils.isBlank((CharSequence)feb.nextBlock)) {
                BlockNode nextNode = new BlockNode(this.getBlockMand(feb.nextBlock), blockPath, identifier);
                chainData.append(this.linkBlocks(currentNode, nextNode, new String[0]));
                visitedBlockIds.add(currentNode.id);
                this.handleChainRec(chainData, visitedBlockIds, feb.nextBlock, blockPath, identifier);
            }
        } else if (bgb instanceof SavedModel.ParallelBlock) {
            SavedModel.ParallelBlock pb = (SavedModel.ParallelBlock)bgb;
            chainData.append(String.format("subgraph cluster_%s {\n    label=<\n        <TABLE BORDER=\"0\" CELLBORDER=\"1\" CELLSPACING=\"0\" CELLPADDING=\"6\">\n          <TR>\n            <TD WIDTH=\"120\" HEIGHT=\"40\">%s</TD>\n          </TR>\n        </TABLE>\n    >;\n    id=%s;\n    %s_in  [shape=point, style=invis; label=\"\";  width=0; height=0; fixedsize=true];\n    %s_out [shape=point, style=invis; label=\"\"];\n", currentNode.id, StringEscapeUtils.escapeHtml((String)bgb.id), idx, currentNode.id, currentNode.id));
            int count = 0;
            for (String branchStartingBlockId : pb.blockIds) {
                if (this.isBlockValid(branchStartingBlockId) && !blockPath.contains(escapedId)) {
                    StringBuilder branchChainData = new StringBuilder();
                    Set<String> branchVisitedBlockIds = visitedBlockIds;
                    BlockNode branchStartingNode = new BlockNode(this.getBlockMand(branchStartingBlockId), currentNode.blockPath, String.valueOf(count));
                    this.handleChainRec(branchChainData, branchVisitedBlockIds, branchStartingBlockId, currentNode.blockPath, String.valueOf(count));
                    if (!StringUtils.isBlank((CharSequence)branchChainData)) {
                        chainData.append("\n// Content of the branch block " + branchStartingBlockId + "\n");
                        chainData.append(branchChainData.toString());
                        chainData.append("\n// END OF Content of the repeat block" + branchStartingBlockId + "\n");
                        String linkProps = this.linkProperties(this.propertiesForLinkingToBlock(branchStartingNode), "style=dashed");
                        chainData.append(String.format("%s -> %s %s;\n", this.nodeIdForBlockInput(currentNode), this.nodeIdForBlockInput(branchStartingNode), linkProps));
                        HashSet<BlockNode> chainTails = new HashSet<BlockNode>();
                        HashSet<String> visitedForTails = new HashSet<String>();
                        this.collectChainTails(chainTails, visitedForTails, branchStartingBlockId, currentNode.blockPath, String.valueOf(count));
                        for (BlockNode tailNode : chainTails) {
                            String linkProps3 = this.linkProperties(this.propertiesForLinkingFromBlock(tailNode), "style=dashed");
                            chainData.append(String.format("%s -> %s %s;\n", this.nodeIdForBlockOutput(tailNode), this.nodeIdForBlockOutput(currentNode), linkProps3));
                        }
                    }
                }
                ++count;
            }
            chainData.append("}\n\n");
            if (!StringUtils.isBlank((CharSequence)pb.nextBlock)) {
                BlockNode nextNode = new BlockNode(this.getBlockMand(pb.nextBlock), blockPath, identifier);
                chainData.append(this.linkBlocks(currentNode, nextNode, new String[0]));
                visitedBlockIds.add(currentNode.id);
                this.handleChainRec(chainData, visitedBlockIds, pb.nextBlock, blockPath, identifier);
            }
        } else if (bgb instanceof SavedModel.ReflectionBlock) {
            SavedModel.ReflectionBlock rb = (SavedModel.ReflectionBlock)bgb;
            String description = this.getDescriptionDefinition(bgb);
            chainData.append(String.format("subgraph cluster_%s {\n    label=<\n        <TABLE BORDER=\"0\" CELLBORDER=\"1\" CELLSPACING=\"0\" CELLPADDING=\"6\">\n          <TR>\n            <TD WIDTH=\"120\" HEIGHT=\"40\">%s</TD>\n          </TR>\n          %s\n        </TABLE>\n    >;\n    id=%s;\n    %s_in  [shape=point, style=invis; label=\"\";  width=0; height=0; fixedsize=true];\n    %s_out [shape=point, style=invis; label=\"\"];\n", currentNode.id, StringEscapeUtils.escapeHtml((String)bgb.id), description, idx, currentNode.id, currentNode.id));
            if (this.isBlockValid(rb.generatorBlockId) && !blockPath.contains(escapedId)) {
                StringBuilder repeatedChainData = new StringBuilder();
                Set<String> repeatedVisitedBlockIds = visitedBlockIds;
                this.handleChainRec(repeatedChainData, repeatedVisitedBlockIds, rb.generatorBlockId, currentNode.blockPath, identifier);
                if (!StringUtils.isBlank((CharSequence)repeatedChainData)) {
                    chainData.append("\n// Content of the generator block " + rb.generatorBlockId + "\n");
                    chainData.append(repeatedChainData.toString());
                    chainData.append("\n// END OF Content of the generator block" + rb.generatorBlockId + "\n");
                    BlockNode nextNode = new BlockNode(this.blocksMap.get(rb.generatorBlockId), currentNode.blockPath, identifier);
                    String linkProps = this.linkProperties(this.propertiesForLinkingToBlock(nextNode), "style=invis");
                    chainData.append(String.format("%s -> %s %s;\n", this.nodeIdForBlockInput(currentNode), this.nodeIdForBlockInput(nextNode), linkProps));
                    HashSet<BlockNode> chainTails = new HashSet<BlockNode>();
                    HashSet<String> visitedForTails = new HashSet<String>();
                    this.collectChainTails(chainTails, visitedForTails, rb.generatorBlockId, currentNode.blockPath, identifier);
                    for (BlockNode tailNode : chainTails) {
                        String linkProps4 = this.linkProperties(this.propertiesForLinkingFromBlock(tailNode), "style=invis");
                        chainData.append(String.format("%s -> %s %s;\n", this.nodeIdForBlockOutput(tailNode), this.nodeIdForBlockOutput(currentNode), linkProps4));
                    }
                }
            }
            chainData.append("}\n\n");
            if (this.isBlockValid(rb.nextBlock)) {
                BlockNode nextNode = new BlockNode(this.blocksMap.get(rb.nextBlock), blockPath, identifier);
                chainData.append(this.linkBlocks(currentNode, nextNode, new String[0]));
                visitedBlockIds.add(currentNode.id);
                this.handleChainRec(chainData, visitedBlockIds, rb.nextBlock, blockPath, identifier);
            }
        }
    }

    public SerializedGraph serialize() throws Exception {
        String startLinkProps;
        BlockNode node;
        String currentBlockId;
        String previousEscapedNodeId;
        StringBuilder chainData;
        this.headSB.append("digraph g {\n      rankdir=LR;\n      compound=true;\n      splines=true;\n      nodesep=0.6;\n      ranksep=0.8;\n      fontname=\"Helvetica\";\n\n      node [fontname=\"Helvetica\", shape=box];\n      edge [fontname=\"Helvetica\"];\n");
        SerializedGraph serializedGraph = this.createSerializedGraph();
        HashSet<String> visitedBlockIds = new HashSet<String>();
        if (this.isBlockValid(this.agentSettings.preChainHeadBlockId)) {
            chainData = new StringBuilder();
            previousEscapedNodeId = "___PRE___";
            currentBlockId = this.agentSettings.preChainHeadBlockId;
            node = new BlockNode(this.blocksMap.get(currentBlockId), List.of());
            startLinkProps = this.linkProperties(this.propertiesForLinkingToBlock(node), new String[0]);
            chainData.append(this.createTextNode("Before", previousEscapedNodeId, this.nodeIdForBlockInput(node), startLinkProps));
            this.handleChainRec(chainData, visitedBlockIds, currentBlockId, List.of(), "");
            this.headSB.append((CharSequence)chainData);
        }
        chainData = new StringBuilder();
        previousEscapedNodeId = "___START___";
        currentBlockId = this.agentSettings.startingBlockId;
        if (!this.isBlockValid(this.agentSettings.startingBlockId)) {
            throw new IllegalArgumentException("Starting block does not exist: " + this.agentSettings.startingBlockId);
        }
        node = new BlockNode(this.getBlockMand(currentBlockId), List.of());
        startLinkProps = this.linkProperties(this.propertiesForLinkingToBlock(node), new String[0]);
        chainData.append(this.createTextNode("Start", previousEscapedNodeId, this.nodeIdForBlockInput(node), startLinkProps));
        this.handleChainRec(chainData, visitedBlockIds, currentBlockId, List.of(), "");
        this.headSB.append((CharSequence)chainData);
        if (this.isBlockValid(this.agentSettings.postChainHeadBlockId)) {
            chainData = new StringBuilder();
            previousEscapedNodeId = "___POST___";
            currentBlockId = this.agentSettings.postChainHeadBlockId;
            node = new BlockNode(this.blocksMap.get(currentBlockId), List.of());
            startLinkProps = this.linkProperties(this.propertiesForLinkingToBlock(node), new String[0]);
            chainData.append(this.createTextNode("After", previousEscapedNodeId, this.nodeIdForBlockInput(node), startLinkProps));
            this.handleChainRec(chainData, visitedBlockIds, currentBlockId, List.of(), "");
            this.headSB.append((CharSequence)chainData);
        }
        this.headSB.append("}\n");
        serializedGraph.dot = this.headSB.toString();
        serializedGraph.blocks = this.usedBlocks;
        TransactionContext.assertNoAttachedTransaction();
        serializedGraph.svg = this.cleanSVGCache(serializedGraph.dot, "dot", false, false);
        return serializedGraph;
    }

    @Override
    protected void cleanupNodeText(Node nodeTextNode, String id, boolean replaceTextContent) throws NodeSelectorException {
        BlockNodeRemapping text = (BlockNodeRemapping)this.labelsRemapping.get(Integer.parseInt(id));
        Element parentNode = (Element)nodeTextNode.getParentNode();
        parentNode.setAttribute("data-id", text.blockId);
        parentNode.setAttribute("data-type", text.type);
        parentNode.setAttribute("data-node-type", text.nodeType.toString());
        parentNode.setAttribute("id", text.nodeId);
        new DOMNodeSelector((Node)parentNode).querySelector("title").setTextContent(text.blockId);
    }

    private String getDescriptionDefinition(SavedModel.BlocksGraphBlock bgb) {
        Object template = "<TR>\n    <TD FIXEDSIZE=\"true\" WIDTH=\"200\" HEIGHT=\"32\"></TD>\n</TR>";
        if (bgb instanceof SavedModel.SetScratchpadEntriesBlock || bgb instanceof SavedModel.SetStateEntriesBlock) {
            List<Object> entriesToSet = new ArrayList();
            if (bgb instanceof SavedModel.SetScratchpadEntriesBlock) {
                SavedModel.SetScratchpadEntriesBlock sspb = (SavedModel.SetScratchpadEntriesBlock)bgb;
                entriesToSet = sspb.entriesToSet;
            } else if (bgb instanceof SavedModel.SetStateEntriesBlock) {
                SavedModel.SetStateEntriesBlock ssb = (SavedModel.SetStateEntriesBlock)bgb;
                entriesToSet = ssb.entriesToSet;
            }
            template = entriesToSet.stream().map(entry -> String.format("<TR>\n    <TD FIXEDSIZE=\"true\" WIDTH=\"200\" HEIGHT=\"32\">%s</TD>\n</TR>", StringEscapeUtils.escapeHtml((String)entry.key), StringEscapeUtils.escapeHtml((String)entry.value))).collect(Collectors.joining("\n"));
        } else if (bgb instanceof SavedModel.MandatoryToolCallBlock || bgb instanceof SavedModel.ReflectionBlock) {
            template = (String)template + (String)template;
        }
        return template;
    }

    @UIModel
    public static class SerializedGraph {
        public String dot;
        public String svg = "";
        public Map<String, SavedModel.BlocksGraphBlock> blocks = new HashMap<String, SavedModel.BlocksGraphBlock>();
    }

    public static class BlockNode {
        public String id;
        public SavedModel.BlocksGraphBlock block;
        public List<String> blockPath;

        public BlockNode(SavedModel.BlocksGraphBlock block, List<String> blockPath) {
            this.block = block;
            this.blockPath = new ArrayList<String>(blockPath);
            this.blockPath.add(GraphSerializerCommon.graphVizEscape(block.id));
            this.id = String.join((CharSequence)"_", this.blockPath);
        }

        public BlockNode(SavedModel.BlocksGraphBlock block, List<String> blockPath, String identifier) {
            this(block, blockPath);
            this.id = this.id + identifier;
        }
    }

    protected static class BlockNodeRemapping
    implements GraphSerializerCommon.LabelRemapping {
        String nodeId;
        String blockId;
        String type;
        NodeType nodeType;

        protected BlockNodeRemapping() {
        }
    }

    @UIModel
    private static enum NodeType {
        BLOCK,
        CONDITION,
        TEXT;

    }
}

