/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TrainingDateExtractorJson
implements ModelExtractor<String> {
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final String jsonPath;
    private final JsonPath compiled;

    public TrainingDateExtractorJson(String jsonPath) {
        this.jsonPath = jsonPath;
        this.compiled = JsonPath.compile((String)jsonPath, (Predicate[])new Predicate[0]);
    }

    @Override
    public String extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        try {
            Object out = documentContext.read(this.compiled);
            if (out instanceof Number) {
                long outAsLong = ((Number)out).longValue();
                return this.sdf.format(new Date(outAsLong));
            }
            if (out != null) {
                return out.toString();
            }
            throw new IOException("Cannot extract the JsonPath \"" + this.jsonPath + "\".");
        }
        catch (PathNotFoundException e) {
            throw new IOException("Cannot extract the JsonPath \"" + this.jsonPath + "\".");
        }
    }
}

