/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.businessapps;

import com.dataiku.dip.coremodel.InfoMessage;

public enum BusinessAppCodes implements InfoMessage.MessageCode
{
    ERR_BUSINESS_APP_NOT_INSTALLED("Business Application not installed or removed", InfoMessage.FixabilityCategory.ADMIN_SETTINGS_MISSING_BUSINESS_APP),
    ERR_BUSINESS_APP_WITHOUT_CODEENV("The Business Application has no code env specification", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_BUSINESS_APP_INVALID_DEFINITION("The Business Application's definition is invalid", InfoMessage.FixabilityCategory.IRRELEVANT),
    ERR_BUSINESS_APP_NOT_ALLOWED("User doesn't have the permission to modify this Business Application", InfoMessage.FixabilityCategory.ADMIN_SETTINGS_BUSINESS_APPS),
    ERR_BUSINESS_APP_UPGRADE_INSTANCE("Business Application instance upgrade failure", InfoMessage.FixabilityCategory.ADMIN_SETTINGS_BUSINESS_APPS),
    ERR_BUSINESS_APP_CREATE_INSTANCE("Business Application instance creation failure", InfoMessage.FixabilityCategory.ADMIN_SETTINGS_BUSINESS_APPS),
    WARN_BUSINESS_APP_UNABLE_TO_TRUST("Business Application instance trust issue", InfoMessage.FixabilityCategory.ADMIN_SETTINGS_BUSINESS_APPS),
    WARN_BUSINESS_APP_UNABLE_TO_START_WEBAPP("Business Application instance start failure", InfoMessage.FixabilityCategory.ADMIN_SETTINGS_BUSINESS_APPS),
    INFO_BUSINESS_APP_INSTALL_OK("Business Application installation succeeded", InfoMessage.FixabilityCategory.IRRELEVANT);

    private final String title;
    private final InfoMessage.FixabilityCategory fixability;

    private BusinessAppCodes(String title, InfoMessage.FixabilityCategory fixability) {
        this.title = title;
        this.fixability = fixability;
    }

    public String getCode() {
        return this.name();
    }

    public String getCodeTitle() {
        return this.title;
    }

    public InfoMessage.FixabilityCategory getFixability() {
        return this.fixability;
    }
}

