/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cli.internalcmd;

import com.dataiku.dip.activity.DSSUsageStatsInternalDB;
import com.dataiku.dip.agentreview.AgentReviewInternalDB;
import com.dataiku.dip.cli.CLICommand;
import com.dataiku.dip.cli.CLISetup;
import com.dataiku.dip.cli.DKU;
import com.dataiku.dip.connections.FilesBasedConnectionsDAO;
import com.dataiku.dip.connections.SQLBaseConnectionService;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.InterestsInternalDB;
import com.dataiku.dip.dao.PersistentNotificationsInternalDB;
import com.dataiku.dip.dao.impl.ExternalCatalogInternalDB;
import com.dataiku.dip.dao.impl.FilesBasedUsersDAO;
import com.dataiku.dip.dao.impl.FlowStateInternalDB;
import com.dataiku.dip.db.AbstractDSSDBService;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.db.DSSDBConnectionsManagementService;
import com.dataiku.dip.db.FromH2Copier;
import com.dataiku.dip.discussions.DiscussionsInternalDB;
import com.dataiku.dip.experimenttracking.ExperimentTrackingInternalDB;
import com.dataiku.dip.hive.catalog.DSSHiveCatalogInternalDB;
import com.dataiku.dip.labeling.LabelingInternalDBService;
import com.dataiku.dip.requestcenter.RequestsInternalDB;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.security.RegularPasswordEncryptionService;
import com.dataiku.dip.security.model.CredentialsService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.DKUTransactionService;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.timelines.ProjectTimelineInternalDB;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.variables.BackendVariablesService;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.cli.Options;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class ImportH2DatabaseToExternalCommand
extends CLICommand {
    private static final int NOT_USED = -1;
    private DSSDBConnectionsManagementService internalDBConnectionsService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.cli.migration");

    @Override
    public String usageString() {
        return "__import_h2_to_external";
    }

    @Override
    public String description() {
        return "Import H2 databases to the external database";
    }

    @Override
    public Options opts() {
        Options options = new Options();
        DKU.addGlobalOptions(options);
        return options;
    }

    @Override
    public int execute(String[] args) throws Exception {
        logger.debug((Object)"Starting import of internal H2 databases.");
        this.parseAndMiniSetup(args, this.usageString(), true);
        try (AnnotationConfigApplicationContext appContext = new AnnotationConfigApplicationContext();){
            appContext.register(new Class[]{SpringUtils.class});
            appContext.register(new Class[]{CredentialsService.class});
            appContext.register(new Class[]{FilesBasedUsersDAO.class});
            appContext.register(new Class[]{FilesBasedConnectionsDAO.class});
            appContext.register(new Class[]{RegularPasswordEncryptionService.class});
            appContext.register(new Class[]{DKUTransactionService.class});
            appContext.register(new Class[]{BackendVariablesService.class});
            appContext.register(new Class[]{GeneralSettingsDAO.class});
            appContext.register(new Class[]{DSSDBConnectionsManagementService.class});
            appContext.register(new Class[]{ScenarioRunContext.class});
            appContext.register(new Class[]{ReadOnlyJobsInternalDB.class});
            appContext.register(new Class[]{SQLBaseConnectionService.class});
            appContext.refresh();
            logger.debug((Object)"App context registered.");
            this.internalDBConnectionsService = (DSSDBConnectionsManagementService)SpringUtils.getBean(DSSDBConnectionsManagementService.class);
            if (this.internalDBConnectionsService.isUsingInternalH2()) {
                throw new IllegalArgumentException("DSS is configured in H2 database mode - migration does not make sense");
            }
            logger.debug((Object)"Copying timelines");
            List<String> projectKeys = CLISetup.listProjectKeys();
            for (int i = 0; i < projectKeys.size(); ++i) {
                String projectKey = projectKeys.get(i);
                logger.infoV("Starting to copy timeline for project %s (%s/%s)", new Object[]{projectKey, i, projectKeys.size()});
                ProjectTimelineInternalDB timelineDB = new ProjectTimelineInternalDB(projectKey);
                FromH2Copier copier = this.newFromH2Copier(timelineDB);
                if (i == 0) {
                    copier.createTablesIfNeeded();
                }
                this.copyTable(timelineDB, "TIMELINE_ITEM", copier);
            }
            logger.debug((Object)"Timelines copied");
            this.createTablesIfNotExistsAndMigrate(new DSSUsageStatsInternalDB(), DSSUsageStatsInternalDB.TABLES);
            this.createTableIfNotExistsAndMigrateNotifications("user_offline_queues");
            this.createTableIfNotExistsAndMigrateNotifications("persistent_notifications");
            this.createTablesIfNotExistsAndMigrate(new InterestsInternalDB(), (List<String>)ImmutableList.of((Object)"INTERESTS"));
            this.createTablesIfNotExistsAndMigrate(new ExternalCatalogInternalDB(), (List<String>)ImmutableList.of((Object)"DSS_METADATA"));
            this.createTablesIfNotExistsAndMigrate(new DiscussionsInternalDB(), DiscussionsInternalDB.TABLES);
            this.createTablesIfNotExistsAndMigrate(new ReadWriteJobsInternalDB(), ReadWriteJobsInternalDB.TABLES);
            this.createTablesIfNotExistsAndMigrate(new FlowStateInternalDB(), FlowStateInternalDB.TABLES);
            this.createTablesIfNotExistsAndMigrate(new DSSHiveCatalogInternalDB(), DSSHiveCatalogInternalDB.TABLES);
            this.createTablesIfNotExistsAndMigrate(new ExperimentTrackingInternalDB(), ExperimentTrackingInternalDB.TABLES);
            this.createTablesIfNotExistsAndMigrate(new LabelingInternalDBService(), LabelingInternalDBService.TABLES);
            this.createTablesIfNotExistsAndMigrate(new RequestsInternalDB(), RequestsInternalDB.TABLES);
            this.createTablesIfNotExistsAndMigrate(new AgentReviewInternalDB(), AgentReviewInternalDB.TABLES);
        }
        return 0;
    }

    private void createTableIfNotExistsAndMigrateNotifications(String notificationsName) throws Exception {
        PersistentNotificationsInternalDB notificationsDB = new PersistentNotificationsInternalDB(notificationsName, -1);
        FromH2Copier copier = this.newFromH2Copier(notificationsDB);
        copier.createTablesIfNeeded();
        this.copyTable(notificationsDB, notificationsDB.getName(), copier);
    }

    private void createTablesIfNotExistsAndMigrate(AbstractDSSDBService db, List<String> tables) throws Exception {
        FromH2Copier copier = this.newFromH2Copier(db);
        copier.createTablesIfNeeded();
        logger.infoV("Starting to copy database %s", new Object[]{db.getName()});
        int i = 1;
        for (String table : tables) {
            logger.infoV("db=%s table=%s: Starting to copy table (table %d/%d)", new Object[]{db.getName(), table, i, tables.size()});
            this.copyTable(db, table, copier);
            logger.infoV("db=%s table=%s: Done copying table (table %d/%d)", new Object[]{db.getName(), table, i, tables.size()});
            ++i;
        }
    }

    private FromH2Copier newFromH2Copier(AbstractDSSDBService db) throws Exception {
        return new FromH2Copier(db, db.getH2File());
    }

    private void copyTable(AbstractDSSDBService involvedService, String sourceTableName, FromH2Copier fromH2Copier) throws Exception {
        SQLUtils.SQLTable targetTable = involvedService.resolveTable(sourceTableName);
        logger.debugV("Import internal H2 databases: %s", new Object[]{sourceTableName});
        try (DSSDBConnection targetConnection = this.internalDBConnectionsService.acquire(involvedService.getDBRef());){
            try {
                fromH2Copier.copyToTarget(sourceTableName, targetTable, targetConnection, this.internalDBConnectionsService.getDialect());
            }
            catch (Exception e) {
                logger.errorV("Could not import internal H2 database from %s.", new Object[]{sourceTableName});
                throw e;
            }
            logger.debugV("Internal H2 databases imported in: %s", new Object[]{targetTable});
        }
    }
}

