/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.analysis.model.llm.LLMModelSnippetData;
import com.dataiku.dip.connections.AbstractAzureAIConnection;
import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.llm.online.openai.OpenAIImageHandling;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ConnectionsTestService;
import com.dataiku.dip.utils.DKULogger;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

public class AzureOpenAIConnection
extends AbstractAzureAIConnection<AzureOpenAIDeployment, HardcodedAzureOpenAIModel, CustomAzureOpenAIModel> {
    public static final String connectionType = "AzureOpenAI";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.connections.azureopenai");

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public ConnectionsTestService.ConnectionTestResult testConnection(AuthCtx authCtx, ConnectionsTestService connectionsTestService) throws Exception {
        return connectionsTestService.testAzureOpenAI(this, authCtx);
    }

    @Override
    protected boolean isHardcodedModelEnabled(HardcodedAzureOpenAIModel hardcodedModel) {
        return hardcodedModel.allowedModel.apply(this.params);
    }

    @Override
    protected List<HardcodedAzureOpenAIModel> listRawHardcodedModels() {
        return Arrays.asList(HardcodedAzureOpenAIModel.values());
    }

    @Override
    protected AzureOpenAIModel loadRawHardcodedModel(HardcodedAzureOpenAIModel hardcodedModel) {
        AzureOpenAIModel model = hardcodedModel.toModel();
        this.loadDefaultHardcodedModelSettings(hardcodedModel, model);
        return model;
    }

    @Override
    protected DKULogger getLogger() {
        return logger;
    }

    public static enum HardcodedAzureOpenAIModel implements AbstractLLMConnection.IHardcodedConnectionModel<AbstractAzureAIConnection.AbstractAzureAIModel>
    {
        GPT3_DAVINCI("davinci-002", "GPT 3 - Davinci", false, true, p -> p.allowDavinciFinetuning),
        GPT3_BABBAGE("babbage-002", "GPT 3 - Babbage", false, true, p -> p.allowBabbageFinetuning),
        GPT35_TURBO_0125("gpt-35-turbo-0125", "GPT 3.5 Turbo - 0125", true, true, p -> p.allowGPT35Turbo0125Finetuning),
        GPT35_TURBO_0613("gpt-35-turbo-0613", "GPT 3.5 Turbo - 0613", true, false, p -> p.allowGPT35Turbo0613Finetuning),
        GPT35_TURBO_1106("gpt-35-turbo-1106", "GPT 3.5 Turbo - 1106", true, true, p -> p.allowGPT35Turbo1106Finetuning),
        GPT4O_MINI("gpt-4o-mini-2024-07-18", "GPT 4o Mini", true, true, p -> p.allowGPT4OMiniFinetuning),
        GPT4O("gpt-4o-2024-08-06", "GPT 4o", true, true, p -> p.allowGPT4OFinetuning),
        GPT41_MINI("gpt-4.1-mini-2025-04-14", "GPT 4.1 Mini", true, true, p -> p.allowGPT41MiniFinetuning),
        GPT41("gpt-4.1-2025-04-14", "GPT 4.1", true, true, p -> p.allowGPT41Finetuning),
        GPT41_NANO("gpt-4.1-nano-2025-04-14", "GPT 4.1 Nano", true, true, p -> p.allowGPT41NanoFinetuning),
        GPTO4_MINI("gpt-o4-mini-2025-04-16", "GPT O4 Mini", true, true, p -> p.allowGPTO4Mini);

        public final String id;
        public final String displayName;
        public final boolean useChatAPI;
        public final boolean canBeFineTuned;
        public final Function<AbstractAzureAIConnection.BaseAzureAIConnectionParams<AzureOpenAIDeployment>, Boolean> allowedModel;

        private HardcodedAzureOpenAIModel(String id, String displayName, boolean useChatAPI, boolean canBeFineTuned, Function<AbstractAzureAIConnection.BaseAzureAIConnectionParams<AzureOpenAIDeployment>, Boolean> allowedModel) {
            this.id = id;
            this.displayName = displayName;
            this.useChatAPI = useChatAPI;
            this.canBeFineTuned = canBeFineTuned;
            this.allowedModel = allowedModel;
        }

        @Override
        public AzureOpenAIModel toModel() {
            AzureOpenAIModel model = new AzureOpenAIModel();
            model.id = this.id;
            model.displayName = this.displayName;
            model.underlyingModelName = this.id;
            model.useChatApi = this.useChatAPI;
            model.canBeFineTuned = this.canBeFineTuned;
            model.deploymentType = null;
            return model;
        }
    }

    public static class AzureOpenAIModel
    extends AbstractAzureAIConnection.AbstractAzureAIModel {
        @Override
        public LLMStructuredRef asStructuredRef(String connection) {
            if (this.isDeployment()) {
                return LLMStructuredRef.forAzureAIConnection(connection, this.getId(), LLMStructuredRef.LLMType.AZURE_OPENAI_DEPLOYMENT);
            }
            return LLMStructuredRef.forAzureAIConnection(connection, this.getId(), LLMStructuredRef.LLMType.AZURE_OPENAI_MODEL);
        }

        @Override
        public AbstractAzureAIConnection.AbstractAzureAIModel toFineTunedModel(LLMModelSnippetData snippetData) {
            AzureOpenAIModel fineTunedModel = new AzureOpenAIModel();
            fineTunedModel.id = snippetData.llmSMInfo.remoteModelId;
            if (snippetData.deployment != null) {
                fineTunedModel.deploymentId = snippetData.deployment.deploymentId;
            }
            fineTunedModel.useChatApi = this.useChatApi;
            fineTunedModel.baseModelId = this.getId();
            fineTunedModel.isDKUFineTuned = true;
            fineTunedModel.canBeFineTuned = true;
            fineTunedModel.displayName = this.displayName;
            fineTunedModel.embeddingSize = this.embeddingSize;
            fineTunedModel.maxTokensLimit = this.maxTokensLimit;
            fineTunedModel.promptCost = this.promptCost;
            fineTunedModel.completionCost = this.completionCost;
            fineTunedModel.embeddingCost = this.embeddingCost;
            fineTunedModel.rerankingRequestCost = this.rerankingRequestCost;
            fineTunedModel.rerankingTokenCost = this.rerankingTokenCost;
            fineTunedModel.rerankingDocumentCost = this.rerankingDocumentCost;
            return fineTunedModel;
        }
    }

    public static class CustomAzureOpenAIModel
    extends AbstractAzureAIConnection.AbstractCustomAzureAIModel {
        @Override
        protected AzureOpenAIModel initModel() {
            return new AzureOpenAIModel();
        }
    }

    public static class AzureOpenAIDeployment
    extends AbstractAzureAIConnection.AbstractAzureAIDeployment {
        public AbstractAzureAIConnection.AzureOpenAIMaxTokensAPIMode maxTokensAPIMode = AbstractAzureAIConnection.AzureOpenAIMaxTokensAPIMode.LEGACY;

        @Override
        protected String getType() {
            return "Azure OpenAI";
        }

        @Override
        protected OpenAIImageHandling getDefaultImageHandlingMode() {
            return OpenAIImageHandling.DALL_E_3;
        }

        @Override
        protected AzureOpenAIModel initModel() {
            return new AzureOpenAIModel();
        }

        @Override
        AbstractAzureAIConnection.AzureOpenAIMaxTokensAPIMode getMaxTokensAPIMode() {
            return this.maxTokensAPIMode;
        }
    }
}

