/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections.bigquery.builtin;

public class SqlLikePatternMatcher {
    private static final char[] META_CHARACTERS = "<([{\\^-=$!|]})?*+.>".toCharArray();

    public static boolean matches(String str, String pattern) {
        if ("%".equals(pattern)) {
            return true;
        }
        StringBuilder regexpStr = new StringBuilder();
        regexpStr.append("^");
        for (int i = 0; i < pattern.length(); ++i) {
            char c2 = pattern.charAt(i);
            if (c2 == '%') {
                regexpStr.append(".*");
                continue;
            }
            if (c2 == '_') {
                regexpStr.append(".");
                continue;
            }
            if (SqlLikePatternMatcher.isMetaCharacter(c2)) {
                regexpStr.append("\\");
            }
            regexpStr.append(c2);
        }
        regexpStr.append("$");
        return str.matches(regexpStr.toString());
    }

    private static boolean isMetaCharacter(char c2) {
        for (char metaCharacter : META_CHARACTERS) {
            if (c2 != metaCharacter) continue;
            return true;
        }
        return false;
    }
}

