/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.MiscCodes;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.db.AbstractDSSDBService;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.sql.queries.AddColumnQueryBuilder;
import com.dataiku.dip.sql.queries.CreateIndexQueryBuilder;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.timelines.EnrichmentService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.EnumUtils;
import org.springframework.stereotype.Service;

@Service
public class InterestsInternalDB
extends AbstractDSSDBService {
    private static final String DB_NAME = "user_interests";
    private static final int SCHEMA_VERSION = 5;
    private static final ExpressionBuilder.ExpressionBuilderFactory EBF = new ExpressionBuilder.ExpressionBuilderFactory();
    private final String insert = "INSERT INTO " + this.getQuotedFullResolvedTableName("INTERESTS") + " VALUES (?,?,?,?,?,?,?)";
    private final String get = "SELECT " + this.quote("WATCHING") + ", " + this.quote("STARRED") + " FROM " + this.getQuotedFullResolvedTableName("INTERESTS") + " WHERE " + this.quote("USER") + "=? AND " + this.quote("OBJECT_TYPE") + "=? AND " + this.quote("PROJECT_KEY") + "=? AND " + this.quote("OBJECT_ID") + "=? AND " + this.quote("WORKSPACE_KEY") + "=? ORDER BY " + this.quote("STARRED") + " DESC, " + this.quote("PROJECT_KEY") + ", " + this.quote("OBJECT_TYPE") + ", " + this.quote("OBJECT_ID");
    private final String update = "UPDATE " + this.getQuotedFullResolvedTableName("INTERESTS") + " SET " + this.quote("WATCHING") + "=?, " + this.quote("STARRED") + "=? WHERE " + this.quote("USER") + "=? AND " + this.quote("OBJECT_TYPE") + "=? AND " + this.quote("PROJECT_KEY") + "=? AND " + this.quote("OBJECT_ID") + "=? AND " + this.quote("WORKSPACE_KEY") + "=?";
    private final String getAllWatches = "SELECT " + this.quote("USER") + ", " + this.quote("OBJECT_TYPE") + ", " + this.quote("PROJECT_KEY") + ", " + this.quote("OBJECT_ID") + ", " + this.quote("WATCHING") + ", " + this.quote("STARRED") + ", " + this.quote("WORKSPACE_KEY") + " FROM " + this.getQuotedFullResolvedTableName("INTERESTS") + " WHERE " + this.quote("WATCHING") + ">1";
    private final String getAllDeepWatches = "SELECT " + this.quote("USER") + ", " + this.quote("PROJECT_KEY") + " FROM " + this.getQuotedFullResolvedTableName("INTERESTS") + " WHERE " + this.quote("OBJECT_TYPE") + "='PROJECT' AND " + this.quote("WATCHING") + ">2";
    private final String getWatchingUsers = "SELECT " + this.quote("USER") + " FROM " + this.getQuotedFullResolvedTableName("INTERESTS") + " WHERE " + this.quote("OBJECT_TYPE") + "=? AND " + this.quote("PROJECT_KEY") + "=? AND " + this.quote("OBJECT_ID") + "=? AND " + this.quote("WORKSPACE_KEY") + "=? AND " + this.quote("WATCHING") + ">1";
    private final String getDeepWatchingUsers = "SELECT " + this.quote("USER") + " FROM " + this.getQuotedFullResolvedTableName("INTERESTS") + " WHERE " + this.quote("OBJECT_TYPE") + "='PROJECT' AND " + this.quote("PROJECT_KEY") + "=? AND " + this.quote("WATCHING") + ">2";
    private final String base = "SELECT " + this.quote("OBJECT_TYPE") + ", " + this.quote("PROJECT_KEY") + ", " + this.quote("OBJECT_ID") + ", " + this.quote("WATCHING") + ", " + this.quote("STARRED") + ", " + this.quote("WORKSPACE_KEY") + " FROM " + this.getQuotedFullResolvedTableName("INTERESTS") + " WHERE ";
    private final String getUserInterests = this.base + this.quote("USER") + "=? AND (" + this.quote("STARRED") + "=TRUE OR " + this.quote("WATCHING") + ">1) ORDER BY " + this.quote("STARRED") + " DESC, " + this.quote("PROJECT_KEY") + ", " + this.quote("OBJECT_TYPE") + ", " + this.quote("OBJECT_ID") + " LIMIT ? OFFSET ?";
    private final String getUserInterestsForType = this.base + this.quote("USER") + "=? AND " + this.quote("OBJECT_TYPE") + "=? AND (" + this.quote("STARRED") + "=TRUE OR " + this.quote("WATCHING") + ">1) ORDER BY " + this.quote("STARRED") + " DESC, " + this.quote("PROJECT_KEY") + ", " + this.quote("OBJECT_TYPE") + ", " + this.quote("OBJECT_ID") + " LIMIT ? OFFSET ?";
    private final String getUserInterestsForProject = this.base + this.quote("USER") + "=? AND " + this.quote("PROJECT_KEY") + "=? AND (" + this.quote("STARRED") + "=TRUE OR " + this.quote("WATCHING") + ">1) ORDER BY " + this.quote("STARRED") + " DESC, " + this.quote("PROJECT_KEY") + ", " + this.quote("OBJECT_TYPE") + ", " + this.quote("OBJECT_ID") + " LIMIT ? OFFSET ?";
    private final String getUserInterestsForWorkspace = this.base + this.quote("USER") + "=? AND " + this.quote("WORKSPACE_KEY") + "=? AND (" + this.quote("STARRED") + "=TRUE OR " + this.quote("WATCHING") + ">1) ORDER BY " + this.quote("STARRED") + " DESC, " + this.quote("WORKSPACE_KEY") + ", " + this.quote("OBJECT_TYPE") + ", " + this.quote("OBJECT_ID") + " LIMIT ? OFFSET ?";
    private final String getUserInterestsForProjectTypeAndWorkspace = this.base + this.quote("USER") + "=? AND " + this.quote("OBJECT_TYPE") + "=? AND " + this.quote("PROJECT_KEY") + "=? AND " + this.quote("WORKSPACE_KEY") + "=? AND (" + this.quote("STARRED") + "=TRUE OR " + this.quote("WATCHING") + ">1) ORDER BY " + this.quote("STARRED") + " DESC, " + this.quote("WORKSPACE_KEY") + ", " + this.quote("PROJECT_KEY") + ", " + this.quote("OBJECT_TYPE") + ", " + this.quote("OBJECT_ID") + " LIMIT ? OFFSET ?";
    private final String getUserInterestsForProjectAndType = this.base + this.quote("USER") + "=? AND " + this.quote("OBJECT_TYPE") + "=? AND " + this.quote("PROJECT_KEY") + "=? AND (" + this.quote("STARRED") + "=TRUE OR " + this.quote("WATCHING") + ">1) ORDER BY " + this.quote("STARRED") + " DESC, " + this.quote("PROJECT_KEY") + ", " + this.quote("OBJECT_TYPE") + ", " + this.quote("OBJECT_ID") + " LIMIT ? OFFSET ?";
    private final String getUserInterestsForWorkspaceAndType = this.base + this.quote("USER") + "=? AND " + this.quote("OBJECT_TYPE") + "=? AND " + this.quote("WORKSPACE_KEY") + "=? AND (" + this.quote("STARRED") + "=TRUE OR " + this.quote("WATCHING") + ">1) ORDER BY " + this.quote("STARRED") + " DESC, " + this.quote("WORKSPACE_KEY") + ", " + this.quote("OBJECT_TYPE") + ", " + this.quote("OBJECT_ID") + " LIMIT ? OFFSET ?";
    private final String getUsersWithStar = "SELECT " + this.quote("USER") + " FROM " + this.getQuotedFullResolvedTableName("INTERESTS") + " WHERE " + this.quote("OBJECT_TYPE") + "=? AND " + this.quote("PROJECT_KEY") + "=? AND " + this.quote("OBJECT_ID") + "=? AND " + this.quote("WORKSPACE_KEY") + "=? AND " + this.quote("STARRED") + "=TRUE ORDER BY " + this.quote("USER");
    private final String getUserStars = this.base + this.quote("USER") + "=? AND (" + this.quote("STARRED") + "=TRUE) ORDER BY " + this.quote("STARRED") + " DESC, " + this.quote("PROJECT_KEY") + ", " + this.quote("OBJECT_TYPE") + ", " + this.quote("OBJECT_ID") + " LIMIT ? OFFSET ?";
    private final String getAllUserStarredItemsForObjectType = this.base + this.quote("OBJECT_TYPE") + "=? AND " + this.quote("USER") + "=? AND " + this.quote("STARRED") + "=TRUE;";
    private final String deleteProject = "DELETE FROM " + this.getQuotedFullResolvedTableName("INTERESTS") + " WHERE " + this.quote("PROJECT_KEY") + "=?";
    private final String deleteWorkspace = "DELETE FROM " + this.getQuotedFullResolvedTableName("INTERESTS") + " WHERE " + this.quote("WORKSPACE_KEY") + "=?";
    private final String deleteProjectFolder = "DELETE FROM " + this.getQuotedFullResolvedTableName("INTERESTS") + " WHERE " + this.quote("OBJECT_ID") + "=? AND " + this.quote("OBJECT_TYPE") + "=" + this.quoteString("PROJECT_FOLDER");
    private final String deleteObject = "DELETE FROM " + this.getQuotedFullResolvedTableName("INTERESTS") + " WHERE " + this.quote("OBJECT_TYPE") + "=? AND " + this.quote("PROJECT_KEY") + "=? AND " + this.quote("OBJECT_ID") + "=?";
    private final String deleteObjectFromWorkspace = "DELETE FROM " + this.getQuotedFullResolvedTableName("INTERESTS") + " WHERE " + this.quote("OBJECT_TYPE") + "=? AND " + this.quote("PROJECT_KEY") + "=? AND " + this.quote("OBJECT_ID") + "=? AND " + this.quote("WORKSPACE_KEY") + "=?";
    private final String deleteUser = "DELETE FROM " + this.getQuotedFullResolvedTableName("INTERESTS") + " WHERE " + this.quote("USER") + "=?";
    private final String changeObjectId = "UPDATE " + this.getQuotedFullResolvedTableName("INTERESTS") + " SET " + this.quote("OBJECT_ID") + "=? WHERE " + this.quote("PROJECT_KEY") + "=? AND " + this.quote("OBJECT_TYPE") + "=? AND " + this.quote("OBJECT_ID") + "=?";
    public static final String INTERESTS_TABLE = "INTERESTS";
    private static final String USER_COLUMN = "USER";
    private static final SchemaColumn USER_SCHEMA_COLUMN = new SchemaColumn("USER", Type.STRING);
    private static final String OBJECT_TYPE_COLUMN = "OBJECT_TYPE";
    private static final SchemaColumn OBJECT_TYPE_SCHEMA_COLUMN = new SchemaColumn("OBJECT_TYPE", Type.STRING);
    private static final String PROJECT_KEY_COLUMN = "PROJECT_KEY";
    private static final SchemaColumn PROJECT_KEY_SCHEMA_COLUMN = new SchemaColumn("PROJECT_KEY", Type.STRING);
    private static final String OBJECT_ID_COLUMN = "OBJECT_ID";
    private static final SchemaColumn OBJECT_ID_SCHEMA_COLUMN = new SchemaColumn("OBJECT_ID", Type.STRING);
    private static final String WATCHING_COLUMN = "WATCHING";
    private static final SchemaColumn WATCHING_SCHEMA_COLUMN = new SchemaColumn("WATCHING", Type.TINYINT);
    private static final String STARRED_COLUMN = "STARRED";
    private static final SchemaColumn STARRED_SCHEMA_COLUMN = new SchemaColumn("STARRED", Type.BOOLEAN);
    private static final String WORKSPACE_KEY_COLUMN = "WORKSPACE_KEY";
    private static final SchemaColumn WORKSPACE_KEY_SCHEMA_COLUMN = new SchemaColumn("WORKSPACE_KEY", Type.STRING);
    private static final SchemaColumn[] interestsColumns = new SchemaColumn[]{USER_SCHEMA_COLUMN, OBJECT_TYPE_SCHEMA_COLUMN, PROJECT_KEY_SCHEMA_COLUMN, OBJECT_ID_SCHEMA_COLUMN, WATCHING_SCHEMA_COLUMN, STARRED_SCHEMA_COLUMN, WORKSPACE_KEY_SCHEMA_COLUMN};
    private static final int DEFAULT_LIMIT = 100000;
    private static final String PROJECT_FOLDER_TYPE = "PROJECT_FOLDER";
    private static DKULogger logger = DKULogger.getLogger((String)"dku.collaboration.interests");

    public InterestsInternalDB() {
        super(ApplicationConfigurator.getDatabaseFile(DB_NAME), DB_NAME, DB_NAME, 5, false);
    }

    @PostConstruct
    public void init() throws SQLException {
        this.create();
    }

    public void deleteForProject(String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"projectKey not specified");
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.deleteProject);
            ps2.setString(1, projectKey);
            ps2.execute();
            conn.commit();
        }
        catch (Exception e) {
            logger.errorV("Failed to delete user interests for project '%s': " + ExceptionUtils.getMessageWithCauses((Throwable)e), new Object[0]);
        }
    }

    public void deleteForWorkspace(String workspaceKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workspaceKey), (Object)"workspaceKey not specified");
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.deleteWorkspace);
            ps2.setString(1, workspaceKey);
            ps2.execute();
            conn.commit();
        }
        catch (Exception e) {
            logger.errorV("Failed to delete user interests for workspace '%s': " + ExceptionUtils.getMessageWithCauses((Throwable)e), new Object[0]);
        }
    }

    public void deleteForFolder(String folderId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)folderId), (Object)"folderId not specified");
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.deleteProjectFolder);
            ps2.setString(1, folderId);
            ps2.execute();
            conn.commit();
        }
        catch (Exception e) {
            logger.errorV("Failed to delete user interests for project folder '%s': " + ExceptionUtils.getMessageWithCauses((Throwable)e), new Object[0]);
        }
    }

    @Override
    protected void initDB(int currentSchemaVersion, DSSDBConnection conn) throws CodedSQLException {
        block26: {
            try {
                Statement st2;
                if (currentSchemaVersion == 0) {
                    st2 = conn.createStatement();
                    try {
                        this.createTable(INTERESTS_TABLE, interestsColumns, null, st2);
                    }
                    finally {
                        if (st2 != null) {
                            st2.close();
                        }
                    }
                }
                if (currentSchemaVersion < 4) {
                    st2 = conn.createStatement();
                    try {
                        CreateIndexQueryBuilder.createAnonymousIndex(this.resolveTable(INTERESTS_TABLE)).addColumns(USER_COLUMN).execute(st2, this.getDialect());
                        CreateIndexQueryBuilder.createAnonymousIndex(this.resolveTable(INTERESTS_TABLE)).addColumns(OBJECT_TYPE_COLUMN, PROJECT_KEY_COLUMN, OBJECT_ID_COLUMN).execute(st2, this.getDialect());
                        CreateIndexQueryBuilder.createAnonymousIndex(this.resolveTable(INTERESTS_TABLE)).addColumns(USER_COLUMN, OBJECT_TYPE_COLUMN, PROJECT_KEY_COLUMN).execute(st2, this.getDialect());
                    }
                    finally {
                        if (st2 != null) {
                            st2.close();
                        }
                    }
                }
                if (currentSchemaVersion >= 5) break block26;
                st2 = conn.createStatement();
                try {
                    if (currentSchemaVersion == 0) {
                        this.createAnonymousIndex(INTERESTS_TABLE, new String[]{WORKSPACE_KEY_SCHEMA_COLUMN.getName()}, st2);
                    } else {
                        logger.debug((Object)"Adding workspaceKey column to interest DB");
                        AddColumnQueryBuilder.addColumnTo(this.resolveTable(INTERESTS_TABLE)).addColumns(WORKSPACE_KEY_SCHEMA_COLUMN).execute(st2, this.getDialect());
                        this.createAnonymousIndex(INTERESTS_TABLE, new String[]{WORKSPACE_KEY_SCHEMA_COLUMN.getName()}, st2);
                        String fillColumnQuery = String.format("UPDATE %s SET %s = '%s'", this.getDialect().getQuotedTableFullName(this.resolveTable(INTERESTS_TABLE)), this.getDialect().quoteIdentifier(WORKSPACE_KEY_SCHEMA_COLUMN.getName()), "");
                        logger.debug((Object)"Filling column workspaceId with empty value");
                        st2.execute(fillColumnQuery);
                    }
                }
                finally {
                    if (st2 != null) {
                        st2.close();
                    }
                }
            }
            catch (SQLException e) {
                throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed to access internal database", (Throwable)e);
            }
        }
    }

    public WatchersResponse getEffectiveWatchingUsers(ITaggingService.TaggableType objectType, @Nullable String projectKey, String objectId, @Nullable String workspaceKey) throws SQLException {
        Preconditions.checkArgument((StringUtils.isNotBlank((String)projectKey) || StringUtils.isNotBlank((String)workspaceKey) ? 1 : 0) != 0, (Object)"Either Project key or workspace key must be specified");
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getWatchingUsers);
            ps2.setString(1, objectType.toString());
            ps2.setString(2, StringUtils.defaultString((String)projectKey, (String)""));
            ps2.setString(3, objectId);
            ps2.setString(4, StringUtils.defaultString((String)workspaceKey, (String)""));
            ps2.execute();
            HashSet<String> users = new HashSet<String>();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    users.add(rs2.getString(1));
                }
            }
            WatchersResponse ret = new WatchersResponse();
            ret.direct = users;
            ret.deep = StringUtils.isEmpty((String)workspaceKey) ? this.getDeepWatchingUsers(projectKey, conn) : Collections.emptySet();
            WatchersResponse watchersResponse = ret;
            return watchersResponse;
        }
    }

    public Map<String, List<String>> getAllDeepWatches() throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getAllDeepWatches);
            ps2.execute();
            HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    String projectKey = rs2.getString(PROJECT_KEY_COLUMN);
                    if (!ret.keySet().contains(projectKey)) {
                        ret.put(projectKey, new ArrayList());
                    }
                    String user = rs2.getString(USER_COLUMN);
                    ((List)ret.get(projectKey)).add(user);
                }
            }
            HashMap<String, List<String>> hashMap = ret;
            return hashMap;
        }
    }

    public List<String> getUsersWithStar(ITaggingService.TaggableType objectType, @Nullable String projectKey, String objectId, @Nullable String workspaceKey) throws SQLException {
        Preconditions.checkArgument((StringUtils.isNotBlank((String)projectKey) || StringUtils.isNotBlank((String)workspaceKey) ? 1 : 0) != 0, (Object)"Either Project key or workspace key must be specified");
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getUsersWithStar);
            ps2.setString(1, objectType.toString());
            ps2.setString(2, StringUtils.defaultString((String)projectKey, (String)""));
            ps2.setString(3, objectId);
            ps2.setString(4, StringUtils.defaultString((String)workspaceKey, (String)""));
            ps2.execute();
            HashSet<String> users = new HashSet<String>();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    users.add(rs2.getString(1));
                }
            }
            ArrayList arrayList = Lists.newArrayList(users);
            return arrayList;
        }
    }

    public Watching getWatching(String user, ITaggingService.TaggableType objectType, String projectKey, String objectId, String workspaceKey) throws SQLException {
        RawInterest ri = this.get(user, objectType, projectKey, objectId, workspaceKey);
        if (ri != null) {
            return ri.watching;
        }
        return Watching.INO;
    }

    public void setWatch(String user, ITaggingService.TaggableType objectType, String projectKey, String objectId, String workspaceKey, Watching watching) throws SQLException {
        RawInterest ri = this.get(user, objectType, projectKey, objectId, workspaceKey);
        if (ri != null) {
            this.update(user, objectType, projectKey, objectId, workspaceKey, watching, ri.starred);
        } else {
            this.insert(user, objectType, projectKey, objectId, workspaceKey, watching, false);
        }
    }

    public void setStar(String user, ITaggingService.TaggableType objectType, String projectKey, String objectId, String workspaceKey, boolean starred) throws SQLException {
        RawInterest ri = this.get(user, objectType, projectKey, objectId, workspaceKey);
        if (ri != null) {
            this.update(user, objectType, projectKey, objectId, workspaceKey, ri.watching, starred);
        } else {
            this.insert(user, objectType, projectKey, objectId, workspaceKey, null, starred);
        }
    }

    public void setNonTaggableTypeStar(String user, NonTaggableType objectType, String objectId, boolean starred) throws SQLException {
        RawInterest ri = this.get(user, objectType, null, objectId, null);
        if (ri != null) {
            this.update(user, objectType, objectId, ri.watching, starred);
        } else {
            this.insert(user, objectType, objectId, null, starred);
        }
    }

    public Interest getObjectAndUserInterest(String user, ITaggingService.TaggableType objectType, @Nullable String projectKey, String objectId, @Nullable String workspaceKey) throws SQLException {
        Preconditions.checkArgument((StringUtils.isNotBlank((String)projectKey) || StringUtils.isNotBlank((String)workspaceKey) ? 1 : 0) != 0, (Object)"Either Project key or workspace key must be specified");
        TaggableObjectRefWithInterest ret = new TaggableObjectRefWithInterest(objectType, projectKey, objectId, workspaceKey);
        SelectQueryBuilder sqb = new SelectQueryBuilder();
        sqb.from(this.resolveTable(INTERESTS_TABLE), INTERESTS_TABLE);
        sqb.select(EBF.caseWhen(EBF.col(WATCHING_COLUMN).gt(1), 1, 0).sum(), "nb_watching");
        sqb.select(EBF.col(STARRED_COLUMN).castToInt().sum(), "nb_starred");
        sqb.where(EBF.parameterizedColumnOperation(OBJECT_TYPE_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ).and(EBF.parameterizedColumnOperation(PROJECT_KEY_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ)).and(EBF.parameterizedColumnOperation(OBJECT_ID_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ)).and(EBF.parameterizedColumnOperation(WORKSPACE_KEY_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ)).and(EBF.col(STARRED_COLUMN).isTrue().or(EBF.col(WATCHING_COLUMN).gt(1))));
        try (DSSDBConnection c2 = this.acquireConnection();
             PreparedStatement ps2 = c2.prepareNonPersistedStatement(sqb.toSQL(this.getDialect()));){
            ps2.setString(1, objectType.toString());
            ps2.setString(2, StringUtils.defaultString((String)projectKey, (String)""));
            ps2.setString(3, objectId);
            ps2.setString(4, StringUtils.defaultString((String)workspaceKey, (String)""));
            ps2.execute();
            try (ResultSet rs2 = ps2.getResultSet();){
                if (rs2.next()) {
                    ret.nbWatching = rs2.getInt(1);
                    ret.nbStarred = rs2.getInt(2);
                }
            }
        }
        ret.watching = this.getWatching(user, objectType, projectKey, objectId, workspaceKey);
        ret.starred = this.hasStarred(user, objectType, projectKey, objectId, workspaceKey);
        return ret;
    }

    public List<TaggableObjectRefWithInterest> getUserInterests(String user, int limit, int offset, ITaggingService.TaggableType type, String projectKey, String workspaceKey, boolean starsOnly) throws SQLException {
        if (type == null && StringUtils.isBlank((String)projectKey) && StringUtils.isBlank((String)workspaceKey)) {
            return this.getUserInterests(user, limit, offset, starsOnly);
        }
        if (type != null && StringUtils.isNotBlank((String)projectKey) && StringUtils.isNotBlank((String)workspaceKey)) {
            return this.getUserInterestsForProjectTypeAndWorkspace(user, type, projectKey, workspaceKey);
        }
        if (type != null && StringUtils.isNotBlank((String)projectKey) && StringUtils.isBlank((String)workspaceKey)) {
            return this.getUserInterestsForProjectAndType(user, type, projectKey);
        }
        if (type != null && StringUtils.isBlank((String)projectKey) && StringUtils.isNotBlank((String)workspaceKey)) {
            return this.getUserInterestsForWorkspaceAndType(user, type, workspaceKey);
        }
        if (type != null) {
            return this.getUserInterestsForType(user, limit, offset, type);
        }
        if (StringUtils.isNotBlank((String)workspaceKey)) {
            return this.getUserInterestsForWorkspace(user, limit, offset, workspaceKey);
        }
        return this.getUserInterestsForProject(user, limit, offset, projectKey);
    }

    public List<TaggableObjectRefWithInterest> getUserInterestsForProjectTypeAndWorkspace(String user, ITaggingService.TaggableType objectType, String projectKey, String workspaceKey) throws SQLException {
        return this.getUserInterestsForProjectTypeAndWorkspace(user, objectType, projectKey, workspaceKey, 0, 100000);
    }

    public List<TaggableObjectRefWithInterest> getUserInterestsForProjectTypeAndWorkspace(String user, ITaggingService.TaggableType objectType, String projectKey, String workspaceKey, int offset, int limit) throws SQLException {
        logger.trace(() -> "getUserInterestsForProjectTypeAndWorkspace:" + projectKey + " " + String.valueOf((Object)objectType) + " " + workspaceKey);
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getUserInterestsForProjectTypeAndWorkspace);
            ps2.setString(1, user);
            ps2.setString(2, objectType.toString());
            ps2.setString(3, projectKey);
            ps2.setString(4, workspaceKey);
            ps2.setInt(5, limit);
            ps2.setInt(6, offset);
            ps2.execute();
            ArrayList<TaggableObjectRefWithInterest> owis = new ArrayList<TaggableObjectRefWithInterest>();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    this.parseResultSetAsTaggableType(rs2).ifPresent(owis::add);
                }
            }
            ArrayList<TaggableObjectRefWithInterest> arrayList = owis;
            return arrayList;
        }
    }

    public List<TaggableObjectRefWithInterest> getUserInterestsForProjectAndType(String user, ITaggingService.TaggableType objectType, String projectKey) throws SQLException {
        return this.getUserInterestsForProjectAndType(user, objectType, projectKey, 0, 100000);
    }

    public List<TaggableObjectRefWithInterest> getUserInterestsForProjectAndType(String user, ITaggingService.TaggableType objectType, String projectKey, int offset, int limit) throws SQLException {
        logger.trace(() -> "getUserInterestsForProjectAndType:" + projectKey + " " + String.valueOf((Object)objectType));
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getUserInterestsForProjectAndType);
            ps2.setString(1, user);
            ps2.setString(2, objectType.toString());
            ps2.setString(3, projectKey);
            ps2.setInt(4, limit);
            ps2.setInt(5, offset);
            ps2.execute();
            ArrayList<TaggableObjectRefWithInterest> owis = new ArrayList<TaggableObjectRefWithInterest>();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    this.parseResultSetAsTaggableType(rs2).ifPresent(owis::add);
                }
            }
            ArrayList<TaggableObjectRefWithInterest> arrayList = owis;
            return arrayList;
        }
    }

    public List<TaggableObjectRefWithInterest> getUserInterestsForWorkspaceAndType(String user, ITaggingService.TaggableType objectType, String workspaceKey) throws SQLException {
        return this.getUserInterestsForWorkspaceAndType(user, objectType, workspaceKey, 0, 100000);
    }

    public List<TaggableObjectRefWithInterest> getUserInterestsForWorkspaceAndType(String user, ITaggingService.TaggableType objectType, String workspaceKey, int offset, int limit) throws SQLException {
        logger.trace(() -> "getUserInterestsForWorkspaceAndType:" + workspaceKey + " " + String.valueOf((Object)objectType));
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getUserInterestsForWorkspaceAndType);
            ps2.setString(1, user);
            ps2.setString(2, objectType.toString());
            ps2.setString(3, workspaceKey);
            ps2.setInt(4, limit);
            ps2.setInt(5, offset);
            ps2.execute();
            ArrayList<TaggableObjectRefWithInterest> owis = new ArrayList<TaggableObjectRefWithInterest>();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    this.parseResultSetAsTaggableType(rs2).ifPresent(owis::add);
                }
            }
            ArrayList<TaggableObjectRefWithInterest> arrayList = owis;
            return arrayList;
        }
    }

    public Map<String, Set<TaggableObjectsService.TaggableObjectRef>> getAllWatchesByUser() throws SQLException {
        HashMap<String, Set<TaggableObjectsService.TaggableObjectRef>> ret = new HashMap<String, Set<TaggableObjectsService.TaggableObjectRef>>();
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getAllWatches);
            ps2.execute();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    String user = rs2.getString("user");
                    if (!ret.containsKey(user)) {
                        ret.put(user, new HashSet());
                    }
                    this.readTOR(rs2).ifPresent(tor -> ((Set)ret.get(user)).add(tor));
                }
            }
            HashMap<String, Set<TaggableObjectsService.TaggableObjectRef>> hashMap = ret;
            return hashMap;
        }
    }

    public Map<String, Map<TaggableObjectsService.TaggableObjectRef, RawInterest>> getAllWatches() throws SQLException {
        HashMap<String, Map<TaggableObjectsService.TaggableObjectRef, RawInterest>> ret = new HashMap<String, Map<TaggableObjectsService.TaggableObjectRef, RawInterest>>();
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getAllWatches);
            ps2.execute();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    try {
                        String objectTypeRaw = rs2.getString(OBJECT_TYPE_COLUMN);
                        if (EnumUtils.isValidEnum(NonTaggableType.class, (String)objectTypeRaw)) continue;
                        String user = rs2.getString(USER_COLUMN);
                        String projectKey = rs2.getString(PROJECT_KEY_COLUMN);
                        ITaggingService.TaggableType objectType = ITaggingService.TaggableType.valueOf(objectTypeRaw);
                        String objectId = rs2.getString(OBJECT_ID_COLUMN);
                        Watching watching = this.watching(rs2.getInt(WATCHING_COLUMN));
                        boolean starred = rs2.getBoolean(STARRED_COLUMN);
                        String workspaceKey = rs2.getString(WORKSPACE_KEY_COLUMN);
                        TaggableObjectsService.TaggableObjectRef tor = new TaggableObjectsService.TaggableObjectRef(projectKey, objectType, objectId, workspaceKey);
                        RawInterest interest = new RawInterest(watching, starred);
                        if (!ret.containsKey(user)) {
                            ret.put(user, new HashMap());
                        }
                        ((Map)ret.get(user)).put(tor, interest);
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Invalid watch in interests", (Throwable)e);
                    }
                }
            }
            HashMap<String, Map<TaggableObjectsService.TaggableObjectRef, RawInterest>> hashMap = ret;
            return hashMap;
        }
    }

    public List<TaggableObjectRefWithInterest> getInterestsForObjectList(String user, ITaggingService.TaggableType objectType, String projectKey) throws SQLException {
        HashMap<String, TaggableObjectRefWithInterest> interestsMap = new HashMap<String, TaggableObjectRefWithInterest>(1000);
        try (DSSDBConnection c2 = this.acquireConnection();){
            ArrayList arrayList;
            block39: {
                ResultSet rs2;
                SelectQueryBuilder sqb = new SelectQueryBuilder();
                sqb.from(INTERESTS_TABLE);
                sqb.select(OBJECT_ID_COLUMN);
                sqb.select(EBF.caseWhen(EBF.col(WATCHING_COLUMN).gt(1), 1, 0).sum(), "nb_watching");
                sqb.select(EBF.col(STARRED_COLUMN).castToInt().sum(), "nb_starred");
                sqb.where(EBF.parameterizedColumnOperation(OBJECT_TYPE_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ).and(EBF.parameterizedColumnOperation(PROJECT_KEY_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ)).and(EBF.col(WORKSPACE_KEY_COLUMN).isNullOrEmptyString()).and(EBF.col(STARRED_COLUMN).isTrue().or(EBF.col(WATCHING_COLUMN).gt(1))));
                sqb.group(OBJECT_ID_COLUMN);
                try (PreparedStatement ps2 = c2.prepareNonPersistedStatement(sqb.toSQL(this.getDialect()));){
                    ps2.setString(1, objectType.toString());
                    ps2.setString(2, projectKey);
                    ps2.execute();
                    rs2 = ps2.getResultSet();
                    try {
                        while (rs2.next()) {
                            try {
                                TaggableObjectRefWithInterest owi = new TaggableObjectRefWithInterest();
                                owi.objectType = objectType;
                                owi.projectKey = projectKey;
                                owi.workspaceKey = "";
                                owi.objectId = rs2.getString(1);
                                owi.nbWatching = rs2.getInt(2);
                                owi.nbStarred = rs2.getInt(3);
                                interestsMap.put(owi.objectId, owi);
                            }
                            catch (Exception e) {
                                logger.error((Object)"Failed to read user star", (Throwable)e);
                            }
                        }
                    }
                    finally {
                        if (rs2 != null) {
                            rs2.close();
                        }
                    }
                }
                sqb = new SelectQueryBuilder();
                sqb.from(INTERESTS_TABLE);
                sqb.select(OBJECT_TYPE_COLUMN);
                sqb.select(PROJECT_KEY_COLUMN);
                sqb.select(OBJECT_ID_COLUMN);
                sqb.select(WATCHING_COLUMN);
                sqb.select(STARRED_COLUMN);
                sqb.where(EBF.parameterizedColumnOperation(USER_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ).and(EBF.parameterizedColumnOperation(OBJECT_TYPE_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ)).and(EBF.parameterizedColumnOperation(PROJECT_KEY_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ)).and(EBF.col(WORKSPACE_KEY_COLUMN).isNullOrEmptyString()).and(EBF.col(STARRED_COLUMN).isTrue().or(EBF.col(WATCHING_COLUMN).gt(1))));
                sqb.order(STARRED_COLUMN, QueryAst.OrderType.DESC).order(PROJECT_KEY_COLUMN).order(OBJECT_TYPE_COLUMN).order(OBJECT_ID_COLUMN);
                ps2 = c2.prepareNonPersistedStatement(sqb.toSQL(this.getDialect()));
                try {
                    ps2.setString(1, user);
                    ps2.setString(2, objectType.toString());
                    ps2.setString(3, projectKey);
                    ps2.execute();
                    rs2 = ps2.getResultSet();
                    try {
                        ArrayList<TaggableObjectRefWithInterest> owis = new ArrayList<TaggableObjectRefWithInterest>();
                        while (rs2.next()) {
                            try {
                                String objectId = rs2.getString(3);
                                TaggableObjectRefWithInterest owi = (TaggableObjectRefWithInterest)interestsMap.get(objectId);
                                if (owi == null) {
                                    owi = new TaggableObjectRefWithInterest();
                                    owi.objectType = objectType;
                                    owi.projectKey = projectKey;
                                    owi.workspaceKey = "";
                                    interestsMap.put(owi.objectId, owi);
                                }
                                owi.watching = this.watching(rs2.getInt(4));
                                owi.starred = rs2.getBoolean(5);
                                owis.add(owi);
                            }
                            catch (Exception e) {
                                logger.error((Object)"Failed to read user star", (Throwable)e);
                            }
                        }
                    }
                    finally {
                        if (rs2 != null) {
                            rs2.close();
                        }
                    }
                    arrayList = Lists.newArrayList(interestsMap.values());
                    if (ps2 == null) break block39;
                }
                catch (Throwable throwable) {
                    if (ps2 != null) {
                        try {
                            ps2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps2.close();
            }
            return arrayList;
        }
    }

    public void deleteUser(String user) throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.deleteUser);
            ps2.setString(1, user);
            ps2.execute();
            conn.commit();
        }
    }

    public void deleteObject(ITaggingService.TaggableType objectType, String projectKey, String objectId) throws Exception {
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.deleteObject);
            ps2.setString(1, objectType.toString());
            ps2.setString(2, projectKey);
            ps2.setString(3, objectId);
            ps2.execute();
            conn.commit();
        }
    }

    public void deleteObjectFromWorkspace(ITaggingService.TaggableType objectType, String projectKey, String objectId, String workspaceKey) throws Exception {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"projectKey not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)objectId), (Object)"objectId not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workspaceKey), (Object)"workspaceKey not specified");
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.deleteObjectFromWorkspace);
            ps2.setString(1, objectType.toString());
            ps2.setString(2, projectKey);
            ps2.setString(3, objectId);
            ps2.setString(4, workspaceKey);
            ps2.execute();
            conn.commit();
        }
    }

    public void changeObjectId(ITaggingService.TaggableType objectType, String projectKey, String objectId, String newObjectId) throws SQLException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key must be specified");
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.changeObjectId);
            ps2.setString(1, newObjectId);
            ps2.setString(2, projectKey);
            ps2.setString(3, objectType.toString());
            ps2.setString(4, objectId);
            ps2.execute();
            conn.commit();
        }
    }

    public void deleteUnauthorized(Map<String, List<String>> changes) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM " + this.getQuotedFullResolvedTableName(INTERESTS_TABLE) + " WHERE ");
        boolean firstUser = true;
        for (Map.Entry<String, List<String>> entry : changes.entrySet()) {
            String user = entry.getKey();
            List<String> changesForUser = entry.getValue();
            if (changesForUser.isEmpty()) continue;
            if (!firstUser) {
                sb.append(" OR ");
            }
            sb.append("\n\t ").append(this.quote(USER_COLUMN)).append("=").append(this.getDialect().quoteString(user)).append(" AND ").append(this.quote(PROJECT_KEY_COLUMN)).append(" IN (");
            boolean firstProjectKey = true;
            for (String projectKey : changesForUser) {
                if (!firstProjectKey) {
                    sb.append(",");
                }
                sb.append(this.getDialect().quoteString(projectKey));
                firstProjectKey = false;
            }
            sb.append(")");
            firstUser = false;
        }
        String sql = sb.toString();
        logger.info((Object)("Deleting unauthorized interests. Query:\n " + sql));
        try (DSSDBConnection conn = this.acquireConnection();
             Statement st2 = conn.createStatement();){
            st2.execute(sql);
            conn.commit();
        }
    }

    private Set<String> getDeepWatchingUsers(String projectKey, DSSDBConnection conn) throws SQLException {
        PreparedStatement ps2 = this.getPreparedStatement(conn, this.getDeepWatchingUsers);
        ps2.setString(1, projectKey);
        ps2.execute();
        HashSet<String> users = new HashSet<String>();
        try (ResultSet rs2 = ps2.getResultSet();){
            while (rs2.next()) {
                users.add(rs2.getString(1));
            }
        }
        return users;
    }

    private Optional<TaggableObjectRefWithInterest> parseResultSetAsTaggableType(ResultSet rs2) {
        try {
            String objectType = rs2.getString(OBJECT_TYPE_COLUMN);
            if (EnumUtils.isValidEnum(NonTaggableType.class, (String)objectType)) {
                return Optional.empty();
            }
            TaggableObjectRefWithInterest owi = new TaggableObjectRefWithInterest();
            owi.objectType = ITaggingService.TaggableType.valueOf(objectType);
            owi.projectKey = rs2.getString(PROJECT_KEY_COLUMN);
            owi.objectId = rs2.getString(OBJECT_ID_COLUMN);
            owi.watching = this.watching(rs2.getInt(WATCHING_COLUMN));
            owi.starred = rs2.getBoolean(STARRED_COLUMN);
            owi.workspaceKey = rs2.getString(WORKSPACE_KEY_COLUMN);
            return Optional.of(owi);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to read user star", (Throwable)e);
            return Optional.empty();
        }
    }

    private RawInterest getRawInterest(String user, String rawObjectType, @Nullable String projectKey, String objectId, @Nullable String workspaceKey) throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.get);
            ps2.setString(1, user);
            ps2.setString(2, rawObjectType);
            ps2.setString(3, StringUtils.defaultString((String)projectKey, (String)""));
            ps2.setString(4, objectId);
            ps2.setString(5, StringUtils.defaultString((String)workspaceKey, (String)""));
            ps2.execute();
            try (ResultSet rs2 = ps2.getResultSet();){
                if (rs2.next()) {
                    RawInterest ri = new RawInterest();
                    ri.watching = this.watching(rs2.getInt(1));
                    ri.starred = rs2.getBoolean(2);
                    RawInterest rawInterest = ri;
                    return rawInterest;
                }
            }
            RawInterest rawInterest = null;
            return rawInterest;
        }
    }

    private RawInterest get(String user, NonTaggableType objectType, @Nullable String projectKey, String objectId, @Nullable String workspaceKey) throws SQLException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)user), (Object)"User not specified");
        Preconditions.checkArgument((objectType != null ? 1 : 0) != 0, (Object)"Should be part of non-taggable supported type");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)objectId), (Object)"Object id not specified");
        return this.getRawInterest(user, objectType.toString(), projectKey, objectId, workspaceKey);
    }

    private RawInterest get(String user, ITaggingService.TaggableType objectType, @Nullable String projectKey, String objectId, @Nullable String workspaceKey) throws SQLException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)user), (Object)"User not specified");
        Preconditions.checkArgument((StringUtils.isNotBlank((String)projectKey) || StringUtils.isNotBlank((String)workspaceKey) ? 1 : 0) != 0, (Object)"Either Project key or workspace key must be specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)objectId), (Object)"Object id not specified");
        Preconditions.checkArgument((objectType != null ? 1 : 0) != 0, (Object)"Object type not specified");
        return this.getRawInterest(user, objectType.toString(), projectKey, objectId, workspaceKey);
    }

    private boolean hasStarred(String user, ITaggingService.TaggableType objectType, String projectKey, String objectId, String workspaceKey) throws SQLException {
        RawInterest ri = this.get(user, objectType, projectKey, objectId, workspaceKey);
        if (ri != null) {
            return ri.starred;
        }
        return false;
    }

    private void insert(String user, String rawObjectType, @Nullable String projectKey, String objectId, @Nullable String workspaceKey, Watching watching, boolean starred) throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.insert);
            ps2.setString(1, user);
            ps2.setString(2, rawObjectType);
            ps2.setString(3, StringUtils.defaultString((String)projectKey, (String)""));
            ps2.setString(4, objectId);
            ps2.setInt(5, this.watching(watching));
            ps2.setBoolean(6, starred);
            ps2.setString(7, StringUtils.defaultString((String)workspaceKey, (String)""));
            ps2.execute();
            conn.commit();
        }
    }

    private void insert(String user, ITaggingService.TaggableType objectType, String projectKey, String objectId, String workspaceKey, Watching watching, boolean starred) throws SQLException {
        Preconditions.checkArgument((StringUtils.isNotBlank((String)projectKey) || StringUtils.isNotBlank((String)workspaceKey) ? 1 : 0) != 0, (Object)"Should either be a project folder or need project key or workspace key to be defined");
        this.insert(user, objectType.toString(), projectKey, objectId, workspaceKey, watching, starred);
    }

    private void insert(String user, NonTaggableType objectType, String objectId, Watching watching, boolean starred) throws SQLException {
        this.insert(user, objectType.toString(), null, objectId, null, watching, starred);
    }

    private void update(String user, String rawObjectType, @Nullable String projectKey, String objectId, @Nullable String workspaceKey, Watching watching, boolean starred) throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.update);
            ps2.setInt(1, this.watching(watching));
            ps2.setBoolean(2, starred);
            ps2.setString(3, user);
            ps2.setString(4, rawObjectType);
            ps2.setString(5, StringUtils.defaultString((String)projectKey, (String)""));
            ps2.setString(6, objectId);
            ps2.setString(7, StringUtils.defaultString((String)workspaceKey, (String)""));
            ps2.execute();
            conn.commit();
        }
    }

    private void update(String user, ITaggingService.TaggableType objectType, String projectKey, String objectId, String workspaceKey, Watching watching, boolean starred) throws SQLException {
        Preconditions.checkArgument((StringUtils.isNotBlank((String)projectKey) || StringUtils.isNotBlank((String)workspaceKey) ? 1 : 0) != 0, (Object)"Need project key or workspace key to be defined");
        this.update(user, objectType.toString(), projectKey, objectId, workspaceKey, watching, starred);
    }

    private void update(String user, NonTaggableType objectType, String objectId, Watching watching, boolean starred) throws SQLException {
        this.update(user, objectType.toString(), null, objectId, null, watching, starred);
    }

    private Watching watching(int code) {
        return Watching.values()[code];
    }

    private int watching(Watching watching) {
        if (watching == null) {
            return Watching.INO.ordinal();
        }
        return watching.ordinal();
    }

    private Optional<TaggableObjectsService.TaggableObjectRef> readTOR(ResultSet rs2) throws SQLException {
        String objectType = rs2.getString(OBJECT_TYPE_COLUMN);
        if (EnumUtils.isValidEnum(NonTaggableType.class, (String)objectType)) {
            return Optional.empty();
        }
        String projectKey = rs2.getString(PROJECT_KEY_COLUMN);
        ITaggingService.TaggableType type = ITaggingService.TaggableType.valueOf(rs2.getString(OBJECT_TYPE_COLUMN));
        String id = rs2.getString(OBJECT_ID_COLUMN);
        String workspaceKey = rs2.getString(WORKSPACE_KEY_COLUMN);
        return Optional.of(new TaggableObjectsService.TaggableObjectRef(projectKey, type, id, workspaceKey));
    }

    private List<TaggableObjectRefWithInterest> getUserInterestsForType(String user, int limit, int offset, ITaggingService.TaggableType type) throws SQLException {
        logger.trace(() -> "getUserInterestsForType user=" + user + " type=" + String.valueOf((Object)type));
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getUserInterestsForType);
            ps2.setString(1, user);
            ps2.setString(2, type.toString());
            ps2.setInt(3, limit);
            ps2.setInt(4, offset);
            ps2.execute();
            ArrayList<TaggableObjectRefWithInterest> owis = new ArrayList<TaggableObjectRefWithInterest>();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    this.parseResultSetAsTaggableType(rs2).ifPresent(owis::add);
                }
            }
            ArrayList<TaggableObjectRefWithInterest> arrayList = owis;
            return arrayList;
        }
    }

    private List<TaggableObjectRefWithInterest> getUserInterestsForProject(String user, int limit, int offset, String projectKey) throws SQLException {
        logger.trace(() -> "getUserInterestsForProject: user=" + user + " project=" + projectKey);
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getUserInterestsForProject);
            ps2.setString(1, user);
            ps2.setString(2, projectKey);
            ps2.setInt(3, limit);
            ps2.setInt(4, offset);
            ps2.execute();
            ArrayList<TaggableObjectRefWithInterest> owis = new ArrayList<TaggableObjectRefWithInterest>();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    this.parseResultSetAsTaggableType(rs2).ifPresent(owis::add);
                }
            }
            ArrayList<TaggableObjectRefWithInterest> arrayList = owis;
            return arrayList;
        }
    }

    private List<TaggableObjectRefWithInterest> getUserInterestsForWorkspace(String user, int limit, int offset, String workspaceKey) throws SQLException {
        logger.trace(() -> "getUserInterestsForWorkspace: user=" + user + " workspace=" + workspaceKey);
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getUserInterestsForWorkspace);
            ps2.setString(1, user);
            ps2.setString(2, workspaceKey);
            ps2.setInt(3, limit);
            ps2.setInt(4, offset);
            ps2.execute();
            ArrayList<TaggableObjectRefWithInterest> owis = new ArrayList<TaggableObjectRefWithInterest>();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    this.parseResultSetAsTaggableType(rs2).ifPresent(owis::add);
                }
            }
            ArrayList<TaggableObjectRefWithInterest> arrayList = owis;
            return arrayList;
        }
    }

    private List<TaggableObjectRefWithInterest> getUserInterests(String user, int limit, int offset, boolean starsOnly) throws SQLException {
        logger.trace(() -> "getUserInterests: user=" + user);
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, starsOnly ? this.getUserStars : this.getUserInterests);
            ps2.setString(1, user);
            ps2.setInt(2, limit);
            ps2.setInt(3, offset);
            ps2.execute();
            ArrayList<TaggableObjectRefWithInterest> owis = new ArrayList<TaggableObjectRefWithInterest>();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    this.parseResultSetAsTaggableType(rs2).ifPresent(owis::add);
                }
            }
            ArrayList<TaggableObjectRefWithInterest> arrayList = owis;
            return arrayList;
        }
    }

    public List<NonTaggableObjectWithInterest> getUserInterestsForProjectFolders(String user) throws SQLException {
        logger.trace(() -> "getUserInterestsForProjectFolders: user=" + user);
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getAllUserStarredItemsForObjectType);
            ps2.setString(1, PROJECT_FOLDER_TYPE);
            ps2.setString(2, user);
            ps2.execute();
            ArrayList<NonTaggableObjectWithInterest> ret = new ArrayList<NonTaggableObjectWithInterest>();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    try {
                        NonTaggableObjectWithInterest nonTaggableObjectWithInterest = new NonTaggableObjectWithInterest();
                        nonTaggableObjectWithInterest.objectType = NonTaggableType.valueOf(rs2.getString(OBJECT_TYPE_COLUMN));
                        nonTaggableObjectWithInterest.objectId = rs2.getString(OBJECT_ID_COLUMN);
                        nonTaggableObjectWithInterest.watching = this.watching(rs2.getInt(WATCHING_COLUMN));
                        nonTaggableObjectWithInterest.starred = rs2.getBoolean(STARRED_COLUMN);
                        ret.add(nonTaggableObjectWithInterest);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed to read user project folder star", (Throwable)e);
                    }
                }
            }
            ArrayList<NonTaggableObjectWithInterest> arrayList = ret;
            return arrayList;
        }
    }

    public static class WatchersResponse {
        public Set<String> direct;
        public Set<String> deep;
    }

    public static class RawInterest {
        public Watching watching;
        public boolean starred;

        public RawInterest() {
        }

        public RawInterest(Watching watching, boolean starred) {
            this.watching = watching;
            this.starred = starred;
        }
    }

    public static enum Watching {
        INO,
        ENO,
        SHALLOW,
        YES;


        public boolean enabled() {
            return this.ordinal() > 1;
        }
    }

    public static enum NonTaggableType {
        PROJECT_FOLDER;

    }

    public static class TaggableObjectRefWithInterest
    extends Interest
    implements EnrichmentService.Enrichable {
        public ITaggingService.TaggableType objectType;
        public String projectKey;
        public String objectId;
        public String workspaceKey;
        public JsonObject details = new JsonObject();

        public TaggableObjectRefWithInterest() {
        }

        public TaggableObjectRefWithInterest(ITaggingService.TaggableType objectType, String projectKey, String objectId, String workspaceKey) {
            this.objectType = objectType;
            this.projectKey = projectKey;
            this.objectId = objectId;
            this.workspaceKey = workspaceKey;
        }

        @Override
        public ITaggingService.TaggableType getTaggableType() {
            return this.objectType;
        }

        @Override
        public String getProjectKey() {
            return this.projectKey;
        }

        @Override
        public String getObjectId() {
            return this.objectId;
        }

        @Override
        public String getWorkspaceKey() {
            return this.workspaceKey;
        }

        @Override
        public String getUserLogin() {
            return null;
        }

        @Override
        public JsonObject getDetails() {
            return this.details;
        }
    }

    public static class NonTaggableObjectWithInterest
    extends Interest {
        public NonTaggableType objectType;
        public String objectId;
    }

    public static class Interest {
        public Watching watching = Watching.INO;
        public boolean starred;
        public int nbWatching = -1;
        public int nbStarred = -1;
    }
}

