/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao.impl;

import com.dataiku.dip.aigenerations.AIFlowGenerationService;
import com.dataiku.dip.dao.AiAssistantsDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TaggableObjectsDeletionService;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.RelFileInputStream;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.annotation.Nullable;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedAiAssistantsDAO
implements AiAssistantsDAO {
    private static final String AI_FLOW_ASSISTANT_FOLDER = "flow-assistant";
    private static final String AI_GENERATED_OBJECTS_FILE_NAME = "ai-generated-objects.json";
    private static final String AI_FLOW_ASSISTANT_STATE_FILE_NAME = "ai-assistant-state.json";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.aiassistants.dao");

    @Override
    public AIFlowGenerationService.AIGeneratedObjects getAIGeneratedObjects(TransactionRef t, String projectKey) throws IOException {
        RelFile aiGeneratedObjectsFile = FilesBasedAiAssistantsDAO.getAIGeneratedObjectsFile(projectKey);
        if (!t.isFile(aiGeneratedObjectsFile)) {
            return null;
        }
        logger.trace((Object)("Reading ai generated objects file " + String.valueOf(aiGeneratedObjectsFile)));
        return (AIFlowGenerationService.AIGeneratedObjects)t.readObject(aiGeneratedObjectsFile, AIFlowGenerationService.AIGeneratedObjects.class);
    }

    @Override
    public void appendAIGeneratedObjects(RWTransactionRef t, String projectKey, String conversationId, Collection<TaggableObjectsDeletionService.DeletionRequestItem> items) throws IOException {
        RelFile aiGeneratedObjectsFile = FilesBasedAiAssistantsDAO.getAIGeneratedObjectsFile(projectKey);
        logger.trace((Object)("Appending AI generated objects to file " + String.valueOf(aiGeneratedObjectsFile)));
        AIFlowGenerationService.AIGeneratedObjects current = t.isFile(aiGeneratedObjectsFile) ? (AIFlowGenerationService.AIGeneratedObjects)t.readObject(aiGeneratedObjectsFile, AIFlowGenerationService.AIGeneratedObjects.class) : new AIFlowGenerationService.AIGeneratedObjects();
        LinkedHashSet entry = current.objectsToDeleteByConversationId.computeIfAbsent(conversationId, k -> new LinkedHashSet());
        if (items != null && !items.isEmpty()) {
            entry.addAll(items);
        }
        t.writeObject(aiGeneratedObjectsFile, (Object)current);
    }

    @Override
    public void saveAIGeneratedObjects(RWTransactionRef t, String projectKey, AIFlowGenerationService.AIGeneratedObjects aiGeneratedObjects) throws IOException {
        RelFile aiGeneratedObjectsFile = FilesBasedAiAssistantsDAO.getAIGeneratedObjectsFile(projectKey);
        logger.trace((Object)("Saving AI generated objects file " + String.valueOf(aiGeneratedObjectsFile)));
        t.writeObject(aiGeneratedObjectsFile, (Object)(aiGeneratedObjects != null ? aiGeneratedObjects : new AIFlowGenerationService.AIGeneratedObjects()));
    }

    @Override
    public AIFlowGenerationService.AIFlowAssistantState getAIFlowAssistantState(TransactionRef t, String projectKey, AuthCtx authCtx) throws IOException {
        Map<String, AIFlowGenerationService.AIFlowAssistantState> statesByUser = this.getAIFlowAssistantStatesByUser(t, projectKey);
        return statesByUser.getOrDefault(authCtx.getIdentifier(), new AIFlowGenerationService.AIFlowAssistantState());
    }

    @Override
    public void setAIFlowAssistantState(RWTransactionRef t, String projectKey, AuthCtx authCtx, @Nullable AIFlowGenerationService.AIFlowAssistantState state) throws IOException {
        Map<String, AIFlowGenerationService.AIFlowAssistantState> statesByUser = this.getAIFlowAssistantStatesByUser((TransactionRef)t, projectKey);
        if (state != null) {
            statesByUser.put(authCtx.getIdentifier(), state);
        } else {
            statesByUser.remove(authCtx.getIdentifier());
        }
        this.setAIFlowAssistantStatesByUser(t, projectKey, statesByUser);
    }

    private Map<String, AIFlowGenerationService.AIFlowAssistantState> getAIFlowAssistantStatesByUser(TransactionRef transaction, String projectKey) throws IOException {
        RelFile aiFlowAssistantStateFile = FilesBasedAiAssistantsDAO.getAIFlowAssistantStateFile(projectKey);
        if (!transaction.isFile(aiFlowAssistantStateFile)) {
            return new HashMap<String, AIFlowGenerationService.AIFlowAssistantState>();
        }
        logger.trace((Object)("Reading AI Flow Assistant state file " + String.valueOf(aiFlowAssistantStateFile)));
        try (RelFileInputStream stream = transaction.readStream(aiFlowAssistantStateFile);){
            Map map = (Map)JSON.parse((InputStream)stream, (TypeToken)TypeToken.getParameterized(Map.class, (Type[])new Type[]{String.class, AIFlowGenerationService.AIFlowAssistantState.class}));
            return map;
        }
    }

    private void setAIFlowAssistantStatesByUser(RWTransactionRef t, String projectKey, Map<String, AIFlowGenerationService.AIFlowAssistantState> statesByUser) throws IOException {
        RelFile aiFlowAssistantStateFile = FilesBasedAiAssistantsDAO.getAIFlowAssistantStateFile(projectKey);
        logger.trace((Object)("Writing AI Flow Assistant state file " + String.valueOf(aiFlowAssistantStateFile)));
        t.writeObject(aiFlowAssistantStateFile, statesByUser);
    }

    private static RelFile getAIGeneratedObjectsFile(String projectKey) {
        return new RelFile(new String[]{"projects", projectKey, AI_FLOW_ASSISTANT_FOLDER, AI_GENERATED_OBJECTS_FILE_NAME});
    }

    private static RelFile getAIFlowAssistantStateFile(String projectKey) {
        return new RelFile(new String[]{"projects", projectKey, AI_FLOW_ASSISTANT_FOLDER, AI_FLOW_ASSISTANT_STATE_FILE_NAME});
    }
}

