/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.analysis.ml.MLPluginsService;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.model.core.PreTrainModelingParams;
import com.dataiku.dip.analysis.model.prediction.assertions.MLAssertionsParams;
import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.AbstractJobKernelSession;
import com.dataiku.dip.dataflow.jobrunner.SerializedJobActivity;
import com.dataiku.dip.dataflow.pipeline.OverridesHelper;
import com.dataiku.dip.dataflow.streaming.DataframePreparationRequest;
import com.dataiku.dip.datasets.fs.LocalFSProvider;
import com.dataiku.dip.datasets.labeling.LabelsDatasetParams;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.DSSInternalErrorException;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.labeling.LabelingAnswerCRUDService;
import com.dataiku.dip.labeling.LabelingAnswersResponse;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.remoterun.RemoteRunFileExchangeService;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.model.PluginCredentialRequestService;
import com.dataiku.dip.server.DkuStandardServletMultipartResolver;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.streaming.endpoints.KernelStreamingEndpointService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public abstract class AbstractJobKernelServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private Map<String, RemoteFSWriteSession> remoteFSWriteSessions = new ConcurrentHashMap<String, RemoteFSWriteSession>();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.job.kernelbase");

    protected abstract RWTransactionRef getCurrentTransactionRef();

    protected abstract void setJobContext();

    protected void writeJSON(HttpServletResponse resp, Object o) throws IOException {
        resp.setContentType("application/json; charset=UTF-8");
        resp.getWriter().write(JSON.json((Object)o));
    }

    protected void sendError(HttpServletResponse resp, Throwable error) throws IOException {
        logger.error((Object)"Call failed", error);
        System.err.flush();
        System.out.flush();
        if (resp.isCommitted()) {
            logger.warn((Object)"Response is already committed, status will not change to 500");
        }
        resp.setStatus(500);
        resp.setContentType("application/json");
        resp.getWriter().write(JSON.json((Object)new SerializedError(error, true)));
    }

    protected void assertCallFromBackend(String command, AuthenticationType auth) throws AuthenticationTypeException {
        if (auth != AuthenticationType.SHARED_SECRET) {
            throw new AuthenticationTypeException(command, auth);
        }
    }

    protected void verifyCallFromChild(String command, AuthenticationType auth) throws AuthenticationTypeException {
        if (auth != AuthenticationType.API_TICKET) {
            throw new AuthenticationTypeException(command, auth);
        }
    }

    protected void baseCommandService(AbstractJobKernelSession currentSession, String path, AuthenticationType authenticationType, HttpServletRequest req, HttpServletResponse resp) throws Exception {
        switch (path) {
            case "/tintercom/datasets/clear-partition": {
                this.verifyCallFromChild(path, authenticationType);
                currentSession.clearDatasetPartition(req.getParameter("projectKey"), req.getParameter("datasetName"), req.getParameter("partition"));
                break;
            }
            case "/tintercom/datasets/clear": {
                this.verifyCallFromChild(path, authenticationType);
                currentSession.clearDatasetData(req.getParameter("projectKey"), req.getParameter("datasetName"));
                break;
            }
            case "/tintercom/datasets/prepare-sql-table-for-write": {
                this.verifyCallFromChild(path, authenticationType);
                InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
                currentSession.prepareSqlTableForWrite(req.getParameter("projectKey"), req.getParameter("datasetName"), req.getParameter("partition"), req.getParameter("writeMode"), messages);
                this.writeJSON(resp, messages);
                break;
            }
            case "/tintercom/datasets/prepare-iceberg-table-for-write": {
                this.verifyCallFromChild(path, authenticationType);
                InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
                currentSession.prepareIcebergTableForWrite(req.getParameter("projectKey"), req.getParameter("datasetName"), req.getParameter("partition"), req.getParameter("writeMode"), messages);
                this.writeJSON(resp, messages);
                break;
            }
            case "/tintercom/datasets/expand-sql-query-for-partition": {
                this.verifyCallFromChild(path, authenticationType);
                this.writeJSON(resp, currentSession.expandSQLQueryForPartition(req.getParameter("projectKey"), req.getParameter("datasetName"), req.getParameter("partition")));
                break;
            }
            case "/tintercom/managed-folders/ensure-direct-access": {
                this.verifyCallFromChild(path, authenticationType);
                boolean ignoreFlow = "true".equalsIgnoreCase(StringUtils.defaultIfBlank((String)req.getParameter("ignoreFlow"), (String)"false"));
                this.writeJSON(resp, currentSession.getManagedFolderAccess(req.getParameter("projectKey"), req.getParameter("lookup"), ignoreFlow));
                break;
            }
            case "/tintercom/plugins/get-plugin-settings": {
                this.verifyCallFromChild(path, authenticationType);
                List params = (List)JSON.parse((String)req.getParameter("params"), (TypeToken)new TypeToken<List<ParamDesc>>(){});
                JsonObject elementConfig = (JsonObject)JSON.parse((String)req.getParameter("elementConfig"), JsonObject.class);
                this.writeJSON(resp, currentSession.getPluginSettings(req.getParameter("projectKey"), params, elementConfig, req.getParameter("pluginId")));
                break;
            }
            case "/tintercom/plugins/get-fully-resolved-credentials": {
                this.verifyCallFromChild(path, authenticationType);
                String executionId = req.getParameter("executionId");
                String executionSecretId = req.getHeader("X-DKU-ExecutionSecretId");
                String name = req.getParameter("name");
                String label = req.getParameter("label");
                String credentialRequestInfoStr = req.getParameter("credentialRequestInfo");
                this.writeJSON(resp, currentSession.getPluginFullyResolvedCredentials(executionId, executionSecretId, name, label, (PluginCredentialRequestService.PluginCredentialRequestInfo)JSON.parse((String)credentialRequestInfoStr, PluginCredentialRequestService.PluginCredentialRequestInfo.class)));
                break;
            }
            case "/tintercom/datasets/init-write-session": {
                this.verifyCallFromChild(path, authenticationType);
                currentSession.initWriteSession(req, resp);
                break;
            }
            case "/tintercom/datasets/wait-write-session": {
                this.verifyCallFromChild(path, authenticationType);
                currentSession.waitSession(req, resp);
                break;
            }
            case "/tintercom/datasets/push-data": {
                this.verifyCallFromChild(path, authenticationType);
                currentSession.pushData(req, resp);
                break;
            }
            case "/tintercom/datasets/init-preparation-session": {
                this.verifyCallFromChild(path, authenticationType);
                DataframePreparationRequest request = (DataframePreparationRequest)JSON.parse((String)req.getParameter("request"), DataframePreparationRequest.class);
                this.writeJSON(resp, currentSession.initPreparationSession(request));
                break;
            }
            case "/tintercom/datasets/push-data-continuous": {
                this.verifyCallFromChild(path, authenticationType);
                currentSession.pushDataContinuous(req, resp);
                break;
            }
            case "/tintercom/datasets/checkpoint-continuous": {
                this.verifyCallFromChild(path, authenticationType);
                currentSession.checkpointContinuous(req);
                break;
            }
            case "/tintercom/datasets/get-continuous-state": {
                this.verifyCallFromChild(path, authenticationType);
                String continuousState = currentSession.getContinuousState(req);
                JsonObject ret = new JsonObject();
                ret.addProperty("state", continuousState);
                this.writeJSON(resp, ret);
                break;
            }
            case "/tintercom/datasets/close-continuous": {
                this.verifyCallFromChild(path, authenticationType);
                currentSession.closeContinuous(req);
                break;
            }
            case "/tintercom/datasets/read-data": {
                this.verifyCallFromChild(path, authenticationType);
                currentSession.readData(req, resp);
                break;
            }
            case "/tintercom/datasets/read-data2": {
                this.verifyCallFromChild(path, authenticationType);
                currentSession.readData2(req, resp);
                break;
            }
            case "/tintercom/datasets/stream-prepared-dataset": {
                this.verifyCallFromChild(path, authenticationType);
                currentSession.readPreparedData(req, resp);
                break;
            }
            case "/tintercom/datasets/verify-read": {
                this.verifyCallFromChild(path, authenticationType);
                currentSession.verifyDatasetRead(req, resp);
                break;
            }
            case "/tintercom/datasets/read-config": {
                this.verifyCallFromChild(path, authenticationType);
                this.writeJSON(resp, currentSession.readConfig(req, resp));
                break;
            }
            case "/tintercom/datasets/set-schema": {
                this.verifyCallFromChild(path, authenticationType);
                currentSession.setSchema(req.getParameter("fullDatasetName"), req.getParameter("schemaData"), req.getParameter("dropAndCreate"), req.getParameter("origin"));
                break;
            }
            case "/tintercom/datasets/get-schema": {
                this.verifyCallFromChild(path, authenticationType);
                this.writeJSON(resp, currentSession.getSchema(req.getParameter("fullDatasetName")));
                break;
            }
            case "/tintercom/datasets/get-settings": {
                this.verifyCallFromChild(path, authenticationType);
                this.writeJSON(resp, currentSession.getDatasetSettings(req.getParameter("fullDatasetName")));
                break;
            }
            case "/tintercom/datasets/list-partitions": {
                this.verifyCallFromChild(path, authenticationType);
                this.writeJSON(resp, currentSession.listPartitions(req.getParameter("fullDatasetName")));
                break;
            }
            case "/tintercom/datasets/get-location-info": {
                this.verifyCallFromChild(path, authenticationType);
                this.writeJSON(resp, currentSession.getLocationInfo(req.getParameter("projectKey"), req.getParameter("datasetName"), Boolean.parseBoolean(req.getParameter("sensitiveInfo"))));
                break;
            }
            case "/tintercom/datasets/get-files-info": {
                this.verifyCallFromChild(path, authenticationType);
                List partitions = (List)JSON.parse((String)req.getParameter("partitions"), (TypeToken)new TypeToken<List<String>>(){});
                this.writeJSON(resp, currentSession.getFilesInfo(req.getParameter("projectKey"), req.getParameter("datasetName"), partitions));
                break;
            }
            case "/tintercom/datasets/list": {
                ArrayList datasetNames = Lists.newArrayList();
                for (SerializedDataset sd : currentSession.listDatasets(req.getParameter("projectKey"))) {
                    datasetNames.add(sd.name);
                }
                this.writeJSON(resp, datasetNames);
                break;
            }
            case "/tintercom/projects/list-accessible": {
                this.writeJSON(resp, currentSession.listAccessibleProjectKeys());
                break;
            }
            case "/tintercom/projects/get": {
                this.writeJSON(resp, currentSession.getProject(req.getParameter("projectKey")));
                break;
            }
            case "/tintercom/datasets/get-metadata": {
                this.verifyCallFromChild(path, authenticationType);
                this.writeJSON(resp, currentSession.getMetadata(req.getParameter("fullDatasetName")));
                break;
            }
            case "/tintercom/datasets/write-metadata": {
                this.verifyCallFromChild(path, authenticationType);
                currentSession.setMetadata(req.getParameter("fullDatasetName"), req.getParameter("metadata"));
                break;
            }
            case "/tintercom/managed-folders/list-partitions": {
                this.verifyCallFromChild(path, authenticationType);
                this.writeJSON(resp, currentSession.listManagedFolderPartitions(req.getParameter("projectKey"), req.getParameter("lookup")));
                break;
            }
            case "/tintercom/managed-folders/clear-partition": {
                this.verifyCallFromChild(path, authenticationType);
                currentSession.clearManagedFolderPartition(req.getParameter("projectKey"), req.getParameter("lookup"), req.getParameter("partition"));
                break;
            }
            case "/tintercom/managed-folders/clear-path": {
                this.verifyCallFromChild(path, authenticationType);
                currentSession.clearManagedFolderPath(req.getParameter("projectKey"), req.getParameter("lookup"), req.getParameter("path"));
                break;
            }
            case "/tintercom/managed-folders/get-info": {
                this.verifyCallFromChild(path, authenticationType);
                boolean sensitiveInfo = StringUtils.isNotBlank((String)req.getParameter("sensitiveInfo")) ? Boolean.parseBoolean(req.getParameter("sensitiveInfo")) : false;
                this.writeJSON(resp, currentSession.getManagedFolderInfo(req.getParameter("projectKey"), req.getParameter("lookup"), sensitiveInfo));
                break;
            }
            case "/tintercom/managed-folders/get-partition-paths": {
                this.verifyCallFromChild(path, authenticationType);
                this.writeJSON(resp, currentSession.getManagedFolderPartitionInfo(req.getParameter("projectKey"), req.getParameter("lookup"), req.getParameter("partition")));
                break;
            }
            case "/tintercom/managed-folders/get-path-details": {
                this.verifyCallFromChild(path, authenticationType);
                this.writeJSON(resp, currentSession.getManagedFolderPathDetails(req.getParameter("projectKey"), req.getParameter("lookup"), req.getParameter("path")));
                break;
            }
            case "/tintercom/managed-folders/download-path": {
                this.verifyCallFromChild(path, authenticationType);
                currentSession.downloadManagedFolderPath(resp, req.getParameter("projectKey"), req.getParameter("lookup"), req.getParameter("path"));
                break;
            }
            case "/tintercom/managed-folders/upload-path": {
                this.verifyCallFromChild(path, authenticationType);
                currentSession.uploadManagedFolderPath(req.getParameter("projectKey"), req.getParameter("lookup"), req.getParameter("path"), (InputStream)req.getInputStream());
                break;
            }
            case "/tintercom/streaming-endpoints/read-config": {
                this.verifyCallFromChild(path, authenticationType);
                this.writeJSON(resp, currentSession.getStreamingEndpointConfig(req, resp));
                break;
            }
            case "/tintercom/streaming-endpoints/set-schema": {
                this.verifyCallFromChild(path, authenticationType);
                currentSession.setStreamingEndpointSchema(req.getParameter("streamingEndpointFullId"), req.getParameter("schemaData"));
                break;
            }
            case "/tintercom/streaming-endpoints/get-schema": {
                this.verifyCallFromChild(path, authenticationType);
                this.writeJSON(resp, currentSession.getStreamingEndpointSchema(req.getParameter("streamingEndpointFullId")));
                break;
            }
            case "/tintercom/streaming-endpoints/get-info": {
                this.verifyCallFromChild(path, authenticationType);
                boolean sensitiveInfo = StringUtils.isNotBlank((String)req.getParameter("sensitiveInfo")) ? Boolean.parseBoolean(req.getParameter("sensitiveInfo")) : false;
                this.writeJSON(resp, currentSession.getStreamingEndpointInfo(req.getParameter("projectKey"), req.getParameter("id"), sensitiveInfo));
                break;
            }
            case "/tintercom/streaming-endpoints/read-data": {
                this.verifyCallFromChild(path, authenticationType);
                KernelStreamingEndpointService.StreamingEndpointStreamingRequestSettings settings = new KernelStreamingEndpointService.StreamingEndpointStreamingRequestSettings();
                if (StringUtils.isNotBlank((String)req.getParameter("settings"))) {
                    settings = (KernelStreamingEndpointService.StreamingEndpointStreamingRequestSettings)JSON.parse((String)req.getParameter("settings"), KernelStreamingEndpointService.StreamingEndpointStreamingRequestSettings.class);
                }
                currentSession.streamEndpointToHttp(req.getParameter("projectKey"), req.getParameter("name"), settings, resp);
                break;
            }
            case "/tintercom/model-evaluation-stores/get-info": {
                this.verifyCallFromChild(path, authenticationType);
                boolean sensitiveInfo = StringUtils.isNotBlank((String)req.getParameter("sensitiveInfo")) ? Boolean.parseBoolean(req.getParameter("sensitiveInfo")) : false;
                this.writeJSON(resp, currentSession.getModelEvaluationStoreInfo(req.getParameter("projectKey"), req.getParameter("lookup"), sensitiveInfo));
                break;
            }
            case "/tintercom/model-evaluation-stores/list-runs": {
                this.verifyCallFromChild(path, authenticationType);
                this.writeJSON(resp, currentSession.getModelEvaluationStoreRuns(req.getParameter("projectKey"), req.getParameter("id")));
                break;
            }
            case "/tintercom/model-evaluation-stores/get-sample-schema": {
                this.verifyCallFromChild(path, authenticationType);
                this.writeJSON(resp, currentSession.getModelEvaluationStoreSampleSchema(req.getParameter("projectKey"), req.getParameter("id"), req.getParameter("evaluationId")));
                break;
            }
            case "/tintercom/model-evaluation-stores/stream-prepared-sample": {
                this.verifyCallFromChild(path, authenticationType);
                currentSession.getModelEvaluationStoreSample(req.getParameter("projectKey"), req.getParameter("id"), req.getParameter("evaluationId"), req.getParameter("script"), req.getParameter("requestedOutputSchema"), req.getParameter("contextProjectKey"), resp);
                break;
            }
            case "/tintercom/ml/distributed/request-worker": {
                this.verifyCallFromChild(path, authenticationType);
                this.writeJSON(resp, currentSession.requestWorker(req.getParameter("workerPoolId"), req.getParameter("workerId")));
                break;
            }
            case "/tintercom/ml/distributed/release-worker": {
                this.verifyCallFromChild(path, authenticationType);
                currentSession.releaseWorker(req.getParameter("workerPoolId"), req.getParameter("workerId"));
                break;
            }
            case "/tintercom/ml/generate-steps-from-filters": {
                this.verifyCallFromChild(path, authenticationType);
                OverridesHelper.Request request = (OverridesHelper.Request)JSON.parse((String)req.getParameter("request"), OverridesHelper.Request.class);
                OverridesHelper.Response scriptData = OverridesHelper.generateScriptData(request);
                this.writeJSON(resp, scriptData);
                break;
            }
            case "/tintercom/ml/generate-steps-from-assertions": {
                this.verifyCallFromChild(path, authenticationType);
                this.writeJSON(resp, MLAssertionsParams.generateScriptData((List)JSON.parse((String)req.getParameter("assertions"), (TypeToken)new TypeToken<List<MLAssertionsParams.MLAssertion>>(){})));
                break;
            }
            case "/tintercom/recipes/get-shaker-resources": {
                this.verifyCallFromChild(path, authenticationType);
                currentSession.collectShakerResources(resp, req.getParameter("projectKey"), req.getParameter("recipeName"));
                break;
            }
            case "/tintercom/plugins/get-lib-folders": {
                this.verifyCallFromChild(path, authenticationType);
                this.writeJSON(resp, currentSession.getPluginLibFolder(req.getParameter("pluginId")));
                break;
            }
            case "/tintercom/plugins/get-plugin-version": {
                this.verifyCallFromChild(path, authenticationType);
                String pluginId = req.getParameter("pluginId");
                IPluginsRegistryService mlPluginsService = (IPluginsRegistryService)SpringUtils.getBean(IPluginsRegistryService.class);
                this.writeJSON(resp, mlPluginsService.getDesc((String)pluginId).version);
                break;
            }
            case "/tintercom/plugins/get-ml-plugin-files": {
                this.verifyCallFromChild(path, authenticationType);
                String pluginId = req.getParameter("pluginId");
                String elementId = req.getParameter("elementId");
                MLPluginsService mlPluginsService = (MLPluginsService)SpringUtils.getBean(MLPluginsService.class);
                mlPluginsService.downloadMlPlugins(pluginId, elementId, resp);
                break;
            }
            case "/tintercom/plugins/get-used-plugins": {
                this.verifyCallFromChild(path, authenticationType);
                PreTrainModelingParams modeling = (PreTrainModelingParams)JSON.parse((String)req.getParameter("modeling_params"), PreTrainModelingParams.class);
                MLPluginsService mlPluginsService = (MLPluginsService)SpringUtils.getBean(MLPluginsService.class);
                this.writeJSON(resp, mlPluginsService.getUsedPlugins(modeling));
                break;
            }
            case "/tintercom/meanings/list": {
                this.verifyCallFromChild(path, authenticationType);
                this.writeJSON(resp, currentSession.listMeanings());
                break;
            }
            case "/tintercom/get-dss-settings": {
                this.verifyCallFromChild(path, authenticationType);
                this.writeJSON(resp, currentSession.getDSSSettings());
                break;
            }
            case "/tintercom/variables/get-context-for-project": {
                this.verifyCallFromChild(path, authenticationType);
                this.writeJSON(resp, currentSession.getContextProjectVariables(req.getParameter("projectKey")));
                break;
            }
            case "/tintercom/variables/get-for-project": {
                this.verifyCallFromChild(path, authenticationType);
                String projectKey = req.getParameter("projectKey");
                this.writeJSON(resp, currentSession.getUnresolvedProjectVariables(projectKey));
                break;
            }
            case "/tintercom/variables/set-for-project": {
                this.verifyCallFromChild(path, authenticationType);
                String body = IOUtils.toString((InputStream)req.getInputStream(), (Charset)StandardCharsets.UTF_8);
                VariablesService.ProjectVariables pv = (VariablesService.ProjectVariables)JSON.parse((String)body, VariablesService.ProjectVariables.class);
                currentSession.setProjectVariables(req.getParameter("projectKey"), pv);
                break;
            }
            case "/tintercom/containers/get-execution": {
                this.verifyCallFromChild(path, authenticationType);
                String executionId = req.getParameter("executionId");
                RemoteRunsRegistry.Execution execution = this.getExecution(executionId);
                if (!execution.dssVersion.equalsIgnoreCase(req.getParameter("version"))) {
                    logger.warnV("DSS version is %s but container sent %s", new Object[]{execution.dssVersion, req.getParameter("version")});
                }
                this.writeJSON(resp, execution);
                break;
            }
            case "/tintercom/containers/get-file": {
                this.verifyCallFromChild(path, authenticationType);
                String executionId = req.getParameter("executionId");
                RemoteRunsRegistry.Execution execution = this.getExecution(executionId);
                this.setJobContext();
                ((RemoteRunFileExchangeService)SpringUtils.getBean(RemoteRunFileExchangeService.class)).downloadFile(execution, RemoteRunFileExchangeService.FileKind.valueOf(req.getParameter("fileKind")), req.getParameter("path"), req.getParameter("pluginId"), req.getParameter("codeEnvName"), StringUtils.defaultIfBlank((String)req.getParameter("compress"), (String)"true").equalsIgnoreCase("true"), resp);
                break;
            }
            case "/tintercom/containers/get-lab-file": {
                this.verifyCallFromChild(path, authenticationType);
                String executionId = req.getParameter("executionId");
                RemoteRunsRegistry.Execution execution = this.getExecution(executionId);
                this.setJobContext();
                MLTaskLoc loc = new MLTaskLoc(req.getParameter("projectKey"), req.getParameter("analysisId"), req.getParameter("mlTaskId"));
                currentSession.checkProjectPrivilege(loc.analysisProjectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                ((RemoteRunFileExchangeService)SpringUtils.getBean(RemoteRunFileExchangeService.class)).downloadMLFile(execution, RemoteRunFileExchangeService.FileKind.valueOf(req.getParameter("fileKind")), req.getParameter("path"), loc, resp);
                break;
            }
            case "/tintercom/containers/get-sm-file": {
                this.verifyCallFromChild(path, authenticationType);
                String executionId = req.getParameter("executionId");
                RemoteRunsRegistry.Execution execution = this.getExecution(executionId);
                this.setJobContext();
                String projectKey = req.getParameter("projectKey");
                String savedModelId = req.getParameter("savedModelId");
                TaggableObjectsService.TaggableObjectRef smRef = new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.SAVED_MODEL, savedModelId);
                currentSession.checkTaggableObjectReadUsePrivilege(smRef, execution.projectKey);
                ((RemoteRunFileExchangeService)SpringUtils.getBean(RemoteRunFileExchangeService.class)).downloadMLFile(execution, RemoteRunFileExchangeService.FileKind.valueOf(req.getParameter("fileKind")), req.getParameter("path"), projectKey, savedModelId, resp);
                break;
            }
            case "/tintercom/containers/put-sm-file": {
                logger.info((Object)("GOT Put CALL, parameters= " + JSON.log((Object)req.getParameterMap())));
                this.verifyCallFromChild(path, authenticationType);
                String executionId = req.getParameter("executionId");
                RemoteRunsRegistry.Execution execution = this.getExecution(executionId);
                this.setJobContext();
                String projectKey = req.getParameter("projectKey");
                String savedModelId = req.getParameter("savedModelId");
                currentSession.checkProjectPrivilege(projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
                ((RemoteRunFileExchangeService)SpringUtils.getBean(RemoteRunFileExchangeService.class)).processMLFileUpload(execution, RemoteRunFileExchangeService.FileKind.valueOf(req.getParameter("fileKind")), req.getParameter("path"), projectKey, savedModelId, (InputStream)req.getInputStream(), "true".equalsIgnoreCase(req.getParameter("expand")));
                break;
            }
            case "/tintercom/containers/put-file": {
                logger.info((Object)("GOT Put CALL, parameters= " + JSON.log((Object)req.getParameterMap())));
                this.verifyCallFromChild(path, authenticationType);
                String executionId = req.getParameter("executionId");
                RemoteRunsRegistry.Execution execution = this.getExecution(executionId);
                this.setJobContext();
                ((RemoteRunFileExchangeService)SpringUtils.getBean(RemoteRunFileExchangeService.class)).processFileUpload(execution, RemoteRunFileExchangeService.FileKind.valueOf(req.getParameter("fileKind")), req.getParameter("path"), (InputStream)req.getInputStream(), "true".equalsIgnoreCase(req.getParameter("expand")));
                break;
            }
            case "/tintercom/containers/put-file-multipart": {
                DkuStandardServletMultipartResolver resolver = new DkuStandardServletMultipartResolver();
                MultipartHttpServletRequest mhsr = resolver.resolveMultipart(req);
                logger.info((Object)("GOT PutMULTIPART CALL, parameters= " + JSON.log(mhsr.getParameterMap().keySet())));
                this.verifyCallFromChild(path, authenticationType);
                String executionId = mhsr.getParameter("executionId");
                RemoteRunsRegistry.Execution execution = this.getExecution(executionId);
                ((RemoteRunFileExchangeService)SpringUtils.getBean(RemoteRunFileExchangeService.class)).processFileUpload(execution, RemoteRunFileExchangeService.FileKind.valueOf(mhsr.getParameter("fileKind")), mhsr.getParameter("path"), mhsr.getFile("file"), "true".equalsIgnoreCase(mhsr.getParameter("expand")));
                break;
            }
            case "/tintercom/containers/delete-file": {
                logger.info((Object)("GOT Delete CALL, parameters= " + JSON.log((Object)req.getParameterMap())));
                this.verifyCallFromChild(path, authenticationType);
                String executionId = req.getParameter("executionId");
                RemoteRunsRegistry.Execution execution = this.getExecution(executionId);
                this.setJobContext();
                ((RemoteRunFileExchangeService)SpringUtils.getBean(RemoteRunFileExchangeService.class)).processFileDelete(execution, RemoteRunFileExchangeService.FileKind.valueOf(req.getParameter("fileKind")), req.getParameter("path"));
                break;
            }
            case "/tintercom/containers/delete-sm-file": {
                logger.info((Object)("GOT Delete CALL, parameters= " + JSON.log((Object)req.getParameterMap())));
                this.verifyCallFromChild(path, authenticationType);
                String executionId = req.getParameter("executionId");
                RemoteRunsRegistry.Execution execution = this.getExecution(executionId);
                this.setJobContext();
                String projectKey = req.getParameter("projectKey");
                String savedModelId = req.getParameter("savedModelId");
                currentSession.checkProjectPrivilege(projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
                ((RemoteRunFileExchangeService)SpringUtils.getBean(RemoteRunFileExchangeService.class)).processMLFileDelete(execution, RemoteRunFileExchangeService.FileKind.valueOf(req.getParameter("fileKind")), req.getParameter("path"), projectKey, savedModelId);
                break;
            }
            case "/tintercom/sql-queries/start-streaming": {
                this.verifyCallFromChild(path, authenticationType);
                String connectionOrDatasetName = req.getParameter("connection");
                boolean findConnectionFromDataset = StringUtils.defaultIfBlank((String)req.getParameter("findConnectionFromDataset"), (String)"false").equalsIgnoreCase("true");
                String projectKey = req.getParameter("projectKey");
                String dbType = req.getParameter("dbType");
                String query = req.getParameter("query");
                String preQueries = req.getParameter("preQueries");
                String postQueries = req.getParameter("postQueries");
                String scriptStepsData = req.getParameter("scriptStepsData");
                String scriptInputSchemaData = req.getParameter("scriptInputSchemaData");
                String scriptOutputSchemaData = req.getParameter("scriptOutputSchemaData");
                String scriptReportLocation = req.getParameter("scriptReportLocation");
                String extraConf = req.getParameter("extraConf");
                AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode = AbstractSQLDatasetHandler.ReadTemporalMode.valueOf(StringUtils.defaultIfBlank((String)req.getParameter("datetimenotzReadMode"), (String)"AS_IS"));
                AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode = AbstractSQLDatasetHandler.ReadTemporalMode.valueOf(StringUtils.defaultIfBlank((String)req.getParameter("dateonlyReadMode"), (String)"AS_IS"));
                if (req.getParameter("readTimestampWithoutTimezoneAsString") != null) {
                    datetimenotzReadMode = StringUtils.defaultIfBlank((String)req.getParameter("readTimestampWithoutTimezoneAsString"), (String)"true").equalsIgnoreCase("true") ? AbstractSQLDatasetHandler.ReadTemporalMode.AS_STRING : AbstractSQLDatasetHandler.ReadTemporalMode.AS_DATE;
                }
                if (req.getParameter("readDateAsString") != null) {
                    dateonlyReadMode = StringUtils.defaultIfBlank((String)req.getParameter("readDateAsString"), (String)"true").equalsIgnoreCase("true") ? AbstractSQLDatasetHandler.ReadTemporalMode.AS_STRING : AbstractSQLDatasetHandler.ReadTemporalMode.AS_DATE;
                }
                this.writeJSON(resp, currentSession.startStreamingSQLQuery(connectionOrDatasetName, findConnectionFromDataset, projectKey, dbType, query, preQueries, postQueries, scriptStepsData, scriptInputSchemaData, scriptOutputSchemaData, scriptReportLocation, extraConf, datetimenotzReadMode, dateonlyReadMode));
                break;
            }
            case "/tintercom/sql-queries/stream": {
                this.verifyCallFromChild(path, authenticationType);
                String queryId = req.getParameter("queryId");
                String format = StringUtils.defaultIfBlank((String)req.getParameter("format"), (String)"tsv-excel-header");
                String formatParams = StringUtils.defaultIfBlank((String)req.getParameter("formatParams"), (String)"");
                currentSession.streamSQLQuery(resp, queryId, format, formatParams);
                break;
            }
            case "/tintercom/sql-queries/verify": {
                this.verifyCallFromChild(path, authenticationType);
                String queryId = req.getParameter("queryId");
                currentSession.verifySQLQuery(queryId);
                resp.setStatus(200);
                break;
            }
            case "/tintercom/fsproviders/browse": {
                this.verifyCallFromChild(path, authenticationType);
                String fsPath = req.getParameter("path");
                String strategyStr = req.getParameter("strategy");
                FSProvider.FSBrowseStrategy strategy = StringUtils.isNotBlank((String)strategyStr) ? FSProvider.FSBrowseStrategy.valueOf((String)strategyStr) : null;
                try (FSProvider fsProvider = this.getFSProvider(currentSession, req);){
                    this.writeJSON(resp, fsProvider.browse(fsPath, strategy));
                    break;
                }
            }
            case "/tintercom/fsproviders/convert-to-uri": {
                this.verifyCallFromChild(path, authenticationType);
                String fsPath = req.getParameter("path");
                try (LocalFSProvider fsProvider = (LocalFSProvider)this.getFSProvider(currentSession, req);){
                    this.writeJSON(resp, fsProvider.convertPathToURI(fsPath));
                    break;
                }
            }
            case "/tintercom/fsproviders/root": {
                this.verifyCallFromChild(path, authenticationType);
                try (LocalFSProvider fsProvider = (LocalFSProvider)this.getFSProvider(currentSession, req);){
                    this.writeJSON(resp, fsProvider.getRoot());
                    break;
                }
            }
            case "/tintercom/fsproviders/enumerate": {
                this.verifyCallFromChild(path, authenticationType);
                String fsPath = req.getParameter("prefix");
                String enumerationSettingsStr = req.getParameter("enumerationSettings");
                FSEnumerationSettings enumerationSettings = StringUtils.isNotBlank((String)enumerationSettingsStr) ? (FSEnumerationSettings)JSON.parse((String)enumerationSettingsStr, FSEnumerationSettings.class) : null;
                try (FSProvider fsProvider = this.getFSProvider(currentSession, req);){
                    this.writeJSON(resp, fsProvider.enumerateRecursive(fsPath, enumerationSettings));
                    break;
                }
            }
            case "/tintercom/fsproviders/stat": {
                this.verifyCallFromChild(path, authenticationType);
                String fsPath = req.getParameter("path");
                try (FSProvider fsProvider = this.getFSProvider(currentSession, req);){
                    this.writeJSON(resp, fsProvider.stat(fsPath));
                    break;
                }
            }
            case "/tintercom/fsproviders/last-modified": {
                this.verifyCallFromChild(path, authenticationType);
                String fsPath = req.getParameter("path");
                String lastModifiedStr = req.getParameter("lastModified");
                long lastModified = Long.parseLong(lastModifiedStr);
                try (FSProvider fsProvider = this.getFSProvider(currentSession, req);){
                    fsProvider.setLastModified(fsPath, lastModified);
                    break;
                }
            }
            case "/tintercom/fsproviders/delete": {
                this.verifyCallFromChild(path, authenticationType);
                String fsPath = req.getParameter("path");
                try (FSProvider fsProvider = this.getFSProvider(currentSession, req);){
                    fsProvider.deleteRecursive(fsPath);
                    break;
                }
            }
            case "/tintercom/fsproviders/move-directory": {
                this.verifyCallFromChild(path, authenticationType);
                String from = req.getParameter("from");
                String to = req.getParameter("to");
                try (FSProvider fsProvider = this.getFSProvider(currentSession, req);){
                    fsProvider.moveDirectory(from, to);
                    break;
                }
            }
            case "/tintercom/fsproviders/move-file": {
                this.verifyCallFromChild(path, authenticationType);
                String from = req.getParameter("from");
                String to = req.getParameter("to");
                try (FSProvider fsProvider = this.getFSProvider(currentSession, req);){
                    fsProvider.moveFile(from, to);
                    break;
                }
            }
            case "/tintercom/fsproviders/access-info": {
                this.verifyCallFromChild(path, authenticationType);
                String withSensitiveInfoStr = req.getParameter("withSensitiveInfo");
                boolean withSensitiveInfo = Boolean.parseBoolean(withSensitiveInfoStr);
                try (FSProvider fsProvider = this.getFSProvider(currentSession, req);){
                    this.writeJSON(resp, fsProvider.getAccessInfo(withSensitiveInfo));
                    break;
                }
            }
            case "/tintercom/fsproviders/empty": {
                this.verifyCallFromChild(path, authenticationType);
                String fsPath = req.getParameter("path");
                try (LocalFSProvider fsProvider = (LocalFSProvider)this.getFSProvider(currentSession, req);){
                    fsProvider.makeEmpty(fsPath);
                    break;
                }
            }
            case "/tintercom/fsproviders/ensure-directory": {
                this.verifyCallFromChild(path, authenticationType);
                String fsPath = req.getParameter("path");
                try (LocalFSProvider fsProvider = (LocalFSProvider)this.getFSProvider(currentSession, req);){
                    fsProvider.ensureDirectory(fsPath);
                    break;
                }
            }
            case "/tintercom/fsproviders/grant-full-acls": {
                this.verifyCallFromChild(path, authenticationType);
                String projectKey = req.getParameter("projectKey");
                try (LocalFSProvider fsProvider = (LocalFSProvider)this.getFSProvider(currentSession, req);){
                    fsProvider.grantFullACLs(currentSession.authCtx, projectKey);
                    break;
                }
            }
            case "/tintercom/fsproviders/grant-read-acls": {
                this.verifyCallFromChild(path, authenticationType);
                String projectKey = req.getParameter("projectKey");
                try (LocalFSProvider fsProvider = (LocalFSProvider)this.getFSProvider(currentSession, req);){
                    fsProvider.grantReadACLs(currentSession.authCtx, projectKey);
                    break;
                }
            }
            case "/tintercom/fsproviders/tighten": {
                this.verifyCallFromChild(path, authenticationType);
                try (LocalFSProvider fsProvider = (LocalFSProvider)this.getFSProvider(currentSession, req);){
                    fsProvider.tightenAccess(currentSession.authCtx);
                    break;
                }
            }
            case "/tintercom/fsproviders/read": {
                this.verifyCallFromChild(path, authenticationType);
                String fsPath = req.getParameter("path");
                try (FSProvider fsProvider = this.getFSProvider(currentSession, req);){
                    EnrichedInputStream eis = fsProvider.read(fsPath);
                    try (InputStream in = eis.rawStream();){
                        resp.setStatus(200);
                        resp.setContentType("application/octet-stream");
                        resp.setHeader("Content-Disposition", "attachment; filename=\"" + eis.getFilename() + "\"");
                        resp.setHeader("Content-Length", "" + eis.size());
                        IOUtils.copy((InputStream)in, (OutputStream)resp.getOutputStream());
                        break;
                    }
                }
            }
            case "/tintercom/fsproviders/write": {
                this.verifyCallFromChild(path, authenticationType);
                DkuStandardServletMultipartResolver resolver = new DkuStandardServletMultipartResolver();
                MultipartHttpServletRequest mhsr = resolver.resolveMultipart(req);
                String fsPath = mhsr.getParameter("path");
                MultipartFile multipart = mhsr.getFile("file");
                try (FSProvider fsProvider = this.getFSProvider(currentSession, (HttpServletRequest)mhsr);){
                    IOUtils.copy((InputStream)multipart.getInputStream(), (OutputStream)fsProvider.write(fsPath));
                    break;
                }
            }
            case "/tintercom/fsproviders/start-write": {
                this.verifyCallFromChild(path, authenticationType);
                String fsPath = req.getParameter("path");
                String rootPath = req.getParameter("rootPath");
                String connectionName = req.getParameter("connectionName");
                String executionId = req.getParameter("executionId");
                String key = String.format("c=%s/r=%s/p=%s", connectionName, rootPath, fsPath);
                if (this.remoteFSWriteSessions.containsKey(key)) {
                    throw new IOException("Concurrent write to " + key);
                }
                try (LocalFSProvider fsProvider = (LocalFSProvider)this.getFSProvider(currentSession, req);){
                    OutputStream os = fsProvider.write(fsPath);
                    RemoteFSWriteSession writeSession = new RemoteFSWriteSession(key, os, executionId, currentSession);
                    logger.info((Object)("Start remote write session " + writeSession.id));
                    this.remoteFSWriteSessions.put(writeSession.id, writeSession);
                    JsonObject sessionInfo = new JsonObject();
                    sessionInfo.addProperty("id", writeSession.id);
                    sessionInfo.addProperty("bufSize", (Number)writeSession.bufSize);
                    sessionInfo.addProperty("hbDelay", (Number)writeSession.hbDelay);
                    this.writeJSON(resp, sessionInfo);
                    break;
                }
            }
            case "/tintercom/fsproviders/finish-write": {
                this.verifyCallFromChild(path, authenticationType);
                String sessionId = req.getParameter("sessionId");
                String exceptionStr = req.getParameter("exception");
                RemoteFSWriteSession writeSession = this.remoteFSWriteSessions.remove(sessionId);
                if (writeSession == null) {
                    throw new IOException("Write session " + sessionId + " is unknown");
                }
                logger.info((Object)("Finish remote write session " + writeSession.id));
                writeSession.close();
                if (StringUtils.isNotBlank((String)exceptionStr)) {
                    throw new IOException("Write end failed: " + exceptionStr);
                }
                resp.setContentType("application/text; charset=UTF-8");
                resp.getWriter().write(writeSession.id);
                break;
            }
            case "/tintercom/fsproviders/push-write-data": {
                this.verifyCallFromChild(path, authenticationType);
                String sessionId = req.getParameter("sessionId");
                long sessionStartAck = Long.parseLong(StringUtils.defaultIfBlank((String)req.getParameter("sessionStartAck"), (String)"0"));
                RemoteFSWriteSession writeSession = this.remoteFSWriteSessions.get(sessionId);
                if (writeSession == null) {
                    throw new IOException("Write session " + sessionId + " is unknown");
                }
                logger.info((Object)("Push data to write session " + writeSession.id));
                if (writeSession.exception != null) {
                    throw writeSession.exception;
                }
                writeSession.pushData(sessionStartAck, req, resp);
                break;
            }
            case "/tintercom/fsproviders/pull-write-acks": {
                this.verifyCallFromChild(path, authenticationType);
                String sessionId = req.getParameter("sessionId");
                RemoteFSWriteSession writeSession = this.remoteFSWriteSessions.get(sessionId);
                if (writeSession == null) {
                    throw new IOException("Write session " + sessionId + " is unknown");
                }
                logger.info((Object)("Get acks from write session " + writeSession.id));
                writeSession.pullAcks(resp);
                break;
            }
            case "/tintercom/connections/get-fully-resolved-credentials": {
                this.verifyCallFromChild(path, authenticationType);
                String connectionName = req.getParameter("name");
                String projectKey = req.getParameter("projectKey");
                String executionId = req.getParameter("executionId");
                String executionSecretId = req.getHeader("X-DKU-ExecutionSecretId");
                boolean useTokenCache = Boolean.parseBoolean(StringUtils.defaultIfBlank((String)req.getParameter("useTokenCache"), (String)"true"));
                this.writeJSON(resp, currentSession.getFullyResolvedCredentials(connectionName, projectKey, executionId, executionSecretId, useTokenCache));
                break;
            }
            case "/tintercom/connections/refresh-access-token-for-iceberg": {
                this.verifyCallFromChild(path, authenticationType);
                String connectionName = req.getParameter("name");
                String onBehalf = req.getParameter("onBehalf");
                String projectKey = req.getParameter("projectKey");
                String executionId = req.getParameter("executionId");
                String executionSecretId = req.getHeader("X-DKU-ExecutionSecretId");
                boolean useTokenCache = Boolean.parseBoolean(StringUtils.defaultIfBlank((String)req.getParameter("useTokenCache"), (String)"true"));
                this.writeJSON(resp, currentSession.refreshAccessTokenForIceberg(connectionName, projectKey, executionId, executionSecretId, useTokenCache, onBehalf));
                break;
            }
            case "/tintercom/connections/get-google-credentials-from-environment": {
                this.verifyCallFromChild(path, authenticationType);
                String executionId = req.getParameter("executionId");
                String executionSecretId = req.getHeader("X-DKU-ExecutionSecretId");
                String credentialType = req.getParameter("credentialType");
                this.writeJSON(resp, currentSession.getDefaultGoogleCredentials(executionId, executionSecretId, credentialType));
                break;
            }
            case "/tintercom/connections/get-google-credentials-from-file": {
                this.verifyCallFromChild(path, authenticationType);
                String executionId = req.getParameter("executionId");
                String executionSecretId = req.getHeader("X-DKU-ExecutionSecretId");
                String filePath = req.getParameter("path");
                String credentialType = req.getParameter("credentialType");
                this.writeJSON(resp, currentSession.getFileGoogleCredentials(executionId, executionSecretId, filePath, credentialType));
                break;
            }
            case "/tintercom/connections/refresh-google-default-credential-access-token": 
            case "/tintercom/connections/refresh-google-credential-access-token": {
                this.verifyCallFromChild(path, authenticationType);
                String connectionName = req.getParameter("name");
                String executionId = req.getParameter("executionId");
                String executionSecretId = req.getHeader("X-DKU-ExecutionSecretId");
                this.writeJSON(resp, currentSession.refreshGoogleCredentialAccessToken(connectionName, executionId, executionSecretId));
                break;
            }
            case "/tintercom/connections/get-private-key-last-modified": {
                this.verifyCallFromChild(path, authenticationType);
                String connectionName = req.getParameter("name");
                String executionId = req.getParameter("executionId");
                String executionSecretId = req.getHeader("X-DKU-ExecutionSecretId");
                this.writeJSON(resp, currentSession.getPrivateKeyLastModified(connectionName, executionId, executionSecretId));
                break;
            }
            case "/tintercom/connections/refresh-azure-default-credential-access-token": {
                this.verifyCallFromChild(path, authenticationType);
                String connectionName = req.getParameter("name");
                String executionId = req.getParameter("executionId");
                String executionSecretId = req.getHeader("X-DKU-ExecutionSecretId");
                String claims = req.getParameter("claims");
                List scopes = (List)JSON.parse((String)req.getParameter("scopes"), (TypeToken)new TypeToken<List<String>>(){});
                String tenantId = req.getParameter("tenantId");
                this.writeJSON(resp, currentSession.refreshAzureCredentialAccessToken(connectionName, executionId, executionSecretId, claims, scopes, tenantId));
                break;
            }
            case "/tintercom/labeling/list-answers": {
                this.verifyCallFromChild(path, authenticationType);
                LabelingAnswerCRUDService LabelingAnswerCRUDService2 = (LabelingAnswerCRUDService)SpringUtils.getBean(LabelingAnswerCRUDService.class);
                this.writeJSON(resp, new LabelingAnswersResponse(LabelingAnswerCRUDService2.listAllForLabelsDataset(currentSession.authCtx, req.getParameter("projectKey"), req.getParameter("labelingTaskId"), LabelsDatasetParams.View.valueOf(req.getParameter("view")))));
                break;
            }
            default: {
                throw new Exception("Unknown command " + path);
            }
        }
    }

    protected RemoteRunsRegistry.Execution getExecution(String executionId) {
        RemoteRunsRegistry.Execution execution = RemoteRunsRegistry.get(executionId);
        if (execution == null) {
            throw new DSSInternalErrorException("Unknown execution context: " + executionId);
        }
        if (!this.getCurrentTransactionRef().getUser().getIdentifier().equals(execution.authCtx.getIdentifier())) {
            throw new SecurityException("Wrong authentication ID, expected " + String.valueOf(execution.authCtx) + " but got " + String.valueOf(this.getCurrentTransactionRef().getUser()));
        }
        return execution;
    }

    private FSProvider getFSProvider(AbstractJobKernelSession currentSession, HttpServletRequest req) throws CodedException, IOException, DKUSecurityException {
        String connectionName = req.getParameter("connectionName");
        String executionId = req.getParameter("executionId");
        String executionSecretId = req.getHeader("X-DKU-ExecutionSecretId");
        String rootPath = req.getParameter("rootPath");
        return currentSession.getFSProvider(connectionName, executionId, executionSecretId, rootPath);
    }

    protected static enum AuthenticationType {
        SHARED_SECRET,
        API_TICKET;

    }

    protected static class AuthenticationTypeException
    extends Exception {
        private static final long serialVersionUID = 1L;

        AuthenticationTypeException(String command, AuthenticationType auth) {
            super("Incorrect authentication type for command '" + command + "' : " + (auth != null ? auth.name() : "not authentified"));
        }
    }

    private class RemoteFSWriteSession {
        final String id;
        final int bufSize = DKUApp.getParams().getIntParam("dku.cde.remotefs.blocksizeB", Integer.valueOf(0x100000));
        final int hbDelay = DKUApp.getParams().getIntParam("dku.cde.remotefs.heartbeatDelayMS", Integer.valueOf(10000));
        final OutputStream os;
        final LinkedBlockingQueue<String> acks = new LinkedBlockingQueue();
        long lastAck = 0L;
        String lastAckSent = "ack:0";
        volatile boolean closed = false;
        volatile Exception exception = null;
        long crashWriteAtPos = -1L;
        List<Long> cutWriteAtPos = null;
        List<Long> cutAcksAtPos = null;
        List<Long> hangAcksAtPos = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        RemoteFSWriteSession(String key, OutputStream os, String executionId, AbstractJobKernelSession currentSession) {
            this.os = os;
            this.id = key;
            try {
                RemoteRunsRegistry.Execution execution = RemoteRunsRegistry.get(executionId);
                SerializedJobActivity sja = (SerializedJobActivity)JSON.parse((String)execution.definition, SerializedJobActivity.class);
                SerializedJobActivity.Recipe recipe = sja.recipes.get(0);
                TransactionContext.attach((TransactionRef)currentSession.getTransactionRef());
                try {
                    SerializedRecipe sr = (SerializedRecipe)((RecipesDAO)SpringUtils.getBean(RecipesDAO.class)).getMandatory(recipe.projectKey, recipe.name);
                    for (AbstractSQLConnection.CustomDatabaseProperty prop : sr.dkuProperties) {
                        if ("crash.write.at.position".equals(prop.name)) {
                            this.crashWriteAtPos = Long.parseLong(prop.value);
                            logger.info((Object)("Will crash the write at " + this.crashWriteAtPos));
                        }
                        if ("cut.write.at.positions".equals(prop.name)) {
                            this.cutWriteAtPos = (List)JSON.parse((String)prop.value, (TypeToken)new TypeToken<List<Long>>(){});
                            logger.info((Object)("Will cut the write at " + JSON.log(this.cutWriteAtPos)));
                        }
                        if ("cut.acks.at.positions".equals(prop.name)) {
                            this.cutAcksAtPos = (List)JSON.parse((String)prop.value, (TypeToken)new TypeToken<List<Long>>(){});
                            logger.info((Object)("Will cut the acks at " + JSON.log(this.cutAcksAtPos)));
                        }
                        if (!"hang.acks.at.positions".equals(prop.name)) continue;
                        this.hangAcksAtPos = (List)JSON.parse((String)prop.value, (TypeToken)new TypeToken<List<Long>>(){});
                        logger.info((Object)("Will hang the acks at " + JSON.log(this.hangAcksAtPos)));
                    }
                }
                finally {
                    TransactionContext.detach((TransactionRef)currentSession.getTransactionRef());
                }
            }
            catch (Throwable t) {
                logger.warn((Object)"Unable to sniff test harness properties", t);
            }
        }

        void close() throws IOException, InterruptedException {
            this.acks.put("eos");
            this.os.close();
            this.closed = true;
        }

        public void pushData(long startAck, HttpServletRequest req, HttpServletResponse resp) throws Exception {
            if (startAck > this.lastAck) {
                throw new IOException("Missing data: pushing data from " + startAck + " but needs from " + this.lastAck);
            }
            if (this.exception != null) {
                throw this.exception;
            }
            String retryCount = req.getParameter("attempt");
            ServletInputStream is = req.getInputStream();
            if (startAck < this.lastAck) {
                long newSkipped;
                long toSkip = this.lastAck - startAck;
                for (long skipped = 0L; skipped < toSkip; skipped += newSkipped) {
                    newSkipped = is.skip(this.lastAck - startAck);
                    if (newSkipped != 0L) continue;
                    logger.warn((Object)"Unable to skip in the stream");
                    Thread.sleep(100L);
                }
            }
            byte[] buf = new byte[this.bufSize];
            boolean eos = false;
            while (!eos) {
                int pos;
                try {
                    int read;
                    for (pos = 0; pos < buf.length; pos += read) {
                        read = is.read(buf, pos, buf.length - pos);
                        if (read >= 0) continue;
                        eos = true;
                        break;
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)"Failed to read data");
                    this.acks.put("exc:" + retryCount);
                    throw e;
                }
                if (pos == 0) continue;
                if (this.cutWriteAtPos != null && !this.cutWriteAtPos.isEmpty() && this.lastAck + (long)pos > this.cutWriteAtPos.get(0)) {
                    long p = this.cutWriteAtPos.get(0);
                    this.cutWriteAtPos.remove(0);
                    throw new RuntimeException("Test harness: disconnect write at " + p);
                }
                try {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("> write " + this.lastAck + " + " + pos));
                    }
                    if (this.crashWriteAtPos >= 0L && this.lastAck <= this.crashWriteAtPos && this.lastAck + (long)pos > this.crashWriteAtPos) {
                        throw new IOException("Test harness: write to target failed at " + this.crashWriteAtPos);
                    }
                    this.os.write(buf, 0, pos);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to write pushed data", (Throwable)e);
                    this.exception = e;
                    break;
                }
                this.lastAck += (long)pos;
                this.acks.put("ack:" + this.lastAck);
            }
            if (this.exception != null) {
                throw this.exception;
            }
        }

        void pullAcks(HttpServletResponse resp) throws Exception {
            if (this.exception != null) {
                throw this.exception;
            }
            resp.setStatus(200);
            resp.setContentType("application/text; charset=UTF-8");
            resp.flushBuffer();
            PrintWriter writer = resp.getWriter();
            writer.write(this.lastAckSent + "\n");
            while (!this.closed) {
                String ack = this.acks.poll(this.hbDelay, TimeUnit.MILLISECONDS);
                if (ack == null) {
                    writer.write("hb\n");
                    writer.flush();
                    logger.trace((Object)" > heartbeat");
                    continue;
                }
                if (ack.equals("eos")) break;
                if (ack.startsWith("exc:")) {
                    writer.write(ack + "\n");
                    writer.flush();
                    logger.trace((Object)" > exception in push call");
                    continue;
                }
                if (ack.startsWith("ack:")) {
                    long p;
                    this.lastAckSent = ack;
                    long ackPos = Long.parseLong(ack.substring("ack:".length()));
                    if (this.cutAcksAtPos != null && !this.cutAcksAtPos.isEmpty() && ackPos >= this.cutAcksAtPos.get(0)) {
                        p = this.cutAcksAtPos.get(0);
                        this.cutAcksAtPos.remove(0);
                        throw new Exception("Test harness: disconnect acks at " + p);
                    }
                    if (this.hangAcksAtPos != null && !this.hangAcksAtPos.isEmpty() && ackPos >= this.hangAcksAtPos.get(0)) {
                        p = this.hangAcksAtPos.get(0);
                        this.hangAcksAtPos.remove(0);
                        logger.info((Object)("Test harness: hang at " + p));
                        Thread.sleep(86400000L);
                    }
                    writer.write(ack + "\n");
                    writer.flush();
                    logger.trace(() -> " > ack " + ackPos + " as read");
                    continue;
                }
                throw new Exception("Unexpected ack: " + ack);
            }
        }
    }
}

