/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.HashesModel;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.impl.FlowStateInternalDB;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowManagedFolder;
import com.dataiku.dip.dataflow.graph.FlowModelEvaluationStore;
import com.dataiku.dip.dataflow.graph.FlowRetrievableKnowledge;
import com.dataiku.dip.dataflow.graph.FlowSavedModel;
import com.dataiku.dip.dataflow.graph.FlowStreamingEndpoint;
import com.dataiku.dip.dataquality.DataQualityRuleSet;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetReadiness;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.metrics.ProbesSet;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ComputableHashComputer {
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private DatasetsDAO dao;
    @Autowired
    private FlowStateInternalDB flowStateInternalDB;
    private final AuthCtx authCtx;
    private ReadinessComputationSession session;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.dataset.hash");

    public ComputableHashComputer(AuthCtx authCtx) {
        this.authCtx = authCtx;
        SpringUtils.getInstance().autowire((Object)this);
    }

    public void allowUseOfSession() {
        this.session = new ReadinessComputationSession();
    }

    public void setAlwaysConsiderReadyAndOnlyAccessDataIfAContentHashCanBeProvided() {
        assert (this.session != null);
        this.session.alwaysConsiderReadyAndOnlyAccessDataIfAContentHashCanBeProvided = true;
    }

    private static SerializedDataset getCopySuitableForSettingsHash(Dataset dataset) {
        SerializedDataset ss = dataset.serialize();
        ss.tags = null;
        ss.description = null;
        ss.shortDesc = null;
        ss.checklists = null;
        ss.creationTag = null;
        ss.versionTag = null;
        ss.setMetrics(new ProbesSet());
        ss.setDataQualityRuleSet(new DataQualityRuleSet());
        ss.setManualDataLineage(null);
        return ss;
    }

    public static String getDatasetSettingsHash(Dataset dataset) {
        String ss = ComputableHashComputer.getCopySuitableForSettingsHash(dataset).toJSONAndFixupForDataQuality(false);
        return DKUtils.md5Base64((String)ss);
    }

    public static String getManagedFolderSettingsHash(ManagedFolder mf) {
        mf = (ManagedFolder)JSON.deepCopy((Object)mf);
        mf.name = null;
        mf.contentType = null;
        mf.tags = null;
        mf.description = null;
        mf.shortDesc = null;
        mf.checklists = null;
        mf.versionTag = null;
        mf.creationTag = null;
        mf.checks = null;
        mf.metrics = null;
        return DKUtils.md5Base64((String)JSON.json((Object)mf));
    }

    public static String getSMSettingsHash(SavedModel sm) {
        sm = (SavedModel)JSON.deepCopy((Object)sm);
        sm.name = null;
        sm.contentType = null;
        sm.tags = null;
        sm.description = null;
        sm.shortDesc = null;
        sm.checklists = null;
        sm.versionTag = null;
        sm.creationTag = null;
        return DKUtils.md5Base64((String)JSON.json((Object)sm));
    }

    public static String getMESSettingsHash(ModelEvaluationStore mes) {
        mes = (ModelEvaluationStore)JSON.deepCopy((Object)mes);
        mes.name = null;
        mes.tags = null;
        mes.description = null;
        mes.shortDesc = null;
        mes.checklists = null;
        mes.versionTag = null;
        mes.creationTag = null;
        return DKUtils.md5Base64((String)JSON.json((Object)mes));
    }

    public static String getRKSettingsHash(RetrievableKnowledge rk) {
        rk = (RetrievableKnowledge)JSON.deepCopy((Object)rk);
        rk.name = null;
        rk.tags = null;
        rk.description = null;
        rk.shortDesc = null;
        rk.checklists = null;
        rk.versionTag = null;
        rk.creationTag = null;
        return DKUtils.md5Base64((String)JSON.json((Object)rk));
    }

    public static String getStreamingEndpointSettingsHash(StreamingEndpoint se) {
        se = (StreamingEndpoint)JSON.deepCopy((Object)se);
        se.id = null;
        se.tags = null;
        se.description = null;
        se.shortDesc = null;
        se.checklists = null;
        se.versionTag = null;
        se.creationTag = null;
        return DKUtils.md5Base64((String)JSON.json((Object)se));
    }

    public String getSettingsHash(FlowComputable computable) throws IOException {
        switch (computable.getType()) {
            case DATASET: {
                return ComputableHashComputer.getDatasetSettingsHash(((FlowDataset)computable).getMandatory(this.dao));
            }
            case SAVED_MODEL: {
                FlowSavedModel fsm = (FlowSavedModel)computable;
                return ComputableHashComputer.getSMSettingsHash(fsm.getSavedModel());
            }
            case MODEL_EVALUATION_STORE: {
                FlowModelEvaluationStore fsm = (FlowModelEvaluationStore)computable;
                return ComputableHashComputer.getMESSettingsHash(fsm.getModelEvaluationStore());
            }
            case RETRIEVABLE_KNOWLEDGE: {
                FlowRetrievableKnowledge fsm = (FlowRetrievableKnowledge)computable;
                return ComputableHashComputer.getRKSettingsHash(fsm.getRetrievableKnowledge());
            }
            case MANAGED_FOLDER: {
                FlowManagedFolder fodb = (FlowManagedFolder)computable;
                return ComputableHashComputer.getManagedFolderSettingsHash(fodb.getManagedFolder());
            }
            case STREAMING_ENDPOINT: {
                FlowStreamingEndpoint fse = (FlowStreamingEndpoint)computable;
                return ComputableHashComputer.getStreamingEndpointSettingsHash(fse.getStreamingEndpoint());
            }
        }
        throw new Error();
    }

    public DatasetReadiness getCurrentContentHash(DSSDBConnection session, FlowComputable computable, Partition p) throws Exception {
        switch (computable.getType()) {
            case DATASET: {
                FlowDataset dataset = (FlowDataset)computable;
                Dataset ds = this.datasetAccessService.getMandatory(DatasetLocUtils.resolveFull(dataset.getFullName()));
                return this.getCurrentContentHash(session, ds, p);
            }
            case SAVED_MODEL: {
                FlowSavedModel fsm = (FlowSavedModel)computable;
                return this.getCurrentContentHash(fsm.getSavedModel());
            }
            case MANAGED_FOLDER: {
                FlowManagedFolder fodb = (FlowManagedFolder)computable;
                return this.getCurrentContentHash(fodb.getManagedFolder(), p);
            }
            case MODEL_EVALUATION_STORE: {
                FlowModelEvaluationStore fsm = (FlowModelEvaluationStore)computable;
                return this.getCurrentContentHash(fsm.getModelEvaluationStore());
            }
            case RETRIEVABLE_KNOWLEDGE: {
                FlowRetrievableKnowledge frk = (FlowRetrievableKnowledge)computable;
                return this.getCurrentContentHash(frk.getRetrievableKnowledge());
            }
            case STREAMING_ENDPOINT: {
                throw new IllegalStateException("Streaming endpoints are not built");
            }
        }
        throw new Error();
    }

    public boolean partitionExists(FlowComputable computable, Partition p) throws Exception {
        RWTransactionRef rwt = TransactionContext.retrieveWrite();
        switch (computable.getType()) {
            case DATASET: {
                FlowDataset fds = (FlowDataset)computable;
                try (DatasetHandler dh = DatasetHandlerFactory.build(rwt.getUser(), fds.getMandatory(this.dao));){
                    boolean bl = dh.partitionExists(p);
                    return bl;
                }
            }
            case MANAGED_FOLDER: {
                FlowManagedFolder fmf = (FlowManagedFolder)computable;
                try (ManagedFolderHandler fh = (ManagedFolderHandler)fmf.getManagedFolder().buildHandler(this.authCtx);){
                    boolean bl = fh.partitionExists(p);
                    return bl;
                }
            }
        }
        return true;
    }

    public DatasetReadiness getCurrentContentHash(DSSDBConnection session, Partitionable dataStore, Partition p) throws Exception {
        if (dataStore instanceof Dataset) {
            Dataset dataset = (Dataset)dataStore;
            return this.getCurrentContentHash(session, dataset, p);
        }
        if (dataStore instanceof ManagedFolder) {
            ManagedFolder managedFolder = (ManagedFolder)dataStore;
            return this.getCurrentContentHash(managedFolder, p);
        }
        if (dataStore instanceof ModelEvaluationStore) {
            ModelEvaluationStore modelEvaluationStore = (ModelEvaluationStore)dataStore;
            return this.getCurrentContentHash(modelEvaluationStore);
        }
        if (dataStore instanceof SavedModel) {
            SavedModel savedModel = (SavedModel)dataStore;
            return this.getCurrentContentHash(savedModel);
        }
        throw new IllegalArgumentException("Unexpected type: " + String.valueOf(dataStore.getClass()));
    }

    public DatasetReadiness getCurrentContentHash(ManagedFolder mf, Partition p) throws Exception {
        String settingsHash = ComputableHashComputer.getManagedFolderSettingsHash(mf);
        try (ManagedFolderHandler handler = (ManagedFolderHandler)mf.buildHandler(this.authCtx);){
            DatasetReadiness ret = handler.getReadiness(p);
            ret.hash = StringUtils.isBlank((String)ret.hash) ? settingsHash : settingsHash + "-" + ret.hash;
            DatasetReadiness datasetReadiness = ret;
            return datasetReadiness;
        }
    }

    public DatasetReadiness getCurrentContentHash(SavedModel sm) {
        return DatasetReadiness.ready(ComputableHashComputer.getSMSettingsHash(sm));
    }

    public DatasetReadiness getCurrentContentHash(ModelEvaluationStore mes) {
        return DatasetReadiness.ready(ComputableHashComputer.getMESSettingsHash(mes));
    }

    public DatasetReadiness getCurrentContentHash(RetrievableKnowledge rk) {
        return DatasetReadiness.ready(ComputableHashComputer.getRKSettingsHash(rk));
    }

    public DatasetReadiness getCurrentContentHash(StreamingEndpoint se) {
        return DatasetReadiness.ready(ComputableHashComputer.getStreamingEndpointSettingsHash(se));
    }

    public DatasetReadiness getCurrentContentHash(DSSDBConnection session, Dataset dataset, Partition p) throws Exception {
        DatasetReadiness ret;
        String settingsHash = ComputableHashComputer.getDatasetSettingsHash(dataset);
        assert (dataset != null);
        DatasetHandler.DatasetMeta<?, ?> meta = DatasetHandlerFactory.getMeta(dataset);
        if (!meta.isReadable()) {
            ret = DatasetReadiness.ready(settingsHash);
        } else if (meta.isFSLike()) {
            ret = this.getDatasetReadiness(this.authCtx, dataset, p);
            if (StringUtils.isBlank((String)ret.hash)) {
                if (ret.isReady()) {
                    ret = DatasetReadiness.notReady(new IOException("No hash provided for FSLike dataset"));
                }
                ret.hash = settingsHash;
            } else {
                ret.hash = settingsHash + "-" + ret.hash;
            }
        } else if (dataset.isManaged()) {
            List<HashesModel.PropagatedHashInfo> propagated = this.flowStateInternalDB.getAllPropagatedFor(session, dataset.getFullName(), p.id());
            if (propagated.size() == 0) {
                logger.infoV("managed non-FS dataset %s/%s has no propagated state, only checking if it has data", new Object[]{dataset.getFullName(), p.id()});
                DatasetReadiness ret2 = this.getDatasetReadiness(this.authCtx, dataset, p);
                ret2.hash = StringUtils.isBlank((String)ret2.hash) ? settingsHash : settingsHash + "-" + ret2.hash;
                return ret2;
            }
            StringBuilder retHash = new StringBuilder();
            int i = 0;
            for (HashesModel.PropagatedHashInfo phi : propagated) {
                if (i++ > 0) {
                    retHash.append("-");
                }
                retHash.append(phi.propagatedHash).append(".").append(DKUtils.isoFormat((long)phi.propagatedOn));
            }
            if (dataset.getParams().isNotReadyIfEmpty()) {
                ret = this.getDatasetReadiness(this.authCtx, dataset, p);
                ret.hash = StringUtils.isBlank((String)ret.hash) ? settingsHash : settingsHash + "-" + ret.hash;
            } else {
                ret = DatasetReadiness.ready(settingsHash);
            }
            ret.hash = ret.hash + "-" + DKUtils.md5Base64((String)retHash.toString());
            logger.infoV("managed non-FS dataset, computed new hash for %s/%s: %s, based on %d propagated from upstream", new Object[]{dataset.getFullName(), p.id(), ret.hash, propagated.size()});
        } else {
            ret = this.getDatasetReadiness(this.authCtx, dataset, p);
            ret.hash = StringUtils.isBlank((String)ret.hash) ? settingsHash : settingsHash + "-" + ret.hash;
        }
        return ret;
    }

    private DatasetReadiness getDatasetReadiness(AuthCtx authCtx, Dataset dataset, Partition p) throws IOException, InterruptedException {
        int debugReadinessLatency = ApplicationConfigurator.getParams().getIntParam("dku.jobs.prune.datasetReadinessLatencyMS", Integer.valueOf(0));
        if (debugReadinessLatency > 0) {
            logger.debugV("Readiness debug sleep %d ms", new Object[]{debugReadinessLatency});
            Thread.sleep(debugReadinessLatency);
        }
        try (DatasetHandler handler = DatasetHandlerFactory.build(authCtx, dataset);){
            DatasetReadiness datasetReadiness = handler.getReadiness(p, this.session);
            return datasetReadiness;
        }
    }

    public static class ReadinessComputationSession {
        public Map<AnyLoc, DatasetReadiness> alreadyComputedAndReusableSQLTableReadiness = new HashMap<AnyLoc, DatasetReadiness>();
        public boolean alwaysConsiderReadyAndOnlyAccessDataIfAContentHashCanBeProvided;
    }
}

