/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.grouping;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.VisualSQLRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipePayloadParams;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.GroupingRecipeService;
import com.dataiku.dip.server.recipes.RecipeSchemaService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class GroupingRecipeSchemaComputer
extends RecipeSchemaComputer
implements RecipeSchemaComputer.RecipeSchemaComputerWithPayload {
    @Autowired
    private GroupingRecipeService service;
    @Autowired
    private VisualSQLRecipesBaseService visualRecipesService;
    @Autowired
    private TransactionService transactionService;
    private GroupingRecipePayloadParams params;
    private static Logger logger = Logger.getLogger((String)"dip.grouping.schema");

    public GroupingRecipeSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        super(authCtx, activity);
    }

    @Override
    public void setPayload(String payload) {
        this.params = this.service.loadParams(payload, this.recipe);
    }

    public void setParams(GroupingRecipePayloadParams params) {
        this.params = params;
    }

    @Override
    public boolean canUpdateRecipe() {
        return true;
    }

    @Override
    public RecipeSchemaService.RecipeSchemaAutoupdateResult updateRecipe_NT(JsonObject optionsObj) throws Exception {
        Schema inputSchema;
        logger.info((Object)("update recipe options=" + JSON.log((Object)optionsObj)));
        GroupingRecipeUpdateOptions options = optionsObj == null ? new GroupingRecipeUpdateOptions() : (GroupingRecipeUpdateOptions)JSON.parse((JsonElement)optionsObj, GroupingRecipeUpdateOptions.class);
        RecipeSchemaService.RecipeSchemaAutoupdateResult ret = new RecipeSchemaService.RecipeSchemaAutoupdateResult();
        try (Transaction t = this.transactionService.beginRead();){
            Iterator<ComputedColumn> inputLoc = this.recipe.getSingleInput("main").getLoc(this.recipe.projectKey);
            Dataset dataset = this.datasetAccessService.getMandatory((AnyLoc)((Object)inputLoc));
            inputSchema = dataset.getSchema();
        }
        HashMap columns = Maps.newHashMap();
        for (SchemaColumn schemaColumn : inputSchema.columns) {
            columns.put(schemaColumn.getName(), schemaColumn);
        }
        for (ComputedColumn computedColumn : this.params.computedColumns) {
            columns.put(computedColumn.name, new SchemaColumn(computedColumn.name, Type.forName((String)computedColumn.type)));
        }
        if (options.removeMissingKeys) {
            ArrayList keyToRemove = Lists.newArrayList();
            for (GroupingRecipePayloadParams.GroupingKey key : this.params.getRawGroupingKeys()) {
                if (columns.containsKey(key.column)) continue;
                keyToRemove.add(key);
            }
            logger.info((Object)("found " + keyToRemove.size() + " keys to remove"));
            this.params.getRawGroupingKeys().removeAll(keyToRemove);
            for (GroupingRecipePayloadParams.GroupingKey key : keyToRemove) {
                ret.recipeChanges.add(String.format("Removed group key %s", key.column));
            }
        }
        if (options.removeMissingAggregates) {
            ArrayList valuesToRemove = Lists.newArrayList();
            for (GroupingRecipePayloadParams.GroupingValue val : this.params.values) {
                if (val.column == null || columns.containsKey(val.column)) continue;
                valuesToRemove.add(val);
            }
            logger.info((Object)("found " + valuesToRemove.size() + " values to remove"));
            this.params.values.removeAll(valuesToRemove);
            for (GroupingRecipePayloadParams.GroupingValue val : valuesToRemove) {
                ret.recipeChanges.add(String.format("Removed %d aggregates on %s", val.aggrCount(), val.column));
            }
        }
        if (!options.newAggregates.isEmpty()) {
            HashSet aggregated = Sets.newHashSet();
            for (GroupingRecipePayloadParams.GroupingValue value : this.params.values) {
                if (value.column == null) continue;
                aggregated.add(value.column);
            }
            ArrayList arrayList = Lists.newArrayList();
            for (SchemaColumn column : inputSchema.getColumns()) {
                if (aggregated.contains(column.getName())) continue;
                arrayList.add(column);
            }
            block13: for (SchemaColumn column : arrayList) {
                if (!options.newAggregates.containsKey(column.getType())) continue;
                List<GroupingRecipePayloadParams.GroupingValue> templates = options.newAggregates.get(column.getType());
                for (GroupingRecipePayloadParams.GroupingValue template : templates) {
                    if (!Pattern.matches(template.column, column.getName())) continue;
                    GroupingRecipePayloadParams.GroupingValue val = (GroupingRecipePayloadParams.GroupingValue)JSON.deepCopy((Object)template);
                    val.column = column.getName();
                    this.params.values.add(val);
                    ret.recipeChanges.add(String.format("Added %d aggregates on %s", val.aggrCount(), val.column));
                    continue block13;
                }
            }
        }
        if (!ret.recipeChanges.isEmpty()) {
            ret.updatedRecipe = this.recipe;
            ret.updatedPayload = JSON.pretty((Object)this.params);
        }
        return ret;
    }

    @Override
    public List<Schema> getSchemasForOutputRole_NT(String role) throws Exception {
        Preconditions.checkArgument((boolean)role.equals("main"), (Object)("Recipe only has output role 'main', got: " + role));
        try (Transaction t = this.transactionService.beginRead();){
            this.recipesValidationService.checkComplianceWithRecipeDesc(this.authCtx, this.recipe);
            ArrayList arrayList = Lists.newArrayList((Object[])new Schema[]{this.getSchema()});
            return arrayList;
        }
    }

    private Schema getSchema() throws Exception {
        AnyLoc inputLoc = this.recipe.getSingleInput("main").getLoc(this.recipe.projectKey);
        Dataset inputDataset = this.datasetAccessService.getMandatory(inputLoc);
        VisualSQLRecipesBaseService.SQLBasedEngineStatus selectedEngine = this.visualRecipesService.getEngine(this.authCtx, this.activity, this.params, this.params.engineType);
        boolean lowerCase = this.visualRecipesService.mustLowerCaseColumnsNames((VisualSQLRecipePayloadParams)this.params, selectedEngine);
        SQLDialect dialect = this.visualRecipesService.getDialect(this.authCtx, this.activity, selectedEngine);
        return this.service.getOutputSchemaAfterOverride(inputDataset, this.params, lowerCase, dialect == null ? null : Integer.valueOf(dialect.getIdentifiersMaxLength()));
    }

    public static class GroupingRecipeUpdateOptions {
        public boolean removeMissingAggregates = true;
        public boolean removeMissingKeys = true;
        public Map<Type, List<GroupingRecipePayloadParams.GroupingValue>> newAggregates = Maps.newHashMap();
    }
}

