/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.joinlike;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.QueryGenerationUtils;
import com.dataiku.dip.dataflow.exec.WithComputedColumns;
import com.dataiku.dip.dataflow.exec.WithPostFilter;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.join.JoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.joinlike.ColumnDesc;
import com.dataiku.dip.dataflow.exec.joinlike.ConditionsMode;
import com.dataiku.dip.dataflow.exec.joinlike.JoinDescBase;
import com.dataiku.dip.dataflow.exec.joinlike.JoinInputDescBase;
import com.dataiku.dip.dataflow.exec.joinlike.JoinLikeRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.joinlike.JoinOutputRole;
import com.dataiku.dip.dataflow.exec.joinlike.JoinType;
import com.dataiku.dip.dataflow.exec.joinlike.MatchingConditionBase;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.sql.BigQuerySQLDialect;
import com.dataiku.dip.sql.OracleSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class JoinLikeQueryGenerator<P extends JoinLikeRecipePayloadParams<? extends JoinInputDescBase, M, J>, M extends MatchingConditionBase, J extends JoinDescBase<M>> {
    protected int _counter = 0;
    protected static ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
    protected Map<Integer, Map<String, String>> trackedNames = new HashMap<Integer, Map<String, String>>();
    protected Map<Integer, Map<String, String>> trackedNamesBuffer = new HashMap<Integer, Map<String, String>>();
    protected Map<String, Dataset> sources;
    protected Map<String, PartitioningScheme> sourcePartitionSchemes;
    protected Map<String, List<Partition>> sourcePartitions;
    protected PartitioningScheme targetPartitionScheme;
    protected P params;
    protected SQLDialect dialect;
    protected boolean ignoreFilterTranslationError;
    protected Map<String, SQLUtils.SQLTable> tablesBySN;
    protected Dataset outputDataset;
    protected Map<Integer, List<SchemaColumn>> virtualColumnsByDataset = Maps.newHashMap();
    protected JoinOutputRole role;
    private static final Logger logger = Logger.getLogger((String)"dip.join.sql.generator");

    public JoinLikeQueryGenerator(P params, Map<String, Dataset> sources, Map<String, SQLUtils.SQLTable> tables, Dataset outputDataset, JoinOutputRole role) {
        this.outputDataset = outputDataset;
        Preconditions.checkNotNull(params);
        Preconditions.checkNotNull(sources);
        this.params = params;
        this.sources = sources;
        this.tablesBySN = tables;
        this.role = role;
    }

    public void setPartitioning(Map<String, PartitioningScheme> sourcePartitionSchemes, Map<String, List<Partition>> sourcePartitions, PartitioningScheme targetPartitionScheme) {
        this.sourcePartitionSchemes = sourcePartitionSchemes;
        this.sourcePartitions = sourcePartitions;
        this.targetPartitionScheme = targetPartitionScheme;
    }

    public void setVirtualColumns(Map<Integer, List<SchemaColumn>> virtualColumnsByDataset) {
        this.virtualColumnsByDataset = virtualColumnsByDataset;
        logger.info((Object)("virtual columns=" + JSON.log(virtualColumnsByDataset)));
    }

    public String generateSQL(SQLDialect dialect) throws IOException {
        return this.generateQuery(dialect).toSQL(dialect);
    }

    private SelectQueryBuilder generateQueryWithoutSelectedColumnsAndPostTreatment() {
        SelectQueryBuilder query = new SelectQueryBuilder();
        int fromTableIndex = ((JoinDescBase)((JoinLikeRecipePayloadParams)this.params).joins.get((int)0)).table1;
        JoinInputDescBase fromTableDesc = (JoinInputDescBase)((JoinLikeRecipePayloadParams)this.params).virtualInputs.get(fromTableIndex);
        QueryAst.TableLike fromTable = this.filterTable(fromTableDesc);
        query.from(fromTable);
        this.selectAll(query, fromTableIndex);
        for (JoinDescBase join : ((JoinLikeRecipePayloadParams)this.params).joins) {
            if (this.requiresWrapper(join)) {
                query = this.wrappedJoin(query, join);
                continue;
            }
            this.simpleJoin(query, join);
        }
        return query;
    }

    private SelectQueryBuilder useSelectedAndComputedColumns(SelectQueryBuilder query) {
        Schema schemaBeforeCompCols = new Schema();
        query.clearSelected();
        for (ColumnDesc cd : ((JoinLikeRecipePayloadParams)this.params).getSelectedColumns()) {
            String colName;
            if (this.isTracked(cd)) {
                colName = this.getTrackedName(cd);
                schemaBeforeCompCols.addColumn(new SchemaColumn(colName, Type.STRING));
                query.select(colName);
                continue;
            }
            colName = this.getColumnAlias(cd, this.params);
            schemaBeforeCompCols.addColumn(new SchemaColumn(colName, Type.STRING));
            query.select(this.col(cd), colName);
        }
        if (this.params instanceof WithComputedColumns) {
            query = QueryGenerationUtils.computedColumns(query, ((WithComputedColumns)this.params).getComputedColumns(), this.dialect, schemaBeforeCompCols);
        }
        return query;
    }

    private SelectQueryBuilder generateMainQuery() {
        SelectQueryBuilder query = this.generateQueryWithoutSelectedColumnsAndPostTreatment();
        if (((JoinLikeRecipePayloadParams)this.params).isAntiJoin()) {
            this.applyAntiJoinFilter(query, ((JoinDescBase)((JoinLikeRecipePayloadParams)this.params).joins.get((int)0)).type == JoinType.LEFT_ANTI);
        }
        query = this.useSelectedAndComputedColumns(query);
        JoinLikeQueryGenerator.applyPartitioning(query, this.targetPartitionScheme, this.outputDataset.getSchema());
        return this.applyPostFilters(query);
    }

    private SelectQueryBuilder applyPostFilters(SelectQueryBuilder query) {
        if (this.params instanceof WithPostFilter) {
            query = QueryGenerationUtils.postFilter(query, ((WithPostFilter)this.params).getPostFilter(), this.dialect, this.ignoreFilterTranslationError);
        }
        return query;
    }

    public List<String> getAllColumnsNamesForInputDataset(int tableIndex) {
        JoinInputDescBase table = (JoinInputDescBase)((JoinLikeRecipePayloadParams)this.params).virtualInputs.get(tableIndex);
        if (!this.sources.containsKey(table.name)) {
            throw ErrorContext.iaef((String)"Dataset '%s' is not in the recipe sources. Has %s", (Object)table.name, (Object[])new Object[]{this.sources.keySet().toString()});
        }
        Schema unmatchedTableSchema = this.sources.get(table.name).getSchema();
        if (unmatchedTableSchema == null) {
            throw ErrorContext.iaef((String)"Dataset '%s' has no schema", (Object)table.name, (Object[])new Object[0]);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (SchemaColumn sc : unmatchedTableSchema.getColumns()) {
            result.add(sc.getName());
        }
        if (table.computedColumns != null) {
            for (ComputedColumn cc : table.computedColumns) {
                result.add(cc.name);
            }
        }
        return result;
    }

    private SelectQueryBuilder generateUnmatchedQuery(boolean leftUnmatched) {
        JoinDescBase join = (JoinDescBase)((JoinLikeRecipePayloadParams)this.params).joins.get(0);
        int unmatchedTableIndex = leftUnmatched ? join.table1 : join.table2;
        SelectQueryBuilder query = this.generateQueryWithoutSelectedColumnsAndPostTreatment();
        this.applyAntiJoinFilter(query, leftUnmatched);
        query.clearSelected();
        for (String columnName : this.getAllColumnsNamesForInputDataset(unmatchedTableIndex)) {
            ColumnDesc cd = JoinLikeQueryGenerator.getColumnDesc(this.params, unmatchedTableIndex, columnName);
            query.select(this.col(cd), columnName);
        }
        JoinLikeQueryGenerator.applyPartitioning(query, this.targetPartitionScheme, this.outputDataset.getSchema());
        return query;
    }

    private void applyAntiJoinFilter(SelectQueryBuilder query, boolean leftAntiJoin) {
        JoinDescBase join = (JoinDescBase)((JoinLikeRecipePayloadParams)this.params).joins.get(0);
        int emptySideTableIndex = leftAntiJoin ? join.table2 : join.table1;
        for (String columnName : this.getAllColumnsNamesForInputDataset(emptySideTableIndex)) {
            ColumnDesc cd = JoinLikeQueryGenerator.getColumnDesc(this.params, emptySideTableIndex, columnName);
            query.where(this.col(cd).isnull());
        }
    }

    public SelectQueryBuilder generateQuery(SQLDialect dialect) {
        SelectQueryBuilder query = this.generateQueryUncasted(dialect);
        return QueryGenerationUtils.applyInsertIntoCasts(query, dialect, this.outputDataset);
    }

    public SelectQueryBuilder generateQueryUncasted(SQLDialect dialect) {
        ((JoinLikeRecipePayloadParams)this.params).validate();
        List joins = ((JoinLikeRecipePayloadParams)this.params).joins;
        if (dialect instanceof OracleSQLDialect) {
            for (JoinDescBase join : joins) {
                if (join.conditionsMode != ConditionsMode.NATURAL) continue;
                throw ErrorContext.iae((String)"Natural join is not supported on Oracle.");
            }
        } else if (dialect instanceof BigQuerySQLDialect) {
            for (JoinDescBase join : joins) {
                if (join.conditionsMode == ConditionsMode.NATURAL) {
                    throw ErrorContext.iae((String)"Natural join is not supported on BigQuery.");
                }
                if (join.type != JoinType.FULL) continue;
                if (join.getJoinConditions().size() > 1) {
                    if (join.conditionsMode == ConditionsMode.OR) {
                        throw ErrorContext.iae((String)"FULL joins cannot have more than one condition in OR mode on BigQuery.");
                    }
                    if (join.conditionsMode != ConditionsMode.AND || !join.getJoinConditions().stream().noneMatch(MatchingConditionBase::isEqualityCondition)) continue;
                    throw ErrorContext.iae((String)"FULL joins with multiple conditions must have an equality condition in AND mode on BigQuery.");
                }
                if (join.isEquiJoin()) continue;
                throw ErrorContext.iae((String)"FULL joins with a single condition are only supported with equality on BigQuery.");
            }
        }
        this.dialect = dialect;
        return switch (this.role) {
            default -> throw new IncompatibleClassChangeError();
            case JoinOutputRole.MAIN -> this.generateMainQuery();
            case JoinOutputRole.UNMATCHED_ROWS_LEFT -> this.generateUnmatchedQuery(true);
            case JoinOutputRole.UNMATCHED_ROWS_RIGHT -> this.generateUnmatchedQuery(false);
        };
    }

    public static void applyPartitioning(SelectQueryBuilder query, PartitioningScheme targetPartitionScheme, Schema outputSchema) {
        if (targetPartitionScheme != null) {
            for (String col : targetPartitionScheme.getDimensionNames()) {
                if (outputSchema.getColumn(col) != null) continue;
                SchemaColumn sc = outputSchema.getColumnOrDefault(col, Type.STRING);
                query.select(ef.dstPartitionId(sc, targetPartitionScheme.getDimension(col)), col);
            }
        }
    }

    public QueryAst.TableLike filterTable(JoinInputDescBase inputDesc) {
        QueryAst.TableLike table;
        SelectQueryBuilder innerQuery;
        boolean hasPreFilter;
        SQLUtils.SQLTable inputTable = this.getTable(inputDesc);
        String inputTableAlias = this.getTableAlias(inputDesc);
        Dataset inputDataset = this.getDataset(inputDesc);
        ExpressionBuilder partitionFilterExpression = null;
        if (this.sourcePartitions != null && this.sourcePartitions.get(inputDesc.name) != null && inputTable.isTrueTable()) {
            partitionFilterExpression = ExpressionUtils.getPartitionFilterClause(this.sourcePartitionSchemes.get(inputDesc.name), this.sources.get(inputDesc.name), this.sourcePartitions.get(inputDesc.name), this.dialect);
        }
        boolean hasPartitionFilter = partitionFilterExpression != null;
        boolean bl = hasPreFilter = inputDesc.preFilter != null && (inputDesc.preFilter.distinct || inputDesc.preFilter.enabled);
        if (hasPreFilter || hasPartitionFilter) {
            innerQuery = new SelectQueryBuilder();
            innerQuery.select(ef.col(inputTableAlias, "*"));
            innerQuery.from(inputTable, inputTableAlias);
            QueryGenerationUtils.preFilter(innerQuery, inputDesc.preFilter, this.dialect, inputDataset, this.ignoreFilterTranslationError);
            if (hasPartitionFilter) {
                innerQuery.where(partitionFilterExpression);
            }
            table = SelectQueryBuilder.table(innerQuery, inputTableAlias);
        } else {
            table = SelectQueryBuilder.table(inputTable, inputTableAlias);
        }
        if (inputDesc.computedColumns != null && !inputDesc.computedColumns.isEmpty()) {
            if (inputDataset == null) {
                throw new IllegalArgumentException("Failed to retrieve the input dataset '" + inputDesc.name + "': dataset is null");
            }
            innerQuery = new SelectQueryBuilder();
            innerQuery.from(table);
            innerQuery.select("*");
            Schema tableSchema = inputDataset.getSchema();
            List<SchemaColumn> virtualColumns = this.virtualColumnsByDataset.get(inputDesc.index);
            if (virtualColumns != null) {
                tableSchema = new Schema(tableSchema);
                tableSchema.addColumns(virtualColumns);
            }
            innerQuery = QueryGenerationUtils.computedColumns(innerQuery, inputDesc.computedColumns, this.dialect, tableSchema);
            table = SelectQueryBuilder.table(innerQuery, inputTableAlias);
        }
        return table;
    }

    protected String addTemporaryUniqueKey(SelectQueryBuilder query) {
        SelectQueryBuilder fromQuery = SelectQueryBuilder.wrappedFrom(query);
        String alias = query.from().getAlias();
        String idName = "row_id_" + this._counter++;
        if (!fromQuery.hasSelectedItems()) {
            fromQuery.select(ef.col(alias, "*"));
        }
        fromQuery.selectUniqueId(idName);
        query.from(fromQuery, alias);
        return idName;
    }

    private SelectQueryBuilder wrappedJoin(SelectQueryBuilder query, J join) {
        SelectQueryBuilder outerQuery = new SelectQueryBuilder();
        outerQuery.from(query, "dku_tmp_subquery_" + this._counter++);
        this.join(outerQuery, query, join);
        this.updateTrackedNames();
        outerQuery.selectSubrequestColumnsExceptTemp(query);
        return outerQuery;
    }

    private void simpleJoin(SelectQueryBuilder query, J join) {
        this.join(null, query, join);
    }

    private void join(SelectQueryBuilder wrapper, SelectQueryBuilder query, J join) {
        JoinInputDescBase table1Desc = (JoinInputDescBase)((JoinLikeRecipePayloadParams)this.params).virtualInputs.get(((JoinDescBase)join).table1);
        JoinInputDescBase table2Desc = (JoinInputDescBase)((JoinLikeRecipePayloadParams)this.params).virtualInputs.get(((JoinDescBase)join).table2);
        QueryAst.TableLike joinedTable = this.filterTable(table2Desc);
        String joinedTableAlias = this.getTableAlias(table2Desc);
        if (((JoinDescBase)join).isEquiJoin() && ((JoinDescBase)join).hasImplicitOrExplicitRightLimit()) {
            SelectQueryBuilder limitedRight = this.limitRightEquiJoin(joinedTable, join);
            joinedTable = SelectQueryBuilder.table(limitedRight, joinedTableAlias);
        }
        SelectQueryBuilder.JoinClauseBuilder joinBuilder = query.join(joinedTable, ((JoinDescBase)join).sqlType(this.role));
        if (((JoinDescBase)join).conditionsMode == ConditionsMode.OR) {
            joinBuilder.withOperator("OR");
        }
        this.selectAll(query, ((JoinDescBase)join).table2);
        this.joinUsingTypeSpecificOperators(wrapper, query, join, joinBuilder, table1Desc, table2Desc);
    }

    protected abstract void joinUsingTypeSpecificOperators(SelectQueryBuilder var1, SelectQueryBuilder var2, J var3, SelectQueryBuilder.JoinClauseBuilder var4, JoinInputDescBase var5, JoinInputDescBase var6);

    private SelectQueryBuilder limitRightEquiJoin(QueryAst.TableLike joinedTable, J join) {
        ArrayList<ExpressionBuilder> partitionColumns = new ArrayList<ExpressionBuilder>(((JoinDescBase)join).getJoinConditions().size());
        for (MatchingConditionBase cond : ((JoinDescBase)join).getJoinConditions()) {
            ExpressionBuilder col = this.col(cond.column2);
            JoinInputDescBase table2Desc = (JoinInputDescBase)((JoinLikeRecipePayloadParams)this.params).virtualInputs.get(((JoinDescBase)join).table2);
            Map<String, SchemaColumn> flatVirtualColumnsMap = this.virtualColumnsByDataset.values().stream().flatMap(Collection::stream).collect(Collectors.toMap(SchemaColumn::getName, Function.identity()));
            SchemaColumn schemaColumn2 = ExpressionUtils.getSchemaColumn(cond.column2.name, this.sources.get(table2Desc.name).getSchema(), table2Desc.computedColumns, flatVirtualColumnsMap);
            col = this.applyColumnPreparationSteps(cond, col, schemaColumn2.getType());
            partitionColumns.add(col);
        }
        JoinRecipePayloadParams.RightLimitDesc rightLimit = ((JoinDescBase)join).getRightLimit();
        assert (rightLimit != null);
        if (rightLimit.decisionColumn == null || StringUtils.isBlank((String)rightLimit.decisionColumn.name)) {
            throw ErrorContext.iae((String)"Decision column to limit matches is not specified");
        }
        ExpressionBuilder orderExpression = this.col(rightLimit.decisionColumn);
        int maxMatches = rightLimit.maxMatches;
        boolean strict = rightLimit.strict;
        switch (rightLimit.type) {
            case KEEP_SMALLEST: {
                return this.keepSmallest(joinedTable, partitionColumns, orderExpression, maxMatches, strict);
            }
            case KEEP_LARGEST: {
                return this.keepBiggest(joinedTable, partitionColumns, orderExpression, maxMatches, strict);
            }
        }
        throw new NotImplementedException();
    }

    private SelectQueryBuilder keepBiggest(QueryAst.TableLike table, List<ExpressionBuilder> partitionColumns, ExpressionBuilder orderExpression, int maxMatches, boolean strict) {
        return this.keepBiggestOrSmallest(table, partitionColumns, orderExpression, maxMatches, strict, QueryAst.OrderType.DESC);
    }

    private SelectQueryBuilder keepSmallest(QueryAst.TableLike table, List<ExpressionBuilder> partitionColumns, ExpressionBuilder orderExpression, int maxMatches, boolean strict) {
        return this.keepBiggestOrSmallest(table, partitionColumns, orderExpression, maxMatches, strict, QueryAst.OrderType.ASC);
    }

    private SelectQueryBuilder keepBiggestOrSmallest(QueryAst.TableLike table, List<ExpressionBuilder> partitionColumns, ExpressionBuilder orderExpression, int maxMatches, boolean strict, QueryAst.OrderType order) {
        SelectQueryBuilder innerQuery = new SelectQueryBuilder();
        innerQuery.select(ef.col(table, "*"));
        innerQuery.from(table);
        SelectQueryBuilder outerQuery = new SelectQueryBuilder();
        String tempName = "dku_tmp_subquery_" + this._counter++;
        outerQuery.from(innerQuery, tempName);
        this.limitMatches(outerQuery, innerQuery, partitionColumns, orderExpression, maxMatches, strict, order);
        return outerQuery;
    }

    protected void limitMatches(SelectQueryBuilder wrapper, SelectQueryBuilder query, List<ExpressionBuilder> partitionColumns, ExpressionBuilder orderExpression, int maxMatches, boolean strict) {
        this.limitMatches(wrapper, query, partitionColumns, orderExpression, maxMatches, strict, QueryAst.OrderType.ASC);
    }

    protected void limitMatches(SelectQueryBuilder wrapper, SelectQueryBuilder query, List<ExpressionBuilder> partitionColumns, ExpressionBuilder orderExpression, int maxMatches, boolean strict, QueryAst.OrderType order) {
        ExpressionBuilder selector = strict ? ef.rowNumber() : ef.rank();
        String tmpColName = "dku_tmp_rank_" + this._counter++;
        QueryAst.Window w = SelectQueryBuilder.window(partitionColumns, Lists.newArrayList((Object[])new ExpressionBuilder[]{orderExpression}), Lists.newArrayList((Object[])new QueryAst.OrderType[]{order}));
        query.select(selector.over(w), tmpColName);
        wrapper.where(ef.col(tmpColName).lte(maxMatches));
    }

    private void selectAll(SelectQueryBuilder query, int joinedTableIndex) {
        ColumnDesc cd;
        JoinInputDescBase joinedTable = (JoinInputDescBase)((JoinLikeRecipePayloadParams)this.params).virtualInputs.get(joinedTableIndex);
        if (!this.sources.containsKey(joinedTable.name)) {
            throw ErrorContext.iaef((String)"Dataset '%s' is not in the recipe sources. Has %s", (Object)joinedTable.name, (Object[])new Object[]{this.sources.keySet().toString()});
        }
        Schema schema = this.sources.get(joinedTable.name).getSchema();
        if (schema == null) {
            throw ErrorContext.iaef((String)"Dataset '%s' has no schema", (Object)joinedTable.name, (Object[])new Object[0]);
        }
        for (SchemaColumn sc : schema.columns) {
            cd = JoinLikeQueryGenerator.getColumnDesc(this.params, joinedTableIndex, sc.getName());
            if (this.isTracked(cd)) {
                query.select(this.getTrackedName(cd));
                continue;
            }
            query.select(this.col(cd), this.getColumnAlias(cd, this.params));
            this.addTrackedName(cd, this.getColumnAlias(cd, this.params));
        }
        for (ComputedColumn cc : joinedTable.getComputedColumns()) {
            cd = JoinLikeQueryGenerator.getColumnDesc(this.params, joinedTableIndex, cc.name);
            if (this.isTracked(cd)) {
                query.select(this.getTrackedName(cd));
                continue;
            }
            query.select(this.col(cd), this.getColumnAlias(cd, this.params));
            this.addTrackedName(cd, this.getColumnAlias(cd, this.params));
        }
    }

    protected ExpressionBuilder applyColumnPreparationSteps(M condition, ExpressionBuilder eb, Type columnType) {
        return eb;
    }

    protected abstract boolean requiresWrapper(J var1);

    protected boolean requiresUniqueKey(J join) {
        return !((JoinDescBase)join).isEquiJoin() && ((JoinDescBase)join).hasImplicitOrExplicitRightLimit();
    }

    public static ColumnDesc getColumnDesc(JoinLikeRecipePayloadParams<?, ?, ?> params, int table, String columnName) {
        for (ColumnDesc cd : params.getSelectedColumns()) {
            if (cd.table != table || !cd.name.equals(columnName)) continue;
            return cd;
        }
        ColumnDesc cd = new ColumnDesc();
        cd.name = columnName;
        cd.table = table;
        return cd;
    }

    private String getColumnAlias(ColumnDesc cd, P params) {
        JoinInputDescBase id = (JoinInputDescBase)((JoinLikeRecipePayloadParams)params).virtualInputs.get(cd.table);
        SQLUtils.SQLTable table = this.getTable(id);
        return JoinLikeQueryGenerator.getColumnAlias(cd, id, table);
    }

    public static String getColumnAlias(ColumnDesc cd, JoinInputDescBase id, SQLUtils.SQLTable table) {
        String alias = cd.alias;
        if (StringUtils.isNotBlank((String)alias)) {
            return alias;
        }
        Object prefix = StringUtils.isNotBlank((String)id.prefix) ? id.prefix : (table.getSchemaNullIfBlank() != null ? table.getSchemaNullIfBlank() + "_" + table.getTable() : table.getTable());
        return (String)prefix + "_" + cd.name;
    }

    Dataset getDataset(JoinInputDescBase desc) {
        return this.sources.get(desc.name);
    }

    SQLUtils.SQLTable getTable(JoinInputDescBase desc) {
        return this.tablesBySN.get(desc.name);
    }

    String getTableAlias(JoinInputDescBase desc) {
        assert (desc.alias != null);
        return desc.alias;
    }

    private String getTrackedName(ColumnDesc col) {
        if (this.trackedNames.get(col.table) == null) {
            return null;
        }
        return this.trackedNames.get(col.table).get(col.name);
    }

    private void addTrackedName(ColumnDesc col, String name) {
        this.trackedNamesBuffer.computeIfAbsent(col.table, k -> new HashMap());
        this.trackedNamesBuffer.get(col.table).put(col.name, name);
    }

    private void updateTrackedNames() {
        this.trackedNames.putAll(this.trackedNamesBuffer);
    }

    private boolean isTracked(ColumnDesc cd) {
        return this.getTrackedName(cd) != null;
    }

    protected ExpressionBuilder col(ColumnDesc cd) {
        if (this.isTracked(cd)) {
            return ef.col(this.getTrackedName(cd));
        }
        JoinInputDescBase inputDesc = (JoinInputDescBase)((JoinLikeRecipePayloadParams)this.params).virtualInputs.get(cd.table);
        SQLUtils.SQLTable table = this.getTable(inputDesc);
        QueryAst.TableLike tl = SelectQueryBuilder.table(table, inputDesc.alias);
        return this.applyTimezoneConversion(ef.col(tl, cd.name), cd.name, inputDesc);
    }

    private ExpressionBuilder applyTimezoneConversion(ExpressionBuilder col, String columnName, JoinInputDescBase inputDesc) {
        if (!this.sources.containsKey(inputDesc.name)) {
            throw ErrorContext.iaef((String)"Dataset '%s' is not in the recipe sources. Has %s", (Object)inputDesc.name, (Object[])new Object[]{this.sources.keySet().toString()});
        }
        return ExpressionUtils.getAdjustedColumn(col, columnName, this.sources.get(inputDesc.name), this.dialect);
    }

    public void ignoreFilterTranslationError(boolean b) {
        this.ignoreFilterTranslationError = b;
    }
}

