/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graph.utils;

import com.dataiku.dip.coremodel.ExposedObject;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dataflow.graph.utils.GraphIds;
import com.dataiku.dip.dataflow.graph.utils.GraphSerializerCommon;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.mec.ModelEvaluationStoresCRUDService;
import com.dataiku.dip.recipes.fromapp.AppRecipeMeta;
import com.dataiku.dip.reports.Report;
import com.dataiku.dip.reports.ReportsDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ImageService;
import com.dataiku.dip.server.services.JupyterService;
import com.dataiku.dip.server.services.JupyterUtils;
import com.dataiku.dip.server.services.ProjectFoldersService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsReadService;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppsDAO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class ProjectsGraphSerializer
extends GraphSerializerCommon {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private ImageService imageService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private ModelEvaluationStoresCRUDService modelEvaluationStoresCRUDService;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private JupyterService jupyterService;
    @Autowired
    private WebAppsDAO webAppsDao;
    @Autowired
    private ReportsDAO reportsDao;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private ProjectFoldersService projectFoldersService;
    @Autowired
    private TaggableObjectsReadService taggableObjectsReadService;
    private StringBuilder headSB = new StringBuilder();
    private StringBuilder mainSB = new StringBuilder();
    private Map<String, SerializedNode> projectNodes = new HashMap<String, SerializedNode>();
    private Map<String, SerializedNode> projectFolderNodes = new HashMap<String, SerializedNode>();
    private Set<String> projectFolderPKeysLevelOne;
    private static Logger logger = Logger.getLogger((String)"dku.projectsGraphSerializer");

    public ProjectsGraphSerializer() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    protected String getCacheKeyPrefix() {
        return "__ALL__";
    }

    public SerializedNode computeNodeForEO(SerializedProject fromProject, SerializedProject toProject, List<ExposedObject> exposedObjects, AuthCtx u) throws Exception {
        String fromProjectKey = fromProject.projectKey;
        String toProjectKey = toProject.projectKey;
        SerializedNode node = new SerializedNode();
        node.nodeType = NodeType.BUNDLE_EO;
        node.id = GraphIds.forExposedObjects(fromProjectKey, toProjectKey);
        node.fromProjectKey = fromProjectKey;
        node.fromProjectName = fromProject.name;
        node.toProjectKey = toProjectKey;
        node.toProjectName = toProject.name;
        node.exposedDatasets = new ArrayList<ExposedComputable>();
        node.exposedModels = new ArrayList<ExposedComputable>();
        node.exposedEvaluationStores = new ArrayList<ExposedComputable>();
        node.exposedFolders = new ArrayList<ExposedComputable>();
        node.exposedNotebooks = new ArrayList<ExposedComputable>();
        node.exposedWebApps = new ArrayList<ExposedComputable>();
        node.exposedReports = new ArrayList<ExposedComputable>();
        node.errorMessages = new ArrayList<String>();
        for (ExposedObject ec : exposedObjects) {
            try {
                this.addObjectToNode(ec, node, fromProjectKey, toProjectKey);
            }
            catch (Exception e) {
                node.errorMessages.add("Couldn't read exposed object");
                logger.warn((Object)("Ignoring bad exposed item: " + String.valueOf((Object)ec.type) + " " + ec.localName + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
        }
        node.description = "";
        node.description = node.description + (String)(node.exposedDatasets.size() > 0 ? node.exposedDatasets.size() + " datasets" : "");
        node.description = node.description + (String)(node.exposedModels.size() > 0 ? node.exposedModels.size() + " models" : "");
        node.description = node.description + (String)(node.exposedEvaluationStores.size() > 0 ? node.exposedEvaluationStores.size() + " evaluation stores" : "");
        node.description = node.description + (String)(node.exposedFolders.size() > 0 ? node.exposedFolders.size() + " managed folders" : "");
        node.description = node.description + (String)(node.exposedNotebooks.size() > 0 ? node.exposedNotebooks.size() + " notebooks" : "");
        node.description = node.description + (String)(node.exposedWebApps.size() > 0 ? node.exposedWebApps.size() + " webapps" : "");
        node.description = node.description + (String)(node.exposedReports.size() > 0 ? node.exposedReports.size() + " RMarkdown reports" : "");
        node.predecessors = new ArrayList<String>();
        node.predecessors.add(GraphIds.forProject(fromProjectKey));
        node.successors = new ArrayList<String>();
        node.successors.add(GraphIds.forProject(toProjectKey));
        node.canExposeFromProject = this.permissionsService.hasProjectPrivilege(u, fromProject.projectKey, Privileges.ProjectLevelPrivilegeType.MANAGE_EXPOSED_ELEMENTS);
        node.canReadFromProject = this.permissionsService.hasProjectPrivilege(u, fromProject.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        node.canReadToProject = this.permissionsService.hasProjectPrivilege(u, toProject.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        int idx = this.labelsRemapping.size();
        GraphSerializerCommon.NodeRemapping nr = new GraphSerializerCommon.NodeRemapping();
        nr.id = node.id;
        nr.name = node.name;
        nr.label = node.name;
        nr.description = node.description;
        nr.type = String.valueOf((Object)node.nodeType);
        this.labelsRemapping.add(nr);
        int nbEoTypes = (node.exposedDatasets.size() > 0 ? 1 : 0) + (node.exposedModels.size() > 0 ? 1 : 0) + (node.exposedEvaluationStores.size() > 0 ? 1 : 0) + (node.exposedFolders.size() > 0 ? 1 : 0);
        String nodeWidth = "0.6";
        String nodeHeight = "0.6";
        if (nbEoTypes == 2 || nbEoTypes == 3) {
            nodeWidth = "1.2";
            nodeHeight = "1.2";
        }
        this.mainSB.append(String.format("%s [id=\"%d\", shape=circle, fontsize=1, fixedsize=true, width=%s,height=%s, label=\"%s\"];\n", node.id, idx, nodeWidth, nodeHeight, node.id));
        return node;
    }

    private void addObjectToNode(ExposedObject ec, SerializedNode node, String fromProjectKey, String toProjectKey) throws IOException {
        ec.type.assertNotFakeType();
        switch (ec.type) {
            case DATASET: {
                SerializedDataset d = (SerializedDataset)this.datasetsDAO.getOrNull(fromProjectKey, ec.localName);
                if (d == null) break;
                ExposedComputable eo = new ExposedComputable(d.name, d.name, d.type, fromProjectKey, toProjectKey, ITaggingService.TaggableType.DATASET);
                node.exposedDatasets.add(eo);
                break;
            }
            case SAVED_MODEL: {
                SavedModel sm = (SavedModel)this.savedModelsDAO.getOrNull(fromProjectKey, ec.localName);
                if (sm == null) break;
                ExposedComputable eo = new ExposedComputable(sm.id, sm.name, sm.getSubtype(), fromProjectKey, toProjectKey, ITaggingService.TaggableType.SAVED_MODEL);
                node.exposedModels.add(eo);
                break;
            }
            case MODEL_EVALUATION_STORE: {
                ModelEvaluationStore mes = this.modelEvaluationStoresCRUDService.getOrNull(fromProjectKey, ec.localName);
                if (mes == null) break;
                ExposedComputable eo = new ExposedComputable(mes.id, mes.name, mes.getSubtype(), fromProjectKey, toProjectKey, ITaggingService.TaggableType.MODEL_EVALUATION_STORE);
                node.exposedEvaluationStores.add(eo);
                break;
            }
            case MANAGED_FOLDER: {
                ManagedFolder mf = (ManagedFolder)this.managedFolderDAO.getOrNull(fromProjectKey, ec.localName);
                if (mf == null) break;
                ExposedComputable eo = new ExposedComputable(mf.id, mf.name, null, fromProjectKey, toProjectKey, ITaggingService.TaggableType.MANAGED_FOLDER);
                node.exposedFolders.add(eo);
                break;
            }
            case JUPYTER_NOTEBOOK: {
                JupyterUtils.JupyterNotebookListEntry jn = this.jupyterService.getOrNullUnsafe(fromProjectKey, ec.localName);
                if (jn == null) break;
                ExposedComputable eo = new ExposedComputable(jn.getId(), jn.getDisplayName(), "jupyter", fromProjectKey, toProjectKey, ITaggingService.TaggableType.JUPYTER_NOTEBOOK);
                node.exposedNotebooks.add(eo);
                break;
            }
            case WEB_APP: {
                WebApp wa = (WebApp)this.webAppsDao.getOrNull(fromProjectKey, ec.localName);
                if (wa == null) break;
                ExposedComputable eo = new ExposedComputable(wa.id, wa.name, null, fromProjectKey, toProjectKey, ITaggingService.TaggableType.WEB_APP);
                node.exposedWebApps.add(eo);
                break;
            }
            case REPORT: {
                Report report = (Report)this.reportsDao.getOrNull(fromProjectKey, ec.localName);
                if (report == null) break;
                ExposedComputable eo = new ExposedComputable(report.id, report.name, null, fromProjectKey, toProjectKey, ITaggingService.TaggableType.REPORT);
                node.exposedReports.add(eo);
                break;
            }
            case LABELING_TASK: 
            case ANALYSIS: 
            case STATISTICS_WORKSHEET: 
            case MODEL_COMPARISON: 
            case DASHBOARD: 
            case INSIGHT: 
            case LAMBDA_SERVICE: 
            case PROJECT: 
            case RECIPE: 
            case SCENARIO: 
            case SQL_NOTEBOOK: 
            case SEARCH_NOTEBOOK: 
            case ARTICLE: 
            case STREAMING_ENDPOINT: 
            case FLOW_ZONE: 
            case CODE_STUDIO: 
            case DATA_COLLECTION: {
                logger.warn((Object)("Found object of type " + String.valueOf((Object)ec.type) + " in exposed objects"));
            }
        }
    }

    public SerializedNode computeNodeForProjectFolder(ProjectFoldersService.ProjectFolderSummary projectFolder, AuthCtx u) throws Exception {
        String id = GraphIds.forProjectFolder(projectFolder.id);
        SerializedNode node = this.projectFolderNodes.get(id);
        if (node == null) {
            node = new SerializedNode();
            node.nodeType = NodeType.PROJECT_FOLDER;
            node.id = id;
            node.projectFolderId = projectFolder.id;
            node.name = projectFolder.name;
            node.description = projectFolder.name;
            node.predecessors = new ArrayList<String>();
            node.successors = new ArrayList<String>();
            this.projectFolderNodes.put(id, node);
            int idx = this.labelsRemapping.size();
            GraphSerializerCommon.NodeRemapping nr = new GraphSerializerCommon.NodeRemapping();
            nr.id = node.id;
            nr.name = node.name;
            nr.label = node.name;
            nr.type = String.valueOf((Object)node.nodeType);
            nr.description = node.description;
            this.labelsRemapping.add(nr);
            String nodeWidth = "2";
            String nodeHeight = "0.45";
            this.mainSB.append(String.format("%s [id=\"%s\", shape=box, labelloc=\"t\", labeljust=r, fillcolor=white, style=filled, fixedsize=true, fontsize=7, lp=5, width=%s,height=%s, label=\"%s\"];\n", node.id, idx, nodeWidth, nodeHeight, GraphSerializerCommon.escapeForQuotedField(node.name)));
        }
        return node;
    }

    public SerializedNode computeNodeForProject(SerializedProject project, AuthCtx u) throws Exception {
        String id = GraphIds.forProject(project.projectKey);
        SerializedNode node = this.projectNodes.get(id);
        if (node == null) {
            node = new SerializedNode();
            node.nodeType = NodeType.PROJECT;
            node.id = id;
            node.name = project.name;
            node.description = project.name;
            node.predecessors = new ArrayList<String>();
            node.successors = new ArrayList<String>();
            node.projectKey = project.projectKey;
            node.objectImgHash = this.imageService.getImgHash(project.projectKey, "PROJECT", null);
            node.imgColor = project.imgColor;
            node.imgPattern = project.imgPattern;
            node.showInitials = project.showInitials;
            node.projectAppType = project.projectAppType;
            node.isArchived = GeneralSettingsDAO.DEFAULT_PROJECT_STATUS.ARCHIVED.projectStatus.name.equals(project.projectStatus);
            node.isForbidden = !this.permissionsService.hasAnyProjectAccess(u, project.projectKey);
            node.isNotInFolder = this.projectFolderPKeysLevelOne != null && !this.projectFolderPKeysLevelOne.contains(project.projectKey);
            node.isAppAsRecipe = AppRecipeMeta.isAppAsRecipeTemplate(project.projectKey, project.projectAppType);
            this.projectNodes.put(id, node);
            int idx = this.labelsRemapping.size();
            GraphSerializerCommon.NodeRemapping nr = new GraphSerializerCommon.NodeRemapping();
            nr.id = node.id;
            nr.name = node.name;
            nr.label = node.name;
            nr.type = String.valueOf((Object)node.nodeType);
            nr.description = node.description;
            this.labelsRemapping.add(nr);
            String nodeWidth = "2";
            String nodeHeight = "1.3";
            this.mainSB.append(String.format("%s [id=\"%d\", shape=box, labelloc=\"t\", labeljust=r, fillcolor=white, style=filled, fixedsize=true, fontsize=7, lp=5, width=%s,height=%s, label=\"%s\"];\n", node.id, idx, nodeWidth, nodeHeight, node.id));
        }
        return node;
    }

    private void addConnection(SerializedNode inNode, SerializedNode outNode) {
        int idx = this.labelsRemapping.size();
        GraphSerializerCommon.EdgeRemapping er = new GraphSerializerCommon.EdgeRemapping();
        er.from = inNode.id;
        er.to = outNode.id;
        this.labelsRemapping.add(er);
        this.mainSB.append(String.format("%s -> %s [arrowsize=%s, label=\"%d\"];\n", inNode.id, outNode.id, outNode.nodeType == NodeType.PROJECT ? "1.1" : "0", idx));
    }

    public Callable<ProjectsSerializedGraph> serialize(String layoutEngine, String projectFolderId, boolean recursive, AuthCtx u) throws Exception {
        String sep = "0";
        if (layoutEngine.equals("neato")) {
            sep = "0.3";
        }
        this.headSB.append("digraph g {\ngraph [bgcolor=lightgray, rankdir=LR, margin=0, nodesep=0.8, ranksep=0.8,resolution=600, labeljust=r, splines=true, overlap=scalexy, sep=" + sep + "]; \nedge [arrowtail=empty, arrowsize=1.1]; \n");
        ProjectsSerializedGraph serializedGraph = new ProjectsSerializedGraph();
        Set<String> projectFolderPkeys = this.projectFoldersService.getProjectKeys_Uncheck(projectFolderId, recursive);
        this.projectFolderPKeysLevelOne = recursive ? this.projectFoldersService.getProjectKeys_Uncheck(projectFolderId, false) : projectFolderPkeys;
        List<ProjectFoldersService.ProjectFolderSummary> subProjectFolders = this.projectFoldersService.getProjectFolderSummaryMandatoryUnsafe_Check((AuthCtx)u, (String)projectFolderId, (int)1, new HashMap<String, List<String>>()).children;
        for (ProjectFoldersService.ProjectFolderSummary pfs : subProjectFolders) {
            this.computeNodeForProjectFolder(pfs, u);
        }
        HashMap exposedObjecsDic = new HashMap();
        HashMap<String, SerializedProject> projectsMap = new HashMap<String, SerializedProject>();
        for (SerializedProject sp : this.projectsService.listAllUnsafe()) {
            projectsMap.put(sp.projectKey, sp);
            for (ExposedObject eo : sp.exposedObjects.objects) {
                if (eo == null || StringUtils.isBlank((String)eo.localName) || this.taggableObjectsReadService.getOrNullUnsafe(sp.projectKey, eo.type, eo.localName) == null) {
                    logger.warn((Object)("Invalid shared element in " + sp.projectKey));
                    continue;
                }
                HashMap<String, ArrayList<ExposedObject>> p1ExpositionMap = (HashMap<String, ArrayList<ExposedObject>>)exposedObjecsDic.get(sp.projectKey);
                if (p1ExpositionMap == null) {
                    p1ExpositionMap = new HashMap<String, ArrayList<ExposedObject>>();
                    exposedObjecsDic.put(sp.projectKey, p1ExpositionMap);
                }
                for (ExposedObject.Rule r : eo.rules) {
                    List<ExposedObject> eoToP2 = (List)p1ExpositionMap.get(r.targetProject);
                    if (eoToP2 == null) {
                        eoToP2 = new ArrayList<ExposedObject>();
                        p1ExpositionMap.put(r.targetProject, (ArrayList<ExposedObject>)eoToP2);
                    }
                    eoToP2.add(eo);
                }
            }
        }
        for (String p1Key : exposedObjecsDic.keySet()) {
            if (StringUtils.isBlank((String)p1Key) || !projectsMap.containsKey(p1Key)) continue;
            SerializedProject sp1 = (SerializedProject)projectsMap.get(p1Key);
            assert (sp1 != null);
            Map p1ExpositionMap = (Map)exposedObjecsDic.get(p1Key);
            boolean canReadP1 = this.permissionsService.hasAnyProjectAccess(u, sp1.projectKey);
            boolean isP1InFolder = projectFolderPkeys == null || projectFolderPkeys.contains(sp1.projectKey);
            boolean shouldDrawP1 = canReadP1 && isP1InFolder;
            for (String p2Key : p1ExpositionMap.keySet()) {
                if (StringUtils.isBlank((String)p2Key) || !projectsMap.containsKey(p2Key)) continue;
                SerializedProject sp2 = (SerializedProject)projectsMap.get(p2Key);
                assert (sp2 != null);
                boolean canReadP2 = this.permissionsService.hasAnyProjectAccess(u, sp2.projectKey);
                boolean isP2InFolder = projectFolderPkeys == null || projectFolderPkeys.contains(sp2.projectKey);
                shouldDrawP1 |= canReadP2 && isP2InFolder;
            }
            if (!shouldDrawP1) continue;
            SerializedNode p1Node = this.computeNodeForProject(sp1, u);
            for (String p2Key : p1ExpositionMap.keySet()) {
                boolean isP2InFolder;
                if (StringUtils.isBlank((String)p2Key) || !projectsMap.containsKey(p2Key)) continue;
                SerializedProject sp2 = (SerializedProject)projectsMap.get(p2Key);
                assert (sp2 != null);
                boolean canReadP2 = this.permissionsService.hasAnyProjectAccess(u, sp2.projectKey);
                boolean bl = isP2InFolder = projectFolderPkeys == null || projectFolderPkeys.contains(sp2.projectKey);
                if (!(canReadP1 && isP1InFolder || canReadP2 && isP2InFolder)) continue;
                SerializedNode p2Node = this.computeNodeForProject(sp2, u);
                List eoToP2 = (List)p1ExpositionMap.get(p2Key);
                SerializedNode eoNode = this.computeNodeForEO(sp1, sp2, eoToP2, u);
                this.addConnection(p1Node, eoNode);
                this.addConnection(eoNode, p2Node);
                p1Node.successors.add(eoNode.id);
                p2Node.predecessors.add(eoNode.id);
                serializedGraph.nodes.put(eoNode.id, eoNode);
            }
        }
        for (SerializedProject project : projectsMap.values()) {
            if (this.projectNodes.containsKey(GraphIds.forProject(project.projectKey)) || !this.permissionsService.hasAnyProjectAccess(u, project.projectKey) || projectFolderPkeys != null && !projectFolderPkeys.contains(project.projectKey)) continue;
            this.computeNodeForProject(project, u);
        }
        serializedGraph.includedProjects = this.projectNodes.size();
        serializedGraph.includedExposedObjectsBundles = serializedGraph.nodes.size();
        serializedGraph.includedProjectFolders = this.projectFolderNodes.size();
        serializedGraph.nodes.putAll(this.projectNodes);
        serializedGraph.nodes.putAll(this.projectFolderNodes);
        Object graphviz = this.headSB.toString() + "\n" + this.mainSB.toString() + "\n";
        graphviz = (String)graphviz + "}";
        if (serializedGraph.nodes.size() == 0) {
            graphviz = ((String)graphviz).replace("newrank=true;", "");
        }
        String finalGraphviz = graphviz;
        return () -> {
            serializedGraph.svg = this.cleanSVGCache(finalGraphviz, layoutEngine, true, true);
            return serializedGraph;
        };
    }

    public static class SerializedNode {
        public NodeType nodeType;
        public String id;
        public String name;
        public String description;
        public List<String> successors = new ArrayList<String>();
        public List<String> predecessors = new ArrayList<String>();
        public String projectFolderId;
        public long objectImgHash;
        public String imgColor;
        public Integer imgPattern;
        public Boolean showInitials;
        public SerializedProject.ProjectAppType projectAppType;
        public Boolean isAppAsRecipe;
        public boolean isArchived;
        public boolean isForbidden;
        public boolean isNotInFolder;
        public String projectKey;
        public boolean canExposeFromProject;
        public boolean canReadFromProject;
        public boolean canReadToProject;
        public String fromProjectKey;
        public String fromProjectName;
        public String toProjectKey;
        public String toProjectName;
        public List<ExposedComputable> exposedDatasets;
        public List<ExposedComputable> exposedModels;
        public List<ExposedComputable> exposedEvaluationStores;
        public List<ExposedComputable> exposedFolders;
        public List<ExposedComputable> exposedNotebooks;
        public List<ExposedComputable> exposedWebApps;
        public List<ExposedComputable> exposedReports;
        public List<String> errorMessages;
    }

    static enum NodeType {
        PROJECT,
        PROJECT_FOLDER,
        BUNDLE_EO;

    }

    public static class ExposedComputable {
        public String id;
        public String name;
        public String type;
        public String fromProjectKey;
        public String toProjectKey;
        public ITaggingService.TaggableType nodeType;

        public ExposedComputable(String id, String name, String type, String fromProjectKey, String toProjectKey, ITaggingService.TaggableType nodeType) {
            this.id = id;
            this.name = name;
            this.type = type;
            this.fromProjectKey = fromProjectKey;
            this.toProjectKey = toProjectKey;
            this.nodeType = nodeType;
        }
    }

    public static class ProjectsSerializedGraph {
        public String svg;
        public int includedProjects;
        public int includedExposedObjectsBundles;
        public int includedProjectFolders;
        public Map<String, SerializedNode> nodes = new HashMap<String, SerializedNode>();
    }
}

