/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graphtools;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dataflow.graph.utils.GraphIds;
import com.dataiku.dip.dataflow.graphtools.AbstractFlowTool;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.metrics.Model;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetMetricsStatusService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class FilesizeView
extends AbstractFlowTool.FlowView {
    @Autowired
    private DatasetMetricsStatusService datasetMetricsStatusService;
    private FilesizeViewState state;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.tools.filesize");

    public FilesizeView(AuthCtx authCtx, String projectKey, JsonObject toolInitialData) {
        super(authCtx, projectKey);
    }

    @Override
    public AbstractFlowTool.FlowState getFlowState(JsonObject options) throws Exception {
        if (this.state != null) {
            Collection<String> currentFocus = this.state.focused;
            this.computeState();
            this.state.focused = currentFocus;
        } else {
            this.computeState();
        }
        return this.state;
    }

    @Override
    public synchronized FilesizeViewState computeState() throws Exception {
        this.state = new FilesizeViewState();
        try (Transaction tr = this.transactionService.beginRead();){
            for (SerializedDataset sd : this.datasetsDAO.listUnsafe(this.projectKey)) {
                FutureProgressState.checkInterrupt();
                String nodeId = GraphIds.forDataset(sd.projectKey, sd.name);
                Model.SummedDatasetMetricValue size = null;
                try {
                    Dataset dataset = Dataset.fromSerialized(sd.getFullId(), sd);
                    DatasetMetricsStatusService.DatasetSummaryStatus cachedStatus = this.datasetMetricsStatusService.getCachedSummaryStatus(dataset);
                    size = cachedStatus.size;
                }
                catch (Exception e) {
                    logger.info((Object)"Failed to get dataset connection", (Throwable)e);
                }
                boolean autoCompute = false;
                try {
                    for (Probe probe : sd.getMetrics().probes) {
                        if (!"records".equals(probe.type) || !probe.enabled || probe.computeOnBuildMode == Probe.ComputeMode.NO) continue;
                        autoCompute = true;
                        break;
                    }
                }
                catch (Exception e) {
                    logger.info((Object)"Failed to get dataset settings", (Throwable)e);
                }
                this.add(nodeId, size, autoCompute);
            }
        }
        return this.state;
    }

    @Override
    public void setFocus(Collection<String> focused) throws Exception {
        if (this.state == null) {
            this.computeState();
        }
        this.state.focused = focused == null ? new HashSet<String>() : focused;
    }

    private void add(String nodeId, Model.SummedDatasetMetricValue size, boolean autoCompute) {
        FilesizeStatus cors = new FilesizeStatus();
        cors.size = size;
        cors.autoCompute = autoCompute;
        this.state.valueByNode.put(nodeId, cors);
    }

    class FilesizeViewState
    implements AbstractFlowTool.FlowState {
        Map<String, FilesizeStatus> valueByNode = new HashMap<String, FilesizeStatus>();
        public Collection<String> focused = new HashSet<String>();

        FilesizeViewState() {
        }
    }

    class FilesizeStatus {
        Model.SummedDatasetMetricValue size;
        boolean autoCompute;

        FilesizeStatus() {
        }
    }
}

