/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.jobrunner;

import com.dataiku.dip.dataflow.Job;
import com.dataiku.dip.dataflow.JobActivity;
import com.google.gson.JsonObject;

public class JobContext {
    public String projectKey;
    public String jobId;
    public String activity;
    private JobActivity activityObj;
    private Job jobObj;
    public boolean ceRowsLimitReached;
    private static InheritableThreadLocal<JobContext> jtal = new InheritableThreadLocal<JobContext>(){

        @Override
        public JobContext childValue(JobContext parent) {
            JobContext newJA = new JobContext();
            if (parent == null) {
                return null;
            }
            newJA.jobId = parent.jobId;
            newJA.projectKey = parent.projectKey;
            newJA.activity = parent.activity;
            newJA.activityObj = parent.activityObj;
            newJA.jobObj = parent.jobObj;
            return newJA;
        }
    };

    public static void setJob(String projectKey, String jobId, Job job) {
        JobContext jac = new JobContext();
        jac.projectKey = projectKey;
        jac.jobId = jobId;
        jac.jobObj = job;
        jtal.set(jac);
    }

    public static void resetJob() {
        jtal.set(null);
    }

    public static JobContext getCurrentJobContext() {
        return (JobContext)jtal.get();
    }

    public static String getCurrentActivity() {
        JobContext jac = JobContext.getCurrentJobContext();
        if (jac == null) {
            return null;
        }
        return jac.activity;
    }

    public static void setCurrentActivityInThread(JobActivity ja) {
        JobContext jac = JobContext.getCurrentJobContext();
        if (jac != null) {
            jac.activity = ja == null ? null : ja.id();
            jac.activityObj = ja;
        }
    }

    public static void setCERowsLimitReached() {
        JobContext jc = JobContext.getCurrentJobContext();
        if (jc != null) {
            jc.ceRowsLimitReached = true;
        }
    }

    public static JobActivity.ActivityRunSummary getCurrentActivitySummary() {
        JobContext jac = JobContext.getCurrentJobContext();
        if (jac != null && jac.activityObj != null) {
            return jac.activityObj.runSummary;
        }
        return new JobActivity.ActivityRunSummary();
    }

    public static Job getCurrentJobObj() {
        JobContext jac = JobContext.getCurrentJobContext();
        if (jac == null) {
            return null;
        }
        return jac.jobObj;
    }

    public static JobActivity getCurrentActivityObj() {
        JobContext jac = JobContext.getCurrentJobContext();
        if (jac != null && jac.activityObj != null) {
            return jac.activityObj;
        }
        return null;
    }

    public Job getJobObj() {
        return this.jobObj;
    }

    public JobActivity getActivityObj() {
        return this.activityObj;
    }

    public static void setJobContext(JobContext parent) {
        if (parent != null) {
            JobContext newJA = new JobContext();
            newJA.jobId = parent.jobId;
            newJA.projectKey = parent.projectKey;
            newJA.activity = parent.activity;
            jtal.set(newJA);
        } else {
            jtal.set(null);
        }
    }

    public static JsonObject getVariablesObject() {
        JsonObject o = new JsonObject();
        JobContext jc = JobContext.getCurrentJobContext();
        if (jc != null) {
            if (jc.projectKey != null) {
                o.addProperty("jobProjectKey", jc.projectKey);
            }
            if (jc.jobId != null) {
                o.addProperty("jobId", jc.jobId);
            }
            if (jc.activity != null) {
                o.addProperty("activityId", jc.activity);
            }
        }
        return o;
    }
}

