/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.pdep;

import com.dataiku.dip.dataflow.pdep.AbstractTimeEvaluator;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.TimeDimension;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class SlidingDaysEvaluator
extends AbstractTimeEvaluator {
    private Date flowEpoch;
    private int firstDay;
    private int lastDay;

    public SlidingDaysEvaluator(Set<Date> blacklist, Date flowEpoch, int firstDay, int lastDay) {
        super(blacklist);
        this.flowEpoch = flowEpoch;
        this.firstDay = firstDay;
        this.lastDay = lastDay;
        Preconditions.checkArgument((firstDay <= 0 ? 1 : 0) != 0, (Object)"First day must be negative or null");
        Preconditions.checkArgument((lastDay <= 0 ? 1 : 0) != 0, (Object)"First day must be negative or null");
    }

    @Override
    public List<DimensionValue> getDependent(DimensionValue target, Dimension srcDim) {
        Preconditions.checkArgument((boolean)(srcDim instanceof TimeDimension), (Object)"Partitioning dimension is not a time dimension");
        Calendar cal = null;
        cal = target == null ? this.getDayLevelCalendarNOW() : this.getDayLevelCalendar(target);
        ArrayList<DimensionValue> ov = new ArrayList<DimensionValue>();
        int currentShift = 0;
        while (currentShift >= this.firstDay) {
            if (cal.getTime().before(this.flowEpoch)) {
                logger.info((Object)("flowEpoch " + String.valueOf(this.flowEpoch) + " reached at " + String.valueOf(cal.getTime())));
                break;
            }
            if (this.isBlacklisted(cal.getTime())) {
                logger.info((Object)("Skipped time:" + String.valueOf(cal.getTime())));
            }
            if (currentShift <= this.lastDay && !this.isBlacklisted(cal.getTime())) {
                ov.add((DimensionValue)SlidingDaysEvaluator.getValueFromCalendar(cal, (TimeDimension)srcDim));
            }
            cal.add(5, -1);
            if (this.isBlacklisted(cal.getTime())) continue;
            --currentShift;
        }
        return ov;
    }
}

