/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.pipeline;

import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.pipeline.AccessibilityGraph;
import com.dataiku.dip.dataflow.pipeline.SparkPipelineDef;
import com.dataiku.dip.dataflow.pipeline.SparkPipelineEltBuilder;
import com.dataiku.dip.dataflow.pipeline.SparkPipelineRunnableSubgraph;
import com.dataiku.dip.dataflow.utils.DatasetPartition;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.util.List;

public class SparkPipelineDefBuilder {
    private SparkPipelineRunnableSubgraph subgraph;
    private List<File> resourceFiles;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.spark.pipeline");

    SparkPipelineDefBuilder(SparkPipelineRunnableSubgraph subgraph) {
        this.subgraph = subgraph;
    }

    public List<File> getResourceFiles() {
        return this.resourceFiles;
    }

    SparkOverrideConfig getSparkConfigToUse() throws Exception {
        SparkPipelineEltBuilder builder = new SparkPipelineEltBuilder();
        return builder.getSparkConfFromRecipeActivity(this.subgraph.getRoot());
    }

    AbstractSparkRecipeParams.SparkExecutionEngine getEngineToUse() throws Exception {
        SparkPipelineEltBuilder builder = new SparkPipelineEltBuilder();
        return builder.getSparkExecutionEngineFromRecipeActivity(this.subgraph.getRoot());
    }

    SparkPipelineDef buildDef() throws Exception {
        SparkPipelineDef pipelineDef = new SparkPipelineDef();
        SparkPipelineEltBuilder builder = new SparkPipelineEltBuilder();
        logger.info((Object)"building spark pipeline def for activities: ");
        for (JobActivity ja : this.subgraph.getAllIncludedActivitiesWithRoot()) {
            logger.info((Object)("  " + ja.id()));
        }
        AccessibilityGraph accessibility = new AccessibilityGraph(this.subgraph.getAllIncludedActivitiesWithRoot());
        List<JobActivity> activitiesInRunOrder = accessibility.orderDepthFirst();
        for (JobActivity next : activitiesInRunOrder) {
            if (!(next.getSubgraph() instanceof RecipeRunnableSubgraph)) continue;
            SparkPipelineDef.SparkPipelineElt elt = builder.buildPipelineElt(next);
            logger.infoV("Built pipeline elt : %s", new Object[]{JSON.log((Object)elt)});
            pipelineDef.orderedElts.add(elt);
        }
        builder.finalizePipeline(pipelineDef);
        pipelineDef.useGlobalMetastore = builder.getGlobalMetastoreFromRecipeActivity(this.subgraph.getRoot());
        pipelineDef.inputs = DatasetPartition.subgraphSources(this.subgraph);
        pipelineDef.outputs = DatasetPartition.subgraphTargets(this.subgraph);
        this.resourceFiles = builder.getGatherer().getResourceFiles();
        return pipelineDef;
    }
}

