/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.pipeline;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.VisualSQLRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.split.SplitRecipeHelper;
import com.dataiku.dip.dataflow.exec.split.SplitRecipeHelperBuilder;
import com.dataiku.dip.dataflow.exec.split.SplitRecipeJobDefBuilder;
import com.dataiku.dip.dataflow.exec.split.SplitRecipePayloadParams;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelper;
import com.dataiku.dip.dataflow.pipeline.SparkPipelineDef;
import com.dataiku.dip.dataflow.pipeline.SqlPipelineElement;
import com.dataiku.dip.dataflow.pipeline.VisualSqlRecipePipelineHelper;
import com.dataiku.dip.dataflow.utils.FakeJobActivityBuilder;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.SplitRecipeService;
import com.dataiku.dip.shaker.resources.ResourcesGatherer;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SparkSQLDialect;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class SplitRecipePipelineHelper
extends VisualSqlRecipePipelineHelper {
    @Autowired
    protected SplitRecipeService service;
    private SplitRecipePayloadParams params;

    public SplitRecipePipelineHelper(AuthCtx authCtx, SerializedRecipe recipe, String payload, RecipePipelineHelper.PipelineType pipelineType, JobActivity jobActivity) {
        super(authCtx, recipe, payload, pipelineType, jobActivity);
    }

    @Override
    protected void parseParams() {
        this.params = this.service.loadParams(this.payload, this.recipe);
        this.engineParams = this.params.engineParams;
    }

    @Override
    protected void finalizeElt(SparkPipelineDef.SparkPipelineElt elt, JobActivity activity, SparkSQLDialect dialect, ResourcesGatherer gatherer) throws Exception {
        elt.split = new SplitRecipeJobDefBuilder(activity, this.params, this.buildSplitReciplePipelineHelper(activity, dialect)).build(this.sparkSqlParams);
    }

    @Override
    List<SqlPipelineElement> generateSqlQueries(JobActivity activity, SQLDialect dialect) throws Exception {
        ArrayList<SqlPipelineElement> result = new ArrayList<SqlPipelineElement>();
        Map<String, String> queriesByTargetId = this.buildSplitReciplePipelineHelper(activity, dialect).generateSqlForAllSplits(dialect);
        for (Map.Entry<String, String> entry : queriesByTargetId.entrySet()) {
            result.add(new SqlPipelineElement(FakeJobActivityBuilder.fakeJobActivity(activity).build(entry.getKey()), entry.getValue()));
        }
        return result;
    }

    @Override
    protected boolean isValidConfiguration() {
        return super.isValidConfiguration() && this.params.mode != SplitRecipePayloadParams.Mode.CENTILE && (this.pipelineType == RecipePipelineHelper.PipelineType.SPARK || this.params.mode != SplitRecipePayloadParams.Mode.RANDOM);
    }

    @Override
    VisualSQLRecipePayloadParams getParams() {
        return this.params;
    }

    private SplitRecipeHelper buildSplitReciplePipelineHelper(JobActivity activity, SQLDialect dialect) throws IOException {
        return new SplitRecipeHelperBuilder(activity, this.params, false, dialect).build();
    }
}

