/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datalayer.memimpl.MemTableAppendingOutput;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.SchemaDetection;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopConfig;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.iceberg.IcebergDatasetHandler;
import com.dataiku.dip.datasets.iceberg.IcebergDatasetParams;
import com.dataiku.dip.datasets.inline.InlineDatasetConfig;
import com.dataiku.dip.datasets.jobsdb.JobsdbDatasetParams;
import com.dataiku.dip.datasets.sample.SampleDatasetParams;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.datasets.statsdb.StatsDBDatasetParams;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.row.RowOrientedDatasetHandler;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipeEngineParams;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.shaker.services.TypeInferrer2;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.SparkSQLDialect;
import com.dataiku.dip.sql.TrinoSQLDialect;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class DatasetUtils {
    public static Pattern DATASET_NAME_UNAUTHORIZED_CHARACTERS_PATTERN = Pattern.compile("[^\\w-]");

    private DatasetUtils() {
    }

    public static boolean isInQueryMode(Dataset dataset) {
        DatasetHandler.DatasetParams params = dataset.getParams();
        if (params instanceof AbstractSQLDatasetHandler.AbstractSQLConfig) {
            AbstractSQLDatasetHandler.AbstractSQLConfig config = (AbstractSQLDatasetHandler.AbstractSQLConfig)params;
            return "query".equals(config.mode);
        }
        return false;
    }

    public static boolean isReadOnlySQL(Dataset dataset) {
        return DatasetUtils.isInQueryMode(dataset) || DatasetUtils.isReadOnlySQLType(dataset);
    }

    public static boolean isReadOnlySQLType(Dataset dataset) {
        String sqlType = dataset.getType();
        return BuiltinSQLDatasets.ATHENA_META.getType().equals(sqlType);
    }

    public static boolean isReadOnly(Dataset dataset) {
        DatasetHandler.DatasetParams params = dataset.getParams();
        if (params instanceof JobsdbDatasetParams) {
            return true;
        }
        if (params instanceof StatsDBDatasetParams) {
            return true;
        }
        if (params instanceof BuiltinFSDatasets.FilesInFolderConfig) {
            return true;
        }
        if (params instanceof InlineDatasetConfig) {
            return true;
        }
        if (params instanceof SampleDatasetParams) {
            return true;
        }
        return DatasetUtils.isReadOnlySQL(dataset);
    }

    public static String getTableName(Dataset dataset) {
        DatasetHandler.DatasetParams params = dataset.getParams();
        if (params instanceof AbstractSQLDatasetHandler.AbstractSQLConfig) {
            AbstractSQLDatasetHandler.AbstractSQLConfig config = (AbstractSQLDatasetHandler.AbstractSQLConfig)params;
            return config.table;
        }
        return dataset.getName();
    }

    public static SQLUtils.SQLTable getResolvedTableWithSparkSQLFallback(Dataset dataset, SQLDialect dialect, VisualSQLRecipeEngineParams engineParams) throws IOException {
        boolean canAddHiveDatabase = dialect == null || !(dialect instanceof SparkSQLDialect) || engineParams != null && engineParams.sparkSQL.useGlobalMetastore;
        return DatasetUtils.getResolvedTable(dataset, dialect, canAddHiveDatabase, true);
    }

    private static boolean needResolvedNameForSqlTable(Dataset dataset, SQLDialect dialect) {
        return DatasetInspector.isSQLOrHiveTable(dataset) && !(dialect instanceof SparkSQLDialect);
    }

    public static SQLUtils.SQLTable getResolvedTable(SerializedDataset dataset, SQLDialect dialect, boolean canAddHiveDatabase, boolean canFallback) throws IOException {
        return DatasetUtils.getResolvedTable(Dataset.fromSerialized(dataset), dialect, canAddHiveDatabase, canFallback);
    }

    public static SQLUtils.SQLTable getResolvedTable(Dataset dataset, SQLDialect dialect, boolean canAddHiveDatabase, boolean canFallback) throws IOException {
        DatasetHandler.DatasetParams params = dataset.getParams();
        if (DatasetInspector.isHDFSDatasetWithAssociatedHiveTableOrIsHiveTableDataset(dataset) || DatasetInspector.hasAssociatedMetastoreTable(dataset)) {
            SQLUtils.SQLTable tableRef = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(dataset);
            String schema = canAddHiveDatabase ? tableRef.getSchemaNullIfBlank() : null;
            return new SQLUtils.SQLTable(null, schema, tableRef.getTable(), true);
        }
        if (params instanceof AbstractSQLDatasetHandler.AbstractSQLConfig) {
            if (DatasetUtils.needResolvedNameForSqlTable(dataset, dialect)) {
                try (AbstractSQLTableDatasetHandler stdh = (AbstractSQLTableDatasetHandler)DatasetHandlerFactory.build(DSSAuthCtx.newNone(), dataset);){
                    SQLUtils.SQLTable sQLTable = stdh.getResolvedTable();
                    return sQLTable;
                }
            }
            if (canFallback) {
                return new SQLUtils.SQLTable(null, null, dataset.getName(), false);
            }
            throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "No table specified in dataset " + dataset.getFullName());
        }
        if (params instanceof IcebergDatasetParams && dialect instanceof TrinoSQLDialect) {
            IcebergDatasetHandler dh = (IcebergDatasetHandler)DatasetHandlerFactory.build(DSSAuthCtx.newNone(), dataset);
            try {
                SQLUtils.SQLTable sQLTable = dh.getResolvedSQLTable();
                if (dh != null) {
                    dh.close();
                }
                return sQLTable;
            }
            catch (Throwable throwable) {
                try {
                    if (dh != null) {
                        try {
                            dh.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    if (canFallback) {
                        return new SQLUtils.SQLTable(null, null, dataset.getName(), false);
                    }
                    throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "No catalog specified in connection of dataset " + dataset.getFullName());
                }
            }
        }
        if (canFallback) {
            return new SQLUtils.SQLTable(null, null, dataset.getName(), false);
        }
        throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "No table specified in dataset " + dataset.getFullName());
    }

    public static SQLUtils.SQLTable getUnresolvedTable(SerializedDataset dataset, SQLDialect dialect, boolean canAddHiveDatabase, boolean canFallback) throws IOException {
        return DatasetUtils.getUnresolvedTable(Dataset.fromSerialized(dataset), dialect, canAddHiveDatabase, canFallback);
    }

    public static SQLUtils.SQLTable getUnresolvedTable(Dataset dataset, SQLDialect dialect, boolean canAddHiveDatabase, boolean canFallback) throws IOException {
        DatasetHandler.DatasetParams params = dataset.getParams();
        if (DatasetInspector.isHDFSDatasetWithAssociatedHiveTableOrIsHiveTableDataset(dataset) || DatasetInspector.hasAssociatedMetastoreTable(dataset)) {
            SQLUtils.SQLTable tableRef = HiveSchemaHandler.getUnresolvedHiveTableRefFromDataset(dataset);
            String schema = canAddHiveDatabase ? tableRef.getSchemaNullIfBlank() : null;
            return new SQLUtils.SQLTable(null, schema, tableRef.getTable(), true);
        }
        if (params instanceof AbstractSQLDatasetHandler.AbstractSQLConfig) {
            if (DatasetUtils.needResolvedNameForSqlTable(dataset, dialect)) {
                try (AbstractSQLTableDatasetHandler stdh = (AbstractSQLTableDatasetHandler)DatasetHandlerFactory.build(DSSAuthCtx.newNone(), dataset);){
                    SQLUtils.SQLTable sQLTable = stdh.getUnresolvedTable();
                    return sQLTable;
                }
            }
            if (canFallback) {
                return new SQLUtils.SQLTable(null, null, dataset.getName(), false);
            }
            throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "No table specified in dataset " + dataset.getFullName());
        }
        if (canFallback) {
            return new SQLUtils.SQLTable(null, null, dataset.getName(), false);
        }
        throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "No table specified in dataset " + dataset.getFullName());
    }

    public static Pair<SchemaDetection.SchemaDetectionResult, MemTable> simpleDetectSchema(AuthCtx authCtx, Dataset dataset, boolean forConsistencyCheck) throws Exception {
        return DatasetUtils.simpleDetectSchema(authCtx, dataset, forConsistencyCheck, null);
    }

    public static Pair<SchemaDetection.SchemaDetectionResult, MemTable> simpleDetectSchema(AuthCtx authCtx, Dataset dataset, boolean forConsistencyCheck, @Nullable Schema definedSchema) throws Exception {
        Schema datasetSchema = dataset.getSchema();
        dataset.setSchema(null);
        MemTable mt = new MemTable();
        try (DatasetHandler dh = DatasetHandlerFactory.build(authCtx, dataset);){
            RowsInputSplit split = ((RowOrientedDatasetHandler)dh).getSampleSplit();
            if (split != null) {
                MemTableAppendingOutput out = new MemTableAppendingOutput(mt);
                split.push((ProcessorOutput)out, mt, mt, new ExtractionLimit(100L), null, new WarningsContext());
                out.lastRowEmitted();
            }
        }
        new TypeInferrer2().processFullAuto(null, mt);
        Schema querySchema = definedSchema;
        if (querySchema == null) {
            querySchema = new Schema();
            for (MemColumn mc : mt.columnsList) {
                querySchema.getColumns().add(new SchemaColumn(mc.getName(), Type.STRING));
            }
        }
        SchemaDetection.Mode detectionMode = null;
        if (forConsistencyCheck) {
            detectionMode = SchemaDetection.Mode.CONSISTENCY_CHECK;
        } else {
            boolean currentSchemaIsImportant = datasetSchema != null && datasetSchema.userModified || dataset.isManaged();
            detectionMode = currentSchemaIsImportant ? SchemaDetection.Mode.DETECTION_PREFER_USER_AND_WARN : SchemaDetection.Mode.DETECTION_PREFER_DATA;
        }
        return new Pair((Object)SchemaDetection.handleDetectionResult(SchemaDetection.SchemaHandlingType.NAME_BASED_VARIABLE_COLUMNS, datasetSchema, detectionMode, querySchema), (Object)mt);
    }

    public static Pair<SchemaDetection.SchemaDetectionResult, MemTable> detectSchemaWithStorageTypeInference(AuthCtx authCtx, Dataset dataset, boolean forConsistencyCheck) throws Exception {
        Schema datasetSchema = dataset.getSchema();
        dataset.setSchema(null);
        MemTable mt = new MemTable();
        try (DatasetHandler dh = DatasetHandlerFactory.build(authCtx, dataset);){
            RowsInputSplit split = ((RowOrientedDatasetHandler)dh).getSampleSplit();
            if (split != null) {
                MemTableAppendingOutput out = new MemTableAppendingOutput(mt);
                split.push((ProcessorOutput)out, mt, mt, new ExtractionLimit(100L), null, new WarningsContext());
                out.lastRowEmitted();
            }
        }
        new TypeInferrer2().processFullAuto(null, mt);
        Schema detectedSchema = SchemaDetection.buildDetectedSchemaWithStorageTypesInference(mt);
        SchemaDetection.Mode detectionMode = null;
        if (forConsistencyCheck) {
            detectionMode = SchemaDetection.Mode.CONSISTENCY_CHECK;
        } else {
            boolean currentSchemaIsImportant = datasetSchema != null && datasetSchema.userModified || dataset.isManaged();
            detectionMode = currentSchemaIsImportant ? SchemaDetection.Mode.DETECTION_ONLY_TYPES : SchemaDetection.Mode.DETECTION_PREFER_DATA;
        }
        return new Pair((Object)SchemaDetection.handleDetectionResult(SchemaDetection.SchemaHandlingType.NAME_BASED_VARIABLE_COLUMNS, datasetSchema, detectionMode, detectedSchema), (Object)mt);
    }

    public static void performWriteOfZeroRows(DatasetHandler dh, Partition partition, WarningsContext wc, Output.WriteMode wm) throws Exception {
        StreamColumnFactory scf = new StreamColumnFactory();
        Output output = dh.buildOutput(partition, 0, 1, wc);
        OutputWriter writer = output.getWriter(wm);
        writer.init((ColumnFactory)scf);
        writer.lastRowEmitted();
    }

    public static void checkName(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_NAME, "Dataset name cannot be empty.");
        }
        if (DATASET_NAME_UNAUTHORIZED_CHARACTERS_PATTERN.matcher(name).find()) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_NAME, "Invalid dataset name, allowed characters are a-z, A-Z, 0-9, '_' and '-' but name was: '" + name + "'.");
        }
    }

    public static VariablesExpansionLoopConfig getDatasetVeLoopConfig(DatasetHandler.DatasetParams datasetParams) {
        if (datasetParams instanceof AbstractFSDatasetHandler.AbstractFSConfig) {
            return ((AbstractFSDatasetHandler.AbstractFSConfig)datasetParams).variablesExpansionLoopConfig;
        }
        if (datasetParams instanceof AbstractSQLDatasetHandler.AbstractSQLConfig) {
            return ((AbstractSQLDatasetHandler.AbstractSQLConfig)datasetParams).variablesExpansionLoopConfig;
        }
        return null;
    }
}

