/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.fs.FSEnumerationResult;
import com.dataiku.dip.fs.FSPath;
import java.util.List;
import java.util.Objects;

public class AbstractFSEnumerationResult
implements FSEnumerationResult {
    protected final List<FSPath> paths;
    protected final Throwable error;
    protected final boolean successful;
    protected final boolean prefixDoesntExists;

    public AbstractFSEnumerationResult() {
        this.paths = null;
        this.error = null;
        this.successful = true;
        this.prefixDoesntExists = true;
    }

    public AbstractFSEnumerationResult(List<FSPath> paths) {
        this.paths = paths;
        this.error = null;
        this.successful = true;
        this.prefixDoesntExists = false;
    }

    public AbstractFSEnumerationResult(Throwable error) {
        this.error = error;
        this.paths = null;
        this.successful = false;
        this.prefixDoesntExists = false;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public boolean enumerationPrefixExists() {
        return !this.prefixDoesntExists;
    }

    public Throwable getError() {
        return this.error;
    }

    public Iterable<FSPath> getPaths() {
        return this.paths;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractFSEnumerationResult that = (AbstractFSEnumerationResult)o;
        return this.successful == that.successful && this.prefixDoesntExists == that.prefixDoesntExists && Objects.equals(this.paths, that.paths) && Objects.equals(this.error, that.error);
    }

    public int hashCode() {
        return Objects.hash(this.paths, this.error, this.successful, this.prefixDoesntExists);
    }
}

