/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.iceberg;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.iceberg.IcebergDatasetHandler;
import com.dataiku.dip.datasets.iceberg.IcebergOutputWriter;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.org.apache.iceberg.Table;
import com.google.common.collect.Lists;
import java.io.IOException;

public class IcebergOutput
implements Output {
    private final IcebergDatasetHandler datasetHandler;
    private final Dataset dataset;
    private final int targetSplit;
    private final int resplitFactor;
    private final Partition targetPartition;
    private final WarningsContext warningsContext;

    public IcebergOutput(IcebergDatasetHandler datasetHandler, Dataset dataset, int targetSplit, int resplitFactor, Partition targetPartition, WarningsContext warningsContext) {
        this.datasetHandler = datasetHandler;
        this.dataset = dataset;
        this.targetSplit = targetSplit;
        this.resplitFactor = resplitFactor <= 0 ? 1 : resplitFactor;
        this.targetPartition = targetPartition;
        this.warningsContext = warningsContext;
    }

    public OutputWriter getWriter(Output.WriteMode writeMode) throws IOException, DKUSecurityException, InterruptedException, CodedException {
        Table table = this.datasetHandler.loadTableCreateIfNeeded(writeMode, this.targetPartition);
        if (writeMode == Output.WriteMode.OVERWRITE) {
            this.datasetHandler.clearPartitions(Lists.newArrayList((Object[])new Partition[]{this.targetPartition}));
        }
        return new IcebergOutputWriter(table, this.targetSplit, this.targetPartition, this.datasetHandler.getIcebergActionRunner());
    }
}

