/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.streamwrite;

import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.streamwrite.TargetPartitionComputer;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.partitioning.PartitioningUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class CurrentTimestampTargetPartitionComputer
implements TargetPartitionComputer {
    public static NowProvider nowProvider = System::currentTimeMillis;
    private final PartitioningScheme partitioningScheme;
    private SimpleDateFormat yyyy_local = new SimpleDateFormat("yyyy");
    private SimpleDateFormat yyyymm_local = new SimpleDateFormat("yyyy-MM");
    private SimpleDateFormat yyyymmdd_local = new SimpleDateFormat("yyyy-MM-dd");
    private SimpleDateFormat yyyymmddhh_local = new SimpleDateFormat("yyyy-MM-dd-HH");

    public CurrentTimestampTargetPartitionComputer(PartitioningScheme partitioningScheme, ComputationTimezone tz) {
        this.partitioningScheme = partitioningScheme;
        assert (partitioningScheme.isPartitioned());
        assert (PartitioningUtils.isSingleTimeDimension(partitioningScheme));
        switch (tz) {
            case UTC: {
                this.yyyy_local.setTimeZone(TimeZone.getTimeZone("UTC"));
                this.yyyymm_local.setTimeZone(TimeZone.getTimeZone("UTC"));
                this.yyyymmdd_local.setTimeZone(TimeZone.getTimeZone("UTC"));
                this.yyyymmddhh_local.setTimeZone(TimeZone.getTimeZone("UTC"));
                break;
            }
            case LOCAL: {
                this.yyyy_local.setTimeZone(TimeZone.getDefault());
                this.yyyymm_local.setTimeZone(TimeZone.getDefault());
                this.yyyymmdd_local.setTimeZone(TimeZone.getDefault());
                this.yyyymmddhh_local.setTimeZone(TimeZone.getDefault());
            }
        }
    }

    @Override
    public String compute(Row row) {
        long now = nowProvider.now();
        switch (this.partitioningScheme.getSingleTimeDimension().mappedPeriod) {
            case YEAR: {
                return this.yyyy_local.format(new Date(now));
            }
            case MONTH: {
                return this.yyyymm_local.format(new Date(now));
            }
            case DAY: {
                return this.yyyymmdd_local.format(new Date(now));
            }
            case HOUR: {
                return this.yyyymmddhh_local.format(new Date(now));
            }
        }
        throw new Error("unreachable");
    }

    public static enum ComputationTimezone {
        UTC,
        LOCAL;

    }

    public static interface NowProvider {
        public long now();
    }
}

