/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.datamodel.actual.azureml.comparator;

import com.dataiku.dip.deployer.apideployer.datamodel.actual.azureml.comparator.AzureMLResourceComparator;
import com.dataiku.dip.deployer.common.datamodel.actual.DeploymentResourceComparator;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLOnlineEndpoint;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLResource;
import com.dataiku.dip.utils.ErrorContext;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class AzureMLOnlineEndpointComparator
extends AzureMLResourceComparator<AzureMLOnlineEndpoint> {
    public AzureMLOnlineEndpointComparator(@Nonnull AzureMLOnlineEndpoint onlineEndpoint) {
        super(onlineEndpoint);
    }

    private String mapAuthMode(String authMode) {
        if ("key".equals(authMode)) {
            return "Key";
        }
        if ("aml_token".equals(authMode)) {
            return "AMLToken";
        }
        return authMode;
    }

    @Override
    public Set<String> reportOutOfSyncFields(@Nonnull AzureMLResource deployedResource) {
        Set<String> outOfSyncFields = super.reportOutOfSyncFields(deployedResource);
        if (!(deployedResource instanceof AzureMLOnlineEndpoint)) {
            throw ErrorContext.iae((String)"Incompatible resource types to compare.");
        }
        AzureMLOnlineEndpoint deployedOnlineEndpoint = (AzureMLOnlineEndpoint)deployedResource;
        if (!StringUtils.equals((CharSequence)this.mapAuthMode(deployedOnlineEndpoint.authMode), (CharSequence)this.mapAuthMode(((AzureMLOnlineEndpoint)this.getResource()).authMode))) {
            outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Endpoint Authentication Mode", deployedOnlineEndpoint.authMode, ((AzureMLOnlineEndpoint)this.getResource()).authMode));
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)deployedOnlineEndpoint.publicNetworkAccess, (CharSequence)((AzureMLOnlineEndpoint)this.getResource()).publicNetworkAccess)) {
            outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Public inbound network access", deployedOnlineEndpoint.publicNetworkAccess, ((AzureMLOnlineEndpoint)this.getResource()).publicNetworkAccess));
        }
        return outOfSyncFields;
    }
}

