/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.datamodel.config;

import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIDockerDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIServiceDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIServiceDockerDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractFullyManagedAPIDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.SnowparkAPIDeploymentInfra;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractDeploymentBasicInfo;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeployment;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.StringTransmogrifier;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class SnowparkAPIDeployment
extends AbstractFullyManagedAPIDeployment {
    @Nonnull
    public SnowparkAPIDeploymentOverrideMask overrideSettings = new SnowparkAPIDeploymentOverrideMask();
    @Nullable
    private String customServiceName;
    @Nullable
    private String customUdfName;
    @Nullable
    private String eventTableLogLevel;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployment.datamodel.config");

    @Nullable
    public String getCustomServiceName(SnowparkAPIDeploymentInfra infra) {
        if (infra.allowOverrideResourcesNames) {
            return this.customServiceName;
        }
        return null;
    }

    @Nullable
    public String getCustomUdfName(SnowparkAPIDeploymentInfra infra) {
        if (infra.allowOverrideResourcesNames) {
            return this.customUdfName;
        }
        return null;
    }

    @Nullable
    public String getEventTableLogLevel(SnowparkAPIDeploymentInfra infra) {
        if (this.overrideSettings.apiNodeLogging) {
            return this.eventTableLogLevel;
        }
        return infra.eventTableLogLevel;
    }

    public SnowparkAPIDeployment() {
    }

    protected SnowparkAPIDeployment(String id, SnowparkAPIDeploymentInfra infra, String publishedServiceId, String version, String endpointId, boolean enabled, VersionTag creationTag) {
        super(id, infra.id, publishedServiceId, version, enabled, creationTag, endpointId);
    }

    protected SnowparkAPIDeployment(AbstractAPIServiceDeployment existingDeployment, List<SnowparkAPIDeployment> otherDeployments, String deploymentId, SnowparkAPIDeploymentInfra infra, @Nullable String endpointId, boolean enabled, VersionTag creationTag) {
        super(existingDeployment, deploymentId, infra.id, enabled, creationTag, endpointId);
        if (existingDeployment instanceof SnowparkAPIDeployment) {
            StringTransmogrifier transmogrifier;
            SnowparkAPIDeployment snowparkExistingDeployment = (SnowparkAPIDeployment)existingDeployment;
            if (snowparkExistingDeployment.customServiceName != null) {
                transmogrifier = new StringTransmogrifier("_", 0, Integer.valueOf(63), true, false);
                for (SnowparkAPIDeployment otherDeployment : otherDeployments) {
                    transmogrifier.addAlreadyTransmogrifiedAcceptDupes(otherDeployment.customServiceName);
                }
                this.customServiceName = transmogrifier.transmogrify(snowparkExistingDeployment.customServiceName);
            }
            if (snowparkExistingDeployment.customUdfName != null) {
                transmogrifier = new StringTransmogrifier("_", 0, Integer.valueOf(63), true, false);
                for (SnowparkAPIDeployment otherDeployment : otherDeployments) {
                    transmogrifier.addAlreadyTransmogrifiedAcceptDupes(otherDeployment.customUdfName);
                }
                this.customUdfName = transmogrifier.transmogrify(snowparkExistingDeployment.customUdfName);
            }
        }
    }

    @Override
    public AbstractDeploymentBasicInfo.SnowparkDeploymentBasicInfo basicInfoUnsafe() {
        AbstractDeploymentBasicInfo.SnowparkDeploymentBasicInfo deploymentBasicInfo = new AbstractDeploymentBasicInfo.SnowparkDeploymentBasicInfo();
        deploymentBasicInfo.id = this.id;
        deploymentBasicInfo.enabled = this.enabled;
        deploymentBasicInfo.publishedServiceId = this.publishedServiceId;
        deploymentBasicInfo.deployedServiceId = this.deployedServiceId;
        deploymentBasicInfo.infraId = this.infraId;
        deploymentBasicInfo.generationsMapping = this.generationsMapping;
        deploymentBasicInfo.tags = this.tags;
        deploymentBasicInfo.creationTag = this.creationTag;
        deploymentBasicInfo.versionTag = this.versionTag;
        deploymentBasicInfo.deploymentTag = this.deploymentTag;
        deploymentBasicInfo.endpointId = this.endpointId;
        return deploymentBasicInfo;
    }

    @Override
    @Nonnull
    public SnowparkAPIDeploymentOverrideMask getOverrideSettings() {
        return this.overrideSettings;
    }

    @Override
    public void verifyFields(AbstractDeploymentInfra infra, AbstractDeployment oldDeployment, boolean isDeployed) {
        super.verifyFields(infra, oldDeployment, isDeployed);
        if (oldDeployment instanceof SnowparkAPIDeployment && infra instanceof SnowparkAPIDeploymentInfra) {
            SnowparkAPIDeploymentInfra snowparkDeploymentInfra = (SnowparkAPIDeploymentInfra)infra;
            SnowparkAPIDeployment snowparkOldDeployment = (SnowparkAPIDeployment)oldDeployment;
            if (isDeployed) {
                SnowparkAPIDeployment.verifyImmutableField(snowparkOldDeployment.getCustomServiceName(snowparkDeploymentInfra), this.getCustomServiceName(snowparkDeploymentInfra), "Custom service name");
                SnowparkAPIDeployment.verifyImmutableField(snowparkOldDeployment.getCustomUdfName(snowparkDeploymentInfra), this.getCustomUdfName(snowparkDeploymentInfra), "Custom UDF name");
            }
        } else {
            throw ErrorContext.iaef((String)"Old deployment with id %s is not a Snowpark deployment.", (Object)oldDeployment.id, (Object[])new Object[0]);
        }
    }

    @Override
    public String getLog4jConfiguration(AbstractAPIDockerDeploymentInfra infra) {
        Object log4jConfiguration = (String)StringUtils.defaultIfBlank((CharSequence)super.getLog4jConfiguration(infra), (CharSequence)"");
        if (this.getNodeLogging((AbstractAPIDeploymentInfra)infra).auditLog.logQueries) {
            logger.info((Object)"Adding logging of audit logs to the console in order to log predictions to the event table");
            log4jConfiguration = (String)log4jConfiguration + "\nlog4j.additivity.dku.audit=true";
            log4jConfiguration = (String)log4jConfiguration + "\nlog4j.logger.dku.audit=INFO";
        }
        return log4jConfiguration;
    }

    public static class SnowparkAPIDeploymentOverrideMask
    extends AbstractAPIServiceDockerDeployment.APIServiceDockerDeploymentOverrideMask {
        public void applyToDeployment(SnowparkAPIDeployment target, SnowparkAPIDeploymentInfra source) {
            super.applyToDeployment(target, source);
            if (!this.apiNodeLogging) {
                target.eventTableLogLevel = (String)JSON.deepCopy((Object)source.eventTableLogLevel);
            }
        }
    }
}

