/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.deployments;

import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIDockerDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIServiceDockerDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AzureMLAPIDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AzureMLAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.DatabricksAPIDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.DatabricksAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.K8SAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.K8SAPIServiceDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.SageMakerAPIDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.SageMakerAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.SnowparkAPIDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.SnowparkAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.VertexAIAPIDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.VertexAIAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.deployments.APIServiceDeploymentHelper;
import com.dataiku.dip.deployer.apideployer.deployments.AzureMLDeploymentConfigManager;
import com.dataiku.dip.deployer.apideployer.deployments.DatabricksDeploymentConfigManager;
import com.dataiku.dip.deployer.apideployer.deployments.K8SDeploymentConfigManager;
import com.dataiku.dip.deployer.apideployer.deployments.SageMakerDeploymentConfigManager;
import com.dataiku.dip.deployer.apideployer.deployments.SnowparkDeploymentConfigManager;
import com.dataiku.dip.deployer.apideployer.deployments.VertexAIDeploymentConfigManager;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.variables.VariablesContext;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractAPIServiceDockerDeploymentConfigManager {
    protected abstract AbstractAPIServiceDockerDeployment getDeployment();

    protected abstract AbstractAPIDockerDeploymentInfra getInfra();

    public abstract String getImageName() throws IllegalConfigurationException;

    public abstract String generateImageVersion() throws IllegalConfigurationException;

    public String getCodeEnvImageName() {
        String baseImagePart = StringUtils.isBlank((String)this.getInfra().baseImageTag) ? "" : "-" + this.getInfra().baseImageTag;
        baseImagePart = baseImagePart.replace(":", "-");
        return (String)(StringUtils.isBlank((String)this.getInfra().imagesNamePrefix) ? "" : this.getInfra().imagesNamePrefix + "/") + "apicodeenv" + baseImagePart + "-" + APIServiceDeploymentHelper.getSanitizedDSSVersionForImages().replace(".", "_");
    }

    public static AbstractAPIServiceDockerDeploymentConfigManager getConfigManager(@Nonnull AbstractAPIDockerDeploymentInfra infra, @Nonnull AbstractAPIServiceDockerDeployment deployment, @Nullable VariablesContext vc) {
        if (infra instanceof SageMakerAPIDeploymentInfra && deployment instanceof SageMakerAPIDeployment) {
            return new SageMakerDeploymentConfigManager((SageMakerAPIDeployment)deployment, (SageMakerAPIDeploymentInfra)infra, vc);
        }
        if (infra instanceof AzureMLAPIDeploymentInfra && deployment instanceof AzureMLAPIDeployment) {
            return new AzureMLDeploymentConfigManager((AzureMLAPIDeployment)deployment, (AzureMLAPIDeploymentInfra)infra, vc);
        }
        if (infra instanceof DatabricksAPIDeploymentInfra && deployment instanceof DatabricksAPIDeployment) {
            return new DatabricksDeploymentConfigManager((DatabricksAPIDeployment)deployment, (DatabricksAPIDeploymentInfra)infra, vc);
        }
        if (infra instanceof VertexAIAPIDeploymentInfra && deployment instanceof VertexAIAPIDeployment) {
            return new VertexAIDeploymentConfigManager((VertexAIAPIDeployment)deployment, (VertexAIAPIDeploymentInfra)infra, vc);
        }
        if (infra instanceof SnowparkAPIDeploymentInfra && deployment instanceof SnowparkAPIDeployment) {
            return new SnowparkDeploymentConfigManager((SnowparkAPIDeployment)deployment, (SnowparkAPIDeploymentInfra)infra, vc);
        }
        if (infra instanceof K8SAPIDeploymentInfra && deployment instanceof K8SAPIServiceDeployment) {
            return new K8SDeploymentConfigManager((K8SAPIServiceDeployment)deployment, (K8SAPIDeploymentInfra)infra);
        }
        throw new IllegalArgumentException("Unsupported type combination: " + infra.getClass().getCanonicalName() + " and " + deployment.getClass().getCanonicalName());
    }
}

