/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.infra;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.SnowflakeConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.deployer.apideployer.datamodel.config.SnowparkAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.infra.ApiNodeInfraManager;
import com.dataiku.dip.deployer.apideployer.monitoring.ActivityMetric;
import com.dataiku.dip.deployer.common.DeployerCodes;
import com.dataiku.dip.deployer.common.DeployerUtils;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.ICodedException;
import com.dataiku.dip.externalinfras.ExternalInfrasUtils;
import com.dataiku.dip.externalinfras.snowpark.SnowparkUtils;
import com.dataiku.dip.externalinfras.snowpark.datamodel.SnowparkComputePool;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.sql.SQLException;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class SnowparkInfraManager
implements ApiNodeInfraManager {
    private final SnowparkAPIDeploymentInfra infra;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.infra.snowpark.manager");

    public SnowparkInfraManager(SnowparkAPIDeploymentInfra infra) {
        this.infra = infra;
    }

    @Override
    public InfoMessage.InfoMessages checkInfraStatus_NT(AuthCtx authCtx) {
        try {
            return this.getStatusMessages(authCtx);
        }
        catch (Exception e) {
            InfoMessage.MessageCode code = null;
            if (e instanceof ICodedException) {
                code = ((ICodedException)e).getCode();
            }
            if (code == null) {
                code = DeployerCodes.ERR_API_DEPLOYER_SNOWPARK_ERROR;
            }
            String errorMessage = "Snowpark request failed with error: " + String.valueOf(e);
            InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
            messages.withFatal(code, errorMessage);
            logger.error((Object)errorMessage);
            return messages;
        }
    }

    @Nonnull
    private InfoMessage.InfoMessages getStatusMessages(AuthCtx authCtx) throws DKUSecurityException, IOException, SQLException, InterruptedException {
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        SnowflakeConnection connection = (SnowflakeConnection)ExternalInfrasUtils.getAndCheckConnection(authCtx, this.infra.authConnection);
        if (connection == null) {
            messages.withError((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_SNOWPARK_INVALID_CONNECTION, "No connection defined in the infrastructure.");
            return messages;
        }
        SnowflakeConnection.Params params = connection.getParams();
        boolean isMissingDatabase = StringUtils.isBlank((String)params.db) && StringUtils.isBlank((String)this.infra.databaseName);
        boolean isMissingSchema = StringUtils.isBlank((String)params.defaultSchema) && StringUtils.isBlank((String)this.infra.schemaName);
        boolean isMissingRole = StringUtils.isBlank((String)params.role) && StringUtils.isBlank((String)this.infra.roleName);
        boolean isMissingWarehouse = StringUtils.isBlank((String)params.warehouse) && StringUtils.isBlank((String)this.infra.warehouseName);
        boolean isMissingComputePool = StringUtils.isBlank((String)this.infra.computePoolName);
        if (isMissingDatabase) {
            messages.withError((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_SNOWPARK_MISSING_DATABASE, "Database should be defined in the connection or in the infrastructure.");
            return messages;
        }
        if (isMissingSchema) {
            messages.withError((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_SNOWPARK_MISSING_SCHEMA, "Schema should be defined in the connection or in the infrastructure.");
            return messages;
        }
        if (isMissingRole) {
            messages.withError((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_SNOWPARK_MISSING_ROLE, "Role should be defined in the connection or in the infrastructure.");
            return messages;
        }
        if (isMissingWarehouse) {
            messages.withError((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_SNOWPARK_MISSING_WAREHOUSE, "Warehouse should be defined in the connection or in the infrastructure.");
            return messages;
        }
        if (isMissingComputePool) {
            messages.withError((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_SNOWPARK_MISSING_COMPUTE_POOL, "Compute pool should be defined in the infrastructure.");
            return messages;
        }
        try (SQLConnectionProvider.SQLConnectionWrapper wrapper = SnowparkUtils.createSQLWrapper_NT(connection, authCtx, this.infra, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());){
            if (StringUtils.isBlank((String)SnowparkUtils.getCurrentDatabase(wrapper))) {
                messages.withError((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_SNOWPARK_INVALID_DATABASE, "You can update the database in the connection or in the infrastructure.");
                InfoMessage.InfoMessages infoMessages = messages;
                return infoMessages;
            }
            if (StringUtils.isBlank((String)SnowparkUtils.getCurrentSchema(wrapper))) {
                messages.withError((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_SNOWPARK_INVALID_SCHEMA, "You can update the schema in the connection or in the infrastructure.");
                InfoMessage.InfoMessages infoMessages = messages;
                return infoMessages;
            }
            if (StringUtils.isBlank((String)SnowparkUtils.getCurrentWarehouse(wrapper))) {
                messages.withError((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_SNOWPARK_INVALID_WAREHOUSE, "You can update the warehouse in the connection or in the infrastructure.");
                InfoMessage.InfoMessages infoMessages = messages;
                return infoMessages;
            }
            SnowparkComputePool computePool = SnowparkUtils.getComputePool_NT(wrapper, this.infra.computePoolName);
            if (computePool == null) {
                messages.withErrorV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_SNOWPARK_COMPUTE_POOL_NOT_FOUND, "Compute pool '%s' does not exist or not authorized.", new Object[]{this.infra.computePoolName});
            } else if (!computePool.name.equals(this.infra.computePoolName)) {
                String errorMessage = String.format("Compute pool in infrastructure settings is named '%s' but its name in Snowflake is '%s'. Update your settings to match exactly the Snowflake name, including the case.", this.infra.computePoolName, computePool.name);
                throw new CodedSQLException(DeployerCodes.ERR_API_DEPLOYER_SNOWPARK_COMPUTE_POOL_NOT_FOUND, errorMessage);
            }
            String imageRepositoryURL = this.infra.getImageRepositoryURL();
            if (!SnowparkUtils.isImageRepositoryAccessible_NT(wrapper, imageRepositoryURL)) {
                messages.withErrorV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_SNOWPARK_IMAGE_REPOSITORY_NOT_FOUND, "Image repository %s does not exist or not authorized.", new Object[]{imageRepositoryURL});
            }
        }
        return messages;
    }

    @Override
    public ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint getActivityMetrics_NT(AuthCtx authCtx, int connectTimeout, int socketTimeout, String overridingConnectionName) {
        return new ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint.None();
    }
}

