/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.common.datamodel.actual;

import com.dataiku.dip.badges.TypeBadge;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractDeploymentBasicInfo;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractInfraBasicInfo;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractPublishedItemBasicInfo;
import com.dataiku.dip.deployer.common.datamodel.actual.PublishedPackageInfo;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractPublishedItemLightStatus {
    public List<PublishedPackageInfo> packages;
    public List<? extends AbstractDeploymentBasicInfo> deployments;
    public List<AbstractInfraBasicInfo> infras;
    private boolean isAdmin;
    private boolean canDeploy;
    private boolean canWrite;

    AbstractPublishedItemLightStatus(List<PublishedPackageInfo> packages, List<? extends AbstractDeploymentBasicInfo> deployments, List<AbstractInfraBasicInfo> infras, boolean isAdmin, boolean canDeploy, boolean canWrite) {
        this.packages = packages;
        this.deployments = deployments;
        this.infras = infras;
        this.canDeploy = canDeploy;
        this.canWrite = canWrite;
        this.isAdmin = isAdmin;
    }

    public static class PublishedProjectLightStatus
    extends AbstractPublishedItemLightStatus {
        public AbstractPublishedItemBasicInfo.PublishedProjectBasicInfo projectBasicInfo;
        public Set<TypeBadge> typeBadges;

        public PublishedProjectLightStatus(List<PublishedPackageInfo> packages, List<? extends AbstractDeploymentBasicInfo> deployments, List<AbstractInfraBasicInfo> infras, AbstractPublishedItemBasicInfo.PublishedProjectBasicInfo projectBasicInfo, boolean isProjectAdmin, boolean canDeploy, boolean canWrite) {
            super(packages, deployments, infras, isProjectAdmin, canDeploy, canWrite);
            this.projectBasicInfo = projectBasicInfo;
            this.typeBadges = deployments.stream().map(deployment -> (AbstractDeploymentBasicInfo.ProjectDeploymentBasicInfo)deployment).flatMap(deployment -> deployment.typeBadges.stream()).collect(Collectors.toSet());
        }
    }

    public static class PublishedAPIServiceLightStatus
    extends AbstractPublishedItemLightStatus {
        AbstractPublishedItemBasicInfo.PublishedAPIServiceBasicInfo serviceBasicInfo;

        public PublishedAPIServiceLightStatus(List<PublishedPackageInfo> packages, List<? extends AbstractDeploymentBasicInfo> deployments, List<AbstractInfraBasicInfo> infras, AbstractPublishedItemBasicInfo.PublishedAPIServiceBasicInfo serviceBasicInfo, boolean isServiceAdmin, boolean canDeploy, boolean canWrite) {
            super(packages, deployments, infras, isServiceAdmin, canDeploy, canWrite);
            this.serviceBasicInfo = serviceBasicInfo;
        }
    }
}

