/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.common.deployments.actions;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIServiceDeployment;
import com.dataiku.dip.deployer.common.DeployerCodes;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractDeploymentHeavyStatus;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeployment;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.deployer.common.deployments.AbstractDeploymentsService;
import com.dataiku.dip.deployer.common.deployments.actions.DeploymentAction;
import com.dataiku.dip.deployer.common.deployments.actions.DeploymentActionHandle;
import com.dataiku.dip.deployer.common.deployments.actions.DeploymentDeletion;
import com.dataiku.dip.deployer.common.deployments.actions.DeploymentUpdate;
import com.dataiku.dip.deployer.common.deployments.actions.updates.DeploymentUpdateService;
import com.dataiku.dip.deployer.common.engine.DeploymentFutureThread;
import com.dataiku.dip.deployer.common.engine.DeploymentReport;
import com.dataiku.dip.deployer.common.infra.AbstractInfrasService;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.AbstractProjectDeployment;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeploymentActionsService {
    private final FutureService futureService;
    private final DeploymentUpdateService deploymentUpdateService;
    private final HashMap<String, String> inProgressJobIdsByDeploymentKey = new HashMap();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployment.actions.service");

    @Autowired
    public DeploymentActionsService(FutureService futureService, DeploymentUpdateService deploymentUpdateService) {
        this.futureService = futureService;
        this.deploymentUpdateService = deploymentUpdateService;
    }

    public synchronized void abortDeploymentAction(@Nonnull AuthCtx authCtx, @Nonnull AbstractDeployment deployment) {
        String jobId = this.inProgressJobIdsByDeploymentKey.get(deployment.getKey());
        if (StringUtils.isBlank((CharSequence)jobId)) {
            throw ErrorContext.isef((String)"jobId is not found for update of the deployment: %s", (Object)deployment.getKey(), (Object[])new Object[0]);
        }
        String deploymentKey = deployment.getKey();
        logger.infoV("Aborting action on deployment %s with jobId %s", new Object[]{deploymentKey, jobId});
        this.futureService.abort(jobId, authCtx);
    }

    private static PublicUser getPublicUserOrLogin(FutureThread<?> thread) {
        String login = thread.getOwner().getAssociatedDSSUserOrIdentifier();
        PublicUser user = new PublicUser();
        try {
            user = ((UsersService)SpringUtils.getBean(UsersService.class)).getPublicUser(login);
        }
        catch (IOException e) {
            logger.warnV((Throwable)e, "Unable to get PublicUser with login %s. Return login only.", new Object[]{login});
            user.login = login;
        }
        return user;
    }

    private List<String> computePublishedItemIds(AbstractDeployment deployment, long startTimestamp) {
        if (deployment instanceof AbstractProjectDeployment) {
            AbstractProjectDeployment projectDeployment = (AbstractProjectDeployment)deployment;
            return List.of(projectDeployment.bundleId);
        }
        if (deployment instanceof AbstractAPIServiceDeployment) {
            AbstractAPIServiceDeployment apiDeployment = (AbstractAPIServiceDeployment)deployment;
            if (apiDeployment.generationsMapping != null && !apiDeployment.generationsMapping.getEntries().isEmpty()) {
                return apiDeployment.generationsMapping.getEntries().stream().map(e -> e.generation).toList();
            }
            logger.warnV("No generations found for API service deployment (update timestamp: %d, deployment key: '%s')", new Object[]{startTimestamp, deployment.getKey()});
        } else {
            logger.warnV("Could not determine publishedItemIds for deployment due to unknown deployment type '%s' (update timestamp: %d, deployment key: '%s')", new Object[]{deployment.getClass().getName(), startTimestamp, deployment.getKey()});
        }
        return List.of();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private FutureResponse<Object> findDeploymentFuture(@Nonnull AuthCtx authCtx, @Nonnull AbstractDeploymentInfra infra, @Nonnull AbstractDeployment deployment) throws Exception {
        DeploymentActionsService deploymentActionsService = this;
        synchronized (deploymentActionsService) {
            String inProgressJobId = this.inProgressJobIdsByDeploymentKey.get(deployment.getKey());
            if (inProgressJobId != null) {
                return this.futureService.getUpdate(inProgressJobId);
            }
        }
        DeploymentAction deploymentAction = this.getLastDeploymentActionForUser(authCtx, deployment, infra);
        return deploymentAction != null ? deploymentAction.asFutureResponse() : null;
    }

    private FutureResponse<Object> resolveDeploymentFuture(AuthCtx authCtx, AbstractDeploymentInfra infra, AbstractDeployment deployment, @Nullable String jobId) throws Exception {
        if (StringUtils.isBlank((CharSequence)jobId)) {
            return this.findDeploymentFuture(authCtx, infra, deployment);
        }
        try {
            return this.futureService.getUpdate(jobId);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().startsWith("JobID not found")) {
                return this.findDeploymentFuture(authCtx, infra, deployment);
            }
            throw e;
        }
    }

    private void copyWithSensitiveDataAccessRules(FutureResponse<Object> response, AuthCtx authCtx, AbstractDeploymentInfra infra) {
        boolean isAdmin = AbstractInfrasService.hasAdminPermission(infra, authCtx) && authCtx.isSafeCodeAllowed();
        Object object = response.progress;
        if (object instanceof DeploymentFutureThread.DeploymentFutureProgressStateSnapshot) {
            DeploymentFutureThread.DeploymentFutureProgressStateSnapshot progress = (DeploymentFutureThread.DeploymentFutureProgressStateSnapshot)((Object)object);
            if (progress.report != null) {
                DeploymentReport deploymentReport = progress.report = isAdmin ? progress.report.copyHookStatusWithSensitiveDataAdded() : progress.report.copyWithNonAdminDeploymentFailureMessage();
            }
        }
        if ((object = response.result) instanceof DeploymentReport) {
            DeploymentReport deploymentReport = (DeploymentReport)((Object)object);
            response.result = isAdmin ? deploymentReport.copyHookStatusWithSensitiveDataAdded() : deploymentReport.copyWithNonAdminDeploymentFailureMessage();
        }
    }

    @Nullable
    public FutureResponse<Object> peekDeploymentActionProgress(@Nonnull AuthCtx authCtx, @Nonnull AbstractDeployment deployment, @Nonnull AbstractDeploymentInfra infra, @Nullable String jobId) throws Exception {
        FutureResponse<Object> futureResponse = this.resolveDeploymentFuture(authCtx, infra, deployment, jobId);
        if (futureResponse == null) {
            return null;
        }
        futureResponse.jobId = null;
        this.copyWithSensitiveDataAccessRules(futureResponse, authCtx, infra);
        return futureResponse;
    }

    @Nullable
    public DeploymentAction getLastDeploymentActionForUser(@Nonnull AuthCtx authCtx, @Nonnull AbstractDeployment deployment, @Nonnull AbstractDeploymentInfra infra) {
        DeploymentUpdate deploymentUpdate = this.deploymentUpdateService.getLastUpdate(infra, deployment, false);
        if (deploymentUpdate != null && !deploymentUpdate.isInProgress()) {
            if (AbstractInfrasService.hasAdminPermission(infra, authCtx) && authCtx.isSafeCodeAllowed()) {
                return deploymentUpdate.copyWithAllData();
            }
            return deploymentUpdate.copyWithNonAdminDeploymentFailureMessage();
        }
        return deploymentUpdate;
    }

    public DeploymentActionHandle updateDeployment(@Nonnull AbstractDeployment deployment, @Nonnull AbstractDeploymentInfra infra, @Nonnull DeploymentFutureThread<? extends DeploymentReport> futureThread, long startTimestamp) throws CodedException {
        PublicUser user = DeploymentActionsService.getPublicUserOrLogin(futureThread);
        List<String> publishedItemIds = this.computePublishedItemIds(deployment, startTimestamp);
        DeploymentUpdate initiatedAction = DeploymentUpdate.initiated(user, infra, deployment, startTimestamp, publishedItemIds);
        return this.startDeploymentAction(deployment, infra, initiatedAction, futureThread);
    }

    public DeploymentActionHandle deleteDeployment(@Nonnull AbstractDeployment deployment, @Nonnull AbstractDeploymentInfra infra, @Nonnull FutureThread<AbstractDeploymentsService.DeploymentDeletionReport> futureThread) throws CodedException {
        PublicUser user = DeploymentActionsService.getPublicUserOrLogin(futureThread);
        long startTimestamp = Instant.now().toEpochMilli();
        return this.startDeploymentAction(deployment, infra, DeploymentDeletion.initiated(user, infra, deployment, startTimestamp), futureThread);
    }

    private synchronized DeploymentActionHandle startDeploymentAction(@Nonnull AbstractDeployment deployment, @Nonnull AbstractDeploymentInfra infra, DeploymentAction actionToStart, @Nonnull FutureThread<?> futureThread) throws CodedException {
        String deploymentKey = deployment.getKey();
        if (this.inProgressJobIdsByDeploymentKey.containsKey(deploymentKey)) {
            throw new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_DEPLOYER_ACTION_IN_PROGRESS, "Another action is in progress");
        }
        logger.infoV("Starting %s action for deployment %s", new Object[]{actionToStart.getType(), deploymentKey});
        if (actionToStart instanceof DeploymentUpdate) {
            DeploymentUpdate update = (DeploymentUpdate)actionToStart;
            this.deploymentUpdateService.saveUpdate(update);
            try {
                this.deploymentUpdateService.deleteUpdatesBeyondLimit(infra, deployment);
            }
            catch (Exception e) {
                logger.warnV((Throwable)e, "Failed to delete stored update entries beyond limit for deployment: %s", new Object[]{deploymentKey});
            }
        }
        this.inProgressJobIdsByDeploymentKey.put(deploymentKey, futureThread.jobId);
        return new DeploymentActionHandle(actionToStart, futureThread);
    }

    protected synchronized void endDeploymentAction(@Nonnull DeploymentAction actionToComplete, @Nonnull FutureThread<?> futureThread, @Nullable AbstractDeploymentHeavyStatus heavyStatus, @Nullable VersionTag deploymentTag) {
        AbstractDeployment deployment = actionToComplete.deployment;
        AbstractDeploymentInfra infra = actionToComplete.infra;
        long startTimestamp = actionToComplete.getStartTimestamp();
        String deploymentKey = deployment.getKey();
        if (!actionToComplete.isInProgress()) {
            logger.warnV("The last action for deployment '%s' was not in progress", new Object[]{deploymentKey});
            return;
        }
        logger.infoV("Ending %s action for deployment %s", new Object[]{actionToComplete.getType(), deploymentKey});
        long endTimestamp = Instant.now().toEpochMilli();
        DeploymentAction completedDeploymentAction = actionToComplete.completeAction(futureThread.getResult(), endTimestamp);
        this.inProgressJobIdsByDeploymentKey.remove(deploymentKey);
        if (completedDeploymentAction instanceof DeploymentUpdate) {
            DeploymentUpdate update = (DeploymentUpdate)completedDeploymentAction;
            update.deployment.deploymentTag = deploymentTag;
            this.deploymentUpdateService.saveUpdate(update);
            this.deploymentUpdateService.saveTrimmedHeavyStatus(startTimestamp, infra, deployment, heavyStatus);
        } else if (completedDeploymentAction instanceof DeploymentDeletion) {
            if (InfoMessage.Severity.ERROR.equals((Object)completedDeploymentAction.getStatus())) {
                this.deploymentUpdateService.deleteUpdate(infra, deployment, startTimestamp);
            } else {
                this.deploymentUpdateService.deleteAllUpdates(infra, deployment);
            }
        } else {
            logger.warnV("Received an unexpected deployment action type: %s", new Object[]{completedDeploymentAction.getClass().getCanonicalName()});
        }
    }
}

