/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.common.engine;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.kernel.master.locking.Permit;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIServiceDeployment;
import com.dataiku.dip.deployer.common.DeployerCodes;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeploymentHook;
import com.dataiku.dip.deployer.common.datamodel.config.DeploymentHook;
import com.dataiku.dip.deployer.common.datamodel.config.DeploymentHookResult;
import com.dataiku.dip.deployer.common.engine.DeploymentHooksKernelProtocol;
import com.dataiku.dip.deployer.common.engine.DeploymentHooksRunRequest;
import com.dataiku.dip.deployer.common.engine.DeploymentReport;
import com.dataiku.dip.deployer.common.engine.DeploymentReportForPostHooksCode;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.MultiNodeProjectDeployment;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.SingleNodeProjectDeployment;
import com.dataiku.dip.directory.NodeConnection;
import com.dataiku.dip.engine.SmoothlyClosableRunner;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.base.Stopwatch;
import com.google.gson.JsonParseException;
import java.io.File;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import org.intellij.lang.annotations.PrintFormat;

public class DeploymentHooksRunner
extends SmoothlyClosableRunner<DeploymentHooksKernelProtocol> {
    public final Permit<DeploymentHooksRunRequest> permit;
    private final int executionTimeoutMinutes;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final Stopwatch stopwatch;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployment.hooks.runner");

    public DeploymentHooksRunner(DeploymentHooksKernelProtocol runner, int executionTimeoutMinutes, Permit<DeploymentHooksRunRequest> permit, Stopwatch stopwatch) {
        super(runner);
        this.executionTimeoutMinutes = executionTimeoutMinutes;
        this.permit = permit;
        this.stopwatch = stopwatch;
    }

    public InfoMessage.InfoMessages execute(AuthCtx requestingUser, List<AbstractDeploymentHook> hooks, File deploymentLogFile, File updateLogFile, List<DeploymentReport.HookResult> hookResults, DeploymentHookMetadata metadata, DeploymentReportForPostHooksCode deploymentReportForPostHooksCode, boolean errorsAsWarnings) throws Exception {
        this.incRefCount();
        if (this.isDeadKernel()) {
            ((DeploymentHooksKernelProtocol)this.runner).getKernel().appendKernelLogsToLogFile(deploymentLogFile);
            ((DeploymentHooksKernelProtocol)this.runner).getKernel().appendKernelLogsToLogFile(updateLogFile);
            ((DeploymentHooksKernelProtocol)this.runner).getKernel().start();
        }
        ((DeploymentHooksKernelProtocol)this.runner).loadMetadata(requestingUser, metadata, deploymentReportForPostHooksCode);
        InfoMessage.InfoMessages report = new InfoMessage.InfoMessages();
        for (AbstractDeploymentHook aDeploymentHook : hooks) {
            if (!aDeploymentHook.enabled) continue;
            if (!(aDeploymentHook instanceof DeploymentHook)) {
                this.errorOrWarn(errorsAsWarnings, report, DeployerCodes.ERR_DEPLOYMENT_HOOK, "Unsupported deployment hook type: %s", aDeploymentHook.getClass().getSimpleName());
                return report;
            }
            DeploymentHook deploymentHook = (DeploymentHook)aDeploymentHook;
            logger.infoV("Executing deployment hook %s", new Object[]{deploymentHook.name});
            DeploymentReport.HookResult hookResult = DeploymentReport.HookResult.startExecutingHook(deploymentHook.name);
            hookResults.add(hookResult);
            Future<DeploymentHookResult> futureResult = this.executor.submit(() -> ((DeploymentHooksKernelProtocol)this.runner).execute(deploymentHook));
            try {
                DeploymentHookResult result = futureResult.get(this.executionTimeoutMinutes, TimeUnit.MINUTES);
                hookResult.setExecutionResult(result);
                switch (result.status) {
                    case SUCCESS: {
                        logger.infoV("Deployment hook %s finished successfully, with message: %s", new Object[]{deploymentHook.name, result.message});
                        break;
                    }
                    case WARNING: {
                        logger.warnV("Deployment hook %s finished with a warning, with message: %s", new Object[]{deploymentHook.name, result.message});
                        report.withWarningV((InfoMessage.MessageCode)DeployerCodes.WARN_DEPLOYMENT_HOOK, "\"%s\" returned message: %s.", new Object[]{deploymentHook.name, result.message});
                        break;
                    }
                    case ERROR: {
                        logger.errorV("Deployment hook %s finished with an error, with message: %s", new Object[]{deploymentHook.name, result.message});
                        this.errorOrWarn(errorsAsWarnings, report, DeployerCodes.ERR_DEPLOYMENT_HOOK, "\"%s\" returned message: %s.", deploymentHook.name, result.message);
                        return report;
                    }
                }
            }
            catch (InterruptedException e) {
                logger.infoV("Deployment hook %s interrupted", new Object[]{deploymentHook.name});
                hookResult.executionInterrupted();
                return report;
            }
            catch (TimeoutException e) {
                logger.errorV("Deployment hook %s timed out", new Object[]{deploymentHook.name});
                hookResult.executionTimedOut();
                this.errorOrWarn(errorsAsWarnings, report, DeployerCodes.ERR_DEPLOYMENT_HOOK, "Deployment hook %s timed out.", deploymentHook.name);
                return report;
            }
            catch (ExecutionException e) {
                hookResult.executionError();
                if (e.getCause() instanceof JsonParseException) {
                    logger.errorV("Failed parsing response of deployment hook %s. %s", new Object[]{deploymentHook.name, ExceptionUtils.getMessageWithCauses((Throwable)e.getCause())});
                    this.errorOrWarn(errorsAsWarnings, report, DeployerCodes.ERR_DEPLOYMENT_HOOK, "Failed parsing response of deployment hook %s. %s", deploymentHook.name, ExceptionUtils.getMessageWithCauses((Throwable)e.getCause()));
                } else {
                    logger.errorV("Unexpected error when executing deployment hook %s. %s", new Object[]{deploymentHook.name, ExceptionUtils.getMessageWithCauses((Throwable)e)});
                    this.errorOrWarn(errorsAsWarnings, report, DeployerCodes.ERR_DEPLOYMENT_HOOK, "Unexpected error when executing deployment hook %s. %s", deploymentHook.name, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
                return report;
            }
            catch (Exception e) {
                hookResult.executionError();
                logger.errorV("Execution of deployment hook %s failed with error %s", new Object[]{deploymentHook.name, ExceptionUtils.getMessageWithCauses((Throwable)e)});
                this.errorOrWarn(errorsAsWarnings, report, DeployerCodes.ERR_DEPLOYMENT_HOOK, "Execution of deployment hook %s failed with error %s", deploymentHook.name, ExceptionUtils.getMessageWithCauses((Throwable)e));
                return report;
            }
        }
        return report;
    }

    public void errorOrWarn(boolean asWarning, InfoMessage.InfoMessages report, InfoMessage.MessageCode code, @PrintFormat String details, Object ... args) {
        if (asWarning) {
            report.withWarningV(code, details, args);
        } else {
            report.withErrorV(code, details, args);
        }
    }

    public boolean isDeadKernel() {
        return ((DeploymentHooksKernelProtocol)this.runner).getKernel().getLink() == null || !((DeploymentHooksKernelProtocol)this.runner).getKernel().isAlive();
    }

    @Override
    public void close() throws Exception {
        logger.infoV("Closing deployment hook kernel and releasing permit for infra %s after holding it for %d ms", new Object[]{this.permit.getRequest().getPermitGroupKey(), this.stopwatch.elapsed(TimeUnit.MILLISECONDS)});
        this.decRefCount();
        super.close();
        this.permit.release();
    }

    public static interface DeploymentHookMetadata {
    }

    public static class ApiDeploymentHookMetadata
    implements DeploymentHookMetadata {
        public final AbstractAPIServiceDeployment apiServiceDeployment;

        public ApiDeploymentHookMetadata(AbstractAPIServiceDeployment apiServiceDeployment) {
            this.apiServiceDeployment = apiServiceDeployment;
        }
    }

    public static class MultiNodeProjectDeploymentHookMetadata
    implements DeploymentHookMetadata {
        public final List<NodeConnection> nodeConnections;
        public final boolean trustAllSSLCertificates;
        public final MultiNodeProjectDeployment deployment;
        public final String deployingUser;

        public MultiNodeProjectDeploymentHookMetadata(List<NodeConnection> nodeConnections, boolean trustAllSSLCertificates, MultiNodeProjectDeployment deployment, String deployingUser) {
            this.nodeConnections = nodeConnections;
            this.trustAllSSLCertificates = trustAllSSLCertificates;
            this.deployment = deployment;
            this.deployingUser = deployingUser;
        }
    }

    public static class SingleNodeProjectDeploymentHookMetadata
    implements DeploymentHookMetadata {
        public final NodeConnection nodeConnection;
        public final boolean trustAllSSLCertificates;
        public final SingleNodeProjectDeployment deployment;
        public final String deployingUser;

        public SingleNodeProjectDeploymentHookMetadata(@Nonnull NodeConnection nodeConnection, SingleNodeProjectDeployment deployment, String deployingUser) {
            this.nodeConnection = nodeConnection;
            this.trustAllSSLCertificates = nodeConnection.trustAllSSLCertificates;
            this.deployment = deployment;
            this.deployingUser = deployingUser;
        }
    }
}

