/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.projectdeployer.infra;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.deployer.projectdeployer.datamodel.actual.SingleNodeProjectDeploymentHeavyStatus;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.AbstractProjectDeployment;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.AbstractProjectDeploymentInfra;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.SingleAutomationNodeInfra;
import com.dataiku.dip.deployer.projectdeployer.infra.AbstractAutomationNodeInfraManager;
import com.dataiku.dip.directory.NodeConnection;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.nodeclients.AutomationNodeClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ProjectFoldersService;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SingleAutomationNodeInfraManager
extends AbstractAutomationNodeInfraManager {
    @Nonnull
    final SingleAutomationNodeInfra infra;
    @Nonnull
    final NodeConnection nodeConnection;
    @Nullable
    public AutomationNodeClient automationNodeClient;

    public SingleAutomationNodeInfraManager(AuthCtx authCtx, @Nonnull SingleAutomationNodeInfra infra, int connectTimeout, int socketTimeout) {
        super(authCtx, connectTimeout, socketTimeout);
        this.infra = infra;
        this.nodeConnection = infra.getConnectionInfo();
    }

    @Override
    @Nonnull
    public AbstractProjectDeploymentInfra getInfra() {
        return this.infra;
    }

    @Override
    @Nullable
    public ProjectFoldersService.ProjectFolderSummary getProjectFolderHierarchy() throws IOException, CodedException {
        return this.getProjectFolderHierarchyOnNode(this.nodeConnection);
    }

    @Override
    @Nonnull
    public InfoMessage.InfoMessages checkInfraStatus() {
        return this.checkInfraStatusOnNode(this.nodeConnection);
    }

    @Nonnull
    public List<SingleNodeProjectDeploymentHeavyStatus> listHeavyStatus(List<AbstractProjectDeployment> allDeployments) {
        return this.listHeavyStatusOnNode(this.nodeConnection, allDeployments);
    }

    @Override
    @Nonnull
    public List<String> getProjectKeys() throws IOException, CodedException {
        return this.getProjectKeysOnNode(this.nodeConnection);
    }

    @Override
    @Nullable
    public List<String> listUserLogins() throws IOException, CodedException {
        return this.listUserLoginsOnNode(this.nodeConnection);
    }

    @Override
    @Nullable
    public List<String> listConnectionsNames(@Nullable String deploymentId) throws IOException, URISyntaxException, CodedException {
        return this.listConnectionsNamesOnNode(this.nodeConnection, deploymentId);
    }

    @Override
    @Nonnull
    public List<String> listContainerExecNames(@Nullable String deploymentId) throws IOException, URISyntaxException, CodedException {
        return this.listContainerExecNamesOnNode(this.nodeConnection, deploymentId);
    }

    @Override
    @Nonnull
    public List<NodeConnection> getNodeConnections() {
        return Collections.singletonList(this.nodeConnection);
    }

    @Override
    public void openAutomationNodeClientConnections() {
        try {
            this.automationNodeClient = AutomationNodeClient.automationNodeClient(this.nodeConnection, null, this.connectTimeout, this.socketTimeout);
        }
        catch (Exception e) {
            logger.warnV((Throwable)e, "Could not open automation node connection for node connection: url [%s], id [%s]", new Object[]{this.nodeConnection.url, this.nodeConnection.automationNodeId});
        }
    }

    @Override
    public void closeAutomationNodeClientConnections() {
        if (this.automationNodeClient == null) {
            return;
        }
        this.automationNodeClient.close();
    }
}

