/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow.placeholders.dataset.details;

import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datasets.custompython.CustomDatasetDesc;
import com.dataiku.dip.datasets.fs.plugin.CustomFSProviderDesc;
import com.dataiku.dip.datasets.fs.plugin.CustomJavaFSProvidersService;
import com.dataiku.dip.datasets.fs.plugin.CustomPythonFSProvidersService;
import com.dataiku.dip.docgen.flow.FlowDocumentContext;
import com.dataiku.dip.docgen.flow.FlowPlaceholder;
import com.dataiku.dip.docgen.helpers.DatasetTypeDisplayNames;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.docgen.resolver.PlaceholderOutput;
import com.dataiku.dip.plugins.CustomJavaDatasetsService;
import com.dataiku.dip.plugins.CustomPythonDatasetsService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dss.shadelib.com.google.common.collect.Streams;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;

public class DatasetTypePlaceholder
implements FlowPlaceholder.TextPlaceholder<SerializedDataset> {
    @Autowired
    private CustomPythonDatasetsService customPythonDatasetsService;
    @Autowired
    private CustomJavaDatasetsService customJavaDatasetsService;
    @Autowired
    private CustomPythonFSProvidersService customPythonFSProvidersService;
    @Autowired
    private CustomJavaFSProvidersService customJavaFSProvidersService;
    private final Map<String, String> pluginDatasetTypesMapping = new HashMap<String, String>();

    public DatasetTypePlaceholder() {
        SpringUtils.getInstance().autowire((Object)this);
        Streams.concat((Stream[])new Stream[]{this.customPythonDatasetsService.list().stream(), this.customJavaDatasetsService.list().stream()}).forEach(desc -> {
            if (desc.desc != null && ((CustomDatasetDesc)desc.desc).meta != null && ((CustomDatasetDesc)desc.desc).meta.label != null) {
                this.pluginDatasetTypesMapping.put(desc.datasetType, ((CustomDatasetDesc)desc.desc).meta.label);
            }
        });
        Streams.concat((Stream[])new Stream[]{this.customPythonFSProvidersService.list().stream(), this.customJavaFSProvidersService.list().stream()}).forEach(desc -> {
            if (desc.desc != null && ((CustomFSProviderDesc)desc.desc).meta != null && ((CustomFSProviderDesc)desc.desc).meta.label != null) {
                this.pluginDatasetTypesMapping.put(desc.fsProviderType, ((CustomFSProviderDesc)desc.desc).meta.label);
            }
        });
    }

    @Override
    public Class<SerializedDataset> getInputType() {
        return SerializedDataset.class;
    }

    @Override
    public PlaceholderOutput.Text resolve(FlowDocumentContext flowDocumentContext, SerializedDataset dataset) throws PlaceholderExpectedException {
        String humanReadableType = DatasetTypeDisplayNames.getOrDefault(dataset.type, this.pluginDatasetTypesMapping.getOrDefault(dataset.type, dataset.type.toLowerCase()));
        return new PlaceholderOutput.Text(humanReadableType);
    }
}

