/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.compute.grouping;

import com.dataiku.dip.eda.compute.filtering.Filter;
import com.dataiku.dip.eda.compute.grouping.Grouping;
import com.dataiku.dip.eda.compute.grouping.GroupingResult;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class UnionGrouping
extends Grouping {
    public static final String TYPE = "union";
    public List<Grouping> groupings;

    public UnionGrouping(Grouping ... groupings) {
        this.groupings = Lists.newArrayList((Object[])groupings);
    }

    public UnionGrouping(List<Grouping> groupings) {
        this.groupings = groupings;
    }

    private UnionGrouping() {
    }

    public static class UnionGroupingResult
    extends GroupingResult {
        public List<GroupingResult> groupings;

        public UnionGroupingResult(GroupingResult ... groupings) {
            this.groupings = Lists.newArrayList((Object[])groupings);
        }

        public UnionGroupingResult(List<GroupingResult> groupings) {
            this.groupings = groupings;
        }

        private UnionGroupingResult() {
        }

        public int[] unflattenIndex(int flatIndex) {
            int nbGroupings = this.groupings.size();
            int groupingStartsAt = 0;
            for (int groupingIdx = 0; groupingIdx < nbGroupings; ++groupingIdx) {
                int size = this.groupings.get(groupingIdx).size();
                int groupingEndsAt = groupingStartsAt + size;
                if (flatIndex >= groupingStartsAt && flatIndex < groupingEndsAt) {
                    return new int[]{groupingIdx, flatIndex - groupingStartsAt};
                }
                groupingStartsAt += size;
            }
            throw new IndexOutOfBoundsException("Invalid index: " + flatIndex);
        }

        @Override
        public List<Filter> listFilters() {
            ArrayList<Filter> output = new ArrayList<Filter>();
            for (GroupingResult gr : this.groupings) {
                output.addAll(gr.listFilters());
            }
            return output;
        }

        @Override
        public int size() {
            int size = 0;
            for (GroupingResult gr : this.groupings) {
                size += gr.size();
            }
            return size;
        }
    }
}

