/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.queries;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.eda.compute.engine.ComputationRunner;
import com.dataiku.dip.eda.compute.filtering.Filter;
import com.dataiku.dip.eda.worksheets.cards.Card;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.eda.worksheets.models.Variable;
import com.dataiku.dip.eda.worksheets.queries.InteractiveQuery;
import com.dataiku.dip.eda.worksheets.suggester.AssistantSettingsCardFixer;
import com.dataiku.dip.eda.worksheets.suggester.BivariateAnalysisSuggester;
import com.dataiku.dip.eda.worksheets.suggester.BivariateSuggester;
import com.dataiku.dip.eda.worksheets.suggester.BivariateSuggestionCleaner;
import com.dataiku.dip.eda.worksheets.suggester.CardComputer;
import com.dataiku.dip.eda.worksheets.suggester.CardMiniaturizer;
import com.dataiku.dip.eda.worksheets.suggester.CategoricalTestSuggester;
import com.dataiku.dip.eda.worksheets.suggester.FitCurveSuggester;
import com.dataiku.dip.eda.worksheets.suggester.FitDistributionSuggester;
import com.dataiku.dip.eda.worksheets.suggester.KDE2DSuggester;
import com.dataiku.dip.eda.worksheets.suggester.KSSuggester;
import com.dataiku.dip.eda.worksheets.suggester.MultivariateSuggester;
import com.dataiku.dip.eda.worksheets.suggester.NSampleTestSuggester;
import com.dataiku.dip.eda.worksheets.suggester.NoSelectionSuggester;
import com.dataiku.dip.eda.worksheets.suggester.OneSampleTestSuggester;
import com.dataiku.dip.eda.worksheets.suggester.ParallelCoordinatesPlotSuggester;
import com.dataiku.dip.eda.worksheets.suggester.Scatter2DSuggester;
import com.dataiku.dip.eda.worksheets.suggester.SniffedVariable;
import com.dataiku.dip.eda.worksheets.suggester.SplitSuggester;
import com.dataiku.dip.eda.worksheets.suggester.Suggester;
import com.dataiku.dip.eda.worksheets.suggester.TimeSeriesAnalysisSuggester;
import com.dataiku.dip.eda.worksheets.suggester.UnivariateAnalysisSuggester;
import com.dataiku.dip.eda.worksheets.suggester.UnivariateSuggester;
import com.dataiku.dip.eda.worksheets.suggester.VariableInterestScorer;
import com.dataiku.dip.eda.worksheets.suggester.VariableSniffer;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class SuggestCards
extends InteractiveQuery {
    public static final String TYPE = "suggest_cards";
    private static final Suggester[] SUGGESTERS = new Suggester[]{new UnivariateAnalysisSuggester(), new UnivariateSuggester(), new Scatter2DSuggester(), new BivariateAnalysisSuggester(), new BivariateSuggester(), new MultivariateSuggester(), new TimeSeriesAnalysisSuggester(), new FitCurveSuggester(), new KDE2DSuggester(), new FitDistributionSuggester(), new OneSampleTestSuggester(), new NSampleTestSuggester(), new KSSuggester(), new CategoricalTestSuggester(), new SplitSuggester(new UnivariateAnalysisSuggester(), new UnivariateSuggester(), new FitDistributionSuggester(), new Scatter2DSuggester(), new MultivariateSuggester(), new ParallelCoordinatesPlotSuggester())};
    private static final Suggester NO_SELECTION_SUGGESTER = new NoSelectionSuggester();
    private static final BivariateSuggestionCleaner suggestionCleaner = new BivariateSuggestionCleaner();
    public List<String> selectedVariables = new ArrayList<String>();
    public AssistantSettings assistantSettings;

    @Override
    public InteractiveQuery.InteractiveQueryResult run(Schema schema, ComputationRunner runner) throws Exception {
        List<String> allColumns = schema.columns.stream().map(SchemaColumn::getName).collect(Collectors.toList());
        List<String> filteredSelectedVariables = this.selectedVariables.stream().filter(allColumns::contains).collect(Collectors.toList());
        List<SniffedVariable> sniffedVariables = new VariableSniffer(runner).sniff(allColumns, filteredSelectedVariables);
        List<SuggestedVariable> suggestedVariables = new VariableInterestScorer(sniffedVariables).score();
        AssistantSettingsCardFixer cardFixer = new AssistantSettingsCardFixer(this.assistantSettings);
        for (SuggestedVariable suggestedVariable : suggestedVariables) {
            suggestedVariable.card = cardFixer.fix(suggestedVariable.card);
        }
        CardComputer cardComputer = new CardComputer(runner);
        cardComputer.computeCards(suggestedVariables, sv -> sv.card, (sv, card) -> {
            sv.card = card;
        }, (sv, result) -> {
            sv.result = result;
        });
        List<SuggestedCard> suggestedCards = this.suggestCards(sniffedVariables);
        suggestedCards = suggestionCleaner.cleanRedundantSuggestions(suggestedCards);
        CardMiniaturizer miniaturizer = new CardMiniaturizer();
        for (SuggestedCard suggestedCard : suggestedCards) {
            Card thumbnailCard = miniaturizer.minify(suggestedCard.card);
            suggestedCard.card = cardFixer.fix(suggestedCard.card);
            suggestedCard.miniatureCard = cardFixer.fix(thumbnailCard);
        }
        cardComputer.computeCards(suggestedCards, sc -> sc.miniatureCard, (sc, card) -> {
            sc.miniatureCard = card;
        }, (sc, result) -> {
            sc.miniatureResult = result;
        });
        suggestedCards = suggestedCards.stream().filter(it -> !(it.miniatureResult instanceof CardResult.UnavailableCardResult)).collect(Collectors.toList());
        SuggestCardsResult queryResult = new SuggestCardsResult();
        queryResult.suggestedVariables = suggestedVariables;
        queryResult.suggestedCards = suggestedCards;
        return queryResult;
    }

    private List<SuggestedCard> suggestCards(List<SniffedVariable> sniffedVariables) {
        if (this.selectedVariables.isEmpty()) {
            return NO_SELECTION_SUGGESTER.suggestCards(sniffedVariables);
        }
        List selectedSniffedVariables = sniffedVariables.stream().filter(SniffedVariable::isSelected).collect(Collectors.toList());
        return Arrays.stream(SUGGESTERS).flatMap(s -> s.suggestCards(selectedSniffedVariables).stream()).collect(Collectors.toList());
    }

    @UIModel
    public static class AssistantSettings {
        public double confidenceLevel;
        public boolean showConfidenceInterval;
        @Nullable
        public Filter highlightFilter;
    }

    @UIModel
    public static class SuggestedVariable {
        public String name;
        public Variable.Type type;
        public Double individualScore;
        public Double totalScore;
        public List<String> explanations;
        public Card card;
        public CardResult result;
    }

    @UIModel
    public static class SuggestedCard {
        public String name;
        public Card card;
        public Card miniatureCard;
        public CardResult miniatureResult;

        public SuggestedCard(String name, Card card) {
            this.name = name;
            this.card = card;
        }
    }

    public static class SuggestCardsResult
    extends InteractiveQuery.InteractiveQueryResult {
        public List<SuggestedCard> suggestedCards;
        public List<SuggestedVariable> suggestedVariables;
    }
}

