/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.exposition;

import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.coremodel.DkuComponentMetadata;
import com.dataiku.dip.exposition.AbstractKubernetesExpositionHandler;
import com.dataiku.dip.exposition.Exposables;
import com.dataiku.dip.exposition.ExposedEndpointConsumer;
import com.dataiku.dip.exposition.Exposition;
import com.dataiku.dip.exposition.ExpositionDesc;
import com.dataiku.dip.exposition.ExpositionHandler;
import com.dataiku.dip.exposition.ExpositionMeta;
import com.dataiku.dip.exposition.ExpositionParams;
import com.dataiku.dip.futures.IStateLabelAggregator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.process.RegularProcess;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ClusterIPExposition {
    public static final ExpositionMeta META = new ExpositionMeta(){

        @Override
        public String getType() {
            return "cluster_ip";
        }

        @Override
        public Class<? extends ExpositionParams> getParamsClass() {
            return ClusterIPExpositionParams.class;
        }

        @Override
        public ExpositionDesc getDesc(ExpositionMeta.ExpositionUsageContext usageContext) {
            ParamDesc serviceAnnotations = new ParamDesc();
            serviceAnnotations.type = ParamDesc.Type.KEY_VALUE_LIST;
            serviceAnnotations.name = "serviceAnnotations";
            serviceAnnotations.label = "Service annotations";
            ParamDesc port = new ParamDesc();
            port.type = ParamDesc.Type.INT;
            port.name = "port";
            port.label = "Port";
            port.defaultValue = -1;
            return new ExpositionDesc().withType(this.getType()).withMeta(new DkuComponentMetadata("Cluster IP", "Expose on a cluster IP", null, null)).withParam(port).withParam(serviceAnnotations);
        }

        @Override
        public long getMaxStartWait(AuthCtx authCtx) {
            return 120000L;
        }

        @Override
        public boolean handles(ContainerExecRuntimeConfig containerConfig) {
            return containerConfig.type == ContainerExecRuntimeConfig.Container.KUBERNETES;
        }

        @Override
        public boolean handles(ContainerExecRuntimeConfig.Container containerType) {
            return containerType == ContainerExecRuntimeConfig.Container.KUBERNETES;
        }

        @Override
        public boolean handles(Exposables.ExposableKind kind) {
            return kind == Exposables.ExposableKind.WEBAPP || kind == Exposables.ExposableKind.API_DEPLOYER;
        }

        @Override
        public ExpositionHandler buildHandler(AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, Exposition exposition, ExposedEndpointConsumer endpointConsumer) {
            ClusterIPExpositionParams params = exposition.getParamsAs(ClusterIPExpositionParams.class);
            return new ClusterIPExpositionHandler(authCtx, projectKey, containerConfig, params, endpointConsumer);
        }

        @Override
        public void expandParametersInPlace(VariablesContext vc, Exposition exposition) {
            ClusterIPExpositionParams params = exposition.getParamsAs(ClusterIPExpositionParams.class);
            for (ExpositionParams.Annotation annotation : params.serviceAnnotations) {
                annotation.expandParametersInPlace(vc);
            }
        }
    };
    private static Logger logger = Logger.getLogger((String)"dip.webapp.expose");

    private static class ClusterIPExpositionHandler
    extends AbstractKubernetesExpositionHandler {
        private final ClusterIPExpositionParams params;
        private int port;
        private List<String> serviceFiles;
        private IStateLabelAggregator stateLabelAggregator;
        private ExpositionHandler.ExpositionStatus status = new ExpositionHandler.ExpositionStatus();
        private boolean closed;

        ClusterIPExpositionHandler(AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, ClusterIPExpositionParams params, ExposedEndpointConsumer endpointConsumer) {
            super(authCtx, projectKey, containerConfig, endpointConsumer);
            this.params = params;
        }

        @Override
        public void cleanup() {
            this.closed = true;
            if (this.serviceFiles != null) {
                logger.info((Object)"Remove ClusterIP service");
                try {
                    KubernetesExecUtils.delete(this.authCtx, this.projectKey, this.containerConfig, true, this.serviceFiles.toArray(new String[0]));
                }
                catch (IOException e) {
                    logger.error((Object)"Could not stop Kubernetes service", (Throwable)e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.error((Object)"Interrupted while stopping Kubernetes service", (Throwable)e);
                }
            }
        }

        @Override
        public void init(Exposables.Exposable exposable, IStateLabelAggregator stateLabelAggregator) throws IOException {
            this.stateLabelAggregator = stateLabelAggregator;
            super.init(exposable, stateLabelAggregator);
            logger.info((Object)"Add ClusterIP service");
            HashMap<String, String> serviceAnnotations = new HashMap<String, String>(this.annotations);
            for (ExpositionParams.Annotation kv : this.params.serviceAnnotations) {
                if (!StringUtils.isNotBlank((String)kv.from)) continue;
                serviceAnnotations.put(kv.from, StringUtils.defaultIfBlank((String)kv.to, (String)""));
            }
            this.port = this.params.port < 0 ? this.exposedPort : this.params.port;
            File serviceFile = new File(this.tmpDir, "service_" + this.executionId + ".yaml");
            String serviceSnippet = String.format("  type: ClusterIP\n  ports:\n  - port: %d\n    targetPort: %d\n    protocol: TCP", this.port, this.exposedPort);
            String serviceDesc = KubernetesExecUtils.getServiceConf(this.namePrefix, this.executionId, serviceSnippet, this.labels, serviceAnnotations, this.selectors);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("service=\n" + serviceDesc));
            }
            DKUFileUtils.writeFileUTF8((File)serviceFile, (String)serviceDesc);
            this.serviceFiles = Lists.newArrayList((Object[])new String[]{"-f", serviceFile.getAbsolutePath()});
        }

        @Override
        public void start(DKUtils.LineSubscriptionAttacher expositionLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) throws Exception {
            Object[] cmd = KubernetesExecUtils.getKubeCtlApplyCommand(this.authCtx, this.projectKey, this.containerConfig, this.serviceFiles.toArray(new String[0]));
            expositionLog.handle("Running ClusterIP " + Joiner.on((String)" ").join(cmd), false);
            new DKUtils.ExecBuilder().withCwd(this.tmpDir).withEnv(KubernetesExecUtils.getKubeCtlEnv(this.containerConfig)).withArgs((String[])cmd).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(smartLogTailBuilder)).withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(smartLogTailBuilder)).withOutputConsumer((DKUtils.ExecSubscription)expositionLog).withErrorConsumer((DKUtils.ExecSubscription)expositionLog).withTimestamps(true).withLineContext("[clusterip] ").withCompletionHandler((DKUtils.ExecCompletionHandler)new DKUtils.SimpleExceptionExecCompletionHandler((List)Lists.newArrayList((Object[])cmd)).withLogTailBuilder(smartLogTailBuilder)).exec();
        }

        @Override
        public void waitReady(DKUtils.LineSubscriptionAttacher expositionLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) throws Exception {
            JsonObject obj;
            String host;
            long pollInterval = KubernetesExecUtils.getWebappsPollingPeriodInMillis();
            Closeable ipState = this.stateLabelAggregator.startWaitingOn("Waiting on Cluster IP");
            do {
                Thread.sleep(pollInterval);
                this.status.raw = obj = this.describeClusterIP(expositionLog, smartLogTailBuilder);
            } while ((host = ClusterIPExpositionHandler.getClusterIP(obj)) == null);
            ipState.close();
            ExposedEndpointConsumer.ExposedEndpoint endpoint = new ExposedEndpointConsumer.ExposedEndpoint(META.getType(), null, null, host, this.port, null, ExposedEndpointConsumer.ExposedEndpointAvailability.CLUSTER);
            this.endpointConsumer.registerPort(endpoint);
            this.status.endpoints.add(endpoint);
            this.status.isHealthy = true;
        }

        private JsonObject describeClusterIP(DKUtils.LineSubscriptionAttacher expositionLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) throws IOException, InterruptedException, Exception {
            String serviceId = this.namePrefix + "-service-" + this.executionId;
            ProcessBuilder pollServiceProcessBuilder = new ProcessBuilder(KubernetesExecUtils.getKubeCtlCommand(this.authCtx, this.projectKey, this.containerConfig, false, "get", "service", serviceId, "-o", "json"));
            pollServiceProcessBuilder.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(this.containerConfig));
            pollServiceProcessBuilder.directory(this.tmpDir);
            logger.info((Object)("Poll service status " + Joiner.on((String)" ").join(pollServiceProcessBuilder.command())));
            expositionLog.handle("Poll LB " + Joiner.on((String)" ").join(pollServiceProcessBuilder.command()), false);
            RegularProcess pollServiceProcess = new RegularProcess(pollServiceProcessBuilder, this.tmpDir);
            pollServiceProcess.start();
            DKUtils.ByteCollectingSubscription outputCollector = new DKUtils.ByteCollectingSubscription();
            DKUtils.ExecOutputConsumer pollServiceEoc = new DKUtils.ExecOutputConsumer().withTimestamps(true).withLineContext("[clusterip] ").withErrorConsumer((DKUtils.ExecSubscription)expositionLog).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(smartLogTailBuilder)).withOutputConsumer((DKUtils.ExecSubscription)outputCollector);
            pollServiceEoc.start(pollServiceProcess.getInputStream(), pollServiceProcess.getErrorStream(), null);
            int rv = pollServiceProcess.waitFor();
            if (rv != 0) {
                throw new Exception("Unable to get status of service " + serviceId);
            }
            pollServiceEoc.finish();
            JsonObject obj = (JsonObject)JSON.parse((InputStream)new ByteArrayInputStream(outputCollector.getCollected()), JsonObject.class);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Service JSON: " + JSON.prettyLog((Object)obj)));
            }
            return obj;
        }

        @Override
        public ExpositionHandler.ExpositionStatus getStatus(DKUtils.LineSubscriptionAttacher expositionLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) throws Exception {
            JsonObject obj;
            String host;
            ExpositionHandler.ExpositionStatus status = new ExpositionHandler.ExpositionStatus();
            if (!this.closed && (host = ClusterIPExpositionHandler.getClusterIP(obj = this.describeClusterIP(expositionLog, smartLogTailBuilder))) != null) {
                ExposedEndpointConsumer.ExposedEndpoint endpoint = new ExposedEndpointConsumer.ExposedEndpoint(META.getType(), null, null, host, this.port, null, ExposedEndpointConsumer.ExposedEndpointAvailability.CLUSTER);
                status.endpoints.add(endpoint);
                status.isHealthy = true;
            }
            return status;
        }

        @Override
        public ExposedEndpointConsumer.ExposedEndpoint getExpectedExposedEndpoint() {
            return new ExposedEndpointConsumer.ExposedEndpoint(META.getType(), null, null, "${K8S_SERVICE_ADDRESS}", this.port, null, ExposedEndpointConsumer.ExposedEndpointAvailability.CLUSTER);
        }
    }

    public static class ClusterIPExpositionParams
    implements ExpositionParams {
        public List<ExpositionParams.Annotation> serviceAnnotations = Lists.newArrayList();
        public int port = -1;
    }
}

