/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.parquet;

import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.datasets.SchemaDetection;
import com.dataiku.dip.formats.FormatMeta;
import com.dataiku.dip.input.formats.FormatExtractor;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.input.formats.parquet.ParquetFormatExtractor;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.ParamDesc;

public class ParquetFormatMeta
extends FormatMeta<ParquetFormatExtractor, ParquetFormatConfig> {
    public static final String TYPE = "parquet";
    public static final FormatMeta<ParquetFormatExtractor, ParquetFormatConfig> META = new ParquetFormatMeta();

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Class<? extends FormatParams> paramsClass() {
        return ParquetFormatConfig.class;
    }

    @Override
    public FormatExtractor build(AuthCtx authCtx, String projectKey, FormatParams params) {
        return new ParquetFormatExtractor((ParquetFormatConfig)params);
    }

    @Override
    public OutputFormatter buildFormatter(AuthCtx authCtx, String projectKey, FormatParams params) {
        throw new Error("Parquet is an output, not a format");
    }

    @Override
    public String getLabel() {
        return "Parquet";
    }

    @Override
    public SchemaDetection.SchemaHandlingType getSchemaHandlingType() {
        return SchemaDetection.SchemaHandlingType.FIXED_TYPE_AND_SCHEMA;
    }

    @Override
    public ParamDesc[] getParams() {
        return new ParamDesc[]{ParamDesc.advancedSelect("parquetCompressionMethod", "Compression method", "", ParamDesc.enumValues(ParquetFormatConfig.CompressionMethod.class), ParamDesc.capitalize(ParamDesc.enumValues(ParquetFormatConfig.CompressionMethod.class))).withDefaultValue(ParquetFormatConfig.CompressionMethod.SNAPPY.name()), ParamDesc.advancedSelect("parquetFlavor", "Flavor", "", ParamDesc.enumValues(ParquetFormatConfig.Flavor.class), ParamDesc.capitalize(ParamDesc.enumValues(ParquetFormatConfig.Flavor.class))).withDefaultValue(ParquetFormatConfig.Flavor.HIVE.name()).withTooltip("Specify how complex types are mapped in Parquet."), ParamDesc.booleanP("representsNullFields", "Extract null fields in structs").withDefaultValue(false).withTooltip("Extract null fields in structs"), ParamDesc.intP("parquetBlockSizeMB", "Block size (MB)", "(Advanced) The block size is the size of a row group being buffered in memory.This limits the memory usage when writing. Larger values will improve the IO when reading but consume more memory when writing", 64), ParamDesc.booleanP("parquetLowerCaseIdentifiers", "Lower case columns").withDefaultValue(false).withTooltip("(Advanced) Forces lower case column names in Parquet schema when writing from DSS - Only use for Hive 0.12 compatibility"), ParamDesc.advancedSelect("readTemporalMode", "Date handling", "", ParamDesc.enumValues(ParquetFormatConfig.ReadTemporalMode.class), new String[]{"As raw type", "As logical type"}).withDefaultValue(ParquetFormatConfig.ReadTemporalMode.AS_TEMPORAL.name()).withTooltip("Specify how date and timestamp logical types are read.")};
    }
}

