/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online;

import com.dataiku.common.stereotype.RoutinelyUsedInExtensionCode;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.agents.tools.AgentToolRunner;
import com.dataiku.dip.agents.tools.filtering.SimpleFilter;
import com.dataiku.dip.agents.tools.utils.JsonSchema;
import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.externalinfras.azureml.AzureMLUtils;
import com.dataiku.dip.files.MimeTypeUtils;
import com.dataiku.dip.io.JavaBlockLink;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.llm.governance.GuardrailsPipelineRunner;
import com.dataiku.dip.llm.governance.GuardrailsPipelineSettings;
import com.dataiku.dip.llm.online.ISavedModelDeployer;
import com.dataiku.dip.llm.online.RemoteFineTuningClient;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.managedfolder.ManagedFoldersService;
import com.dataiku.dip.recipes.nlp.common.LLMCompletionSettings;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKUEhcacheSerializer;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.GsonNullableJsonElementTypeAdapterFactory;
import com.dataiku.dip.utils.JF;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.JSONRedactor;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FilenameUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.j2py.annotations.PyModel;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.JsonAdapter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public interface LLMClient
extends AutoCloseable {
    public static final List<String> streamableSourceItemTypes = List.of("TEXT");
    public static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.online.llmclient");

    public boolean supportNativeBatch();

    public boolean requiresCostLimiting();

    public String getProviderId();

    public AbstractLLMConnection getConnection();

    default public void throwIfBadImageAuditFolder() {
        AbstractLLMConnection connection = this.getConnection();
        if (connection != null) {
            connection.throwIfBadImageAuditFolder();
        }
    }

    public int getMaxParallelism();

    default public int getBatchSize(AbstractLLMConnection.QueryType queryType, LLMStructuredRef llmRef) {
        logger.info((Object)"No batching supported");
        return 1;
    }

    public List<SimpleCompletionResponse> completeBatch(List<SingleCompletionQuery> var1, CompletionSettings var2) throws Exception;

    public List<SimpleEmbeddingResponse> embedBatch(List<EmbeddingQuery> var1, EmbeddingSettings var2) throws Exception;

    public List<SingleRerankingResponse> rerankBatch(List<RerankingQuery> var1, RerankingSettings var2) throws Exception;

    default public boolean supportsStream() {
        return false;
    }

    default public void streamComplete(SingleCompletionQuery query, CompletionSettings settings, StreamedCompletionResponseConsumer consumer) throws Exception {
        throw new UnsupportedOperationException("Streaming not supported on LLM: " + String.valueOf(this.getClass()));
    }

    default public ImageGenerationResponse generateImages(ImageGenerationQuery query) throws Exception {
        throw new UnsupportedOperationException("Image generation not supported on LLM: " + String.valueOf(this.getClass()));
    }

    public ComputeResourceUsage getTotalCRU(ComputeResourceUsage.LLMUsageType var1, LLMStructuredRef var2);

    public EnrichedLLMStructuredRef getEnrichedRef() throws Exception;

    default public RemoteFineTuningClient newFineTuningClient() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Fine-tuning is not supported on this LLM: " + String.valueOf(this.getClass()));
    }

    default public ISavedModelDeployer newSavedModelDeployer(AuthCtx authCtx) throws UnsupportedOperationException, AzureMLUtils.AzureAuthenticationException, IOException, DKUSecurityException {
        throw new UnsupportedOperationException("Model deployment is not supported on this LLM: " + String.valueOf(this.getClass()));
    }

    public List<ChatMessage> getFormattedPrompt(List<ChatMessage> var1);

    default public SmartLogTail getKernelLog() throws Exception {
        return null;
    }

    public static JSONRedactor.RedactionConfig inputRedactionConfig() {
        String additionalPatternsStr;
        JSONRedactor.RedactionConfigBuilder builder = JSONRedactor.configBuilder();
        builder.withRedactedKey("dkuCallerTicket");
        String additionalKeysStr = DKUApp.getParams().getParam("dku.agents.redactionConfig.additionalKeys");
        if (additionalKeysStr != null) {
            JSON.StringList additionalKeys = (JSON.StringList)JSON.parse((String)additionalKeysStr, JSON.StringList.class);
            additionalKeys.forEach(arg_0 -> ((JSONRedactor.RedactionConfigBuilder)builder).withRedactedKey(arg_0));
        }
        if ((additionalPatternsStr = DKUApp.getParams().getParam("dku.agents.redactionConfig.additionalPatterns")) != null) {
            JSON.StringList additionalPatterns = (JSON.StringList)JSON.parse((String)additionalPatternsStr, JSON.StringList.class);
            additionalPatterns.forEach(arg_0 -> ((JSONRedactor.RedactionConfigBuilder)builder).withRedactedKeyPattern(arg_0));
        }
        return builder.build();
    }

    @RoutinelyUsedInExtensionCode
    public static class RefusalException
    extends LLMException {
        public RefusalException(String message) {
            super(message);
        }
    }

    @RoutinelyUsedInExtensionCode
    public static class LLMException
    extends RuntimeException {
        public Integer promptTokens;
        public Integer completionTokens;
        public Integer totalTokens;
        public Double estimatedCost;

        public LLMException(String message) {
            super(message);
        }

        public void includeInUsageData(ComputeResourceUsage.InternalLLMUsageData usageData, long elapsedTime) {
            usageData.incrementTotalComputationTimeMS(Long.valueOf(elapsedTime));
            usageData.incrementTotalPromptTokens(this.promptTokens);
            usageData.incrementTotalCompletionTokens(this.completionTokens);
            usageData.incrementEstimatedCostUSD(this.estimatedCost);
        }
    }

    public static class SingleRerankingResponseOrError
    extends SingleRerankingResponse {
        public boolean ok;
        public String errorMessage;

        private SingleRerankingResponseOrError() {
        }

        public static SingleRerankingResponseOrError fromSuccess(SingleRerankingResponse origResp) {
            if (origResp instanceof SingleRerankingResponseOrError) {
                return (SingleRerankingResponseOrError)origResp;
            }
            SingleRerankingResponseOrError resp = new SingleRerankingResponseOrError();
            resp.ok = true;
            resp.documents = origResp.documents;
            resp.estimatedCost = origResp.estimatedCost;
            resp.trace = origResp.trace;
            return resp;
        }

        public static SingleRerankingResponseOrError fromError(Throwable e) {
            SingleRerankingResponseOrError resp = new SingleRerankingResponseOrError();
            resp.ok = false;
            resp.errorMessage = ExceptionUtils.getMessageWithCauses((Throwable)e);
            return resp;
        }
    }

    public static class RerankedDocument {
        int index;
        float relevanceScore;

        public RerankedDocument(int index, float relevanceScore) {
            this.index = index;
            this.relevanceScore = relevanceScore;
        }
    }

    @PyModel
    public static class SingleRerankingResponse {
        public LLMMeshTraceSpan trace;
        public TotalUsage totalUsage;
        public double estimatedCost;
        public boolean fromCache;
        public List<RerankedDocument> documents = new ArrayList<RerankedDocument>();

        public void includeInUsageData(ComputeResourceUsage.InternalLLMUsageData usageData) {
            usageData.incrementEstimatedCostUSD(Double.valueOf(this.estimatedCost));
        }
    }

    public static class RerankingDocument {
        List<RerankingDocumentPart> parts = new ArrayList<RerankingDocumentPart>();

        public String getText() {
            return this.parts.stream().filter(RerankingDocumentPart::isText).map(part -> part.text).filter(StringUtils::isNotBlank).collect(Collectors.joining(System.lineSeparator()));
        }

        public RerankingDocument(List<RerankingDocumentPart> parts) {
            this.parts = parts;
        }
    }

    public static class RerankingDocumentPart {
        public RankingPartType type;
        public String text;

        public boolean isText() {
            return this.type == RankingPartType.TEXT;
        }
    }

    public static class RerankingQueryPart {
        public RankingPartType type;
        public String text;

        public boolean isText() {
            return this.type == RankingPartType.TEXT;
        }
    }

    public static enum RankingPartType {
        TEXT;

    }

    public static class RerankingSettings {
    }

    public static class RerankingQuery {
        public List<RerankingQueryPart> queryParts = new ArrayList<RerankingQueryPart>();
        public List<RerankingDocument> documents = new ArrayList<RerankingDocument>();

        public String getQueryText() {
            return this.queryParts.stream().filter(RerankingQueryPart::isText).map(part -> part.text).filter(StringUtils::isNotBlank).collect(Collectors.joining(System.lineSeparator()));
        }
    }

    public static class RerankingsRequest {
        public String llmId;
        public List<RerankingQuery> queries = new ArrayList<RerankingQuery>();
        public RerankingSettings settings = new RerankingSettings();
    }

    public static class ImageGenerationResponseOrError
    extends ImageGenerationResponse {
        public boolean ok;
        public String errorMessage;
        public transient JsonArray guardrailsAuditData;

        private ImageGenerationResponseOrError() {
        }

        public static ImageGenerationResponseOrError fromSuccess(ImageGenerationResponse origResp) {
            ImageGenerationResponseOrError resp = new ImageGenerationResponseOrError();
            resp.ok = true;
            resp.images = origResp.images;
            resp.estimatedCost = origResp.estimatedCost;
            resp.additionalInformation = origResp.additionalInformation;
            return resp;
        }

        public static ImageGenerationResponseOrError fromError(Throwable e) {
            ImageGenerationResponseOrError resp = new ImageGenerationResponseOrError();
            resp.ok = false;
            resp.errorMessage = ExceptionUtils.getMessageWithCauses((Throwable)e);
            return resp;
        }
    }

    @PyModel
    public static class ImageGenerationResponse {
        public List<ImageGenerationImage> images = new ArrayList<ImageGenerationImage>();
        public double estimatedCost;
        public JsonObject additionalInformation;
        public LLMMeshTraceSpan trace;
        public TotalUsage totalUsage;
        public transient ComputeResourceUsage cru = new ComputeResourceUsage();

        public ImageGenerationResponse audit(List<String> savedOutputImagePaths) {
            ImageGenerationResponse auditedResponse = (ImageGenerationResponse)JSON.deepCopy((Object)this);
            if (savedOutputImagePaths == null || savedOutputImagePaths.isEmpty()) {
                auditedResponse.images.forEach(image -> {
                    image.data = null;
                });
                return auditedResponse;
            }
            assert (savedOutputImagePaths.size() == auditedResponse.images.size()) : "There should be as many saved images as generated images";
            for (int i = 0; i < savedOutputImagePaths.size(); ++i) {
                ImageGenerationImage generation = auditedResponse.images.get(i);
                String savedImageOutput = savedOutputImagePaths.get(i);
                generation.data = null;
                generation.savedImagePath = savedImageOutput;
            }
            return auditedResponse;
        }
    }

    public static class ImageGenerationImage {
        public String data;
        public String savedImagePath;

        public ImageGenerationImage() {
        }

        public ImageGenerationImage(String data) {
            this.data = data;
        }
    }

    public static class ImageGenerationQuery {
        public String llmId;
        public List<ImageGenerationPrompt> prompts = new ArrayList<ImageGenerationPrompt>();
        public List<ImageGenerationPrompt> negativePrompts = new ArrayList<ImageGenerationPrompt>();
        public Integer nbImagesToGenerate;
        public Integer height;
        public Integer width;
        public String quality;
        public Integer seed;
        public String style;
        public Double fidelity;
        public ImageGenerationEditionMode originalImageEditionMode = ImageGenerationEditionMode.MASK_FREE;
        public String originalImage;
        public Double originalImageWeight;
        public String originalImagePath;
        public ImageGenerationMaskMode maskMode;
        public String maskImage;
        public String maskPrompt;
        public GuardrailsPipelineSettings guardrails;

        public String getConcatenatedPrompts() {
            if (this.prompts == null || this.prompts.isEmpty()) {
                return null;
            }
            return this.prompts.stream().map(p -> p.prompt).collect(Collectors.joining(" "));
        }

        public String getConcatenatedNegativePrompts() {
            if (this.negativePrompts == null || this.negativePrompts.isEmpty()) {
                return null;
            }
            return this.negativePrompts.stream().map(p -> p.prompt).collect(Collectors.joining(" "));
        }

        public void throwIfNullOriginalImageEditionMode() {
            if (this.originalImageEditionMode == null) {
                throw new IllegalArgumentException("Invalid image edition mode.");
            }
        }

        public ImageGenerationQuery audit(@Nullable String savedOriginalImagePath) {
            ImageGenerationQuery auditedQuery = (ImageGenerationQuery)JSON.deepCopy((Object)this);
            if (auditedQuery.originalImage != null) {
                auditedQuery.originalImage = "provided";
            }
            auditedQuery.originalImagePath = savedOriginalImagePath;
            return auditedQuery;
        }
    }

    public static enum ImageGenerationMaskMode {
        MASK_IMAGE_ALPHA,
        MASK_IMAGE_BLACK,
        ORIGINAL_IMAGE_ALPHA,
        TEXT;

    }

    public static enum ImageGenerationEditionMode {
        MASK_FREE,
        INPAINTING,
        OUTPAINTING,
        VARY,
        CONTROLNET_SKETCH,
        CONTROLNET_STRUCTURE;

    }

    @PyModel
    public static class ImageGenerationPrompt {
        public String prompt;
        public Double weight;
    }

    public static class StreamedCompletionResponseConsumerProxy
    implements StreamedCompletionResponseConsumer {
        private final StreamedCompletionResponseConsumer consumer;
        private final ExceptionUtils.ThrowingConsumer<StreamedCompletionResponseFooter, Exception> footerHook;

        public StreamedCompletionResponseConsumerProxy(StreamedCompletionResponseConsumer consumer, ExceptionUtils.ThrowingConsumer<StreamedCompletionResponseFooter, Exception> footerHook) {
            this.consumer = consumer;
            this.footerHook = footerHook;
        }

        @Override
        public void onStreamStarted() throws Exception {
            this.consumer.onStreamStarted();
        }

        @Override
        public void onStreamChunk(StreamedCompletionResponseChunk chunk) throws Exception {
            this.consumer.onStreamChunk(chunk);
        }

        @Override
        public void onStreamComplete(StreamedCompletionResponseFooter footer) throws Exception {
            this.footerHook.accept((Object)footer);
            this.consumer.onStreamComplete(footer);
        }
    }

    public static abstract class StreamedCompletionResponseFilter
    implements StreamedCompletionResponseConsumer {
        protected final StreamedCompletionResponseConsumer underlying;

        protected StreamedCompletionResponseFilter(StreamedCompletionResponseConsumer underlying) {
            this.underlying = underlying;
        }

        @Override
        public void onStreamStarted() throws Exception {
            this.underlying.onStreamStarted();
        }

        @Override
        public void onStreamComplete(StreamedCompletionResponseFooter footer) throws Exception {
            this.underlying.onStreamComplete(footer);
        }
    }

    public static interface StreamedCompletionResponseConsumer {
        public void onStreamStarted() throws Exception;

        public void onStreamChunk(StreamedCompletionResponseChunk var1) throws Exception;

        public void onStreamComplete(StreamedCompletionResponseFooter var1) throws Exception;
    }

    public static class StreamedCompletionResponseFooter {
        public final String type = "footer";
        public FinishReason finishReason = FinishReason.UNKNOWN;
        public Integer promptTokens;
        public Integer completionTokens;
        public Integer totalTokens;
        public Boolean tokenCountsAreEstimated;
        public Double estimatedCost;
        public JsonObject additionalInformation;
        public JsonObject contextUpsert;
        public LLMMeshTraceSpan trace;
        public TotalUsage totalUsage;
        public transient ComputeResourceUsage cru = new ComputeResourceUsage();

        public void includeInUsageData(ComputeResourceUsage.InternalLLMUsageData usageData, long elapsedTimeMS) {
            usageData.incrementTotalPromptTokens(this.promptTokens);
            usageData.incrementTotalCompletionTokens(this.completionTokens);
            usageData.incrementTotalComputationTimeMS(Long.valueOf(elapsedTimeMS));
            usageData.incrementEstimatedCostUSD(this.estimatedCost);
        }
    }

    public static class StreamedCompletionResponseChunk {
        public String type = "content";
        @Nullable
        public String text;
        @Nullable
        public List<Artifact> artifacts;
        @Nullable
        public List<DetailedLogProb> logProbs;
        @Nullable
        public List<AbstractToolCall> toolCalls;
        @Nullable
        public List<ToolValidationRequest> toolValidationRequests;
        @Nullable
        public MemoryFragment memoryFragment;
        @Nullable
        public String eventKind;
        @Nullable
        public JsonObject eventData = new JsonObject();

        public boolean isEmpty() {
            return !(this.text != null && !this.text.isEmpty() || this.toolCalls != null && !this.toolCalls.isEmpty() || this.artifacts != null && !this.artifacts.isEmpty() || this.memoryFragment != null || this.toolValidationRequests != null && !this.toolValidationRequests.isEmpty());
        }

        public static StreamedCompletionResponseChunk empty() {
            return new StreamedCompletionResponseChunk();
        }

        public static StreamedCompletionResponseChunk event(String eventKind, JsonObject eventData) {
            StreamedCompletionResponseChunk ret = new StreamedCompletionResponseChunk();
            ret.type = "event";
            ret.eventKind = eventKind;
            ret.eventData = eventData;
            return ret;
        }

        public static StreamedCompletionResponseChunk textContent(String content) {
            StreamedCompletionResponseChunk ret = new StreamedCompletionResponseChunk();
            ret.type = "content";
            ret.text = content;
            return ret;
        }
    }

    public static class SimpleEmbeddingResponseOrError
    extends SimpleEmbeddingResponse {
        public boolean ok;
        public String errorMessage;
        public transient JsonArray guardrailsAuditData;

        private SimpleEmbeddingResponseOrError() {
        }

        public static SimpleEmbeddingResponseOrError fromSuccess(SimpleEmbeddingResponse origResp) {
            SimpleEmbeddingResponseOrError resp = new SimpleEmbeddingResponseOrError();
            resp.ok = true;
            resp.embedding = origResp.embedding;
            resp.promptTokens = origResp.promptTokens;
            resp.tokenCountsAreEstimated = origResp.tokenCountsAreEstimated;
            resp.estimatedCost = origResp.estimatedCost;
            resp.additionalInformation = origResp.additionalInformation;
            resp.trace = origResp.trace;
            return resp;
        }

        public static SimpleEmbeddingResponseOrError fromError(Throwable e) {
            SimpleEmbeddingResponseOrError resp = new SimpleEmbeddingResponseOrError();
            resp.ok = false;
            resp.errorMessage = ExceptionUtils.getMessageWithCauses((Throwable)e);
            return resp;
        }

        @Override
        public void serializeToCache(DataOutputStream dos) throws IOException {
            super.serializeToCache(dos);
            dos.writeBoolean(this.ok);
            dos.writeBoolean(this.errorMessage != null);
            if (this.errorMessage != null) {
                dos.writeUTF(this.errorMessage);
            }
        }

        @Override
        public void deserializeFromCache(DataInputStream dis) throws IOException {
            super.deserializeFromCache(dis);
            this.ok = dis.readBoolean();
            if (dis.readBoolean()) {
                this.errorMessage = dis.readUTF();
            }
        }
    }

    @PyModel
    public static class SimpleEmbeddingResponse
    implements DKUEhcacheSerializer.WithCustomCacheSerializer {
        public double[] embedding;
        public Integer promptTokens;
        public Boolean tokenCountsAreEstimated;
        public boolean fromCache;
        public Double estimatedCost;
        public JsonObject additionalInformation;
        public LLMMeshTraceSpan trace;
        public TotalUsage totalUsage;
        public transient ComputeResourceUsage cru = new ComputeResourceUsage();

        @Override
        public void serializeToCache(DataOutputStream dos) throws IOException {
            dos.writeInt(this.embedding.length);
            for (double d : this.embedding) {
                dos.writeFloat((float)d);
            }
            if (this.promptTokens != null) {
                dos.writeInt(this.promptTokens);
            } else {
                dos.writeInt(-1);
            }
            if (this.tokenCountsAreEstimated != null) {
                dos.writeBoolean(this.tokenCountsAreEstimated);
            } else {
                dos.writeBoolean(false);
            }
            if (this.estimatedCost != null) {
                dos.writeDouble(this.estimatedCost);
            } else {
                dos.writeDouble(Double.NEGATIVE_INFINITY);
            }
            dos.writeBoolean(this.additionalInformation != null);
            if (this.additionalInformation != null) {
                dos.writeUTF(JSON.json((Object)this.additionalInformation));
            }
        }

        @Override
        public void deserializeFromCache(DataInputStream dis) throws IOException {
            int embeddingLength = dis.readInt();
            this.embedding = new double[embeddingLength];
            for (int i = 0; i < embeddingLength; ++i) {
                this.embedding[i] = dis.readFloat();
            }
            this.promptTokens = dis.readInt();
            if (this.promptTokens < 0) {
                this.promptTokens = null;
            }
            this.tokenCountsAreEstimated = dis.readBoolean();
            this.estimatedCost = dis.readDouble();
            if (Double.isInfinite(this.estimatedCost)) {
                this.estimatedCost = null;
            }
            if (dis.readBoolean()) {
                this.additionalInformation = (JsonObject)JSON.parse((String)dis.readUTF(), JsonObject.class);
            }
        }

        public void includeInUsageData(ComputeResourceUsage.InternalLLMUsageData usageData) {
            usageData.incrementTotalPromptTokens(this.promptTokens);
            usageData.incrementEstimatedCostUSD(this.estimatedCost);
        }
    }

    @PyModel
    public static enum LLMErrorType {
        REFUSAL,
        ERROR;

    }

    public static class SimpleCompletionResponseOrError
    extends SimpleCompletionResponse {
        public boolean ok;
        public LLMResponseErrorSource errorSource;
        public String errorCode;
        public LLMErrorType errorType;
        public String errorMessage;
        public transient JsonArray guardrailsAuditData;

        private SimpleCompletionResponseOrError() {
        }

        public static SimpleCompletionResponseOrError blank() {
            return new SimpleCompletionResponseOrError();
        }

        public static SimpleCompletionResponseOrError fromSuccess(SimpleCompletionResponse origResp) {
            SimpleCompletionResponseOrError resp = new SimpleCompletionResponseOrError();
            resp.ok = true;
            resp.text = origResp.text;
            resp.finishReason = origResp.finishReason;
            resp.logProbs = origResp.logProbs;
            resp.toolCalls = origResp.toolCalls;
            resp.toolValidationRequests = origResp.toolValidationRequests;
            resp.memoryFragment = origResp.memoryFragment;
            resp.sources = origResp.sources;
            resp.artifacts = origResp.artifacts;
            resp.predictedClass = origResp.predictedClass;
            resp.predictedClassProbas = origResp.predictedClassProbas;
            resp.promptTokens = origResp.promptTokens;
            resp.completionTokens = origResp.completionTokens;
            if (origResp.promptTokens != null || origResp.completionTokens != null) {
                resp.totalTokens = (origResp.promptTokens != null ? origResp.promptTokens : 0) + (origResp.completionTokens != null ? origResp.completionTokens : 0);
            }
            resp.tokenCountsAreEstimated = origResp.tokenCountsAreEstimated;
            resp.estimatedCost = origResp.estimatedCost;
            resp.additionalInformation = origResp.additionalInformation;
            resp.contextUpsert = origResp.contextUpsert;
            resp.reportedUsageMetadata = origResp.reportedUsageMetadata;
            resp.trace = origResp.trace;
            return resp;
        }

        public static SimpleCompletionResponseOrError fromError(Throwable t) {
            if (t instanceof GuardrailsPipelineRunner.LLMUsageEnforcerException) {
                SimpleCompletionResponseOrError ret = SimpleCompletionResponseOrError.fromError(t, ((GuardrailsPipelineRunner.LLMUsageEnforcerException)((Object)t)).errorSource);
                ret.errorCode = ((GuardrailsPipelineRunner.LLMUsageEnforcerException)((Object)t)).getCode().getCode();
                return ret;
            }
            return SimpleCompletionResponseOrError.fromError(t, null);
        }

        public static SimpleCompletionResponseOrError fromErrorWithTrace(Throwable t, LLMMeshTraceSpan trace) {
            SimpleCompletionResponseOrError ret = SimpleCompletionResponseOrError.fromError(t);
            ret.trace = trace;
            return ret;
        }

        /*
         * Enabled aggressive block sorting
         */
        public static SimpleCompletionResponseOrError fromError(Throwable t, LLMResponseErrorSource errorSource) {
            SimpleCompletionResponseOrError resp = new SimpleCompletionResponseOrError();
            resp.ok = false;
            resp.errorSource = errorSource;
            if (t instanceof RefusalException) {
                RefusalException refusal = (RefusalException)t;
                resp.promptTokens = refusal.promptTokens;
                resp.completionTokens = refusal.completionTokens;
                resp.totalTokens = refusal.totalTokens;
                resp.estimatedCost = refusal.estimatedCost;
                resp.errorType = LLMErrorType.REFUSAL;
                resp.errorMessage = refusal.getMessage();
                return resp;
            }
            if (t instanceof JavaBlockLink.RequestFailedException) {
                JavaBlockLink.RequestFailedException rfe = (JavaBlockLink.RequestFailedException)t;
                if (StringUtils.isNotBlank((String)rfe.pythonExceptionPath)) {
                    resp.errorMessage = "Python error " + rfe.pythonExceptionPath + ": " + ExceptionUtils.getMessageWithCauses((Throwable)t);
                    resp.errorType = LLMErrorType.ERROR;
                    return resp;
                }
            }
            resp.errorMessage = ExceptionUtils.getMessageWithCauses((Throwable)t);
            resp.errorType = LLMErrorType.ERROR;
            return resp;
        }

        public String getSafeForLoggingCopy() {
            int maxByteSize = 51200;
            SimpleCompletionResponseOrError responseCopy = (SimpleCompletionResponseOrError)JSON.deepCopy((Object)this);
            responseCopy.trace = null;
            int currentSizeBytes = JSON.json((Object)responseCopy).getBytes().length;
            if (currentSizeBytes > maxByteSize) {
                JsonObject responseAsJson = JSON.toJsonObject((Object)responseCopy, (String[])new String[0]);
                String redactedMessage = "too big to be included in log";
                if (responseCopy.additionalInformation != null && responseCopy.additionalInformation.size() > 0) {
                    responseCopy.additionalInformation = null;
                    responseAsJson.addProperty("additionalInformation", redactedMessage);
                }
                if (responseCopy.artifacts != null && !responseCopy.artifacts.isEmpty()) {
                    responseCopy.artifacts = null;
                    responseAsJson.addProperty("artifacts", redactedMessage);
                }
                if (responseCopy.memoryFragment != null && !responseCopy.memoryFragment.isEmpty()) {
                    responseCopy.memoryFragment = null;
                    responseAsJson.addProperty("memoryFragment", redactedMessage);
                }
                if (responseCopy.sources != null && !responseCopy.sources.isEmpty()) {
                    responseCopy.sources = null;
                    responseAsJson.addProperty("sources", redactedMessage);
                }
                if (!StringUtils.isEmpty((String)responseCopy.text)) {
                    responseCopy.text = null;
                    responseAsJson.addProperty("text", redactedMessage);
                }
                if (responseCopy.toolCalls != null && !responseCopy.toolCalls.isEmpty()) {
                    responseCopy.toolCalls = null;
                    responseAsJson.addProperty("toolCalls", redactedMessage);
                }
                if (JSON.json((Object)responseCopy).getBytes().length > maxByteSize) {
                    return "Completion response is too big to be included in log";
                }
                return responseAsJson.toString();
            }
            return JSON.json((Object)responseCopy);
        }
    }

    public static class ImageRefExcerpt {
        String fullFolderId;
        String path;

        public ImageRefExcerpt() {
        }

        public ImageRefExcerpt(String fullFolderId, String path) {
            this.fullFolderId = fullFolderId;
            this.path = path;
        }
    }

    public static class ImagesRefExcerpt
    extends Excerpt {
        List<ImageRefExcerpt> images;

        public ImagesRefExcerpt() {
            this.type = Excerpt.Type.IMAGE_REF;
        }
    }

    public static class TextExcerpt
    extends Excerpt {
        String text;

        public TextExcerpt() {
            this.type = Excerpt.Type.TEXT;
        }
    }

    @PolyJSON(value={@Mapping(value=TextExcerpt.class, type="TEXT"), @Mapping(value=ImagesRefExcerpt.class, type="IMAGE_REF")}, enumClass=Type.class)
    public static abstract class Excerpt {
        Type type;

        public static enum Type {
            TEXT,
            IMAGE_REF;

        }
    }

    public static class MemoryFragment {
        public List<ChatMessage> messages = new ArrayList<ChatMessage>();
        @Nullable
        public Integer agentLoopIteration;
        @Nullable
        public List<AgentToolRunner.Source> stashedSources;
        @Nullable
        public JsonObject llmReasoning;
        @Nullable
        public JsonObject data;

        public MemoryFragment() {
        }

        public MemoryFragment(MemoryFragment other) {
            this.agentLoopIteration = other.agentLoopIteration;
            this.llmReasoning = (JsonObject)JSON.deepCopy((Object)other.llmReasoning);
            this.data = (JsonObject)JSON.deepCopy((Object)other.data);
            this.messages = other.messages.stream().map(ChatMessage::new).toList();
            if (other.stashedSources != null) {
                this.stashedSources = other.stashedSources.stream().map(JSON::deepCopy).toList();
            }
        }

        public boolean isEmpty() {
            return !(this.messages != null && !this.messages.isEmpty() || this.llmReasoning != null && this.llmReasoning.size() != 0 || this.data != null && this.data.size() != 0 || this.stashedSources != null && !this.stashedSources.isEmpty() || this.agentLoopIteration != null);
        }
    }

    public static class Artifact {
        public String id;
        public String type;
        public String name;
        public String description;
        public List<HierarchyEntry> hierarchy = new ArrayList<HierarchyEntry>();
        public List<SourceItem> parts = new ArrayList<SourceItem>();

        public Artifact duplicateWithoutParts() {
            Artifact duplicatedArtifact = new Artifact();
            duplicatedArtifact.id = this.id;
            duplicatedArtifact.type = this.type;
            duplicatedArtifact.name = this.name;
            duplicatedArtifact.description = this.description;
            return duplicatedArtifact;
        }
    }

    public static class ToolHierarchyEntry
    extends HierarchyEntry {
        public String toolRef;
        public String toolName;
        public String toolCallId;

        @Override
        public ToolHierarchyEntry copy() {
            ToolHierarchyEntry entry = new ToolHierarchyEntry();
            entry.toolRef = this.toolRef;
            entry.toolName = this.toolName;
            entry.toolCallId = this.toolCallId;
            return entry;
        }
    }

    public static class AgentHierarchyEntry
    extends HierarchyEntry {
        public String agentId;
        public String agentName;
        @Nullable
        public Integer agentLoopIteration;

        @Override
        public AgentHierarchyEntry copy() {
            AgentHierarchyEntry entry = new AgentHierarchyEntry();
            entry.agentId = this.agentId;
            entry.agentName = this.agentName;
            entry.agentLoopIteration = this.agentLoopIteration;
            return entry;
        }
    }

    @PolyJSON(value={@Mapping(value=AgentHierarchyEntry.class, type="AGENT"), @Mapping(value=ToolHierarchyEntry.class, type="TOOL")})
    public static abstract class HierarchyEntry {
        public abstract HierarchyEntry copy();
    }

    @PyModel
    public static class SourceItem {
        public String type;
        public Integer index;
        public JsonObject metadata;
        public JsonObject customData;
        public String performedQuery;
        public SourceRecords records;
        public FileRef fileRef;
        public List<ImageRef> imageRefs;
        public String title;
        public String url;
        public String thumbnailInlineB64;
        public String thumbnailURL;
        public Integer thumbnailW;
        public Integer thumbnailH;
        public String textSnippet;
        public String markdownSnippet;
        public String htmlSnippet;
        public String jsonSnippet;
        public String filename;
        public String mimeType;
        public String dataBase64;
        public String text;

        public void aggregate(SourceItem chunk) {
            if (!this.canBeAggregated()) {
                return;
            }
            this.text = this.text + chunk.text;
        }

        public boolean canBeAggregated() {
            return this.index != null && streamableSourceItemTypes.contains(this.type);
        }
    }

    public static class DocumentPageRange {
        public int start;
        public int end;
    }

    public static class FileRef {
        public String folderId;
        public String path;
        public DocumentPageRange pageRange;
        public List<String> sectionOutline;
    }

    public static class ImageRef {
        public String folderId;
        public String path;
    }

    public static class SourceRecords {
        public List<String> columns;
        public List<List<JsonElement>> data;
    }

    @PyModel
    @Deprecated(forRemoval=true)
    public static class Source {
        Excerpt excerpt;
        Map<String, String> metadata;
    }

    public static class DetailedLogProb
    extends SimpleLogProb {
        @Nullable
        public List<SimpleLogProb> topLogProbs;
    }

    public static class SimpleLogProb {
        public String token;
        public double logProb;
    }

    public static enum LLMResponseErrorSource {
        QUERY_FORBIDDEN_TERMS,
        QUERY_PII_DETECTION,
        QUERY_TOXICITY_DETECTION,
        QUERY_PROMPT_INJECTION_DETECTION,
        QUERY_CUSTOM_HOOK,
        LLM,
        GUARDRAIL,
        RESPONSE_FORBIDDEN_TERMS,
        RESPONSE_TOXICITY_DETECTION,
        RESPONSE_CUSTOM_HOOK;

    }

    @PyModel
    public static class SimpleCompletionResponse
    extends UsageMetadata {
        @Nullable
        public String text;
        public FinishReason finishReason = FinishReason.UNKNOWN;
        @Nullable
        public List<DetailedLogProb> logProbs;
        @Nullable
        public List<AbstractToolCall> toolCalls;
        @Nullable
        public List<ToolValidationRequest> toolValidationRequests;
        @Nullable
        public MemoryFragment memoryFragment;
        @Nullable
        @Deprecated
        public List<Source> sources;
        public List<Artifact> artifacts;
        public String predictedClass;
        public List<PredictedClassProba> predictedClassProbas = new ArrayList<PredictedClassProba>();
        public boolean fromCache;
        @Nullable
        public JsonObject additionalInformation;
        @Nullable
        public JsonObject contextUpsert;
        public UsageMetadata reportedUsageMetadata;
        public LLMMeshTraceSpan trace;
        public TotalUsage totalUsage;
        public SmartLogTail log;
        public transient ComputeResourceUsage cru = new ComputeResourceUsage();

        public void includeInUsageData(ComputeResourceUsage.InternalLLMUsageData usageData, long elapsedTimeMS) {
            this.includeInUsageData(usageData);
            usageData.incrementTotalComputationTimeMS(Long.valueOf(elapsedTimeMS));
        }

        public void includeInUsageData(ComputeResourceUsage.InternalLLMUsageData usageData) {
            usageData.incrementTotalPromptTokens(this.promptTokens);
            usageData.incrementTotalCompletionTokens(this.completionTokens);
            usageData.incrementEstimatedCostUSD(this.estimatedCost);
        }
    }

    @RoutinelyUsedInExtensionCode
    public static enum FinishReason {
        STOP,
        LENGTH,
        CONTENT_FILTER,
        TOOL_CALLS,
        TOOL_VALIDATION_REQUESTS,
        UNKNOWN;


        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }

    public static class LLMMeshTraceEvent
    extends LLMMeshTraceObservation {
        public String timestamp;

        public static LLMMeshTraceEvent mark(String subtype) {
            LLMMeshTraceEvent ret = new LLMMeshTraceEvent();
            ret.type = "event";
            ret.name = subtype;
            ret.timestamp = DKUDateUtils.isoFormatUTCNow();
            return ret;
        }
    }

    public static class LLMMeshTraceSpan
    extends LLMMeshTraceObservation
    implements AutoCloseable {
        public String begin;
        public String end;
        private transient long _begin;
        public Long duration;
        public UsageMetadata usageMetadata;

        private LLMMeshTraceSpan() {
        }

        public static LLMMeshTraceSpan newNotStarted() {
            LLMMeshTraceSpan ret = new LLMMeshTraceSpan();
            ret.type = "span";
            return ret;
        }

        public static LLMMeshTraceSpan start(String name) {
            LLMMeshTraceSpan ret = LLMMeshTraceSpan.newNotStarted();
            ret.name = name;
            ret.start();
            return ret;
        }

        public void start() {
            this._begin = System.currentTimeMillis();
            this.begin = DKUDateUtils.isoFormatUTC((long)this._begin);
        }

        @Override
        public void close() {
            long _end = System.currentTimeMillis();
            this.duration = _end - this._begin;
            this.end = DKUDateUtils.isoFormatUTC((long)_end);
        }
    }

    @PolyJSON(value={@Mapping(value=LLMMeshTraceEvent.class, type="event"), @Mapping(value=LLMMeshTraceSpan.class, type="span")})
    public static abstract class LLMMeshTraceObservation {
        public String type;
        public String name;
        public List<LLMMeshTraceObservation> children = new ArrayList<LLMMeshTraceObservation>();
        public JsonObject attributes = new JsonObject();
        @Nullable
        public JsonObject inputs;
        @Nullable
        public JsonObject outputs;

        public LLMMeshTraceSpan withChildSpan(String subtype) {
            LLMMeshTraceSpan ret = LLMMeshTraceSpan.start(subtype);
            this.addObservation(ret);
            return ret;
        }

        public LLMMeshTraceEvent withChildEvent(String name) {
            LLMMeshTraceEvent ret = LLMMeshTraceEvent.mark(name);
            this.addObservation(ret);
            return ret;
        }

        public void addObservation(LLMMeshTraceObservation observation) {
            this.children.add(observation);
        }

        public void setInputs(JsonObject inputs) {
            this.inputs = inputs;
        }

        public void setInput(String key, Object value) {
            if (this.inputs == null) {
                this.inputs = new JsonObject();
            }
            if (value instanceof String) {
                this.inputs.addProperty(key, (String)value);
            } else if (value instanceof JsonObject) {
                this.inputs.add(key, (JsonElement)((JsonObject)value));
            } else if (value instanceof JsonArray) {
                this.inputs.add(key, (JsonElement)((JsonArray)value));
            } else if (value instanceof Collection) {
                this.inputs.add(key, (JsonElement)JSON.toJsonArray((Object)value));
            } else {
                this.inputs.add(key, (JsonElement)JSON.toJsonObject((Object)value, (String[])new String[0]));
            }
        }

        public void setCompletionLLMInput(SingleCompletionQuery query) {
            JsonArray msgs = new JsonArray();
            for (ChatMessage msg : query.messages) {
                JF.ObjectBuilder ob = JF.obj();
                if (msg.isTextOnly()) {
                    ob.with("role", msg.role).with("text", msg.getTextEvenIfNotTextOnly());
                } else {
                    ob.with("role", msg.role).with("content", "non-text-only-message");
                }
                if (msg.memoryFragment != null) {
                    ob.with("memoryFragment", (JsonElement)JSON.toJsonObject((Object)msg.memoryFragment, (String[])new String[0]));
                }
                if (msg.toolCalls != null && msg.toolCalls.size() > 0) {
                    ob.with("toolCalls", (JsonElement)JSON.toJsonArray(msg.toolCalls));
                }
                if (msg.toolValidationRequests != null && !msg.toolValidationRequests.isEmpty()) {
                    ob.with("toolValidationRequests", (JsonElement)JSON.toJsonArray(msg.toolValidationRequests));
                }
                if (msg.toolValidationResponses != null && !msg.toolValidationResponses.isEmpty()) {
                    ob.with("toolValidationResponses", (JsonElement)JSON.toJsonArray(msg.toolValidationResponses));
                }
                if (msg.toolOutputs != null && msg.toolOutputs.size() > 0) {
                    ob.with("toolOutputs", (JsonElement)JSON.toJsonArray(msg.toolOutputs));
                }
                msgs.add((JsonElement)ob.get());
            }
            this.setInput("messages", msgs);
        }

        public void setEmbeddingLLMInput(EmbeddingQuery query) {
            if (query.hasText()) {
                this.setInput("text", query.text);
            }
        }

        public void setRerankingLLMInput(RerankingQuery query) {
            this.setInput("query", JSON.toJsonObject((Object)query, (String[])new String[0]));
        }

        public void setToolInput(AgentToolRunner.AgentToolInput input) {
            this.setInput("input", input.input);
        }

        public void setLLMOutput(SimpleCompletionResponseOrError scror) {
            this.outputs = new JsonObject();
            if (StringUtils.isNotBlank((String)scror.text)) {
                this.outputs.addProperty("text", scror.text);
            }
            if (scror.toolCalls != null && scror.toolCalls.size() > 0) {
                this.outputs.add("toolCalls", (JsonElement)JSON.toJsonArray((Object)scror.toolCalls));
            }
            if (scror.toolValidationRequests != null && !scror.toolValidationRequests.isEmpty()) {
                this.outputs.add("toolValidationRequests", (JsonElement)JSON.toJsonArray((Object)scror.toolValidationRequests));
            }
            if (scror.memoryFragment != null) {
                this.outputs.add("memoryFragment", (JsonElement)JSON.toJsonObject((Object)scror.memoryFragment, (String[])new String[0]));
            }
        }

        public void setToolOutput(AgentToolRunner.AgentToolOutput output) {
            this.outputs = new JsonObject();
            if (output.output != null) {
                this.outputs.add("output", output.output);
            }
            if (StringUtils.isNotBlank((String)output.error)) {
                this.outputs.addProperty("error", output.error);
            }
            if (!output.sources.isEmpty()) {
                int maxNumSources = DKUApp.getParams().getIntParam("dku.agents.trace.maxSourcesCount", Integer.valueOf(1000));
                int maxSourceBytes = DKUApp.getParams().getIntParam("dku.agents.trace.maxSourceSizeBytes", Integer.valueOf(51200));
                JsonArray traceSources = new JsonArray();
                if (output.sources.size() > maxNumSources) {
                    traceSources.add(this.createTooManySourcesMessage(output.sources.get(0), output.sources.size(), maxNumSources));
                } else {
                    for (AgentToolRunner.Source source : output.sources) {
                        traceSources.add(this.removeSourceIfTooLarge(source, maxSourceBytes));
                    }
                }
                this.outputs.add("sources", (JsonElement)traceSources);
            }
            if (!output.artifacts.isEmpty()) {
                int maxNumArtifacts = DKUApp.getParams().getIntParam("dku.agents.trace.maxArtifactsCount", Integer.valueOf(1000));
                int maxArtifactBytes = DKUApp.getParams().getIntParam("dku.agents.trace.maxArtifactSizeBytes", Integer.valueOf(51200));
                JsonArray traceArtifacts = new JsonArray();
                if (output.artifacts.size() > maxNumArtifacts) {
                    traceArtifacts.add(this.createTooManyArtifactsMessage(output.artifacts.get(0), output.artifacts.size(), maxNumArtifacts));
                } else {
                    for (Artifact artifact : output.artifacts) {
                        traceArtifacts.add(this.removeArtifactIfTooLarge(artifact, maxArtifactBytes));
                    }
                }
                this.outputs.add("artifacts", (JsonElement)traceArtifacts);
            }
        }

        private JsonElement removeSourceIfTooLarge(AgentToolRunner.Source source, int maxBytes) {
            int sourceSizeBytes = JSON.json((Object)source).getBytes().length;
            if (sourceSizeBytes > maxBytes) {
                String originalSourceType = "UNKNOWN";
                if (!source.items.isEmpty()) {
                    originalSourceType = source.items.get((int)0).type;
                }
                AgentToolRunner.Source truncatedSource = source.duplicateWithoutItems();
                SourceItem part = new SourceItem();
                part.type = "REMOVED_SOURCE";
                part.text = String.format("%dB source of type %s removed from the trace", sourceSizeBytes, originalSourceType);
                truncatedSource.items.add(part);
                source = truncatedSource;
            }
            return JSON.toJsonElement((Object)source);
        }

        private JsonElement removeArtifactIfTooLarge(Artifact artifact, int maxBytes) {
            int artifactSizeBytes = JSON.json((Object)artifact).getBytes().length;
            if (artifactSizeBytes > maxBytes) {
                String originalArtifactType = "UNKNOWN";
                if (StringUtils.isNotBlank((String)artifact.type)) {
                    originalArtifactType = artifact.type;
                }
                Artifact truncatedArtifact = artifact.duplicateWithoutParts();
                truncatedArtifact.type = "REMOVED_ARTIFACT";
                SourceItem part = new SourceItem();
                part.type = "TEXT";
                part.text = String.format("%dB artifact of type %s removed from the trace", artifactSizeBytes, originalArtifactType);
                truncatedArtifact.parts.add(part);
                artifact = truncatedArtifact;
            }
            return JSON.toJsonElement((Object)artifact);
        }

        private JsonElement createTooManySourcesMessage(AgentToolRunner.Source source, int numSources, int maxNumSources) {
            AgentToolRunner.Source newSource = source.duplicateWithoutItems();
            SourceItem part = new SourceItem();
            part.type = "REMOVED_SOURCE";
            part.text = String.format("%d sources removed from the trace (max number of sources in one trace node is %d)", numSources, maxNumSources);
            newSource.items.add(part);
            return JSON.toJsonElement((Object)newSource);
        }

        private JsonElement createTooManyArtifactsMessage(Artifact artifact, int numArtifacts, int maxNumArtifacts) {
            Artifact newArtifact = artifact.duplicateWithoutParts();
            newArtifact.type = "REMOVED_ARTIFACT";
            SourceItem part = new SourceItem();
            part.type = "TEXT";
            part.text = String.format("%d artifacts removed from the trace (max number of artifacts in one trace node is %d)", numArtifacts, maxNumArtifacts);
            newArtifact.parts.add(part);
            return JSON.toJsonElement((Object)newArtifact);
        }
    }

    public static class TotalUsage {
        public Integer promptTokens;
        public Integer completionTokens;
        public Integer totalTokens;
        public Double estimatedCost;
        public Integer images;
        public Integer llmMeshCalls;
        public Integer llmCacheHits;
        public Map<TotalUsageSpanType, TotalUsage> details;

        public TotalUsage() {
        }

        public TotalUsage(TotalUsage that) {
            this.promptTokens = that.promptTokens;
            this.completionTokens = that.completionTokens;
            this.totalTokens = that.totalTokens;
            this.estimatedCost = that.estimatedCost;
            this.images = that.images;
            this.llmMeshCalls = that.llmMeshCalls;
            this.llmCacheHits = that.llmCacheHits;
            if (that.details != null && !that.details.isEmpty()) {
                this.details = new HashMap<TotalUsageSpanType, TotalUsage>();
                for (Map.Entry<TotalUsageSpanType, TotalUsage> entry : that.details.entrySet()) {
                    this.details.put(entry.getKey(), new TotalUsage(entry.getValue()));
                }
            }
        }

        public void aggregate(TotalUsage that) {
            this.promptTokens = TotalUsage.safeAdd(this.promptTokens, that.promptTokens);
            this.completionTokens = TotalUsage.safeAdd(this.completionTokens, that.completionTokens);
            this.totalTokens = TotalUsage.safeAdd(this.totalTokens, that.totalTokens);
            this.estimatedCost = TotalUsage.safeAdd(this.estimatedCost, that.estimatedCost);
            this.images = TotalUsage.safeAdd(this.images, that.images);
            this.llmMeshCalls = TotalUsage.safeAdd(this.llmMeshCalls, that.llmMeshCalls);
            this.llmCacheHits = TotalUsage.safeAdd(this.llmCacheHits, that.llmCacheHits);
            if (that.details != null) {
                if (this.details == null) {
                    this.details = new HashMap<TotalUsageSpanType, TotalUsage>();
                }
                for (Map.Entry<TotalUsageSpanType, TotalUsage> entry : that.details.entrySet()) {
                    TotalUsage existingValue = this.details.computeIfAbsent(entry.getKey(), k -> new TotalUsage());
                    existingValue.aggregate(entry.getValue());
                }
            }
        }

        protected static Integer safeAdd(Integer a, Integer b) {
            if (a == null) {
                return b;
            }
            if (b == null) {
                return a;
            }
            return a + b;
        }

        protected static Double safeAdd(Double a, Double b) {
            if (a == null) {
                return b;
            }
            if (b == null) {
                return a;
            }
            return a + b;
        }
    }

    public static enum TotalUsagePriority {
        LOW,
        HIGH;

    }

    public static enum TotalUsageSpanType {
        COMPLETION(TotalUsagePriority.LOW, Set.of("DKU_LLM_MESH_COMPLETION_QUERY", "DKU_LLM_MESH_COMPLETION_QUERY_STREAMED")),
        IMAGE_GENERATION(TotalUsagePriority.LOW, Set.of("DKU_LLM_MESH_IMAGE_GENERATION_QUERY")),
        EMBEDDING(TotalUsagePriority.LOW, Set.of("DKU_LLM_MESH_EMBEDDING_QUERY")),
        RERANKING(TotalUsagePriority.LOW, Set.of("DKU_LLM_MESH_RERANKING_QUERY")),
        GUARDRAIL(TotalUsagePriority.HIGH, Set.of("DKU_LLM_MESH_QUERY_ENFORCEMENT", "DKU_LLM_MESH_RESPONSE_ENFORCEMENT"));

        public static final Set<String> CALL_SPAN_NAMES;
        public static final String CACHE_HIT_SPAN_NAME = "DKU_LLM_MESH_CACHE_HIT";
        public final TotalUsagePriority priority;
        public final Set<String> spanNames;

        public static TotalUsageSpanType from(LLMMeshTraceObservation observation) {
            for (TotalUsageSpanType spanType : TotalUsageSpanType.values()) {
                if (!spanType.spanNames.contains(observation.name)) continue;
                return spanType;
            }
            return null;
        }

        private TotalUsageSpanType(TotalUsagePriority priority, Set<String> spanNames) {
            this.priority = priority;
            this.spanNames = spanNames;
        }

        static {
            CALL_SPAN_NAMES = Set.of("DKU_LLM_MESH_LLM_CALL", "DKU_LLM_MESH_LLM_CALL_STREAMED");
        }
    }

    public static class UsageMetadata {
        public Integer promptTokens;
        public Integer completionTokens;
        public Integer totalTokens;
        public Boolean tokenCountsAreEstimated;
        public Double estimatedCost;
        public Integer images;

        public UsageMetadata() {
        }

        public UsageMetadata(SimpleCompletionResponse r) {
            this.promptTokens = r.promptTokens;
            this.completionTokens = r.completionTokens;
            this.totalTokens = r.totalTokens;
            this.tokenCountsAreEstimated = r.tokenCountsAreEstimated;
            this.estimatedCost = r.estimatedCost;
        }

        public UsageMetadata(StreamedCompletionResponseFooter f) {
            this.promptTokens = f.promptTokens;
            this.completionTokens = f.completionTokens;
            this.totalTokens = f.totalTokens;
            this.tokenCountsAreEstimated = f.tokenCountsAreEstimated;
            this.estimatedCost = f.estimatedCost;
        }

        public UsageMetadata(SimpleEmbeddingResponse r) {
            this.promptTokens = r.promptTokens;
            this.totalTokens = r.promptTokens;
            this.tokenCountsAreEstimated = r.tokenCountsAreEstimated;
            this.estimatedCost = r.estimatedCost;
        }

        public UsageMetadata(ImageGenerationResponse r) {
            this.estimatedCost = r.estimatedCost;
            this.images = r.images.size();
        }

        public UsageMetadata(LLMException exception) {
            this.estimatedCost = exception.estimatedCost;
        }

        public UsageMetadata(SingleRerankingResponse r) {
            this.estimatedCost = r.estimatedCost;
        }
    }

    public static class PredictedClassProba {
        public String className;
        public double proba;
    }

    public static enum TextOverflowMode {
        TRUNCATE,
        FAIL;

    }

    public static enum EmbeddingType {
        TEXT,
        IMAGE;


        public AbstractLLMConnection.QueryType getQueryType() {
            switch (this) {
                case TEXT: {
                    return AbstractLLMConnection.QueryType.textEmbedding;
                }
                case IMAGE: {
                    return AbstractLLMConnection.QueryType.imageEmbedding;
                }
            }
            throw new RuntimeException("Unreachable");
        }
    }

    public static class EmbeddingSettings {
        public TextOverflowMode textOverflowMode = TextOverflowMode.TRUNCATE;
    }

    public static class EmbeddingQuery {
        @Nullable
        public String text;
        @Nullable
        public String inlineImage;

        public boolean hasImage() {
            return this.inlineImage != null;
        }

        public boolean hasText() {
            return this.text != null;
        }

        public EmbeddingQuery getSafeForLoggingCopy() {
            int limit = 50;
            if (this.inlineImage == null || this.inlineImage.length() <= 50) {
                return this;
            }
            EmbeddingQuery queryCopy = (EmbeddingQuery)JSON.deepCopy((Object)this);
            queryCopy.inlineImage = StringUtils.substring((String)queryCopy.inlineImage, (int)0, (int)50) + "... (truncated)";
            return queryCopy;
        }
    }

    @PyModel
    public static class ChatMessage {
        public static final String PARTS_JOINING_SEPARATOR = "\n";
        public String role;
        @Nullable
        private String content;
        @Nullable
        public Boolean partOfExample;
        @Nullable
        public List<ChatMessagePart> parts;
        @Nullable
        public List<ToolOutput> toolOutputs;
        @Nullable
        public List<AbstractToolCall> toolCalls;
        @Nullable
        public List<ToolValidationRequest> toolValidationRequests;
        @Nullable
        public List<ToolValidationResponse> toolValidationResponses;
        @Nullable
        public MemoryFragment memoryFragment;
        @Nullable
        public HierarchyEntry memoryFragmentTarget;

        public ChatMessage() {
        }

        public ChatMessage(String role, String content) {
            this.role = role;
            this.content = content;
        }

        public ChatMessage(ChatMessage other) {
            this.role = other.role;
            this.content = other.content;
            this.partOfExample = other.partOfExample;
            if (other.parts != null) {
                this.parts = other.parts.stream().map(ChatMessagePart::new).collect(Collectors.toList());
            }
            if (other.toolCalls != null) {
                this.toolCalls = other.toolCalls.stream().map(AbstractToolCall::copy).collect(Collectors.toList());
            }
            if (other.toolOutputs != null) {
                this.toolOutputs = other.toolOutputs.stream().map(ToolOutput::new).collect(Collectors.toList());
            }
            if (other.toolValidationRequests != null) {
                this.toolValidationRequests = other.toolValidationRequests.stream().map(ToolValidationRequest::new).toList();
            }
            if (other.toolValidationResponses != null) {
                this.toolValidationResponses = other.toolValidationResponses.stream().map(ToolValidationResponse::new).toList();
            }
            if (other.memoryFragment != null) {
                this.memoryFragment = new MemoryFragment(other.memoryFragment);
            }
            if (other.memoryFragmentTarget != null) {
                this.memoryFragmentTarget = other.memoryFragmentTarget.copy();
            }
        }

        public ChatMessage(String role, List<ChatMessagePart> parts) {
            this.role = role;
            this.parts = parts.stream().map(ChatMessagePart::new).collect(Collectors.toList());
        }

        public ChatMessage withIsPartOfExample() {
            this.partOfExample = true;
            return this;
        }

        public static ChatMessage wrapMemoryFragment(MemoryFragment memoryFragment, HierarchyEntry memoryFragmentTarget) {
            ChatMessage m = new ChatMessage();
            m.role = "memoryFragment";
            m.memoryFragment = memoryFragment;
            m.memoryFragmentTarget = memoryFragmentTarget;
            return m;
        }

        public boolean isTextOnly() {
            return this.parts == null || this.parts.stream().allMatch(p -> p.type == ChatMessagePartType.TEXT);
        }

        public String getText() {
            if (!this.isTextOnly()) {
                throw new IllegalArgumentException("This message is not text-only");
            }
            if (this.parts == null) {
                return this.content;
            }
            return this.parts.stream().map(p -> p.text).collect(Collectors.joining(PARTS_JOINING_SEPARATOR));
        }

        public String getTextEvenIfNotTextOnly() {
            if (this.parts == null) {
                return this.content;
            }
            return this.parts.stream().map(p -> p.text == null ? "" : p.text).collect(Collectors.joining(PARTS_JOINING_SEPARATOR));
        }

        public void setTextOnly(String text) {
            this.parts = null;
            this.content = text;
        }

        public void trimImageParts() {
            if (this.parts != null) {
                for (ChatMessagePart part : this.parts) {
                    part.trimImageData();
                }
            }
            if (this.toolOutputs != null) {
                for (ToolOutput toolOutput : this.toolOutputs) {
                    if (toolOutput.parts == null) continue;
                    for (ChatMessagePart chatMessagePart : toolOutput.parts) {
                        chatMessagePart.trimImageData();
                    }
                }
            }
        }
    }

    public static class FunctionToolCallInfo {
        @Nullable
        public String name;
        public String arguments;
    }

    @PyModel
    public static class FunctionToolCall
    extends AbstractToolCall {
        public FunctionToolCallInfo function;

        @Override
        public AbstractToolCall copy() {
            FunctionToolCall copy = new FunctionToolCall();
            copy.id = this.id;
            copy.index = this.index;
            copy.function = new FunctionToolCallInfo();
            copy.function.name = this.function.name;
            copy.function.arguments = this.function.arguments;
            copy.llmReasoning = (JsonObject)JSON.deepCopy((Object)this.llmReasoning);
            return copy;
        }
    }

    @PolyJSON(value={@Mapping(value=FunctionToolCall.class, type="function")})
    public static abstract class AbstractToolCall {
        @Nullable
        public String id;
        @Nullable
        public Integer index;
        @Nullable
        public JsonObject llmReasoning;

        public abstract AbstractToolCall copy();
    }

    public static class ToolValidationResponse {
        public String validationRequestId;
        public boolean validated;
        @Nullable
        public String arguments;

        public ToolValidationResponse() {
        }

        public ToolValidationResponse(ToolValidationResponse other) {
            this.validationRequestId = other.validationRequestId;
            this.validated = other.validated;
            this.arguments = other.arguments;
        }
    }

    public static class ToolValidationRequest {
        public String id;
        public List<HierarchyEntry> hierarchy = new ArrayList<HierarchyEntry>();
        public String blockId;
        public String message;
        public boolean allowEditingInputs;
        public String toolRef;
        public String toolName;
        public String toolType;
        public String toolDescription;
        public JsonSchema toolInputSchema;
        public AbstractToolCall toolCall;

        public ToolValidationRequest() {
        }

        public ToolValidationRequest(ToolValidationRequest other) {
            this.id = other.id;
            this.hierarchy = other.hierarchy.stream().map(HierarchyEntry::copy).toList();
            this.message = other.message;
            this.allowEditingInputs = other.allowEditingInputs;
            this.toolName = other.toolName;
            this.toolType = other.toolType;
            this.toolInputSchema = (JsonSchema)JSON.deepCopy((Object)other.toolInputSchema);
            if (other.toolCall != null) {
                this.toolCall = other.toolCall.copy();
            }
        }
    }

    public static class ToolOutputPart
    extends ChatMessagePart {
        @Nullable
        public String folderId;
        @Nullable
        public String path;

        public ToolOutputPart() {
        }

        public ToolOutputPart(ToolOutputPart other) {
            super(other);
            this.folderId = other.folderId;
            this.path = other.path;
        }

        public ChatMessagePart toInlineImage(AuthCtx authCtx) throws Exception {
            ManagedFolder mf;
            if (this.type != ChatMessagePartType.IMAGE_REF) {
                throw new UnsupportedOperationException("This part is not an image reference.");
            }
            if (this.folderId == null) {
                throw new IllegalArgumentException("folder ID must be set on image reference parts");
            }
            if (this.path == null) {
                throw new IllegalArgumentException("image path must be set on image reference parts");
            }
            AnyLoc loc = AnyLoc.resolveFull(this.folderId);
            TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
            ManagedFoldersService managedFoldersService = (ManagedFoldersService)SpringUtils.getBean(ManagedFoldersService.class);
            try (Transaction t = transactionService.beginRead();){
                AnyLoc managedFolderLoc = AnyLoc.resolveSmart(loc.getProjectKey(), loc.getId());
                mf = managedFoldersService.getMandatoryUnsafe(managedFolderLoc);
            }
            try (ManagedFolderHandler handler = (ManagedFolderHandler)mf.buildHandler(authCtx);){
                ChatMessagePart chatMessagePart;
                block22: {
                    Callable<InputStream> imageStream = () -> handler.getInputStream(this.path).rawStream();
                    InputStream img = imageStream.call();
                    try {
                        byte[] sourceBytes = IOUtils.toByteArray((InputStream)img);
                        MimeTypeUtils.MimeType fullMimeType = MimeTypeUtils.fromExtension((String)FilenameUtils.getExtension((String)this.path));
                        String mimeType = Optional.ofNullable(fullMimeType).map(obj -> obj.mimeType).orElse(null);
                        chatMessagePart = new ChatMessagePart().withInlineImage(Base64.getEncoder().encodeToString(sourceBytes), mimeType);
                        if (img == null) break block22;
                    }
                    catch (Throwable throwable) {
                        if (img != null) {
                            try {
                                img.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    img.close();
                }
                return chatMessagePart;
            }
        }
    }

    public static class ToolOutput {
        public String callId;
        public String output;
        @Nullable
        public List<ToolOutputPart> parts;

        public ToolOutput() {
        }

        public ToolOutput(ToolOutput other) {
            this.callId = other.callId;
            this.output = other.output;
            if (other.parts != null) {
                this.parts = other.parts.stream().map(ToolOutputPart::new).collect(Collectors.toList());
            }
        }
    }

    public static class Base64Image {
        public String base64Data;
        public String mimeType;

        public Base64Image(String base64Data, String mimeType) {
            this.base64Data = base64Data;
            this.mimeType = mimeType;
        }
    }

    public static class ChatMessagePart {
        public ChatMessagePartType type = ChatMessagePartType.TEXT;
        @Nullable
        public String text;
        @Nullable
        public String imageMimeType;
        @Nullable
        public String inlineImage;
        @Nullable
        public String imageUrl;
        private static final Pattern inlineImageMatcherPattern = Pattern.compile("^data:(image/[^;]+);base64,(.*)$");

        public ChatMessagePart() {
        }

        public ChatMessagePart(ChatMessagePart other) {
            this.type = other.type;
            this.text = other.text;
            this.imageMimeType = other.imageMimeType;
            this.inlineImage = other.inlineImage;
            this.imageUrl = other.imageUrl;
        }

        public ChatMessagePart withText(String text) {
            this.type = ChatMessagePartType.TEXT;
            this.text = text;
            return this;
        }

        public ChatMessagePart withInlineImageFromExtension(String inlineImage, @Nullable String extension) {
            MimeTypeUtils.MimeType mt = MimeTypeUtils.fromExtension((String)extension);
            String mimeType = Optional.ofNullable(mt).map(obj -> obj.mimeType).orElse(null);
            return this.withInlineImage(inlineImage, mimeType);
        }

        public ChatMessagePart withInlineImage(String inlineImage, @Nullable String mimeType) {
            this.type = ChatMessagePartType.IMAGE_INLINE;
            this.inlineImage = inlineImage;
            this.imageMimeType = mimeType;
            return this;
        }

        public boolean containsImageData() {
            switch (this.type) {
                case IMAGE_INLINE: {
                    return true;
                }
                case IMAGE_URI: {
                    return StringUtils.startsWith((String)this.imageUrl, (String)"data:");
                }
            }
            return false;
        }

        public String getImageData() {
            switch (this.type) {
                case IMAGE_INLINE: {
                    return this.inlineImage;
                }
                case IMAGE_URI: {
                    assert (StringUtils.startsWith((String)this.imageUrl, (String)"data:"));
                    return this.imageUrl.substring("data:".length());
                }
            }
            throw new UnsupportedOperationException("This chat message part contains no image.");
        }

        private static String truncate(String data) {
            int limit = 50;
            if (data == null || data.length() <= 50) {
                return data;
            }
            return StringUtils.substring((String)data, (int)0, (int)50) + "... (truncated)";
        }

        public void trimImageData() {
            if (this.type == ChatMessagePartType.IMAGE_INLINE) {
                this.inlineImage = ChatMessagePart.truncate(this.inlineImage);
            } else if (this.type == ChatMessagePartType.IMAGE_URI && StringUtils.startsWith((String)this.imageUrl, (String)"data:")) {
                this.imageUrl = ChatMessagePart.truncate(this.imageUrl);
            }
        }

        public Base64Image getBase64Image() {
            switch (this.type) {
                case IMAGE_INLINE: {
                    return new Base64Image(this.inlineImage, this.imageMimeType);
                }
                case IMAGE_URI: {
                    if (this.imageUrl == null) {
                        throw new UnsupportedOperationException("This part contains no image.");
                    }
                    Matcher matcher = inlineImageMatcherPattern.matcher(this.imageUrl);
                    if (matcher.find()) {
                        String mimeType = StringUtils.isBlank((String)matcher.group(1)) ? "image/jpeg" : matcher.group(1);
                        String imageData = matcher.group(2);
                        return new Base64Image(imageData, mimeType);
                    }
                    throw new UnsupportedOperationException("Image parts are only supported with data URLs");
                }
            }
            throw new UnsupportedOperationException("This part contains no image.");
        }
    }

    public static enum ChatMessagePartType {
        TEXT,
        IMAGE_INLINE,
        IMAGE_URI,
        IMAGE_REF;

    }

    public static class FunctionToolDesc {
        public String name;
        @Nullable
        public String description;
        @Nullable
        public Boolean strict;
        @Nullable
        public Boolean compatible;
        @Nullable
        @JsonAdapter(value=GsonNullableJsonElementTypeAdapterFactory.class)
        private JsonObject parameters;

        public JsonObject getParameters() {
            if (this.parameters == null) {
                JsonObject obj = new JsonObject();
                obj.addProperty("type", "object");
                obj.add("properties", (JsonElement)new JsonObject());
                return obj;
            }
            return this.parameters.getAsJsonObject();
        }

        public void setParameters(@Nullable JsonObject parameters) {
            this.parameters = parameters;
        }
    }

    public static class FunctionTool
    extends AbstractTool {
        public FunctionToolDesc function;
    }

    @PolyJSON(value={@Mapping(value=FunctionTool.class, type="function")})
    public static abstract class AbstractTool {
    }

    public static class NamedToolChoice
    extends ToolChoice {
        public String name;
    }

    public static class RequiredToolChoice
    extends ToolChoice {
    }

    public static class NoneToolChoice
    extends ToolChoice {
    }

    public static class AutoToolChoice
    extends ToolChoice {
    }

    @PolyJSON(value={@Mapping(value=AutoToolChoice.class, type="auto"), @Mapping(value=NoneToolChoice.class, type="none"), @Mapping(value=RequiredToolChoice.class, type="required"), @Mapping(value=NamedToolChoice.class, type="tool_name")})
    public static abstract class ToolChoice {
    }

    public static enum ReasoningEffort {
        OFF,
        STANDARD,
        CUSTOM;

    }

    public static class ResponseFormatJson
    extends ResponseFormat {
        @JsonAdapter(value=GsonNullableJsonElementTypeAdapterFactory.class)
        @Nullable
        public JsonObject schema;
        @Nullable
        public Boolean strict;
        @Nullable
        public Boolean compatible;

        @Override
        public LLMCompletionSettings.ResponseFormat toLegacyResponseFormat() {
            LLMCompletionSettings.ResponseFormatJson responseFormat = new LLMCompletionSettings.ResponseFormatJson();
            responseFormat.schema = this.schema;
            responseFormat.strict = this.strict;
            responseFormat.compatible = this.compatible;
            return responseFormat;
        }
    }

    public static class ResponseFormatText
    extends ResponseFormat {
        @Override
        public LLMCompletionSettings.ResponseFormatText toLegacyResponseFormat() {
            return new LLMCompletionSettings.ResponseFormatText();
        }
    }

    @PolyJSON(value={@Mapping(type="text", value=ResponseFormatText.class), @Mapping(type="json", value=ResponseFormatJson.class)})
    public static abstract class ResponseFormat {
        public abstract LLMCompletionSettings.ResponseFormat toLegacyResponseFormat();
    }

    public static class CompletionSettings {
        @Nullable
        public Double temperature;
        @Nullable
        public Integer topK;
        @Nullable
        public Double topP;
        @Nullable
        public Integer maxOutputTokens;
        @Nullable
        public List<String> stopSequences = new ArrayList<String>();
        @Nullable
        public Double frequencyPenalty;
        @Nullable
        public Double presencePenalty;
        @Nullable
        public Map<Integer, Double> logitBias;
        @Nullable
        public Boolean logProbs;
        @Nullable
        public Integer topLogProbs;
        @Nullable
        public ResponseFormat responseFormat;
        @Nullable
        public ReasoningEffort reasoningEffort;
        @Nullable
        public String customReasoningEffort;
        @Nullable
        public ToolChoice toolChoice;
        @Nullable
        public List<AbstractTool> tools;
        @Nullable
        public Boolean outputTrajectory = true;
        @Nullable
        public List<String> classLabels;
        @Nullable
        public String hypothesisTemplate;
        @Nullable
        public Integer summarizationMinTokens;
        @Nullable
        public Integer summarizationMaxTokens;
        @Nullable
        public Integer summarizationSpecialTokensSafetyFactor;
        @Nullable
        public Integer summarizationNumOverlapTokens;
        @Nullable
        public Integer summarizationMaxNumSplitLevels;
        @Nullable
        public ClassificationOutputMode textClassificationOutputMode;

        public static enum ClassificationOutputMode {
            ALL,
            MOST_RELEVANT,
            FIRST;

        }
    }

    public static class SingleCompletionQuery {
        @Nullable
        public SimpleFilter filter;
        @Nullable
        public JsonObject context;
        public List<ChatMessage> messages = new ArrayList<ChatMessage>();

        public List<ChatMessagePart> getImageParts() {
            return this.messages.stream().filter(messages -> messages.parts != null).flatMap(messages -> messages.parts.stream()).filter(part -> part.type == ChatMessagePartType.IMAGE_INLINE || part.type == ChatMessagePartType.IMAGE_URI).collect(Collectors.toList());
        }

        public SingleCompletionQuery getSafeForLoggingCopy() {
            SingleCompletionQuery queryCopy = (SingleCompletionQuery)JSON.deepCopy((Object)this);
            for (ChatMessage message : queryCopy.messages) {
                message.trimImageParts();
            }
            if (queryCopy.context != null) {
                JSONRedactor.RedactionConfig redactionConfig = LLMClient.inputRedactionConfig();
                queryCopy.context = JSONRedactor.redactObject((JsonObject)queryCopy.context, (JSONRedactor.RedactionConfig)redactionConfig);
            }
            return queryCopy;
        }
    }

    @RoutinelyUsedInExtensionCode
    public static class CompletionQuery {
        public List<ChatMessage> messages = new ArrayList<ChatMessage>();
        public LLMCompletionSettings settings = new LLMCompletionSettings();
        public List<String> classLabels;
        public String hypothesisTemplate;
        public Integer summarizationMinTokens;
        public Integer summarizationMaxTokens;
        public Integer summarizationSpecialTokensSafetyFactor;
        public Integer summarizationNumOverlapTokens;
        public Integer summarizationMaxNumSplitLevels;
        public ClassificationOutputMode textClassificationOutputMode;

        public static enum ClassificationOutputMode {
            ALL,
            MOST_RELEVANT,
            FIRST;

        }
    }
}

