/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.snowflakecortex;

import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.SnowflakeConnection;
import com.dataiku.dip.connections.SnowflakeCortexLLMConnection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.llm.LLMModelHandle;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.llm.online.AbstractLLMClient;
import com.dataiku.dip.llm.online.LLMChatMessageUtils;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.marshall.CoreCompletionSettings;
import com.dataiku.dip.llm.online.snowflakecortex.AbstractRawSnowflakeCortexLLMClient;
import com.dataiku.dip.llm.online.snowflakecortex.RawSnowflakeCortexLLMRESTClient;
import com.dataiku.dip.llm.online.snowflakecortex.RawSnowflakeCortexLLMSQLClient;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.IsolationLevel;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class SnowflakeCortexLLMClient
extends AbstractLLMClient
implements LLMClient {
    private final SnowflakeCortexLLMConnection connection;
    private final AbstractRawSnowflakeCortexLLMClient raw;
    private final SnowflakeCortexLLMConnection.SnowflakeCortexLLMModel model;
    private final ComputeResourceUsage.InternalLLMUsageData usageData = new ComputeResourceUsage.LLMUsageData();

    public SnowflakeCortexLLMClient(AuthCtx authCtx, String projectKey, SnowflakeCortexLLMConnection connection, LLMModelHandle<SnowflakeCortexLLMConnection.SnowflakeCortexLLMModel> modelHandle) throws IOException, DKUSecurityException {
        super(modelHandle.getEnrichedRef());
        SnowflakeConnection sfConnection;
        this.connection = connection;
        TransactionService ts = (TransactionService)SpringUtils.getBean(TransactionService.class);
        try (Transaction t = ts.retrieveOrBeginRead(IsolationLevel.YOLO);){
            sfConnection = ConnectionsDAO.get().getMandatoryConnectionAs(authCtx, connection.params.snowflakeConnection, SnowflakeConnection.class);
            if (!sfConnection.isFreelyUsableBy(authCtx)) {
                throw new UnauthorizedException("You may not use the snowflake connection " + sfConnection.name, "denied");
            }
        }
        this.model = modelHandle.getModel();
        if (this.model.restCompatible && sfConnection.params.authType != SnowflakeConnection.AuthType.PASSWORD) {
            logger.infoV("Model %s and authentication type %s are compatible with Snowflake Cortex REST API. Will use REST API client.", new Object[]{this.model.id, sfConnection.params.authType});
            this.raw = new RawSnowflakeCortexLLMRESTClient(authCtx, connection, sfConnection);
        } else {
            if (!this.model.sqlCompatible) {
                if (this.model.restCompatible && sfConnection.params.authType == SnowflakeConnection.AuthType.PASSWORD) {
                    throw new IllegalArgumentException(String.format("Model %s is not compatible with Snowflake Cortex SQL API and authentication method %s not supported by REST selected", new Object[]{this.model.id, sfConnection.params.authType}));
                }
                throw new IllegalArgumentException(String.format("Can not use Snowflake Cortex REST API for model %s and model is not compatible with Snowflake Cortex REST API", this.model.id));
            }
            logger.infoV("Using Snowflake Cortex SQL client.", new Object[0]);
            this.raw = new RawSnowflakeCortexLLMSQLClient(authCtx, projectKey, sfConnection);
        }
    }

    @Override
    public boolean supportNativeBatch() {
        return false;
    }

    @Override
    public boolean requiresCostLimiting() {
        return true;
    }

    @Override
    public String getProviderId() {
        return "SnowflakeCortex";
    }

    @Override
    public AbstractLLMConnection getConnection() {
        return this.connection;
    }

    @Override
    public int getMaxParallelism() {
        return this.connection.params.maxParallelism;
    }

    @Override
    public List<LLMClient.ChatMessage> getFormattedPrompt(List<LLMClient.ChatMessage> chatMessages) {
        LLMChatMessageUtils.throwIfUnsupportedToolOutputParts(chatMessages);
        return LLMChatMessageUtils.collapseAdjacentSameRoleMessages(chatMessages);
    }

    @Override
    public List<LLMClient.SimpleCompletionResponse> completeBatch(List<LLMClient.SingleCompletionQuery> queries, LLMClient.CompletionSettings settings) throws Exception {
        CoreCompletionSettings ccs = this.getCoreCompletionSettings(settings);
        ArrayList<LLMClient.SimpleCompletionResponse> ret = new ArrayList<LLMClient.SimpleCompletionResponse>();
        for (LLMClient.SingleCompletionQuery query : queries) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            logger.info((Object)("Snowflake Cortex LLM single complete query: " + JSON.log((Object)query.getSafeForLoggingCopy())));
            List<LLMClient.ChatMessage> chatMessages = this.getFormattedPrompt(query.messages);
            LLMClient.SimpleCompletionResponse scr = this.raw.chatComplete(this.model, chatMessages, ccs);
            if (this.raw instanceof RawSnowflakeCortexLLMRESTClient) {
                scr.estimatedCost = this.model.getEstimatedCompletionCost(scr.promptTokens, scr.completionTokens);
            }
            scr.includeInUsageData(this.usageData, stopwatch.elapsed(TimeUnit.MILLISECONDS));
            ret.add(scr);
        }
        return ret;
    }

    @Override
    public List<LLMClient.SimpleEmbeddingResponse> embedBatch(List<LLMClient.EmbeddingQuery> queries, LLMClient.EmbeddingSettings settings) throws IOException, SQLException, DKUSecurityException, InterruptedException {
        if (LLMClient.TextOverflowMode.TRUNCATE.equals((Object)settings.textOverflowMode)) {
            logger.warn((Object)"Truncation for long texts overflow is not supported yet for Snowflake, defaulting to Failure mode");
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        List<LLMClient.SimpleEmbeddingResponse> ret = this.raw.embed(this.model.getId(), this.model.embeddingSize, queries.stream().map(q -> q.text).collect(Collectors.toList()));
        this.usageData.totalComputationTimeMS = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        ret.forEach(ser -> this.usageData.incrementTotalPromptTokens(ser.promptTokens));
        return ret;
    }

    @Override
    public List<LLMClient.SingleRerankingResponse> rerankBatch(List<LLMClient.RerankingQuery> queries, LLMClient.RerankingSettings settings) throws Exception {
        throw new IllegalArgumentException("Reranking not supported on this LLM");
    }

    @Override
    public void streamComplete(LLMClient.SingleCompletionQuery query, LLMClient.CompletionSettings settings, LLMClient.StreamedCompletionResponseConsumer consumer) throws Exception {
        CoreCompletionSettings ccs = this.getCoreCompletionSettings(settings);
        logger.trace(() -> "Snowflake Cortex stream complete: " + JSON.log((Object)query.getSafeForLoggingCopy()));
        Stopwatch stopwatch = Stopwatch.createStarted();
        LLMClient.StreamedCompletionResponseConsumerProxy wrappedConsumer = new LLMClient.StreamedCompletionResponseConsumerProxy(consumer, (ExceptionUtils.ThrowingConsumer<LLMClient.StreamedCompletionResponseFooter, Exception>)((ExceptionUtils.ThrowingConsumer)footer -> footer.includeInUsageData(this.usageData, stopwatch.elapsed(TimeUnit.MILLISECONDS))));
        List<LLMClient.ChatMessage> chatMessages = this.getFormattedPrompt(query.messages);
        try {
            this.raw.streamChatComplete(wrappedConsumer, this.model, chatMessages, ccs);
        }
        catch (LLMClient.LLMException e) {
            e.estimatedCost = this.model.getEstimatedCompletionCost(e.promptTokens, e.completionTokens);
            e.includeInUsageData(this.usageData, stopwatch.elapsed(TimeUnit.MILLISECONDS));
            throw e;
        }
    }

    @Override
    public ComputeResourceUsage getTotalCRU(ComputeResourceUsage.LLMUsageType usageType, LLMStructuredRef llmRef) {
        ComputeResourceUsage cru = new ComputeResourceUsage();
        cru.setupLLMUsage(usageType, llmRef.connection, llmRef.type.toString(), llmRef.id);
        cru.llmUsage.setFromInternal(this.usageData);
        return cru;
    }

    @Override
    public boolean supportsStream() {
        return this.raw instanceof RawSnowflakeCortexLLMRESTClient;
    }

    @Override
    public int getBatchSize(AbstractLLMConnection.QueryType queryType, LLMStructuredRef llmRef) {
        switch (queryType) {
            case textEmbedding: {
                if (this.model.getBatchSize().isPresent()) {
                    logger.info((Object)"Using user defined batch size");
                    return this.model.getBatchSize().getAsInt();
                }
                return 10;
            }
        }
        return 1;
    }

    @Override
    public void close() throws Exception {
        this.raw.close();
    }
}

