/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.managedfolder;

import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.exec.CodeBasedRecipeDatasetInfoHelper;
import com.dataiku.dip.datasets.LatestPartitionsSelector;
import com.dataiku.dip.datasets.fs.FSDatasetUtils;
import com.dataiku.dip.datasets.fs.LocalFSProvider;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.ICodedException;
import com.dataiku.dip.fs.FSBrowsePath;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderCodes;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.managedfolder.ManagedFolderSelectedFiles;
import com.dataiku.dip.managedfolder.ManagedFolderSelection;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.IImpersonationResolverService;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dss.shadelib.org.apache.commons.io.FilenameUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KernelsManagedFolderService {
    @Autowired
    private FutureService futureService;
    @Autowired
    private ManagedFolderDAO dao;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private IImpersonationResolverService impersonationResolverService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.managedfolders.kernels");

    public ManagedFolder getOrNull(String projectKey, String id) throws IOException {
        return (ManagedFolder)this.dao.getOrNull(projectKey, id);
    }

    public ManagedFolder getMandatory(String projectKey, String id) throws IOException {
        return (ManagedFolder)this.dao.getMandatory(projectKey, id);
    }

    public ManagedFolder lookupMandatoryUnsafe(String projectKey, String lookup) throws IOException {
        ManagedFolder ret = (ManagedFolder)this.dao.getOrNullUnsafe(projectKey, lookup);
        if (ret != null) {
            return ret;
        }
        for (ManagedFolder mf : this.dao.listUnsafe(projectKey)) {
            if (!mf.name.equals(lookup)) continue;
            return mf;
        }
        throw new NotFoundException("Managed folder name not found: " + lookup + " in " + projectKey);
    }

    public List<ManagedFolder> list(String projectKey) throws IOException {
        return this.dao.list(projectKey);
    }

    public ManagedFolderHandler.ManagedFolderListing handleListFSRequest_NT(AuthCtx authCtx, String projectKey, String id, String partitionId, boolean relativeToPartition) throws Exception {
        ManagedFolder odb;
        TransactionContext.assertNoAttachedTransaction();
        try (Transaction t = this.transactionService.beginRead();){
            odb = (ManagedFolder)this.dao.getMandatoryUnsafe(projectKey, id);
        }
        return this.handleListFSRequest_NT(authCtx, odb, partitionId, relativeToPartition);
    }

    public ManagedFolderHandler.ManagedFolderListing handleListFSRequest_NT(AuthCtx authCtx, String projectKey, String id) throws Exception {
        ManagedFolder odb;
        TransactionContext.assertNoAttachedTransaction();
        try (Transaction t = this.transactionService.beginRead();){
            odb = (ManagedFolder)this.dao.getMandatoryUnsafe(projectKey, id);
        }
        PartitioningScheme partitioningScheme = odb.getPartitioningSchema();
        if (partitioningScheme.isPartitioned()) {
            ManagedFolderSelection selection = odb.selection;
            if (selection == null) {
                selection = ManagedFolderSelection.newAll();
            }
            switch (selection.partitionSelectionMethod) {
                case ALL: {
                    return this.handleListFSRequest_NT(authCtx, odb, Partition.newALL((PartitioningScheme)partitioningScheme), false);
                }
                case LATEST_N: {
                    return this.handleListFSRequest_NT(authCtx, odb, LatestPartitionsSelector.select(authCtx, odb, selection.latestPartitionsN), false);
                }
                case SELECTED: {
                    ArrayList selectedPartitions = selection.selectedPartitions;
                    if (selectedPartitions == null) {
                        selectedPartitions = Lists.newArrayList();
                    }
                    ArrayList partitions = Lists.newArrayList();
                    for (String partitionId : selectedPartitions) {
                        partitions.add(PartitionFactory.fromIdentifier(partitioningScheme, partitionId));
                    }
                    return this.handleListFSRequest_NT(authCtx, odb, partitions, false);
                }
            }
            throw new NotImplementedException("Unknown partition selection type");
        }
        return this.handleListFSRequest_NT(authCtx, odb, (Partition)null, false);
    }

    public ManagedFolderHandler.ManagedFolderListing handleListFSRequest_NT(AuthCtx authCtx, ManagedFolder odb, Partition partition, boolean relativeToPartition) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        try (ManagedFolderHandler fh = (ManagedFolderHandler)odb.buildHandler(authCtx);){
            ManagedFolderHandler.ManagedFolderListing managedFolderListing = fh.listFS(partition, true, relativeToPartition);
            return managedFolderListing;
        }
    }

    public ManagedFolderHandler.ManagedFolderListing handleListFSRequest_NT(AuthCtx authCtx, ManagedFolder odb, String partitionId, boolean relativeToPartition) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        Partition partition = odb.getPartitioningSchema().isPartitioned() && StringUtils.isNotBlank((String)partitionId) ? PartitionFactory.fromIdentifier(odb.getPartitioningSchema(), partitionId) : Partition.newNP();
        try (ManagedFolderHandler fh = (ManagedFolderHandler)odb.buildHandler(authCtx);){
            ManagedFolderHandler.ManagedFolderListing managedFolderListing = fh.listFS(partition, true, relativeToPartition);
            return managedFolderListing;
        }
    }

    public ManagedFolderHandler.ManagedFolderListing handleListFSRequest_NT(AuthCtx authCtx, ManagedFolder odb, List<Partition> partitions, boolean relativeToPartition) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        try (ManagedFolderHandler fh = (ManagedFolderHandler)odb.buildHandler(authCtx);){
            ManagedFolderHandler.ManagedFolderListing listing = new ManagedFolderHandler.ManagedFolderListing();
            for (Partition partition : partitions) {
                ManagedFolderHandler.ManagedFolderListing partitionListing = fh.listFS(partition, true, relativeToPartition);
                listing.folderPath = partitionListing.folderPath;
                listing.items.addAll(partitionListing.items);
            }
            ManagedFolderHandler.ManagedFolderListing managedFolderListing = listing;
            return managedFolderListing;
        }
    }

    public void handleDownloadFolderRequest_NT(String projectKey, String obdId, String path, HttpServletResponse resp, AuthCtx authCtx) throws Exception {
        ManagedFolder odb;
        TransactionContext.assertNoAttachedTransaction();
        try (Transaction t = this.transactionService.beginRead();){
            odb = (ManagedFolder)this.dao.getMandatoryUnsafe(projectKey, obdId);
        }
        try (ManagedFolderHandler handler = (ManagedFolderHandler)odb.buildHandler(authCtx);){
            try {
                handler.getAccessInfo(false);
            }
            catch (DKUSecurityException e) {
                throw new IOException("Fail to get folder backend specifics", e);
            }
            logger.info((Object)("Download all  from " + projectKey + "." + obdId));
            try (AutoDelete targetArchive = DSSTempUtils.getTempFile((String)"managed-folder-download-multiple", (String)("".equals(odb.name) ? "folder" : odb.name), (String)"zip");){
                logger.info((Object)("Zipping into " + String.valueOf(targetArchive)));
                try (FileOutputStream fos = new FileOutputStream((File)targetArchive);){
                    handler.zipToStream(path, fos);
                }
                this.sendFileAsUrl(resp, (File)targetArchive);
            }
        }
        catch (IOException e) {
            logger.error((Object)"Failed to send file", (Throwable)e);
            resp.setStatus(404);
            resp.getWriter().write("No such file in this managed folder.");
        }
    }

    public void handleDownloadRequest_NT(String projectKey, String obdId, String path, HttpServletResponse resp, AuthCtx authCtx) throws Exception {
        ManagedFolder odb;
        TransactionContext.assertNoAttachedTransaction();
        try (Transaction t = this.transactionService.beginRead();){
            odb = (ManagedFolder)this.dao.getMandatoryUnsafe(projectKey, obdId);
        }
        try (ManagedFolderHandler handler = (ManagedFolderHandler)odb.buildHandler(authCtx);){
            try {
                handler.getAccessInfo(false);
            }
            catch (DKUSecurityException e) {
                throw new IOException("Fail to get folder backend specifics", e);
            }
            try {
                this.sendFileAsUrl(resp, handler.getInputStream(path));
            }
            catch (IOException e) {
                logger.error((Object)"Failed to send file", (Throwable)e);
                resp.setStatus(404);
                resp.getWriter().write("No such file in this managed folder.");
            }
        }
    }

    public FutureResponse<String> prepareDownloadZip(final String projectKey, final String obdId, final ManagedFolderSelectedFiles selectedFiles, AuthCtx authCtx) throws Exception {
        ManagedFolder mf;
        try (Transaction t = this.transactionService.beginRead();){
            mf = (ManagedFolder)this.dao.getMandatoryUnsafe(projectKey, obdId);
        }
        return this.futureService.runFuture(new SimpleFutureThread<String>(authCtx){

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"download_managed_folder", (String)"Download managed folder");
            }

            /*
             * Exception decompiling
             */
            @Override
            public String compute() throws Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }, 0L, new TypeToken<FutureResponse<String>>(){});
    }

    public static File getTargetFile(String projectKey, String obdId, String exportId) throws IOException {
        if (!Pattern.matches("^[A-Za-z0-9]*$", exportId)) {
            throw new IllegalArgumentException("Invalid export id");
        }
        return DSSTempUtils.getTempFileWithSpecificName((String)"managed-folder-downloadall", (String)(projectKey + "-" + obdId + "-" + exportId), (String)"zip");
    }

    public void sendFileAsUrl(HttpServletResponse resp, EnrichedInputStream eis) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        try (InputStream in = eis.rawStream();
             ServletOutputStream os = resp.getOutputStream();){
            resp.setStatus(200);
            resp.setContentType(KernelsManagedFolderService.filenameToMime(eis.getFilename()));
            resp.setHeader("Content-Disposition", "attachment; filename=\"" + eis.getFilename() + "\"");
            if (eis.size() >= 0L) {
                resp.setHeader("Content-Length", "" + eis.size());
            }
            IOUtils.copy((InputStream)in, (OutputStream)os);
        }
        catch (IOException e) {
            logger.error((Object)"Failed to send file", (Throwable)e);
            resp.setStatus(404);
            resp.getWriter().write("No such file in this managed folder.");
        }
    }

    public void sendFileAsUrl(HttpServletResponse resp, File eis) throws IOException, InterruptedException, DKUSecurityException {
        try (FileInputStream in = new FileInputStream(eis);
             ServletOutputStream os = resp.getOutputStream();){
            resp.setStatus(200);
            resp.setContentType(KernelsManagedFolderService.filenameToMime(eis.getName()));
            resp.setHeader("Content-Disposition", "attachment; filename=\"" + eis.getName() + "\"");
            resp.setHeader("Content-Length", "" + eis.length());
            IOUtils.copy((InputStream)in, (OutputStream)os);
        }
        catch (IOException e) {
            logger.error((Object)"Failed to send file", (Throwable)e);
            resp.setStatus(404);
            resp.getWriter().write("No such file in this managed folder.");
        }
    }

    public ManagedFolderHandler.ManagedFolderListingItem handleUploadRequest_NT(String projectKey, String obdId, InputStream is, String path, boolean forceUpload, AuthCtx authCtx) throws Exception {
        ManagedFolder odb;
        TransactionContext.assertNoAttachedTransaction();
        try (Transaction t = this.transactionService.beginRead();){
            odb = (ManagedFolder)this.dao.getMandatoryUnsafe(projectKey, obdId);
        }
        try (ManagedFolderHandler handler = (ManagedFolderHandler)odb.buildHandler(authCtx);){
            try {
                handler.getAccessInfo(false);
            }
            catch (DKUSecurityException e) {
                throw new IOException("Fail to get folder backend specifics", e);
            }
            logger.info((Object)("Upload " + FilenameUtils.getName((String)path) + " to " + projectKey + "." + obdId + ", path is " + path));
            handler.ensurePartitionFolder(null);
            if (!forceUpload) {
                FSDatasetUtils.checkDestPathDoesNotExist(path, handler.getFile(path));
            }
            try (OutputStream os = handler.getOutputStream(path);){
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            FSPathOrDirectory stat = handler.getFile(path);
            if (stat == null) {
                throw new FileNotFoundException("No file at path " + path);
            }
            ManagedFolderHandler.ManagedFolderListingItem item = new ManagedFolderHandler.ManagedFolderListingItem();
            item.path = path;
            item.size = stat.getSize();
            item.lastModified = stat.getLastModified();
            ManagedFolderHandler.ManagedFolderListingItem managedFolderListingItem = item;
            return managedFolderListingItem;
        }
    }

    static String filenameToMime(String fileName) {
        if (fileName.endsWith("csv")) {
            return "text/csv";
        }
        if (fileName.endsWith("xls")) {
            return "application/vnd.ms-excel";
        }
        if (fileName.endsWith("xlsx")) {
            return "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        }
        if (fileName.endsWith("txt")) {
            return "text/plain";
        }
        if (fileName.endsWith("tsv")) {
            return "text/csv";
        }
        return "application/octet-stream";
    }

    public void clear(AuthCtx authCtx, ManagedFolder odb) throws Exception {
        try (ManagedFolderHandler handler = (ManagedFolderHandler)odb.buildHandler(authCtx);){
            handler.clear();
        }
    }

    public void clear(AuthCtx authCtx, ManagedFolder odb, List<String> partitionIds) throws Exception {
        try (ManagedFolderHandler handler = (ManagedFolderHandler)odb.buildHandler(authCtx);){
            PartitioningScheme scheme = odb.getPartitioningSchema();
            ArrayList partitions = Lists.newArrayList();
            for (String partitionId : partitionIds) {
                partitions.add(PartitionFactory.fromIdentifier(scheme, partitionId));
            }
            handler.clearPartitions(partitions);
        }
    }

    public FutureResponse<FSDeleteResult> handleDeleteItemsRequest(String projectKey, String folderId, final String[] itemPaths, AuthCtx authCtx, final FSProvider.FSBrowseStrategy strategy) throws Exception {
        ManagedFolderHandler handler;
        try (Transaction t = this.transactionService.beginRead();){
            ManagedFolder odb = (ManagedFolder)this.dao.getMandatoryUnsafe(projectKey, folderId);
            handler = (ManagedFolderHandler)odb.buildHandler(authCtx);
        }
        SimpleFutureThread<FSDeleteResult> sft = new SimpleFutureThread<FSDeleteResult>(authCtx){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected FSDeleteResult compute() throws Exception {
                FSDeleteResult result = new FSDeleteResult();
                result.paths = new ArrayList<String>();
                try (FutureProgress.AutocloseableFutureProgressState state = FutureProgress.pushAutoCloseableState((String)"Deleting items", (double)itemPaths.length, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                    for (String item : itemPaths) {
                        try {
                            if (strategy == FSProvider.FSBrowseStrategy.FILE_OR_DIRECTORY) {
                                handler.delete(item);
                            } else if (strategy == FSProvider.FSBrowseStrategy.FILE) {
                                handler.deleteFile(item);
                            } else if (strategy == FSProvider.FSBrowseStrategy.DIRECTORY) {
                                handler.deleteDirectory(item);
                            }
                            FSBrowsePath browsedPath = handler.browse(item, strategy);
                            if (browsedPath == null || !browsedPath.exists) {
                                result.paths.add(item);
                            }
                        }
                        catch (CodedException | DKUSecurityException e) {
                            result.messages.add(InfoMessage.fatal((InfoMessage.MessageCode)((ICodedException)e).getCode(), (String)ExceptionUtils.getMessageWithCauses((Throwable)e)));
                        }
                        catch (Exception e) {
                            result.messages.add(InfoMessage.fatal((String)ExceptionUtils.getMessageWithCauses((Throwable)e)));
                        }
                        result.summarize();
                        state.increment(1.0);
                    }
                }
                finally {
                    handler.close();
                }
                return result;
            }

            public FuturePayload getPayload() {
                FuturePayload fp = new FuturePayload();
                fp.action = "managed_folders_delete";
                fp.displayName = "Delete files and folders";
                return fp;
            }
        };
        return this.futureService.runFuture(sft, 0L, new TypeToken<FutureResponse<FSDeleteResult>>(){});
    }

    public FutureResponse<FSDeleteResult> handleDeleteItemsRequest(String projectKey, String folderId, String[] itemPaths, AuthCtx authCtx) throws Exception {
        return this.handleDeleteItemsRequest(projectKey, folderId, itemPaths, authCtx, FSProvider.FSBrowseStrategy.FILE_OR_DIRECTORY);
    }

    public void handleDecompressRequest_NT(String projectKey, String folderId, String itemPath, AuthCtx authCtx) throws Exception {
        ManagedFolder odb;
        TransactionContext.assertNoAttachedTransaction();
        try (Transaction t = this.transactionService.beginRead();){
            odb = (ManagedFolder)this.dao.getMandatoryUnsafe(projectKey, folderId);
        }
        try (ManagedFolderHandler handler = (ManagedFolderHandler)odb.buildHandler(authCtx);){
            handler.decompress(itemPath);
        }
    }

    public CodeBasedRecipeDatasetInfoHelper.LocationInfo getPartitionPaths_NT(AuthCtx authCtx, ManagedFolder mf, String partition) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        try (ManagedFolderHandler handler = (ManagedFolderHandler)mf.buildHandler(authCtx);){
            Partition p = mf.getPartitioningSchema().isPartitioned() && StringUtils.isNotBlank((String)partition) ? PartitionFactory.fromIdentifier(mf.getPartitioningSchema(), partition) : Partition.newNP();
            ManagedFolderHandler.ManagedFolderListing listing = handler.listFS(p, true, false);
            ArrayList paths = Lists.newArrayList();
            CodeBasedRecipeDatasetInfoHelper.LocationInfo info = CodeBasedRecipeDatasetInfoHelper.LocationInfo.makeInfo(CodeBasedRecipeDatasetInfoHelper.LocationInfoType.MANAGEDFOLDER, "projectKey", mf.projectKey, "id", mf.id, "name", mf.name);
            if (listing.partitioningSchemeRepresentableAsFolder) {
                info.info.put("folder", listing.partitionPrefix);
            }
            for (ManagedFolderHandler.ManagedFolderListingItem item : listing.items) {
                paths.add(item.path);
            }
            info.info.put("paths", paths);
            CodeBasedRecipeDatasetInfoHelper.LocationInfo locationInfo = info;
            return locationInfo;
        }
    }

    public String access(AuthCtx authCtx, ManagedFolder mf) throws IOException, DKUSecurityException, CodedException, InterruptedException {
        try (ManagedFolderHandler fh = (ManagedFolderHandler)mf.buildHandler(authCtx);){
            FSProvider provider = fh.getProvider();
            if (provider instanceof LocalFSProvider) {
                String rootPath = ((LocalFSProvider)provider).getRoot();
                if (this.impersonationResolverService.isEnabled()) {
                    fh.grantFullACLs();
                }
                String string = rootPath;
                return string;
            }
            throw new CodedException((InfoMessage.MessageCode)ManagedFolderCodes.ERR_FOLDER_INVALID_CONFIG, "Direct access is only available for folders on a filesystem connection");
        }
    }

    public static class ItemPreview {
        String itemPath;
        PreviewType type;
        String head;
        String charsetUsed;
        String contentType;
        boolean hasMore;
    }

    public static enum PreviewType {
        TEXT,
        IMAGE,
        BINARY,
        ARCHIVE;

    }

    public static class FSDeleteResult
    extends InfoMessage.InfoMessages {
        public List<String> paths;
    }
}

