/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.checks;

import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.util.AnyLoc;
import com.google.common.collect.Maps;
import java.util.List;

public class SavedModelVersionCheckContext
extends AbstractCheckContext {
    public final SavedModel savedModel;
    public final String version;

    public SavedModelVersionCheckContext(SavedModel savedModel, String version, long timeCheck, ReadWriteJobsInternalDB jobsDatabaseService, APITicketService.Ticket ticket, String projectKey) {
        super(timeCheck, jobsDatabaseService, ticket, projectKey);
        this.savedModel = savedModel;
        this.version = version;
    }

    @Override
    public void ensureLastValues() throws Exception {
        if (this.lastValues == null) {
            this.lastValues = Maps.newHashMap();
            AnyLoc loc = new AnyLoc(this.savedModel.projectKey, this.savedModel.id);
            for (ReadOnlyJobsInternalDB.MetricDataPoint computed : this.jobsDatabaseService.getLastMetrics(loc, this.version)) {
                this.lastValues.put(computed.metric.getId(), computed);
            }
        }
    }

    @Override
    public List<ReadOnlyJobsInternalDB.MetricDataPoint> getHistory(String metricId) throws Exception {
        AnyLoc loc = new AnyLoc(this.savedModel.projectKey, this.savedModel.id);
        return this.jobsDatabaseService.getMetrics(loc, this.version, metricId);
    }

    @Override
    public AbstractCheckContext.CheckParameters setParamsForPythonChecks() throws Exception {
        String partitionId = this.version;
        String fullName = this.savedModel.projectKey + "." + this.savedModel.id;
        MetricTargetType objectType = MetricTargetType.SAVED_MODEL;
        return new AbstractCheckContext.CheckParameters(objectType, partitionId, fullName);
    }
}

