/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.engines;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.connections.ImpalaConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.impala.ImpalaConfigurator;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricsEngineDesc;
import com.dataiku.dip.metrics.engines.JdbcEngine;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.metrics.engines.MetricsQueryBuilder;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.security.AuthCtx;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ImpalaMetricsEngine
extends JdbcEngine
implements MetricsQueryBuilder.MetricsQueryBuilderEngine {
    public final String filter;
    private static Logger logger = Logger.getLogger((String)"dku.datasets.metrics.impala.metrics");

    public ImpalaMetricsEngine(MetricsEngineRun engineRun, Dataset dataset, Partition partition, JdbcEngine.ImpalaMetricsEngineConfig config) {
        super(dataset, partition);
        this.filter = ((ImpalaMetricsEngineRun)engineRun).filter;
    }

    @Override
    public void setupConnection(AuthCtx authCtx) throws IOException, DKUSecurityException, SQLException {
        String database = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(this.dataset).getSchemaNullIfBlank();
        logger.info((Object)("Impala metrics engine on database : " + database));
        ImpalaConnection datasetConnection = ImpalaConfigurator.configureConnectionForDatabase(authCtx, database == null ? "" : database);
        this.connectionData = datasetConnection.getConnectionData_NT(authCtx, this.dataset.getProjectKey());
        this.dialect = this.connectionData.getDialect();
    }

    @Override
    public QueryBunch buildQuery(AuthCtx authCtx, List<MetricComputation> computations, Map<String, String> alreadyComputed) throws Exception {
        MetricsQueryBuilder builder = new MetricsQueryBuilder();
        return builder.buildQuery(authCtx, this, computations, alreadyComputed, this.filter);
    }

    @Override
    public Map<Metric, String> getAggregates(QueryRunResult rs2, List<MetricComputation> computations) throws Exception {
        HashMap metricsValues = Maps.newHashMap();
        for (int i = 0; i < computations.size(); ++i) {
            MetricComputation computation = computations.get(i);
            MetricsQueryBuilder.MetricsQueryBuilderAggregation computer = (MetricsQueryBuilder.MetricsQueryBuilderAggregation)((Object)computation.computer);
            metricsValues.put(computation.metric, computer.getAggregate(rs2, computation));
        }
        return metricsValues;
    }

    public static class ImpalaMetricsEngineRun
    extends MetricsEngineRun {
        public final String countDistinctColumn;
        public String filter;
        private boolean neverMergeable = false;

        public ImpalaMetricsEngineRun(String countDistinctColumn) {
            super(MetricsEngineDesc.ImpalaMetricsEngine);
            this.countDistinctColumn = countDistinctColumn;
        }

        public ImpalaMetricsEngineRun(String countDistinctColumn, double cost, List<MetricComputation> computations, int pass) {
            super(MetricsEngineDesc.ImpalaMetricsEngine, cost, computations, pass);
            this.countDistinctColumn = countDistinctColumn;
        }

        public ImpalaMetricsEngineRun withFilter(String filter) {
            this.filter = filter;
            return this;
        }

        public ImpalaMetricsEngineRun neverMergeable() {
            this.neverMergeable = true;
            return this;
        }

        @Override
        protected MetricsEngineRun subset(double cost, List<MetricComputation> computations) {
            return new ImpalaMetricsEngineRun(this.countDistinctColumn, cost, computations, this.pass).withFilter(this.filter);
        }

        public boolean baseCanMergeWith(MetricsEngineRun other) {
            int maxComputationCount = DKUApp.getParams().getIntParam("dku.metricsEngine.impala.maxMetricsPerRun", Integer.valueOf(500));
            return super.canMergeWith(other) && !this.neverMergeable && other instanceof ImpalaMetricsEngineRun && StringUtils.equals((String)this.filter, (String)((ImpalaMetricsEngineRun)other).filter) && !((ImpalaMetricsEngineRun)other).neverMergeable && this.countAfterMergeStaysBelow(other, maxComputationCount);
        }

        @Override
        public boolean canMergeWith(MetricsEngineRun other) {
            String otherCountDistinctColumn = ((ImpalaMetricsEngineRun)other).countDistinctColumn;
            if (StringUtils.isNotBlank((String)this.countDistinctColumn)) {
                return this.baseCanMergeWith(other) && (StringUtils.isBlank((String)otherCountDistinctColumn) || StringUtils.equals((String)this.countDistinctColumn, (String)otherCountDistinctColumn));
            }
            return this.baseCanMergeWith(other);
        }

        @Override
        public boolean canAdd(MetricsEngineRun other) {
            String otherCountDistinctColumn = ((ImpalaMetricsEngineRun)other).countDistinctColumn;
            return this.baseCanMergeWith(other) && (StringUtils.isBlank((String)otherCountDistinctColumn) || StringUtils.equals((String)this.countDistinctColumn, (String)otherCountDistinctColumn));
        }

        @Override
        public MetricsEngineRun mergeWith(MetricsEngineRun other) {
            String otherCountDistinctColumn = ((ImpalaMetricsEngineRun)other).countDistinctColumn;
            if (StringUtils.isBlank((String)this.countDistinctColumn) && StringUtils.isNotBlank((String)otherCountDistinctColumn)) {
                return other.mergeWith(this);
            }
            return this.with(other.getComputations());
        }
    }
}

