/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.probes;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.meanings.IBasicMeaningsService;
import com.dataiku.dip.meanings.MeaningsService;
import com.dataiku.dip.meanings.ScopedBasicMeaningsPseudoService;
import com.dataiku.dip.meanings.model.UserDefinedMeaning;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricComputer;
import com.dataiku.dip.metrics.MetricMetadata;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.engines.DSSMetricsEngine;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.metrics.probes.ProbeConfiguration;
import com.dataiku.dip.metrics.probes.ProbeMetadata;
import com.dataiku.dip.metrics.probes.ProbeType;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.types.MeaningDetector;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class VerifyDatasetColumnProbeType
extends ProbeType {
    public static final String TYPE = "verify_col";
    private static Map<VerifyDatasetColumnMetrics, MetricMetadata> metadataPerType = Maps.newHashMap();
    private static Map<VerifyDatasetColumnConfiguredMetrics, MetricMetadata> metadataPerConfiguredType = Maps.newHashMap();
    private static Logger logger;

    @Override
    public List<MetricComputer> getComputers(IBasicMeaningsService basicMeaningsService) {
        ArrayList computers = Lists.newArrayList();
        computers.add(new VerifyForcedMeaningComputer(basicMeaningsService));
        return computers;
    }

    public VerifyDatasetColumnProbeType() {
        this.type = TYPE;
    }

    @Override
    public List<Metric> listBuildableMetrics(Object object, MetricTargetType objectType) {
        ArrayList metrics = Lists.newArrayList();
        if (objectType == MetricTargetType.DATASET) {
            Dataset dataset = (Dataset)object;
            for (SchemaColumn column : dataset.getSchema().getColumns()) {
                boolean disabled = StringUtils.isBlank((String)column.getMeaning());
                if (disabled) continue;
                metrics.add(new VerifyDatasetColumnMetric(VerifyDatasetColumnMetrics.FORCED_MEANING_PERCENTAGE, column.getName()));
                metrics.add(new VerifyDatasetColumnMetric(VerifyDatasetColumnMetrics.FORCED_MEANING_COUNT, column.getName()));
                metrics.add(new VerifyDatasetColumnMetric(VerifyDatasetColumnMetrics.FORCED_MEANING_VALID_COUNT, column.getName()));
                metrics.add(new VerifyDatasetColumnMetric(VerifyDatasetColumnMetrics.FORCED_MEANING_INVALID_COUNT, column.getName()));
                metrics.add(new VerifyDatasetColumnMetric(VerifyDatasetColumnMetrics.FORCED_MEANING_EMPTY_COUNT, column.getName()));
            }
        }
        return metrics;
    }

    @Override
    public Object listSelectableMetrics(Probe probe, Object object, MetricTargetType objectType) {
        if (objectType == MetricTargetType.DATASET) {
            VerifyDatasetColumnProbeHint probeHint = new VerifyDatasetColumnProbeHint();
            Dataset dataset = (Dataset)object;
            for (SchemaColumn column : dataset.getSchema().getColumns()) {
                VerifyDatasetColumnProbeColumnHint columnHint = new VerifyDatasetColumnProbeColumnHint(column.getName());
                for (VerifyDatasetColumnConfiguredMetrics aggregated : VerifyDatasetColumnConfiguredMetrics.values()) {
                    boolean active = false;
                    for (VerifyDatasetColumnProbeColumnConfiguration aggregate : ((VerifyDatasetColumnProbeConfiguration)probe.configuration).aggregates) {
                        if (!aggregate.column.equals(column.getName())) continue;
                        active = true;
                    }
                    boolean disabled = StringUtils.isBlank((String)column.getMeaning());
                    columnHint.metrics.add(new VerifyDatasetColumnProbeMetricHint(VerifyDatasetColumnProbeType.metadataPerConfiguredType.get((Object)((Object)aggregated)).name, aggregated, active, disabled));
                }
                probeHint.columns.add(columnHint);
            }
            return probeHint;
        }
        return null;
    }

    @Override
    public List<Metric> getMetricsToCompute(Probe probe, Object object, MetricTargetType objectType, boolean forDisplay) {
        ArrayList metrics = Lists.newArrayList();
        VerifyDatasetColumnProbeConfiguration configuration = (VerifyDatasetColumnProbeConfiguration)probe.getConfiguration();
        for (VerifyDatasetColumnProbeColumnConfiguration configured : configuration.aggregates) {
            if (configured.aggregated != VerifyDatasetColumnConfiguredMetrics.FORCED_MEANING) continue;
            metrics.add(new VerifyDatasetColumnMetric(VerifyDatasetColumnMetrics.FORCED_MEANING_COUNT, configured.column, configuration.explicitMeaning));
            metrics.add(new VerifyDatasetColumnMetric(VerifyDatasetColumnMetrics.FORCED_MEANING_PERCENTAGE, configured.column, configuration.explicitMeaning));
            metrics.add(new VerifyDatasetColumnMetric(VerifyDatasetColumnMetrics.FORCED_MEANING_VALID_COUNT, configured.column, configuration.explicitMeaning));
            metrics.add(new VerifyDatasetColumnMetric(VerifyDatasetColumnMetrics.FORCED_MEANING_INVALID_COUNT, configured.column, configuration.explicitMeaning));
            metrics.add(new VerifyDatasetColumnMetric(VerifyDatasetColumnMetrics.FORCED_MEANING_EMPTY_COUNT, configured.column, configuration.explicitMeaning));
        }
        return metrics;
    }

    @Override
    public ProbeConfiguration buildFullConfiguration(List<SchemaColumn> columns, Probe probe) {
        VerifyDatasetColumnProbeConfiguration configuration = new VerifyDatasetColumnProbeConfiguration();
        for (SchemaColumn column : columns) {
            if (!StringUtils.isNotBlank((String)column.getMeaning())) continue;
            for (VerifyDatasetColumnConfiguredMetrics aggregated : VerifyDatasetColumnConfiguredMetrics.values()) {
                VerifyDatasetColumnProbeColumnConfiguration columnConfiguration = new VerifyDatasetColumnProbeColumnConfiguration();
                columnConfiguration.aggregated = aggregated;
                columnConfiguration.column = column.getName();
                configuration.aggregates.add(columnConfiguration);
            }
        }
        return configuration;
    }

    @Override
    public ProbeType trimForSave() {
        return new VerifyDatasetColumnProbeType();
    }

    @Override
    public Class<? extends ProbeConfiguration> getParamsClazz() {
        return VerifyDatasetColumnProbeConfiguration.class;
    }

    @Override
    public ProbeMetadata getMeta() {
        return new ProbeMetadata().withLevel(4).withName("Data validity");
    }

    @Override
    public boolean isUserSelectedProbe() {
        return false;
    }

    static {
        metadataPerType.put(VerifyDatasetColumnMetrics.FORCED_MEANING_PERCENTAGE, new MetricMetadata().withName("Meaning validity").withFormat("smartPercentage"));
        metadataPerType.put(VerifyDatasetColumnMetrics.FORCED_MEANING_COUNT, new MetricMetadata().withName("Meaning not valid count"));
        metadataPerType.put(VerifyDatasetColumnMetrics.FORCED_MEANING_VALID_COUNT, new MetricMetadata().withName("Meaning valid count"));
        metadataPerType.put(VerifyDatasetColumnMetrics.FORCED_MEANING_INVALID_COUNT, new MetricMetadata().withName("Meaning invalid count"));
        metadataPerType.put(VerifyDatasetColumnMetrics.FORCED_MEANING_EMPTY_COUNT, new MetricMetadata().withName("Empty values count"));
        metadataPerConfiguredType.put(VerifyDatasetColumnConfiguredMetrics.FORCED_MEANING, new MetricMetadata().withName("Meaning validity"));
        logger = Logger.getLogger((String)"dku.datasets.metrics.verifycolumn");
    }

    public static class VerifyForcedMeaningComputer
    extends DSSMetricsEngine.DSSMetricsEngineComputer {
        private IBasicMeaningsService basicMeaningsService;

        public VerifyForcedMeaningComputer(IBasicMeaningsService basicMeaningsService) {
            this.basicMeaningsService = basicMeaningsService;
        }

        public VerifyForcedMeaningComputer() {
        }

        @Override
        public String getProbeType() {
            return VerifyDatasetColumnProbeType.TYPE;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            VerifyDatasetColumnMetric verificationMetric = (VerifyDatasetColumnMetric)metric;
            if (verificationMetric.getMetricType() instanceof VerifyDatasetColumnMetrics) {
                return new DSSMetricsEngine.DSSMetricsEngineRun().with(new MetricComputation(probe, this, metric, 10.0));
            }
            return null;
        }

        @Override
        public DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession start(DSSMetricsEngine.DSSMetricsEngineCallbacks engine, List<MetricComputation> computations, Map<String, String> alreadyComputed) throws Exception {
            VerifyForcedMeaningComputerSession session = new VerifyForcedMeaningComputerSession();
            for (MetricComputation computation : computations) {
                VerifyForcedMeaningComputerSubSessions sub;
                Pair key;
                block6: {
                    VerifyDatasetColumnMetric metric = (VerifyDatasetColumnMetric)computation.metric;
                    String columnName = computation.metric.getColumn();
                    key = new Pair((Object)columnName, (Object)(metric.explicitMeaning == null ? "" : metric.explicitMeaning));
                    if (!session.subSessions.containsKey(key)) {
                        sub = new VerifyForcedMeaningComputerSubSessions();
                        sub.column = engine.getDataset().getSchema().getColumn(columnName);
                        sub.memColumn = engine.getColumnFactory().column(columnName);
                        try {
                            if (metric.explicitMeaning != null) {
                                sub.meaning = this.basicMeaningsService.buildSingleDetector(metric.explicitMeaning);
                                break block6;
                            }
                            sub.meaning = this.basicMeaningsService.buildSingleDetector(sub.column.getMeaning());
                        }
                        catch (Exception ex) {
                            logger.error((Object)("Could not fetch meaning detector for column " + columnName + ". Skipping."), (Throwable)ex);
                        }
                    } else {
                        sub = session.subSessions.get(key);
                    }
                }
                sub.computations.add(computation);
                computation.session = sub;
                session.subSessions.put((Pair<String, String>)key, sub);
            }
            return session;
        }

        @Override
        public void cleanup(DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession dssComputerSession) throws Exception {
        }

        @Override
        public boolean accumulate(Row row, DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession dssComputerSession) throws Exception {
            VerifyForcedMeaningComputerSession session = (VerifyForcedMeaningComputerSession)dssComputerSession;
            for (VerifyForcedMeaningComputerSubSessions sub : session.subSessions.values()) {
                if (sub.meaning == null) continue;
                String value = row.get(sub.memColumn);
                if (StringUtils.isNotBlank((String)value)) {
                    if (sub.meaning.validates(value)) {
                        ++sub.validCount;
                    } else {
                        ++sub.invalidCount;
                    }
                } else {
                    ++sub.emptyCount;
                }
                ++sub.count;
            }
            return true;
        }

        @Override
        public Map<Metric, String> getAggregates(DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession dssComputerSession) {
            VerifyForcedMeaningComputerSession session = (VerifyForcedMeaningComputerSession)dssComputerSession;
            HashMap<Metric, String> aggregates = new HashMap<Metric, String>();
            for (VerifyForcedMeaningComputerSubSessions sub : session.subSessions.values()) {
                block8: for (MetricComputation computation : sub.computations) {
                    VerifyDatasetColumnMetric verificationMetric = (VerifyDatasetColumnMetric)computation.metric;
                    VerifyDatasetColumnMetrics metricType = verificationMetric.getMetricType();
                    if (sub.meaning != null) {
                        switch (metricType) {
                            case FORCED_MEANING_PERCENTAGE: {
                                if (sub.count > 0L) {
                                    aggregates.put(computation.metric, Double.toString((double)sub.validCount / (double)sub.count));
                                    continue block8;
                                }
                                aggregates.put(computation.metric, null);
                                continue block8;
                            }
                            case FORCED_MEANING_VALID_COUNT: {
                                aggregates.put(computation.metric, Long.toString(sub.validCount));
                                continue block8;
                            }
                            case FORCED_MEANING_INVALID_COUNT: {
                                aggregates.put(computation.metric, Long.toString(sub.invalidCount));
                                continue block8;
                            }
                            case FORCED_MEANING_EMPTY_COUNT: {
                                aggregates.put(computation.metric, Long.toString(sub.emptyCount));
                                continue block8;
                            }
                            case FORCED_MEANING_COUNT: {
                                aggregates.put(computation.metric, Long.toString(sub.invalidCount + sub.emptyCount));
                                continue block8;
                            }
                        }
                        aggregates.put(computation.metric, null);
                        continue;
                    }
                    aggregates.put(computation.metric, null);
                }
            }
            return aggregates;
        }

        @Override
        public JsonObject writeJson(JsonSerializationContext ctx) {
            JsonObject obj = new JsonObject();
            try {
                ArrayList udms = Lists.newArrayList(this.basicMeaningsService.getUDMs().values());
                obj.add("udms", ctx.serialize((Object)udms, new TypeToken<List<UserDefinedMeaning>>(){}.getType()));
            }
            catch (IOException e) {
                logger.error((Object)"Failed to retrieve udms for remote metrics engine", (Throwable)e);
                obj.add("udms", ctx.serialize(new ArrayList(), new TypeToken<List<UserDefinedMeaning>>(){}.getType()));
            }
            return obj;
        }

        @Override
        public void readJson(JsonObject jsonObj, JsonDeserializationContext ctx) {
            List udms = (List)ctx.deserialize(jsonObj.get("udms"), new TypeToken<List<UserDefinedMeaning>>(){}.getType());
            this.basicMeaningsService = new ScopedBasicMeaningsPseudoService(udms);
        }

        @Override
        public boolean canComputeWith(List<MetricComputation> handledComputations, List<MetricComputation> otherComputations) {
            return otherComputations.stream().allMatch(computation -> computation.computer instanceof VerifyForcedMeaningComputer);
        }

        public static class VerifyForcedMeaningComputerSession
        implements DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession {
            public Map<Pair<String, String>, VerifyForcedMeaningComputerSubSessions> subSessions = new HashMap<Pair<String, String>, VerifyForcedMeaningComputerSubSessions>();
        }

        public static class VerifyForcedMeaningComputerSubSessions {
            public List<MetricComputation> computations = new ArrayList<MetricComputation>();
            private long emptyCount = 0L;
            private long invalidCount = 0L;
            private long validCount = 0L;
            private long count = 0L;
            private SchemaColumn column;
            private MeaningDetector meaning;
            private Column memColumn;
        }
    }

    public static class VerifyDatasetColumnMetric
    extends Metric {
        public VerifyDatasetColumnMetrics metricType;
        public String column;
        @Nullable
        public String explicitMeaning;
        private transient String meaningLabel;

        public VerifyDatasetColumnMetric(VerifyDatasetColumnMetrics metricType, String column, @Nullable String explicitMeaning) {
            super(VerifyDatasetColumnProbeType.TYPE, metricType == VerifyDatasetColumnMetrics.FORCED_MEANING_PERCENTAGE ? Type.DOUBLE : Type.BIGINT);
            this.metricType = metricType;
            this.column = column;
            this.explicitMeaning = explicitMeaning;
            this.id = Metric.serializeMetric(this);
        }

        public VerifyDatasetColumnMetric(VerifyDatasetColumnMetrics metricType, String column) {
            this(metricType, column, null);
        }

        public VerifyDatasetColumnMetrics getMetricType() {
            return this.metricType;
        }

        @Override
        public String getColumn() {
            return this.column;
        }

        @Override
        public String getColumnInvariantId(String placeholder) {
            return new VerifyDatasetColumnMetric(this.metricType, placeholder, this.explicitMeaning).getId();
        }

        @Override
        public MetricMetadata getMeta() {
            MetricMetadata meta = new MetricMetadata(metadataPerType.get((Object)this.metricType));
            if (this.explicitMeaning == null) {
                meta.withFullName(meta.getName() + " of " + this.column);
            } else {
                meta.withFullName(meta.getName() + " of " + this.column + " using meaning " + this.getMeaningLabel());
                meta.withName(meta.getName() + " using meaning " + this.getMeaningLabel());
            }
            return meta;
        }

        private String getMeaningLabel() {
            if (this.meaningLabel == null) {
                try (Transaction t = ((TransactionService)SpringUtils.getBean(TransactionService.class)).retrieveOrBeginRead();){
                    this.meaningLabel = ((MeaningsService)SpringUtils.getBean(MeaningsService.class)).listAll().labelsMap.get(this.explicitMeaning);
                }
                catch (Exception e) {
                    logger.info((Object)("Could not get label for meaning " + this.explicitMeaning));
                }
                if (this.meaningLabel == null) {
                    this.meaningLabel = this.explicitMeaning;
                }
            }
            return this.meaningLabel;
        }

        @Override
        public Probe getMatchingProbe(List<Probe> probes) {
            VerifyDatasetColumnProbeConfiguration conf = new VerifyDatasetColumnProbeConfiguration();
            VerifyDatasetColumnProbeColumnConfiguration col = new VerifyDatasetColumnProbeColumnConfiguration();
            col.column = this.getColumn();
            col.aggregated = VerifyDatasetColumnConfiguredMetrics.FORCED_MEANING;
            conf.aggregates.add(col);
            conf.explicitMeaning = this.explicitMeaning;
            return new Probe(this.getType()).withConfiguration(conf).withMeta(ProbeType.getProbeType(VerifyDatasetColumnProbeType.TYPE).getMeta());
        }
    }

    public static enum VerifyDatasetColumnMetrics {
        FORCED_MEANING_PERCENTAGE,
        FORCED_MEANING_COUNT,
        FORCED_MEANING_VALID_COUNT,
        FORCED_MEANING_INVALID_COUNT,
        FORCED_MEANING_EMPTY_COUNT;

    }

    public static class VerifyDatasetColumnProbeHint {
        public List<VerifyDatasetColumnProbeColumnHint> columns = Lists.newArrayList();
    }

    public static class VerifyDatasetColumnProbeColumnHint {
        public String column;
        public List<VerifyDatasetColumnProbeMetricHint> metrics = Lists.newArrayList();

        VerifyDatasetColumnProbeColumnHint(String column) {
            this.column = column;
        }
    }

    public static enum VerifyDatasetColumnConfiguredMetrics {
        FORCED_MEANING;

    }

    public static class VerifyDatasetColumnProbeConfiguration
    implements ProbeConfiguration {
        public List<VerifyDatasetColumnProbeColumnConfiguration> aggregates = Lists.newArrayList();
        @Nullable
        public String explicitMeaning;
    }

    public static class VerifyDatasetColumnProbeColumnConfiguration {
        public String column;
        public VerifyDatasetColumnConfiguredMetrics aggregated;
    }

    public static class VerifyDatasetColumnProbeMetricHint {
        public String name;
        public VerifyDatasetColumnConfiguredMetrics aggregated;
        public boolean disabled;
        public boolean active;

        VerifyDatasetColumnProbeMetricHint(String name, VerifyDatasetColumnConfiguredMetrics aggregated, boolean active, boolean disabled) {
            this.name = name;
            this.aggregated = aggregated;
            this.active = active;
            this.disabled = disabled;
        }
    }

    public static class VerifyDatasetColumnMetricSerializer
    implements Metric.MetricIdSerializer {
        @Override
        public String serializeMetric(Metric metric) {
            if (!(metric instanceof VerifyDatasetColumnMetric)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + this.getClass().getSimpleName() + " does not handle " + metric.getClass().getSimpleName());
            }
            VerifyDatasetColumnMetric verifyDatasetColumnMetric = (VerifyDatasetColumnMetric)metric;
            if (verifyDatasetColumnMetric.explicitMeaning == null) {
                return Metric.buildMetricIdFromParts(VerifyDatasetColumnProbeType.TYPE, verifyDatasetColumnMetric.getMetricType().name(), verifyDatasetColumnMetric.getColumn());
            }
            return Metric.buildMetricIdFromParts(VerifyDatasetColumnProbeType.TYPE, verifyDatasetColumnMetric.getMetricType().name(), verifyDatasetColumnMetric.getColumn(), verifyDatasetColumnMetric.explicitMeaning);
        }

        @Override
        public Metric deserializeMetric(String metricId) {
            List<String> parts = Metric.buildPartsFromMetricId(metricId);
            if (parts.size() < 3 || parts.size() > 4 || !parts.get(0).equals(VerifyDatasetColumnProbeType.TYPE)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + this.getClass().getSimpleName() + " does not handle " + metricId);
            }
            if (parts.size() == 3) {
                return new VerifyDatasetColumnMetric(VerifyDatasetColumnMetrics.valueOf(parts.get(1)), parts.get(2));
            }
            return new VerifyDatasetColumnMetric(VerifyDatasetColumnMetrics.valueOf(parts.get(1)), parts.get(2), parts.get(3));
        }
    }
}

