/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss;

import com.dataiku.dip.SingleCopyAdditionalInputsLoader;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.ProcessorOutputToSIP;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.SingleInputRowProcessor;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datalayer.utils.SilentLimitProcessorOutput;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.io.LinoWriter;
import com.dataiku.dip.pivot.backend.dss.LinoUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.AdditionalInputsHelper;
import com.dataiku.dip.shaker.SampleBuilder;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.processors.BaseProcessorsFactory;
import com.dataiku.dip.shaker.server.SampleMetadata;
import com.dataiku.dip.shaker.server.StreamedAdditionalInputAccessor;
import com.dataiku.dip.shaker.streamimpl.StreamPipelineFactory;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ShakerToLino {
    public static final String SAMPLING_METADATA_NAME = "sampling.metadata.json";
    private static DKULogger logger = DKULogger.getLogger((String)"dku.lino");

    private static void prepareColumns(List<SchemaColumn> columnsToKeep, ColumnFactory cf, List<Column> columns, TIntIntMap firstLinoColPerSchemaCol, LinoWriter wr) {
        int nbSchemaCols = 0;
        int nbLinoCols = 0;
        for (SchemaColumn col : columnsToKeep) {
            columns.add(cf.column(col.getName()));
            logger.info((Object)("Will add " + JSON.log((Object)col) + " ns=" + nbSchemaCols + " nl=" + nbLinoCols));
            switch (col.getType()) {
                case DATE: 
                case DATEONLY: 
                case DATETIMENOTZ: 
                case DOUBLE: 
                case FLOAT: 
                case BIGINT: {
                    wr.addColumn(col.getName(), ColumnBlock.MemoryType.DOUBLE, col.getType());
                    firstLinoColPerSchemaCol.put(nbSchemaCols, nbLinoCols);
                    ++nbLinoCols;
                    break;
                }
                case GEOMETRY: 
                case GEOPOINT: {
                    wr.addColumn(col.getName() + "__dku_lon", ColumnBlock.MemoryType.DOUBLE, col.getType());
                    wr.addColumn(col.getName() + "__dku_lat", ColumnBlock.MemoryType.DOUBLE, col.getType());
                    wr.addColumn(col.getName() + "__dku_raw", ColumnBlock.MemoryType.STRING, col.getType());
                    firstLinoColPerSchemaCol.put(nbSchemaCols, nbLinoCols);
                    nbLinoCols += 3;
                    break;
                }
                default: {
                    wr.addColumn(col.getName(), ColumnBlock.MemoryType.STRING_DICT, col.getType());
                    firstLinoColPerSchemaCol.put(nbSchemaCols, nbLinoCols);
                    ++nbLinoCols;
                }
            }
            ++nbSchemaCols;
        }
    }

    private static StreamPipelineFactory.StreamPipeline buildPipeline(AuthCtx authCtx, List<ScriptStep> steps, LinoUtils.LinoWritingOutput lwo, String projectKey, TransactionService transactionService, DatasetsDAO datasetsDAO, ColumnFactory cf, RowFactory rf) throws Exception {
        StreamPipelineFactory.StreamPipeline streamPipeline = StreamPipelineFactory.build(steps, BaseProcessorsFactory.PipelineContext.sharedPipelineContext(), true);
        streamPipeline.setPipelineOutput((ProcessorOutput)lwo);
        streamPipeline.init(authCtx, projectKey, cf, rf);
        try (Transaction t = transactionService.beginRead();){
            StreamedAdditionalInputAccessor additionalInputsAccessor = new StreamedAdditionalInputAccessor(authCtx, projectKey, datasetsDAO);
            List<SingleCopyAdditionalInputsLoader> additionalInputLoaders = AdditionalInputsHelper.getLoadersForAllProcessors(additionalInputsAccessor, steps, null);
            AdditionalInputsHelper.setAdditionalInputsOnProcessors(additionalInputsAccessor, additionalInputLoaders, streamPipeline.allProcessors);
        }
        return streamPipeline;
    }

    public static void fromPredictedMemTable(MemTable mt, File linoFolder, String linoName, List<SchemaColumn> columnsToKeep, int limit) throws Exception {
        TIntIntHashMap firstLinoColPerSchemaCol = new TIntIntHashMap();
        ArrayList<Column> columns = new ArrayList<Column>();
        MemTable cf = mt;
        LinoWriter wr = new LinoWriter(linoFolder, linoName);
        ShakerToLino.prepareColumns(columnsToKeep, cf, columns, (TIntIntMap)firstLinoColPerSchemaCol, wr);
        wr.init();
        LinoUtils.LinoWritingOutput lwo = new LinoUtils.LinoWritingOutput(wr, cf, columnsToKeep, columns, (TIntIntMap)firstLinoColPerSchemaCol);
        for (int i = 0; i < Math.min(mt.rows.size(), limit); ++i) {
            lwo.emitRow(mt.rows.get(i));
        }
        lwo.lastRowEmitted();
        wr.end();
    }

    public static void fromDataset(AuthCtx authCtx, Dataset dataset, StreamableDatasetSelection selection, List<ScriptStep> steps, File linoFolder, String linoName, List<SchemaColumn> columnsToKeep) throws Exception {
        DatasetsDAO datasetsDAO = (DatasetsDAO)SpringUtils.getBean(DatasetsDAO.class);
        TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        TIntIntHashMap firstLinoColPerSchemaCol = new TIntIntHashMap();
        ArrayList<Column> columns = new ArrayList<Column>();
        StreamColumnFactory cf = new StreamColumnFactory();
        StreamRowFactory rf = new StreamRowFactory();
        LinoWriter wr = new LinoWriter(linoFolder, linoName);
        ShakerToLino.prepareColumns(columnsToKeep, (ColumnFactory)cf, columns, (TIntIntMap)firstLinoColPerSchemaCol, wr);
        wr.init();
        LinoUtils.LinoWritingOutput lwo = new LinoUtils.LinoWritingOutput(wr, (ColumnFactory)cf, columnsToKeep, columns, (TIntIntMap)firstLinoColPerSchemaCol);
        StreamPipelineFactory.StreamPipeline streamPipeline = ShakerToLino.buildPipeline(authCtx, steps, lwo, dataset.getProjectKey(), transactionService, datasetsDAO, (ColumnFactory)cf, (RowFactory)rf);
        SingleInputRowProcessor headProcessor = (SingleInputRowProcessor)streamPipeline.allProcessors.get(0);
        Object connector = new ProcessorOutputToSIP(headProcessor);
        boolean maxRecordLimitOverReached = false;
        SampleBuilder.CountDatasetRecordsThread countDatasetRecordsThread = SampleBuilder.startCountDatasetRecords(authCtx, dataset, false);
        StreamableDatasetSelection selectionCopy = StreamableDatasetSelection.fromSamplingParam(selection);
        SilentLimitProcessorOutput limiter = null;
        if (selectionCopy.samplingMethod == SamplingParam.SamplingMethod.HEAD_SEQUENTIAL) {
            limiter = new SilentLimitProcessorOutput((ProcessorOutput)connector, selectionCopy.maxRecords);
            connector = limiter;
            ++selectionCopy.maxRecords;
        }
        UniversalSingleThreadPusher pusher = UniversalSingleThreadPusher.prepareForCount(authCtx, dataset, selectionCopy, (ProcessorOutput)connector, (ColumnFactory)cf, (RowFactory)rf);
        pusher.push();
        connector.lastRowEmitted();
        if (selectionCopy.samplingMethod == SamplingParam.SamplingMethod.HEAD_SEQUENTIAL && limiter != null && limiter.isLimitOverReached()) {
            maxRecordLimitOverReached = true;
            --selectionCopy.maxRecords;
        }
        wr.end();
        long processedRowCount = pusher.getProcessedRowCount();
        SampleMetadata sampleMetadata = SampleBuilder.buildSampleMetadata(selectionCopy.hasPartition(dataset), selectionCopy.getRequestedPartitionCount(), selectionCopy.hasFilter(), processedRowCount, false, 0L, lwo.rowIs, maxRecordLimitOverReached, selection, pusher.wasSamplingPushedDownToDB());
        SampleBuilder.completeCountDatasetRecords(countDatasetRecordsThread, sampleMetadata);
        JSON.prettyToFile((Object)sampleMetadata, (File)new File(linoFolder, SAMPLING_METADATA_NAME));
    }
}

