/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.facets;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.io.LinoReader;
import com.dataiku.dip.pivot.backend.dss.facets.AxisFilter;
import com.dataiku.dip.pivot.backend.model.RowFilter;
import java.io.IOException;
import org.apache.log4j.Logger;

public class NumericalAxisFilter
implements AxisFilter {
    private Column col;
    private RowFilter filter;
    private static Logger logger = Logger.getLogger((String)"dip.pivot");

    public NumericalAxisFilter(RowFilter filter) {
        this.filter = filter;
    }

    public NumericalAxisFilter(RowFilter filter, Column col) {
        this.filter = filter;
        this.col = col;
    }

    @Override
    public boolean filter(Row row) {
        double val = Double.NaN;
        String v = row.get(this.col);
        if (v == null || v.isEmpty()) {
            return this.filter.getIncludeEmptyValuesOrDefault();
        }
        try {
            val = Double.parseDouble(v);
            if (Double.isNaN(val)) {
                return false;
            }
            if (this.filter.minValue != null && val < this.filter.minValue) {
                return false;
            }
            if (this.filter.maxValue != null && val > this.filter.maxValue) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public void filter(LinoReader reader, int blockIdx, boolean[] ret) throws IOException {
        ColumnBlock block = reader.readColumnBlock(this.filter.column, blockIdx);
        logger.info((Object)("Filter " + block.nbRecords() + " with " + this.filter.minValue + " " + this.filter.maxValue));
        for (int i = 0; i < block.nbRecords(); ++i) {
            if (!ret[i]) continue;
            double d = block.doubles[i];
            if (Double.isNaN(d)) {
                ret[i] = this.filter.getIncludeEmptyValuesOrDefault();
                continue;
            }
            if (this.filter.minValue != null && d < this.filter.minValue) {
                ret[i] = false;
            }
            if (this.filter.maxValue != null && d > this.filter.maxValue) {
                ret[i] = false;
            }
            if (this.filter.minValue != null || this.filter.maxValue != null) continue;
            ret[i] = true;
        }
    }
}

