/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.utils;

import com.dataiku.dip.pivot.backend.model.Aggregation;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.AxisSortPrune;
import com.dataiku.dip.pivot.backend.model.NumericalAxisParams;
import com.dataiku.dip.utils.JSON;
import java.util.List;
import java.util.Objects;

public class AxisUtils {
    public static AxisDef copyWithGroupingDisabled(AxisDef def) {
        AxisDef copy = (AxisDef)JSON.deepCopy((Object)def);
        if (def.sortPrune != null) {
            copy.sortPrune.generateOthersCategory = false;
        }
        return copy;
    }

    public static boolean produceSameSQLAxis(ExtendedAxisDef axis1, ExtendedAxisDef axis2) {
        if (axis1.def == null || axis2.def == null) {
            return axis1.def == null && axis2.def == null;
        }
        if (axis1.def.type != axis2.def.type) {
            return false;
        }
        if (!axis1.def.column.equals(axis2.def.column)) {
            return false;
        }
        if (axis1.def.sortPrune.sortType != axis2.def.sortPrune.sortType) {
            return false;
        }
        if (axis1.def.sortPrune.sortType == AxisSortPrune.SortType.NATURAL && axis1.def.sortPrune.sortAscending != axis2.def.sortPrune.sortAscending) {
            return false;
        }
        if (axis1.def.sortPrune.sortType == AxisSortPrune.SortType.CUSTOM && !Objects.equals(axis1.def.sortPrune.customSortingValues, axis2.def.sortPrune.customSortingValues)) {
            return false;
        }
        if (axis1.def.sortPrune.sortType == AxisSortPrune.SortType.AGGREGATION && axis1.def.sortPrune.aggregationSortId != -1 && axis2.def.sortPrune.aggregationSortId != -1) {
            Aggregation agg2;
            if (axis1.aggregations == null || axis2.aggregations == null) {
                return false;
            }
            Aggregation agg1 = axis1.aggregations.get(axis1.def.sortPrune.aggregationSortId);
            if (!AxisUtils.isEquivalent(agg1, agg2 = axis2.aggregations.get(axis2.def.sortPrune.aggregationSortId))) {
                return false;
            }
            if (axis1.def.sortPrune.sortAscending != axis2.def.sortPrune.sortAscending) {
                return false;
            }
        }
        if (axis1.def.sortPrune.sortType == AxisSortPrune.SortType.ORIGINAL) {
            return false;
        }
        if (axis1.def.sortPrune.generateOthersCategory != axis2.def.sortPrune.generateOthersCategory) {
            return false;
        }
        if (axis1.def.type == AxisDef.Type.ALPHANUM && axis1.def.sortPrune.maxValues != axis2.def.sortPrune.maxValues) {
            return false;
        }
        if (axis1.def.type == AxisDef.Type.NUMERICAL) {
            if (axis1.def.numParams.mode != axis2.def.numParams.mode) {
                return false;
            }
            if (axis1.def.numParams.mode == NumericalAxisParams.BinningMode.FIXED_NB) {
                if (axis1.def.numParams.nbBins != axis2.def.numParams.nbBins) {
                    return false;
                }
                if (axis1.def.numParams.niceBounds != axis2.def.numParams.niceBounds) {
                    return false;
                }
            }
            if (axis1.def.numParams.mode == NumericalAxisParams.BinningMode.FIXED_SIZE && axis1.def.numParams.binSize != axis2.def.numParams.binSize) {
                return false;
            }
            if (axis1.def.numParams.mode == NumericalAxisParams.BinningMode.CUSTOM && !axis1.def.numParams.customBinValues.equals(axis2.def.numParams.customBinValues)) {
                return false;
            }
            return axis1.def.numParams.mode != NumericalAxisParams.BinningMode.NONE || axis1.def.sortPrune.maxValues == axis2.def.sortPrune.maxValues;
        }
        return axis1.def.type != AxisDef.Type.DATE || axis1.def.dateParams.mode == axis2.def.dateParams.mode;
    }

    public static boolean isEquivalent(Aggregation agg1, Aggregation agg2) {
        if (agg1.function != agg2.function) {
            return false;
        }
        if (agg1.function == Aggregation.Function.CUSTOM) {
            return Objects.equals(agg1.customFunction, agg2.customFunction);
        }
        if (agg1.function != Aggregation.Function.COUNT && (agg1.column == null || agg2.column == null)) {
            return false;
        }
        if (agg1.percentile != agg2.percentile) {
            return false;
        }
        return Objects.equals(agg1.column, agg2.column);
    }

    public static class ExtendedAxisDef {
        public AxisDef def;
        public List<Aggregation> aggregations;

        public ExtendedAxisDef(AxisDef def, List<Aggregation> aggregations) {
            this.def = def;
            this.aggregations = aggregations;
        }
    }
}

