/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.plugins;

import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.remoterun.RemoteRunNetworkingUtils;
import com.dataiku.dip.security.rpc.EncryptedRPC;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class HadoopPluginSettingsHelper {
    private static Logger logger = Logger.getLogger((String)"dku.plugins");

    public static PluginsSettingsState buildState(String projectKey) {
        APITicketService ticketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
        PluginsSettingsState pss = new PluginsSettingsState();
        pss.ticket = ticketService.getSingleTicket().getSecret();
        pss.protocol = RemoteRunNetworkingUtils.getServerProtocol();
        pss.host = RemoteRunNetworkingUtils.getServerHost();
        pss.port = RemoteRunNetworkingUtils.getServerPort();
        if (EncryptedRPC.enabled()) {
            pss.cert = EncryptedRPC.getPEMCertificateText();
        }
        pss.projectKey = projectKey;
        return pss;
    }

    public static String loadAndGetProjectKey(PluginsSettingsState pss) {
        PluginSettingsResolver.setupRemoteResolution(true, pss.protocol + "://" + pss.host + ":" + pss.port, pss.cert, pss.ticket);
        return pss.projectKey;
    }

    public static class PluginsSettingsState
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String projectKey;
        public String protocol;
        public String host;
        public int port;
        public String cert;
        public String ticket;
    }
}

