/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.populardatasets;

import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.populardatasets.MostUsedDatasetInfos;
import java.util.List;
import java.util.Objects;

public interface PopularDatasetsProcessing {

    public static class Output {
        List<MostUsedDatasetInfos> mostUsedDatasetInfos;
        RunMetadata lastRunMetadata;

        public Output(List<MostUsedDatasetInfos> mostUsedDatasetInfos, RunMetadata lastRunMetadata) {
            this.mostUsedDatasetInfos = mostUsedDatasetInfos;
            this.lastRunMetadata = lastRunMetadata;
        }
    }

    public static class RunMetadata {
        public PerfMetricsResult perfMetrics;
        public long timestamp;
        public int numberMostUsedDatasets;

        public RunMetadata(PerfMetricsResult perfMetrics, long timestamp, int numberMostUsedDatasets) {
            this.perfMetrics = perfMetrics;
            this.timestamp = timestamp;
            this.numberMostUsedDatasets = numberMostUsedDatasets;
        }
    }

    public static class PerfMetricsResult {
        public long listing;
        public long getLastRebuild;
        public long collectRecipe;
        public long processRecipe;
        public long compileData;
        public long total;

        public PerfMetricsResult(long listing, long getLastRebuild, long collectRecipe, long processRecipe, long compileData) {
            this.listing = listing;
            this.getLastRebuild = getLastRebuild;
            this.collectRecipe = collectRecipe;
            this.processRecipe = processRecipe;
            this.compileData = compileData;
            this.total = listing + getLastRebuild + collectRecipe + processRecipe + compileData;
        }
    }

    public static class PerfMetrics {
        private final long start = System.currentTimeMillis();
        private long listDatasets;
        private long getLastRebuild;
        private long collectRecipes;
        private long processRecipes;
        private long compileData;

        public void doneListing() {
            this.listDatasets = System.currentTimeMillis();
        }

        public void doneGetLastRebuild() {
            this.getLastRebuild = System.currentTimeMillis();
        }

        public void doneCollectRecipe() {
            this.collectRecipes = System.currentTimeMillis();
        }

        public void doneProcessRecipe() {
            this.processRecipes = System.currentTimeMillis();
        }

        public void doneCompileData() {
            this.compileData = System.currentTimeMillis();
        }

        public PerfMetricsResult getResult() {
            return new PerfMetricsResult(this.listDatasets - this.start, this.getLastRebuild - this.listDatasets, this.collectRecipes - this.getLastRebuild, this.processRecipes - this.collectRecipes, this.compileData - this.processRecipes);
        }
    }

    public static class DownstreamRecipesDesc {
        public final int numDownstreamRecipes;
        public final boolean isTrending;
        public final float percentNewRecipesCreatedDuringLastWindow;

        public DownstreamRecipesDesc(int numDownstreamRecipes, boolean isTrending, int lastWindowCreationCnt) {
            this.numDownstreamRecipes = numDownstreamRecipes;
            this.isTrending = isTrending;
            this.percentNewRecipesCreatedDuringLastWindow = 100.0f * (float)lastWindowCreationCnt / (float)numDownstreamRecipes;
        }
    }

    public static class DatasetInfo {
        public final String name;
        public final String projectKey;
        public final long creationTag;
        public final int columns;
        public final int projects;
        public final int dataCollections;

        public DatasetInfo(SerializedDataset sd, int projects, int dataCollections) {
            this.name = sd.name;
            this.projectKey = sd.projectKey;
            this.creationTag = sd.creationTag != null ? sd.creationTag.getLastModifiedOn() : -1L;
            this.columns = sd.getSchema() == null || sd.getSchema().columns == null ? 0 : sd.getSchema().columns.size();
            this.projects = projects;
            this.dataCollections = dataCollections;
        }

        public String getFullName() {
            return this.projectKey + "." + this.name;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DatasetInfo other = (DatasetInfo)obj;
            return other.name.equals(this.name) && other.projectKey.equals(this.projectKey);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.projectKey, this.creationTag, this.columns, this.projects, this.dataCollections);
        }
    }
}

