/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.datalineage.DataLineageUtils;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public interface BasicRecipeLineageHandler {
    default public RecipeLineage buildBasicRecipeLineage(@Nullable Params params, @Nonnull SerializedDataset predecessor, @Nonnull SerializedDataset successor) {
        return this.buildBasicRecipeLineage(params, Map.of(predecessor.getFullName(), predecessor), Map.of(successor.getFullName(), successor));
    }

    default public RecipeLineage buildBasicRecipeLineage(@Nullable Params params, @Nonnull Map<String, SerializedDataset> predecessorsByFullName, @Nonnull Map<String, SerializedDataset> successorsByFullName) {
        RecipeLineage recipeLineage = new RecipeLineage();
        if (predecessorsByFullName.isEmpty() || successorsByFullName.isEmpty()) {
            return recipeLineage;
        }
        List<ComputedColumn> computedColumns = Stream.ofNullable(params).flatMap(ps2 -> Stream.ofNullable(ps2.getComputedColumns())).flatMap(Collection::stream).collect(Collectors.toList());
        recipeLineage.setUncertain(DataLineageUtils.shouldMarkLineageUncertain(computedColumns));
        Map<String, List<String>> usedColumnsByComputedColumn = DataLineageUtils.getComputedColumnsInputs(computedColumns);
        predecessorsByFullName.forEach((predecessorFullName, predecessor) -> {
            Schema predecessorSchema = predecessor.getSchema();
            successorsByFullName.forEach((successorFullName, successor) -> {
                Schema successorSchema = successor.getSchema();
                DatasetPairLineage datasetPairLineage = new DatasetPairLineage((String)predecessorFullName, predecessorSchema, (String)successorFullName, successorSchema);
                datasetPairLineage.initializeDirectColumnRelations();
                usedColumnsByComputedColumn.forEach((computedColumn, usedColumns) -> usedColumns.stream().filter(arg_0 -> ((Schema)predecessorSchema).hasColumn(arg_0)).forEach(usedColumn -> datasetPairLineage.addRelation((String)usedColumn, (String)computedColumn, false)));
                recipeLineage.setDatasetPairLineage((String)predecessorFullName, (String)successorFullName, datasetPairLineage);
            });
        });
        return recipeLineage;
    }

    default public void handleColumnNameOverrides(@Nullable Params params, @Nonnull RecipeLineage recipeLineage) {
        Map<String, String> outputColumnNameOverrides = Stream.ofNullable(params).flatMap(ps2 -> Stream.ofNullable(ps2.getOutputColumnNameOverrides())).flatMap(map -> map.entrySet().stream()).filter(e -> StringUtils.isNotBlank((String)((String)e.getKey())) && StringUtils.isNotBlank((String)((String)e.getValue())) && !Objects.equals(e.getKey(), e.getValue())).filter(e -> recipeLineage.getDatasetPairLineages().values().stream().anyMatch(datasetPairLineage -> datasetPairLineage.getOutputColumns().contains(e.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (outputColumnNameOverrides.isEmpty()) {
            return;
        }
        recipeLineage.getDatasetPairLineages().values().forEach(datasetPairLineage -> {
            Set<String> outputColumnNames = datasetPairLineage.getOutputColumns();
            HashSet<String> conflictingNames = new HashSet<String>();
            for (Map.Entry entry : outputColumnNameOverrides.entrySet()) {
                String originalName = (String)entry.getKey();
                String overriddenName = (String)entry.getValue();
                if (outputColumnNames.contains(overriddenName)) {
                    conflictingNames.add(overriddenName);
                    recipeLineage.setUncertain(true);
                } else {
                    datasetPairLineage.removeRelationsOnColumn(overriddenName);
                    datasetPairLineage.addFactorizedColumnRelations(originalName, overriddenName);
                }
                datasetPairLineage.removeRelationsOnColumn(originalName);
                outputColumnNames.remove(originalName);
                outputColumnNames.add(overriddenName);
            }
            datasetPairLineage.getOutputColumns().forEach(outputColumn -> {
                if (conflictingNames.stream().anyMatch(conflictColumn -> outputColumn.startsWith((String)conflictColumn) && outputColumn.substring(conflictColumn.length()).matches("^(_\\d)*$"))) {
                    datasetPairLineage.removeRelationsOnColumn((String)outputColumn);
                }
            });
        });
    }

    default public RecipeLineage getBasicValidRecipeLineage(@Nullable Params params, @Nonnull Map<String, SerializedDataset> predecessorsByFullName, @Nonnull Map<String, SerializedDataset> successorsByFullName) {
        RecipeLineage recipeLineage = this.buildBasicRecipeLineage(params, predecessorsByFullName, successorsByFullName);
        this.handleColumnNameOverrides(params, recipeLineage);
        recipeLineage.keepValidRelations();
        return recipeLineage;
    }

    public static interface Params {
        @Nullable
        default public List<ComputedColumn> getComputedColumns() {
            return Collections.emptyList();
        }

        @Nullable
        default public Map<String, String> getOutputColumnNameOverrides() {
            return Collections.emptyMap();
        }
    }
}

