/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.sparksql;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.code.CodeBasedRecipeStatus;
import com.dataiku.dip.recipes.code.scala.ScalaService;
import com.dataiku.dip.recipes.code.sparksql.SparkSQLQueryRecipeMeta;
import com.dataiku.dip.recipes.code.sql.AbstractSQLQueryRecipeTester;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.GenericRecipesValidationService;
import com.dataiku.dip.server.recipes.PreprocessedQueryForSubstitution;
import com.dataiku.dip.server.recipes.RecipeSchemaService;
import com.dataiku.dip.server.recipes.RecipeVariablesHelper;
import com.dataiku.dip.server.services.SingleWriteTransactionTransactionService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.sql.SparkSQLDialect;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Lists;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;

public class SparkSQLRecipeStatusComputer
extends RecipeStatusComputer {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ScalaService scalaService;
    @Autowired
    private RecipeSchemaService recipeSchemaService;
    @Autowired
    private GenericRecipesValidationService validationService;

    public SparkSQLRecipeStatusComputer(SerializedRecipe recipe, String payload) {
        super(recipe, payload);
    }

    @Override
    public RecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) throws Exception {
        SparkSQLRecipeStatus ret;
        Object graph;
        Transaction t;
        CodeBasedRecipeStatus.CodeBasedRecipeStatusRequest request = (CodeBasedRecipeStatus.CodeBasedRecipeStatusRequest)JSON.parse((String)requestData, CodeBasedRecipeStatus.CodeBasedRecipeStatusRequest.class);
        Pair<String[], Integer[]> expandedSqlStatementsAndOffsets = null;
        RecipeRunnableSubgraph subgraph = null;
        if (request != null) {
            SingleWriteTransactionTransactionService.DetransactionalizedCallable<RecipeRunnableSubgraph> subgraphCallable;
            t = this.transactionService.beginRead();
            try {
                this.recipe.name = "testRecipe";
                graph = new FlowGraph();
                FlowRecipe frecipe = ((FlowGraph)graph).buildSingleRecipe(this.recipe);
                subgraphCallable = this.validationService.getValidationRunnableSubgraph(authCtx, frecipe, request.targetPartitionSpec);
            }
            finally {
                if (t != null) {
                    t.close();
                }
            }
            subgraph = subgraphCallable.call_NT();
        }
        PreprocessedQueryForSubstitution preprocessedQuery = PreprocessedQueryForSubstitution.preprocess_NT(this.payload, new SparkSQLDialect());
        t = this.transactionService.beginRead();
        try {
            ret = this.fastStatusIgnorePartitions(authCtx);
            if (ret.topLevelMessages.anyFatal()) {
                graph = ret;
                return graph;
            }
            if (request != null) {
                RecipeVariablesHelper.RecipeSubstitutionVariablesResult vres = new RecipeVariablesHelper().getRecipeVariablesAndSubstitute(authCtx, this.recipe.projectKey, subgraph, preprocessedQuery, null);
                ret.topLevelMessages.mergeFrom(vres.messages);
                ret.substitutionVariables = vres.substitutionVariables;
                if (!vres.checkSubstitutionError(ret.topLevelMessages)) {
                    SparkSQLRecipeStatus sparkSQLRecipeStatus = ret;
                    return sparkSQLRecipeStatus;
                }
                expandedSqlStatementsAndOffsets = vres.substitutedAndSplit;
            }
            boolean needGlobalMetastore = false;
            for (SerializedRecipe.RecipeInput input : this.recipe.getFlatInputs()) {
                SerializedDataset ds = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(DatasetLocUtils.DatasetLoc.resolveSmart(this.recipe.getProjectKey(), input.ref));
                if (!DatasetInspector.isHiveTable(ds)) continue;
                needGlobalMetastore = true;
            }
            if (needGlobalMetastore && !((SparkSQLQueryRecipeMeta.SparkSQLQueryRecipeParams)this.recipe.params).useGlobalMetastore) {
                ret.topLevelMessages.withWarning((InfoMessage.MessageCode)RecipeCodes.WARN_RECIPE_SPARK_INDIRECT_HDFS, "Hive datasets used as inputs will be streamed unless the recipe uses the global Hive metastore");
            }
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
        if (((SparkSQLQueryRecipeMeta.SparkSQLQueryRecipeParams)this.recipe.params).useGlobalMetastore) {
            ret.topLevelMessages.withWarning((InfoMessage.MessageCode)RecipeCodes.WARN_RECIPE_CODE_NOT_CHECKED, "Code of SparkSQL recipes is not checked when using global metastore - only global consistency checks were performed");
            return ret;
        }
        if (request != null) {
            AbstractSQLQueryRecipeTester.SQLQuerySimpleValidationResult svr = this.scalaService.validateSparkSQL(authCtx, expandedSqlStatementsAndOffsets, this.recipe);
            ret.topLevelMessages.mergeFrom(svr.messages);
            if (!ret.topLevelMessages.anyFatal()) {
                try (Transaction t2 = this.transactionService.beginRead();){
                    ret.schemaResult = this.recipeSchemaService.getSchemaUpdateResult(authCtx, this.recipe, Lists.newArrayList((Object[])new Schema[]{svr.queryResultSchema}), "main");
                }
            }
        }
        return ret;
    }

    @Override
    public SparkSQLRecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) throws IOException, DKUSecurityException {
        SparkSQLRecipeStatus ret = new SparkSQLRecipeStatus();
        this.performBasicStructureChecks(ret, authCtx);
        ret.addSingleEngine("SPARK", "Spark", "SPARK_SQL", "SparkSQL", "Spark");
        return ret;
    }

    public static class SparkSQLRecipeStatus
    extends CodeBasedRecipeStatus {
        public RecipeSchemaService.RecipeSchemaAutoupdateResult schemaResult;
    }
}

